/*******************************************************************************
*                                                                              *
*                                   Viewmol                                    *
*                                                                              *
*                               C A L C M O . C                                *
*                                                                              *
*                 Copyright (c) Joerg-R. Hill, December 1997                   *
*                                                                              *
********************************************************************************
*
* $Id: calcmo.c,v 1.2 1998/01/26 00:47:08 jrh Exp jrh $
* $Log: calcmo.c,v $
* Revision 1.2  1998/01/26 00:47:08  jrh
* Release 2.1
*
* Revision 1.1  1996/12/10  18:39:57  jrh
* Initial revision
*
*/
#include<math.h>
#include<stdio.h>
#include<stdlib.h>
#include<string.h>
#include<unistd.h>
#include<sys/types.h>
#include<sys/times.h>
#include<X11/Xlib.h>
#include<X11/cursorfont.h>
#include "viewmol.h"
#include "dialog.h"

void setGridObject(struct GRIDOBJECT *, double, int, int, int);

extern double makemo(struct ATOM *, struct ORBITAL *, double, double, double,
			   int, int, int, int);
extern int runMoloch(double *, double, double, double, int, struct ORBITAL *, int);
extern void GetMessageBoxButton(Widget, XtPointer, caddr_t);
extern char *getStringResource(Widget, char *);
extern void *getmem(size_t, size_t);
extern void *expmem(void *, size_t, size_t);
extern void setCursor(Widget, int);
extern int norbs(int);
extern char *bfname(int);
extern void fremem(void **);
extern void restoreGeometry(void);
extern int  messgb(Widget, int, char *, struct PushButtonRow *, int);
extern int runProg(char *, int, char *, char *, char *, pid_t *);

extern struct WINDOW windows[];
extern struct ATOM *atoms;
extern struct ORBITAL *orbitals;
extern struct GRIDOBJECT *gridObjects;
extern double transx, transy, transz, radfac;
extern double gridres;
extern int na, nbasfu, imo, iwavef, ibasfu, ngridobjects;
extern int bfatom, needMoloch;
extern Widget topShell;
extern char moloch[];

void calcmo(void)
{
  struct ORBITAL *orb=NULL;
  double fac, boxf, step;
/*double d, m, a;*/
  int mo=0, morb;
  register double x, y, z;
  register int i, j, k, l;

  if (ngridobjects == 0)
  {
    ngridobjects++;
    gridObjects=(struct GRIDOBJECT *)getmem(ngridobjects, sizeof(struct GRIDOBJECT));
    setGridObject(&gridObjects[0], gridres, iwavef, imo, ibasfu);
  }
  else
  {
    j=FALSE;
    for (i=0; i<ngridobjects; i++)
    {
      if (gridObjects[i].type == iwavef)
      {
        if ((iwavef == MOLECULAR_ORBITAL && gridObjects[i].mo == imo) ||
            (iwavef == BASIS_IN_MO && gridObjects[i].mo == imo &&
                                      gridObjects[i].basisfunction == ibasfu) ||
            (iwavef == BASIS_FUNCTION && gridObjects[i].basisfunction == ibasfu) ||
             iwavef == DENSITY)
        {
	    if (gridObjects[i].resolution == gridres)
            return;
          else
	    {
		fremem((void **)&gridObjects[i].grid);
		ngridobjects--;
		j=TRUE;
	    }
	  }
      } 
    }
    if (!j) gridObjects=(struct GRIDOBJECT *)expmem(gridObjects, ngridobjects+1, sizeof(struct GRIDOBJECT));
    setGridObject(&gridObjects[ngridobjects], gridres, iwavef, imo, ibasfu);
    ngridobjects++;
  }

  setCursor(windows[VIEWER].widget, XC_watch);
  fac=radfac/0.52917706;
  boxf=fac*windows[VIEWER].far;
  step=2.0*boxf/gridres;
  morb=norbs(na);
  for (i=0; i<na; i++)
  {
    atoms[i].x=fac*(atoms[i].x-transx);
    atoms[i].y=fac*(atoms[i].y-transy);
    atoms[i].z=fac*(atoms[i].z-transz);
  }
/*if (gridObjects[ngridobjects-1] != NULL)
    fremem((void **)&gridObjects[ngridobjects-1]); */
  i=(int)(gridres)+1;
  gridObjects[ngridobjects-1].grid=(double *)getmem((size_t)(i*i*i), sizeof(double));
  switch (iwavef)
  {
    case BASIS_FUNCTION:    orb=(struct ORBITAL *)getmem((size_t)1, sizeof(struct ORBITAL));
				    orb->coeff=(double *)getmem((size_t)morb, sizeof(double));
				    orb->coeff[ibasfu]=1.0;
				    mo=0;
				    break;
    case BASIS_IN_MO:       orb=(struct ORBITAL *)getmem((size_t)1, sizeof(struct ORBITAL));
				    orb->coeff=(double *)getmem((size_t)morb, sizeof(double));
				    orb->coeff[ibasfu]=orbitals[imo].coeff[ibasfu];
				    mo=0;
				    break;
    case MOLECULAR_ORBITAL: mo=imo;
				    orb=orbitals;
				    break;
    case DENSITY:           mo=-1;
				    orb=orbitals;
				    break;
  }
  if ((iwavef == MOLECULAR_ORBITAL || iwavef == DENSITY) && needMoloch)
  {
    if (runMoloch(gridObjects[ngridobjects-1].grid, gridres, boxf, step, mo,
                  orbitals, nbasfu)) iwavef=0;
  }
  else
  {
/*  d=0.0e0;
    m=0.0; */
    i=0;
    z=-boxf;
    for (j=0; j<=gridres; j++)
    {
      y=-boxf;
	for (k=0; k<=gridres; k++)
      {
        x=-boxf;
        for (l=0; l<=gridres; l++)
	  {
/*        a=gridObjects[ngridobjects-1].grid[i]; */
          gridObjects[ngridobjects-1].grid[i++]=makemo(atoms, orb, x, y, z, na, morb, nbasfu, mo);
/*        printf("%15.10f %15.10f %15.10f\n", a, gridObjects[ngridobjects-1].grid[i-1],
                 a-gridObjects[ngridobjects-1].grid[i-1]);
          d=d+fabs(gridObjects[ngridobjects-1].grid[i-1]-a);
	    m=m > fabs(gridObjects[ngridobjects-1].grid[i-1]-a) ? m : fabs(gridObjects[ngridobjects-1].grid[i-1]-a); */
          x+=step;
        }
        y+=step;
      }
      z+=step;
    }
  }
/*printf("%d grid points, %15.10f, %15.10f\n", i, d/((gridres+1.e0)*(gridres+1.e0)*(gridres+1.e0)), m); */
  restoreGeometry();
  if (iwavef == BASIS_FUNCTION || iwavef == BASIS_IN_MO)
  {
    fremem((void **)&orb->coeff);
    fremem((void **)&orb);
  }
  setCursor(windows[VIEWER].widget, XC_top_left_arrow);
}

int runMoloch(double *grid, double gridres, double box, double step, int imo,
		  struct ORBITAL *orbitals, int nbasfu)
{
  static struct PushButtonRow buttons[] = {{"continue", GetMessageBoxButton, (XtPointer)0, NULL}};
  FILE *infile, *outfile;
  pid_t pid;
  char line[MAXLENLINE], mofile[MAXLENLINE], *word;
  register int i, j;

  if (access("control", F_OK))
  {
    word=getStringResource(topShell, "noControlFile");
    messgb(topShell, 1, word, buttons, 1);
    return(TRUE);
  }
  rename("control", "control.save");
  if (!access("propinp", F_OK))
    rename("propinp", "propinp.save");

  if ((infile=fopen("control.save", "r")) == NULL)
  {
    word=getStringResource(topShell, "unableToOpen");
    sprintf(line, word, "control.save");
    messgb(topShell, 1, line, buttons, 1);
    return(TRUE);
  }
  if ((outfile=fopen("control", "w")) == NULL)
  {
    word=getStringResource(topShell, "unableToOpen");
    sprintf(line, word, "control");
    messgb(topShell, 1, line, buttons, 1);
    return(TRUE);
  }
  while (fgets(line, MAXLENLINE, infile) != NULL)
  {
    if (strstr(line, "$end")) break;
    if (strstr(line, "$scfmo"))
    {
	fprintf(outfile, "%s", line);
      if ((word=strtok(line, "=")) != NULL)
	  strcpy(mofile, strtok(NULL, " \t\n"));
      else
        strcpy(mofile, "control");
      continue;
    }
    if (!strstr(line, "$properties"))
    {
      fprintf(outfile, "%s", line);
      continue;
    }
    else
    {
	do
	{
	  fgets(line, MAXLENLINE, infile);
      }
	while (!(word=strchr(line, '$')));
	continue;
    }
  }
  fprintf(outfile, "$properties file=propinp\n");
  fprintf(outfile, "$end\n");
  fclose(infile);
  fclose(outfile);

  outfile=fopen("propinp", "w");
  fprintf(outfile, "$properties\n");
  fprintf(outfile, "    trace                              off\n");
  fprintf(outfile, "    moments                            off\n");
  fprintf(outfile, "    potential                          off\n");
  fprintf(outfile, "    cowan-griffin                      off\n");
  fprintf(outfile, "    localization                       off\n");
  fprintf(outfile, "    population analyses                off\n");
  fprintf(outfile, "    plot                               active\n");
  fprintf(outfile, "    firstorder                         off\n");
  fprintf(outfile, "    fit                                off\n");
  j=0;
  for (i=0; i<=imo; i++)
    if (!strcmp(orbitals[i].symmetry, orbitals[imo].symmetry)) j++;
  fprintf(outfile, "$grid #1\n");
  if (imo != -1)
    fprintf(outfile, " mo %d%s\n", j, orbitals[imo].symmetry);
  else
    fprintf(outfile, " mo\n");
  fprintf(outfile, " origin       .000000      .000000      .000000\n");
  fprintf(outfile, " vector1     1.000000      .000000      .000000\n");
  fprintf(outfile, " vector2      .000000     1.000000      .000000\n");
  fprintf(outfile, " vector3      .000000      .000000     1.000000\n");
  fprintf(outfile, " grid1 range %13.6f%13.6f points %d\n", -box, -box+gridres*step, (int)(gridres)+1);
  fprintf(outfile, " grid2 range %13.6f%13.6f points %d\n", -box, -box+gridres*step, (int)(gridres)+1);
  fprintf(outfile, " grid3 range %13.6f%13.6f points %d\n", -box, -box+gridres*step, (int)(gridres)+1);
  fprintf(outfile, " infile = %s\n", mofile);
  fprintf(outfile, " outfile = grid.dat\n");
  fprintf(outfile, "$end\n");
  fclose(outfile);
  if (runProg(moloch, TRUE, "/dev/null", "/dev/null", "/dev/null", &pid))
  {
    iwavef=ALL_OFF;
    word=getStringResource(topShell, "molochFailed");
    messgb(topShell, 1, word, buttons, 1);
    return(TRUE);
  }
  rename("control.save", "control");
  unlink("propinp");
  if (!access("propinp.save", F_OK)) rename("propinp.save", "propinp");

  if ((infile=fopen("grid.dat", "r")) == NULL)
  {
    word=getStringResource(topShell, "noMolochOutput");
    messgb(topShell, 1, word, buttons, 1);
    return(TRUE);
  }
  while (fgets(line, MAXLENLINE, infile) != NULL)
    if (strstr(line, "$plotdata")) break;
  i=0;
  while (fgets(line, MAXLENLINE, infile) != NULL)
  {
    if (strchr(line, '$')) break;
    while ((word=strchr(line, 'D')) != NULL) *word='E';
    word=line;
    sscanf(word, "%15le", &grid[i++]);
    word+=15;
    while (sscanf(word, "%15le", &grid[i++]) != EOF) word+=15;
    i--;
  }
  fclose(infile);
  unlink("grid.dat");
  return(FALSE);
}

void setGridObject(struct GRIDOBJECT *gridObject, double gridres, int iwavef,
                   int imo, int ibasfu)
{
  char *word;

  gridObject->resolution=gridres;
  gridObject->type=iwavef;
  gridObject->mo=imo;
  gridObject->basisfunction=ibasfu;
  switch (iwavef)
  {
    case BASIS_FUNCTION:    word=getStringResource(topShell, "basisfunctionTitle");
				    sprintf(gridObject->text, word, ibasfu+1,
				            atoms[bfatom].name, bfatom+1, bfname(ibasfu));
                            break;
    case BASIS_IN_MO:       word=getStringResource(topShell, "basisfunctionInMOTitle");
				    sprintf(gridObject->text, word, ibasfu+1, imo+1,
						atoms[bfatom].name, bfatom+1,
						orbitals[imo].coeff[ibasfu], bfname(ibasfu));
                            break;
    case MOLECULAR_ORBITAL: word=getStringResource(topShell, "molecularOrbitalTitle");
				    sprintf(gridObject->text, word, imo+1,
						orbitals[imo].symmetry, orbitals[imo].energy);
				    break;
    case DENSITY:           word=getStringResource(topShell, "electronDensityTitle");
				    sprintf(gridObject->text, word);
				    break;
  }
}

clock_t getCPUTime(void)
{
  struct tms buffer;

  if (times(&buffer) != -1)
    return(buffer.tms_utime+buffer.tms_stime);
  else
    return((clock_t)0);
}
