/*******************************************************************************
*                                                                              *
*                                   Viewmol                                    *
*                                                                              *
*                              C O L E D I T . C                               *
*                                                                              *
*                 Copyright (c) Joerg-R. Hill, December 1997                   *
*                                                                              *
********************************************************************************
*
* $Id: coledit.c,v 1.2 1998/01/26 00:47:11 jrh Exp jrh $
* $Log: coledit.c,v $
* Revision 1.2  1998/01/26 00:47:11  jrh
* Release 2.1
*
* Revision 1.1  1996/12/10  18:40:03  jrh
* Initial revision
*
*/
#include<stdlib.h>
#include<X11/Intrinsic.h>
#include<Xm/Xm.h>
#include<Xm/DialogS.h>
#include<Xm/Form.h>
#include<Xm/Label.h>
#include<Xm/LabelG.h>
#include<Xm/MwmUtil.h>
#include<Xm/PanedW.h>
#include<Xm/PushB.h>
#include<Xm/PushBG.h>
#include<Xm/RowColumn.h>
#include<Xm/Scale.h>
#include<Xm/Separator.h>
#include<Xm/Text.h>
#include<Xm/ToggleB.h>
#ifdef __osf__
#include<X11/GLw/GLwMDrawA.h>
#else
#include<GL/GLwMDrawA.h>
#endif
#include "viewmol.h"
#include "dialog.h"

void colorEditor(Widget, caddr_t, XmAnyCallbackStruct *);
void colorEditorExit(Widget, caddr_t, XmPushButtonCallbackStruct *);
void GetColor(Widget, caddr_t, XmToggleButtonCallbackStruct *);
void SetColor(Widget, float *, XmScrollBarCallbackStruct *);
void getRGBColor(Widget, Pixel, float *, float *, float *);
void storeColor(Pixel, struct WINDOW *, int);
void SetSmooth(Widget, int *, XmToggleButtonCallbackStruct *);

extern Widget CreatePushButtonRow(Widget, struct PushButtonRow *, int);
extern void MapBox(Widget, caddr_t, XmAnyCallbackStruct *);
extern void GetMessageBoxButton(Widget, XtPointer, caddr_t);
extern Pixel getPixel(int);
extern void redraw(int);
extern char *getStringResource(Widget, char *);
extern int getIntResource(Widget, char *);
extern void setMenuItem(int, int, int);
extern void *getmem(size_t, size_t);
extern void *expmem(void *, size_t, size_t);
extern void fremem(void **);
extern int messgb(Widget, int, char *, struct PushButtonRow *, int);

extern Widget topShell;
extern struct WINDOW windows[4];
extern struct ATOM *atoms;
extern struct ELEMENT *elements;
extern struct ORBITAL *orbitals;
extern struct BASISSET *basisset;
extern Pixel stdcol[9], historyColor;
extern float historyColor_rgb[4];
extern int rgbMode, na, ne, nmodes, nhist, debug, projectionMode;

static Widget dialog, red, green, blue, button[9];
static Pixel pixelSave;
static float rSave, gSave, bSave;
static int window, where, smoothSave;

void colorEditor(Widget widget, caddr_t which, XmAnyCallbackStruct *data)
{
  Widget board, form, form1, form2=(Widget)0, smoothRed, smoothGreen, smoothBlue;
  Pixmap selected, unselected;
  Pixel p;
  Arg args[3];
  static struct PushButtonRow buttons[] = {
    { "ok", colorEditorExit, (XtPointer)TRUE, NULL },
    { "cancel", colorEditorExit, (XtPointer)FALSE, NULL }
  };
  static char selectedData[] = {
    0xff, 0xff, 0xff, 0x01, 0x00, 0x80, 0x01, 0x00, 0xb8, 0x01, 0x00, 0xb8,
    0x01, 0x00, 0x9c, 0x01, 0x00, 0x9c, 0x01, 0x00, 0x8e, 0x01, 0x00, 0x8e,
    0x01, 0x00, 0x87, 0x01, 0x00, 0x87, 0x01, 0x80, 0x83, 0x01, 0x80, 0x83,
    0x01, 0x80, 0x81, 0x19, 0xc0, 0x81, 0x39, 0xc0, 0x80, 0x71, 0xe0, 0x80,
    0xe1, 0x60, 0x80, 0xc1, 0x71, 0x80, 0x81, 0x33, 0x80, 0x01, 0x3f, 0x80,
    0x01, 0x1e, 0x80, 0x01, 0x1c, 0x80, 0x01, 0x00, 0x80, 0xff, 0xff, 0xff};
  static char unselectedData[] = {
    0xff, 0xff, 0xff, 0x01, 0x00, 0x80, 0x01, 0x00, 0x80, 0x01, 0x00, 0x80,
    0x01, 0x00, 0x80, 0x01, 0x00, 0x80, 0x01, 0x00, 0x80, 0x01, 0x00, 0x80,
    0x01, 0x00, 0x80, 0x01, 0x00, 0x80, 0x01, 0x00, 0x80, 0x01, 0x00, 0x80,
    0x01, 0x00, 0x80, 0x01, 0x00, 0x80, 0x01, 0x00, 0x80, 0x01, 0x00, 0x80,
    0x01, 0x00, 0x80, 0x01, 0x00, 0x80, 0x01, 0x00, 0x80, 0x01, 0x00, 0x80,
    0x01, 0x00, 0x80, 0x01, 0x00, 0x80, 0x01, 0x00, 0x80, 0xff, 0xff, 0xff};
  float *c=NULL, r, g, b, r1, g1, b1;
  char buttonName[8];
  register int i, j;

  /* This function creates the dialog for the color editor */

  setMenuItem(VIEWER, 16, False);
  setMenuItem(VIEWER, 17, False);
  if (windows[SPECTRUM].widget != 0)
  {
    setMenuItem(SPECTRUM, 7, False);
    setMenuItem(SPECTRUM, 8, False);
  }
  if (windows[MO].widget != 0)
  {
    setMenuItem(MO, 6, False);
    setMenuItem(MO, 7, False);
  }
  if (windows[HISTORY].widget != 0)
  {
    setMenuItem(HISTORY, 3, False);
    setMenuItem(HISTORY, 4, False);
  }

  window=(int)which & 0x7;
  where=((int)which & 0xFFFFFFF8) >> 3;

  XtSetArg(args[0], XmNautoUnmanage, False);
  XtSetArg(args[1], XmNdefaultPosition, False);
  if (XmIsMotifWMRunning(topShell))
    XtSetArg(args[2], XmNmwmDecorations, MWM_DECOR_RESIZEH | MWM_DECOR_TITLE);
  else
    XtSetArg(args[2], (char *)NULL, 0);
  dialog=XmCreateDialogShell(topShell, "colorEditor", args, XtNumber(args));
  board=XtVaCreateWidget("colorEditor", xmFormWidgetClass, dialog,
                         XmNautoUnmanage, False,
                         XmNdefaultPosition, False,
                         NULL);
  form=XtVaCreateWidget("rowcolumn", xmRowColumnWidgetClass, board,
                        XmNorientation, XmVERTICAL,
                        XmNtopAttachment, XmATTACH_FORM,
                        XmNbottomAttachment, XmATTACH_FORM,
                        XmNleftAttachment, XmATTACH_FORM,
                        XmNrightAttachment, XmATTACH_FORM,
                        NULL);

  form1=XtVaCreateWidget("controlarea1", xmRowColumnWidgetClass, form,
                         XmNorientation, XmHORIZONTAL,
                         XmNtopAttachment, XmATTACH_FORM,
                         XmNleftAttachment, XmATTACH_FORM,
                         XmNrightAttachment, XmATTACH_FORM,
                         XmNradioBehavior, True,
                         NULL);
  switch (where)
  {
    case BACKGROUND: if (rgbMode)
                     {
                       r=windows[window].background_rgb[0];
                       g=windows[window].background_rgb[1];
                       b=windows[window].background_rgb[2];
                       pixelSave=-1;
                     }
                     else
                     {
                       getRGBColor(windows[window].widget, windows[window].background, &r, &g, &b);
                       pixelSave=windows[window].background;
                     }
                     break;
    case FOREGROUND: if (rgbMode)
                     {
                       r=windows[window].foreground_rgb[0];
                       g=windows[window].foreground_rgb[1];
                       b=windows[window].foreground_rgb[2];
                       pixelSave=-1;
                     }
                     else
                     {
                       getRGBColor(windows[window].widget, windows[window].foreground, &r, &g, &b);
                       pixelSave=windows[window].foreground;
                     }
                     break;
    case GNORM:      if (rgbMode)
                      {
                       r=historyColor_rgb[0];
                       g=historyColor_rgb[1];
                       b=historyColor_rgb[2];
                       pixelSave=-1;
                     }
                     else
                     {
                       getRGBColor(windows[window].widget, historyColor, &r, &g, &b);
                       pixelSave=historyColor;
                     }
                     break;
  }
  j=WHITE;
  for (i=0; i<=MAGENTA; i++)
  {
    sprintf(buttonName, "button%1d", i);
    p=getPixel(i);
    selected=XCreatePixmapFromBitmapData(XtDisplay(form1), RootWindowOfScreen(XtScreen(form1)),
                selectedData, 24, 24, stdcol[j], p, DefaultDepthOfScreen(XtScreen(form1)));
    unselected=XCreatePixmapFromBitmapData(XtDisplay(form1), RootWindowOfScreen(XtScreen(form1)),
                  unselectedData, 24, 24, stdcol[BLACK], p, DefaultDepthOfScreen(XtScreen(form1)));
    button[i]=XtVaCreateManagedWidget(buttonName, xmToggleButtonWidgetClass, form1,
                                      XmNlabelType, XmPIXMAP,
                                      XmNlabelPixmap, unselected,
                                      XmNselectPixmap, selected,
                                      XmNindicatorOn, False,
                                      NULL);
    XtAddCallback(button[i], XmNvalueChangedCallback, (XtCallbackProc)GetColor, (caddr_t)i);
    getRGBColor(button[i], p, &r1, &g1, &b1);
    if (r1 == r && g1 == g && b1 == b) XtVaSetValues(button[i], XmNset, True, NULL);
    j=BLACK;
  }
  if (rgbMode && where == BACKGROUND && window == VIEWER)
  {
    form2=XtVaCreateWidget("controlarea2", xmRowColumnWidgetClass, form,
                           XmNorientation, XmHORIZONTAL,
                           XmNtopAttachment, XmATTACH_WIDGET,
                           XmNtopWidget, form1,
                           XmNleftAttachment, XmATTACH_FORM,
                           XmNrightAttachment, XmATTACH_FORM,
                           NULL);
    smoothRed=XtVaCreateManagedWidget("smoothRed", xmToggleButtonWidgetClass, form2,
                                      XtVaTypedArg, XmNforeground, XmRString, "Red", 4,
                                      NULL);
    XtAddCallback(smoothRed, XmNvalueChangedCallback, (XtCallbackProc)SetSmooth,
			(XtPointer)1);
    if (windows[window].smooth & 1) XtVaSetValues(smoothRed, XmNset, True, NULL);
    smoothGreen=XtVaCreateManagedWidget("smoothGreen", xmToggleButtonWidgetClass, form2,
                                        XtVaTypedArg, XmNforeground, XmRString, "Green", 6,
                                        NULL);
    XtAddCallback(smoothGreen, XmNvalueChangedCallback, (XtCallbackProc)SetSmooth,
			(XtPointer)2);
    if (windows[window].smooth & 2) XtVaSetValues(smoothGreen, XmNset, True, NULL);
    smoothBlue=XtVaCreateManagedWidget("smoothBlue", xmToggleButtonWidgetClass, form2,
                                       XtVaTypedArg, XmNforeground, XmRString, "Blue", 5,
                                        NULL);
    XtAddCallback(smoothBlue, XmNvalueChangedCallback, (XtCallbackProc)SetSmooth,
			(XtPointer)4);
    if (windows[window].smooth & 4) XtVaSetValues(smoothBlue, XmNset, True, NULL);
  }
  rSave=r;
  gSave=g;
  bSave=b;
  red=XtVaCreateManagedWidget("red", xmScaleWidgetClass, form,
                              XmNorientation, XmHORIZONTAL,
                              XtVaTypedArg, XmNtroughColor, XmRString, "Red", 4,
                              XtVaTypedArg, XmNforeground, XmRString, "Red", 4,
                              XmNvalue, (int)(1000.*r),
                              XmNminimum, 0,
                              XmNmaximum, 1000,
                              XmNdecimalPoints, 3,
                              XmNshowValue, True,
                              XmNsensitive, True,
                              XmNleftAttachment, XmATTACH_FORM,
                              XmNrightAttachment, XmATTACH_FORM,
                              NULL);
  switch (where)
  {
    case FOREGROUND: c=&windows[window].foreground_rgb[0];
                     break;
    case BACKGROUND: c=&windows[window].background_rgb[0];
                     break;
    case GNORM:      c=&historyColor_rgb[0];
                     break;
  }
  XtAddCallback(red, XmNvalueChangedCallback, (XtCallbackProc)SetColor, c);
  XtAddCallback(red, XmNdragCallback, (XtCallbackProc)SetColor, c);
  green=XtVaCreateManagedWidget("green", xmScaleWidgetClass, form,
                                XmNorientation, XmHORIZONTAL,
                                XtVaTypedArg, XmNtroughColor, XmRString, "Green", 6,
                                XtVaTypedArg, XmNforeground, XmRString, "Green", 6,
                                XmNvalue, (int)(1000.*g),
                                XmNminimum, 0,
                                XmNmaximum, 1000,
                                XmNdecimalPoints, 3,
                                XmNshowValue, True,
                                XmNsensitive, True,
                                XmNleftAttachment, XmATTACH_FORM,
                                XmNrightAttachment, XmATTACH_FORM,
                                NULL);
  switch (where)
  {
    case FOREGROUND: c=&windows[window].foreground_rgb[1];
                     break;
    case BACKGROUND: c=&windows[window].background_rgb[1];
                     break;
    case GNORM:      c=&historyColor_rgb[1];
                     break;
  }
  XtAddCallback(green, XmNvalueChangedCallback, (XtCallbackProc)SetColor, c);
  XtAddCallback(green, XmNdragCallback, (XtCallbackProc)SetColor, c);
  blue=XtVaCreateManagedWidget("blue", xmScaleWidgetClass, form,
                               XmNorientation, XmHORIZONTAL,
                               XtVaTypedArg, XmNtroughColor, XmRString, "Blue", 5,
                               XtVaTypedArg, XmNforeground, XmRString, "Blue", 5,
                               XmNvalue, (int)(1000.*b),
                               XmNminimum, 0,
                               XmNmaximum, 1000,
                               XmNdecimalPoints, 3,
                               XmNshowValue, True,
                               XmNsensitive, True,
                               XmNleftAttachment, XmATTACH_FORM,
                               XmNrightAttachment, XmATTACH_FORM,
                               NULL);
  switch (where)
  {
    case FOREGROUND: c=&windows[window].foreground_rgb[2];
                     break;
    case BACKGROUND: c=&windows[window].background_rgb[2];
                     break;
    case GNORM:      c=&historyColor_rgb[2];
                     break;
  }
  XtAddCallback(blue, XmNvalueChangedCallback, (XtCallbackProc)SetColor, c);
  XtAddCallback(blue, XmNdragCallback, (XtCallbackProc)SetColor, c);

  XtManageChild(form1);
  if (rgbMode && where == BACKGROUND && window == VIEWER) XtManageChild(form2);


  CreatePushButtonRow(form, buttons, 2);
  XtAddCallback(dialog, XmNpopupCallback, (XtCallbackProc)MapBox, (XmAnyCallbackStruct *)NULL);
  XtManageChild(form);
  XtManageChild(board);
}

void colorEditorExit(Widget widget, caddr_t which, XmPushButtonCallbackStruct *data)
{
  XColor c;
  Colormap colormap;

  XtDestroyWidget(dialog);
  if (!(int)which)
  {
    switch (where)
    {
      case BACKGROUND: windows[window].background=pixelSave;
                       windows[window].background_rgb[0]=rSave;
                       windows[window].background_rgb[1]=gSave;
                       windows[window].background_rgb[2]=bSave;
                       windows[window].smooth=smoothSave;
                       break;
      case FOREGROUND: windows[window].foreground=pixelSave;
                       windows[window].foreground_rgb[0]=rSave;
                       windows[window].foreground_rgb[1]=gSave;
                       windows[window].foreground_rgb[2]=bSave;
                       break;
      case GNORM:      historyColor=pixelSave;
                       historyColor_rgb[0]=rSave;
                       historyColor_rgb[1]=gSave;
                       historyColor_rgb[2]=bSave;
                       break;
    }
    if (!rgbMode)
    {
      c.pixel=pixelSave;
      c.red=(unsigned short)(rSave*65535.+0.5);
      c.green=(unsigned short)(gSave*65535.+0.5);
      c.blue=(unsigned short)(bSave*65535.+0.5);
      c.flags=DoRed | DoGreen | DoBlue;
      XtVaGetValues(windows[window].widget,
                    XmNcolormap, &colormap,
                    NULL);
      XStoreColor(XtDisplay(windows[window].widget), colormap, &c);
    }
    redraw(window);
  }
  if (projectionMode != ORTHO) setMenuItem(VIEWER, 16, True);
  setMenuItem(VIEWER, 17, True);
  if (windows[SPECTRUM].widget != 0)
  {
    setMenuItem(SPECTRUM, 7, True);
    setMenuItem(SPECTRUM, 8, True);
  }
  if (windows[MO].widget != 0)
  {
    setMenuItem(MO, 6, True);
    setMenuItem(MO, 7, True);
  }
  if (windows[HISTORY].widget != 0)
  {
    setMenuItem(HISTORY, 3, True);
    setMenuItem(HISTORY, 4, True);
  }
}

void GetColor(Widget widget, caddr_t which, XmToggleButtonCallbackStruct *data)
{
  XColor c;
  Colormap colormap;
  float r, g, b;

  if (data->set)
  {
    getRGBColor(widget, stdcol[(int)which], &r, &g, &b);
    switch (where)
    {
      case BACKGROUND: windows[window].background_rgb[0]=r;
                       windows[window].background_rgb[1]=g;
                       windows[window].background_rgb[2]=b;
                       c.pixel=windows[window].background;
                       break;
      case FOREGROUND: windows[window].foreground_rgb[0]=r;
                       windows[window].foreground_rgb[1]=g;
                       windows[window].foreground_rgb[2]=b;
                       c.pixel=windows[window].foreground;
                       break;
      case GNORM:      historyColor_rgb[0]=r;
                       historyColor_rgb[1]=g;
                       historyColor_rgb[2]=b;
                       c.pixel=historyColor;
                       break;
    }
    XtVaSetValues(red,   XmNvalue, (int)(1000.*r), NULL);
    XtVaSetValues(green, XmNvalue, (int)(1000.*g), NULL);
    XtVaSetValues(blue,  XmNvalue, (int)(1000.*b), NULL);
    if (!rgbMode)
    {
      c.red=(unsigned short)(r*65535.+0.5);
      c.green=(unsigned short)(g*65535.+0.5);
      c.blue=(unsigned short)(b*65535.+0.5);
      c.flags=DoRed | DoGreen | DoBlue;
      XtVaGetValues(widget,
                    XmNcolormap, &colormap,
                    NULL);
      XStoreColor(XtDisplay(windows[window].widget), colormap, &c);
    }
    redraw(window);
  }
}

void SetColor(Widget widget, float *color, XmScrollBarCallbackStruct *data)
{
  Colormap colormap;
  XColor c;
  float r, g, b;
  register int i;

  *color=0.001*(double)(data->value);
  switch (where)
  {
    case BACKGROUND: c.pixel=windows[window].background;
                     c.red=(unsigned short)(windows[window].background_rgb[0]*65535.+0.5);
                     c.green=(unsigned short)(windows[window].background_rgb[1]*65535.+0.5);
                     c.blue=(unsigned short)(windows[window].background_rgb[2]*65535.+0.5);
                     break;
    case FOREGROUND: c.pixel=windows[window].foreground;
                     c.red=(unsigned short)(windows[window].foreground_rgb[0]*65535.+0.5);
                     c.green=(unsigned short)(windows[window].foreground_rgb[1]*65535.+0.5);
                     c.blue=(unsigned short)(windows[window].foreground_rgb[2]*65535.+0.5);
                     break;
    case GNORM:      c.pixel=historyColor;
                     c.red=(unsigned short)(historyColor_rgb[0]*65535.+0.5);
                     c.green=(unsigned short)(historyColor_rgb[1]*65535.+0.5);
                     c.blue=(unsigned short)(historyColor_rgb[2]*65535.+0.5);
                     break;
  }
  if (!rgbMode)
  {
    c.flags=DoRed | DoGreen | DoBlue;
    XtVaGetValues(windows[window].widget,
                  XmNcolormap, &colormap,
                  NULL);
    XStoreColor(XtDisplay(windows[window].widget), colormap, &c);
  }
  for (i=0; i<=MAGENTA; i++)
  {
    XtVaSetValues(button[i], XmNset, False, NULL);
    getRGBColor(button[i], stdcol[i], &r, &g, &b);
    if ((unsigned short)(65535.*r+0.5) == c.red && (unsigned short)(65535.*g+0.5) == c.green
        && (unsigned short)(65535.*b+0.5) == c.blue)
    {
      XtVaSetValues(button[i], XmNset, True, NULL);
      break;
    }
  }
  redraw(window);
}

void getRGBColor(Widget widget, Pixel pixel, float *r, float *g, float *b)
{
  Display *display;
  Colormap colormap;
  XColor color;

  display=XtDisplay(widget);
  XtVaGetValues(XtParent(widget), XmNcolormap, &colormap, NULL);
  color.pixel=pixel;
  XQueryColor(display, colormap, &color);
  *r=(float)(color.red)/65535.;
  *g=(float)(color.green)/65535.;
  *b=(float)(color.blue)/65535.;
}

void storeColor(Pixel pixel, struct WINDOW *window, int where)
{
  Display *display;
  Colormap colormap, defaultColormap;
  XColor c;

  switch (where)
  {
    case BACKGROUND: getRGBColor(window->widget, pixel, &(window->background_rgb[0]),
                                 &(window->background_rgb[1]), &(window->background_rgb[2]));
                     break;
    case FOREGROUND: getRGBColor(window->widget, pixel, &(window->foreground_rgb[0]),
                                 &(window->foreground_rgb[1]), &(window->foreground_rgb[2]));
                     break;
    case GNORM:      display=XtDisplay(window->widget);
                     XtVaGetValues(window->widget, XmNcolormap, &colormap, NULL);
                     if (rgbMode)
                     {
                       defaultColormap=DefaultColormap(display, DefaultScreen(display));
                       if (defaultColormap != colormap) colormap=defaultColormap;
                     }
                     c.pixel=pixel;
                     XQueryColor(display, colormap, &c);
                     historyColor_rgb[0]=(float)(c.red)/65535.;
                     historyColor_rgb[1]=(float)(c.green)/65535.;
                     historyColor_rgb[2]=(float)(c.blue)/65535.;
                     break;
  }
  if (rgbMode) return;
  XtVaGetValues(window->widget, XmNcolormap, &colormap, NULL);
  c.flags=DoRed | DoGreen | DoBlue;
  switch (where)
  {
    case BACKGROUND: c.pixel=window->background;
                     c.red=(unsigned short)(window->background_rgb[0]*65535.+0.5);
                     c.green=(unsigned short)(window->background_rgb[1]*65535.+0.5);
                     c.blue=(unsigned short)(window->background_rgb[2]*65535.+0.5);
                     break;
    case FOREGROUND: c.pixel=window->foreground;
                     c.red=(unsigned short)(window->foreground_rgb[0]*65535.+0.5);
                     c.green=(unsigned short)(window->foreground_rgb[1]*65535.+0.5);
                     c.blue=(unsigned short)(window->foreground_rgb[2]*65535.+0.5);
                     break;
    case GNORM:      c.pixel=historyColor;
                     c.red=(unsigned short)(historyColor_rgb[0]*65535.+0.5);
                     c.green=(unsigned short)(historyColor_rgb[1]*65535.+0.5);
                     c.blue=(unsigned short)(historyColor_rgb[2]*65535.+0.5);
                     break;
  }
  XStoreColor(XtDisplay(window->widget), colormap, &c);
}

void loadColorMap(void)
{
  char *colorname[9] = { "black", "white", "red", "green", "blue", "yellow",
                         "magenta", "cyan1", "SkyBlue"};
  Display *display;
  Colormap colormap, defaultColormap;
  XColor hardwarecolor, exactcolor;
  register int i;

  display=XtDisplay(windows[VIEWER].widget);
  XtVaGetValues(windows[VIEWER].widget,
                XmNcolormap, &colormap,
                NULL);
  if (rgbMode)
  {
    defaultColormap=DefaultColormap(display, DefaultScreen(display));
    if (defaultColormap != colormap) colormap=defaultColormap;
  }
  for (i=0; i<9; i++)
  {
    if (XAllocNamedColor(display, colormap, colorname[i], &hardwarecolor,
                         &exactcolor))
      stdcol[i]=hardwarecolor.pixel;
    else
      stdcol[i]=0L;
  }
}

void loadAtomColors()
{
  static struct PushButtonRow buttons[] = {{"exit", GetMessageBoxButton, (XtPointer)0, NULL}};
  Display *display;
  Colormap colormap;
  XColor c;
  XVisualInfo *vi;
  float r, g, b;
  unsigned long *pixels, nramp;
  struct ELEMENT **e;
  char *word;
  int l=0, reserved=0;
  register int i, j, k, count=0;

  e=(struct ELEMENT **)getmem(na, sizeof(struct ELEMENT *));
  for (i=0; i<na; i++)
  {
    e[i]=atoms[i].element;
  }
  for (i=0; i<na; i++)
  {
    for (j=0; j<i; j++)
    {
      if (e[j] && e[j] == e[i]) e[i]=(struct ELEMENT *)0;
    }
  }
  if (basisset != NULL || orbitals != NULL)
  {
    e=(struct ELEMENT **)expmem((void *)e, na+2, sizeof(struct ELEMENT *));
    for (k=0; k<ne; k++)
    {
      if (!strcmp(elements[k].symbol, "Ps")) e[na]=&elements[k];
      if (!strcmp(elements[k].symbol, "Ms")) e[na+1]=&elements[k];
    }
    count=2;
    l=2;
  }
  for (i=0; i<na; i++)
  {
    if (e[i]) count++;
  }
  display=XtDisplay(windows[VIEWER].widget);
  XtVaGetValues(windows[VIEWER].widget,
                GLwNvisualInfo, &vi,
                XmNcolormap, &colormap,
                NULL);
  reserved=getIntResource(topShell, "reservedColors");
  nramp=(vi->colormap_size-20-reserved)/count;
  pixels=(unsigned long *)getmem((size_t)(nramp*count), sizeof(unsigned long));
  while (!XAllocColorCells(display, colormap, True, NULL, 0, pixels,
                           (unsigned long)(nramp*count-reserved)))
  {
    nramp--;
    if (nramp < 3)
    {
      word=getStringResource(topShell, "noColors");
      messgb(topShell, 3, word, buttons, 1);
      exit(-1);
    }
  }
  if (reserved) nramp-=reserved/count+1;
  if (debug) printf("%ld colors per atom available.\n", nramp);
  j=0;
  c.flags=DoRed | DoGreen | DoBlue;
  for (i=0; i<na+l; i++)
  {
    if (e[i])
    {
      r=e[i]->dark[0];
      g=e[i]->dark[1];
      b=e[i]->dark[2];
      c.pixel=pixels[j];
      c.red=(unsigned short)(r*65535.+0.5);
      c.green=(unsigned short)(g*65535.+0.5);
      c.blue=(unsigned short)(b*65535.+0.5);
      XStoreColor(display, colormap, &c);
      e[i]->colormap[0]=pixels[j++];
      r=(e[i]->light[0]-e[i]->dark[0])/(nramp-1);
      g=(e[i]->light[1]-e[i]->dark[1])/(nramp-1);
      b=(e[i]->light[2]-e[i]->dark[2])/(nramp-1);
      for (k=1; k<nramp-1; k++)
      {
        c.pixel=pixels[j];
        c.red=(unsigned short)((e[i]->dark[0]+k*r)*65535.+0.5);
        c.green=(unsigned short)((e[i]->dark[1]+k*g)*65535.+0.5);
        c.blue=(unsigned short)((e[i]->dark[2]+k*b)*65535.+0.5);
        XStoreColor(display, colormap, &c);
        if (k == nramp/2) e[i]->colormap[1]=pixels[j];
        j++;
      }
      r=e[i]->light[0];
      g=e[i]->light[1];
      b=e[i]->light[2];
      c.pixel=pixels[j];
      c.red=(unsigned short)(r*65535.+0.5);
      c.green=(unsigned short)(g*65535.+0.5);
      c.blue=(unsigned short)(b*65535.+0.5);
      XStoreColor(display, colormap, &c);
      e[i]->colormap[2]=pixels[j++];
    }
  }
  fremem((void **)&e);
}

void allocWindowColors(void)
{
  static struct PushButtonRow buttons[] = {{"exit", GetMessageBoxButton, (XtPointer)0, NULL}};
  Display *display;
  Colormap colormap;
  Pixel pixel;
  unsigned long ncolors=2, *pixels;
  char *word;
  register int i=0;

  if (rgbMode)
  {
    XtVaGetValues(windows[VIEWER].widget, XmNbackground, &pixel, NULL);
    getRGBColor(windows[VIEWER].widget, pixel, &(windows[VIEWER].background_rgb[0]),
                &(windows[VIEWER].background_rgb[1]), &(windows[VIEWER].background_rgb[2]));
    XtVaGetValues(windows[VIEWER].widget, XmNforeground, &pixel, NULL);
    getRGBColor(windows[VIEWER].widget, pixel, &(windows[VIEWER].foreground_rgb[0]),
                &(windows[VIEWER].foreground_rgb[1]), &(windows[VIEWER].foreground_rgb[2]));
    windows[VIEWER].background_rgb[3]=1.0;
    windows[VIEWER].foreground_rgb[3]=1.0;
  }
  else
  {
    display=XtDisplay(windows[VIEWER].widget);
    XtVaGetValues(windows[VIEWER].widget, XmNcolormap, &colormap, NULL);
    if (nmodes != 0)      ncolors+=2;
    if (nhist != 0)       ncolors+=3;
    if (orbitals != NULL) ncolors+=2;
    pixels=(unsigned long *)getmem((size_t)ncolors, sizeof(unsigned long));
    if (!XAllocColorCells(display, colormap, True, NULL, 0, pixels, ncolors))
    {
      word=getStringResource(topShell, "noColors");
      messgb(topShell, 3, word, buttons, 1);
      exit(-1);
    }
    windows[VIEWER].background=pixels[i++];
    windows[VIEWER].foreground=pixels[i++];
    if (nmodes != 0)
    {
      windows[SPECTRUM].background=pixels[i++];
      windows[SPECTRUM].foreground=pixels[i++];
    }
    if (nhist != 0)
    {
      windows[HISTORY].background=pixels[i++];
      windows[HISTORY].foreground=pixels[i++];
      historyColor=pixels[i++];
    }
    if (orbitals != NULL)
    {
      windows[MO].background=pixels[i++];
      windows[MO].foreground=pixels[i++];
    }
    free((void *)pixels);
    XtVaGetValues(windows[VIEWER].widget, XmNbackground, &pixel, NULL);
    storeColor(pixel, &windows[VIEWER], BACKGROUND);
    XtVaGetValues(windows[VIEWER].widget, XmNforeground, &pixel, NULL);
    storeColor(pixel, &windows[VIEWER], FOREGROUND);
  }
}

void SetSmooth(Widget widget, int *which, XmToggleButtonCallbackStruct *data)
{
  if (data->set) windows[window].smooth |= (int)which;
  else           windows[window].smooth &= ~(int)which;
  redraw(window);
}
