/*******************************************************************************
*                                                                              *
*                                   Viewmol                                    *
*                                                                              *
*                                 D R A W . C                                  *
*                                                                              *
*                 Copyright (c) Joerg-R. Hill, December 1997                   *
*                                                                              *
********************************************************************************
*
* $Id: draw.c,v 1.2 1998/01/26 00:47:27 jrh Exp jrh $
* $Log: draw.c,v $
* Revision 1.2  1998/01/26 00:47:27  jrh
* Release 2.1
*
* Revision 1.1  1996/12/10  18:40:22  jrh
* Initial revision
*
*/
#include<limits.h>
#include<math.h>
#include<stdio.h>
#include<stdlib.h>
#include<time.h>
#include<X11/Xlib.h>
#include<X11/Intrinsic.h>
#include<X11/StringDefs.h>
#include<X11/keysym.h>
#include<Xm/Xm.h>
#include<GL/gl.h>
#include<GL/glu.h>
#ifdef __osf__
#include<X11/GLw/GLwMDrawA.h>
#else
#include<GL/GLwMDrawA.h>
#endif
#include "viewmol.h"

int renderMolecule(int, int);
void wireModel(Dimension, int);
void stickModel(int, int);
void balls(double, int);
void setAtomProperties(struct ELEMENT *, int);
void drawIntern(void);
void labelAtoms(int);
void drawAnnotation(void);
void drawForces(int);
void drawNormalMode(int);
void drawArrow(double, double, double, double, double, double);
void drawGround(void);
void shadow(GLfloat v0[3], GLfloat v1[3], GLfloat v2[3], GLfloat vector[4]);
void shadowColor(void);

extern void setWindowColor(int, Pixel, const float *);
extern int StringWidth(XFontStruct *, char *);
extern int StringHeight(XFontStruct *);
extern void cone(double, double, double, double, double, double, double, int);
extern double dist(double, double, double, double, double, double);
extern void pixelToWorld(int, double *, double *);
extern void (*drawBegin)(GLenum), (*drawEnd)(void);
extern void (*drawVertex3d)(double, double, double);
extern void (*drawNormal3d)(double, double, double);
extern void (*drawColor4fv)(const GLfloat *);
extern void (*drawSphere)(GLUquadricObj *, GLdouble, GLint, GLint);
extern void (*drawString)(char *, double, double, double, double, GLuint);
extern void (*drawLineStipple)(GLint, GLushort);
extern void (*drawLineWidth)(GLfloat);
extern void (*drawDisable)(GLenum);
extern void raytracerBegin(GLenum);
extern void manual(Widget, caddr_t, caddr_t);
extern char *getStringResource(Widget, char *);
extern void printDialog(Widget, caddr_t, XmAnyCallbackStruct *);
extern void marchingCube(double, double, double, double *grid, double, int,
                         int, int, double, int, void (*)(GLenum), void (*)(void),
                         void (*)(double, double, double),
                         void (*)(double, double, double), int, int);
extern void ellipse(double, double, double, double, double, double, double,
                    double, double, int);
extern void cylinder(double, double, double, double, double, double, double,
                     int, GLenum);
extern char *bfname(int);
extern void raytracerMaterial(struct ELEMENT *);
extern void transformCoordinates(int, float input[4], float output[4]);
extern void redraw(int);
extern void *getmem(size_t, size_t);
extern void *expmem(void *, size_t, size_t);
extern void fremem(void **);
extern clock_t getCPUTime(void);
extern void scaleAnnotation(float);

extern struct ATOM *atoms;
extern struct BOND *bonds;
extern struct ELEMENT *elements;
extern struct WINDOW windows[];
extern struct INTERNAL *internals;
extern struct NORMAL_MODE *normal_modes;
extern struct OPTIMIZATION *optimization;
extern struct COORDS *history;
extern struct ORBITAL *orbitals;
extern struct GRIDOBJECT *gridObjects;
extern struct ANNOTATION *annotation;
extern Pixel stdcol[9];
extern Widget topShell;
extern GLfloat light0p[], light1p[];
extern int na, nb, ne, ninternal, nmodes, ngridobjects;
extern int label, mode, showForces, animate, existsUnitCell, showUnitCell, showInertia;
extern int primitive, imo, ibasfu, bfatom, lights, moveItem, projectionMode;
extern int shadows, ground;
extern double *cnm, cycle, amplitude, forceScale, wnScale;
extern double gridres, sphereres, lineWidth;
extern double tinert[3][3];
extern float xrot[4], yrot[4], zrot[4];
extern float xmov[2], ymov[2], zmov[2];
extern int rgbMode, picking, swapBuffers, selectAtom;
extern int iwavef, interp, debug, setins, nAnnotations;
extern double *grid, radfac, level, weight;
extern char *formBondLength, *formBondAngle, *formTorsionAngle;

void drawBackground(int window, Pixel color, double depthBufferClear)
{
  float background_rgb[4] = {0.0, 0.0, 1.0, 0.0};
  int clear=GL_COLOR_BUFFER_BIT;

  if (windows[window].smooth)
  {
    background_rgb[0]=windows[window].background_rgb[0];
    background_rgb[1]=windows[window].background_rgb[1];
    background_rgb[2]=windows[window].background_rgb[2];

    glMatrixMode(GL_PROJECTION);
    glPushMatrix();
    glLoadIdentity();
    glOrtho(0.0, 1.0, 0.0, 1.0, 0.0, 1.0);
    glShadeModel(GL_SMOOTH);
    glBegin(GL_POLYGON);
    if (windows[window].smooth & 1) background_rgb[0]=0.7;
    if (windows[window].smooth & 2) background_rgb[1]=0.7;
    if (windows[window].smooth & 4) background_rgb[2]=0.7;
    setWindowColor(FOREGROUND, color, background_rgb);
    glVertex3f(0.0, 0.0, 0.0);
    glVertex3f(1.0, 0.0, 0.0);
    if (windows[window].smooth & 1) background_rgb[0]=0.3;
    if (windows[window].smooth & 2) background_rgb[1]=0.3;
    if (windows[window].smooth & 4) background_rgb[2]=0.3;
    setWindowColor(FOREGROUND, color, background_rgb);
    glVertex3f(1.0, 1.0, 0.0);
    glVertex3f(0.0, 1.0, 0.0);
    glEnd();
    glShadeModel(GL_FLAT);
    glPopMatrix();
    glMatrixMode(GL_MODELVIEW);
    clear=GL_DEPTH_BUFFER_BIT;
  }
  else
  {
    setWindowColor(BACKGROUND, color, windows[window].background_rgb);
    if (depthBufferClear != 0.0) clear|=GL_DEPTH_BUFFER_BIT;
  }
  if (depthBufferClear != 0.0)
    glClearDepth(depthBufferClear);
  if (shadows) clear|=GL_STENCIL_BUFFER_BIT;
  glClear(clear);
}

void drawMolecule(Widget w, caddr_t client_data, GLwDrawingAreaCallbackStruct *data)
{
  GLfloat light1t[4];
  GLfloat xview, yview, zview;
  GLfloat light0c[4] = {1.0, 1.0, 1.0, 1.0};
  GLfloat light1c[4] = {1.0, 1.0, 1.0, 1.0};
  GLfloat ground0[3] = {0.0, 0.0, 0.0};
  GLfloat ground1[3] = {1.0, 0.0, 0.0};
  GLfloat ground2[3] = {0.0, 0.0, 1.0};
  clock_t startTime=0;
  Dimension width, height;
  int renderMode;
  register int found;

  if (debug) startTime=getCPUTime();
  glGetIntegerv(GL_RENDER_MODE, &renderMode);
  if (renderMode == GL_RENDER)
    GLwDrawingAreaMakeCurrent(windows[VIEWER].widget, windows[VIEWER].context);
  if (!picking)
  {
    glMatrixMode(GL_PROJECTION);
    glLoadIdentity();
  }
  XtVaGetValues(windows[VIEWER].widget, XtNwidth, &width, XtNheight, &height, NULL);
  if (projectionMode == ORTHO)
    glOrtho(windows[VIEWER].left, windows[VIEWER].right, windows[VIEWER].bottom,
            windows[VIEWER].top, windows[VIEWER].near, windows[VIEWER].far);
  else
  {
    if (2.0*windows[VIEWER].far > zmov[VIEWPOINT])
      zview=2.0*windows[VIEWER].far-zmov[VIEWPOINT];
    else
      zview=0.1;
    yview=0.75*windows[VIEWER].near*windows[VIEWER].top/windows[VIEWER].far;
    xview=yview*(double)(width)/(double)(height);
    glFrustum(xview, (-xview), yview, (-yview), zview,
              10.0*windows[VIEWER].far-zmov[VIEWPOINT]);
    glTranslatef(xmov[VIEWPOINT], ymov[VIEWPOINT], zmov[VIEWPOINT]);
    glRotatef(0.25*xrot[VIEWPOINT], 1.0, 0.0, 0.0);
    glRotatef(0.25*yrot[VIEWPOINT], 0.0, 1.0, 0.0);
    glRotatef(0.25*zrot[VIEWPOINT], 0.0, 0.0, 1.0);
    gluLookAt(0.0, 0.0, 3.0*windows[VIEWER].far, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0);
  }
  if (!picking)
  {
    glMatrixMode(GL_MODELVIEW);
    glLoadIdentity();
    drawBackground(VIEWER, windows[VIEWER].background, windows[VIEWER].far);
  }
  if (nAnnotations > 0) drawAnnotation();
  if (shadows) glPushMatrix();
  if (primitive == GLU_FILL && windows[VIEWER].mode != WIREMODEL)
  {
    if (lights & 0x1)
    {
      glPushMatrix();
      glRotatef(xrot[LIGHTNO0], 1.0, 0.0, 0.0);
      glRotatef(yrot[LIGHTNO0], 0.0, 1.0, 0.0);
      glRotatef(zrot[LIGHTNO0], 0.0, 0.0, 1.0);
      glLightfv(GL_LIGHT0, GL_POSITION, light0p);
      glLightfv(GL_LIGHT0, GL_DIFFUSE,  light0c);
      glPopMatrix();
    }
    if (lights & 0x2)
    {
      glPushMatrix();
      glRotatef(xrot[LIGHTNO1], 1.0, 0.0, 0.0);
      glRotatef(yrot[LIGHTNO1], 0.0, 1.0, 0.0);
      glRotatef(zrot[LIGHTNO1], 0.0, 0.0, 1.0);
      glLightfv(GL_LIGHT1, GL_POSITION, light1p);
      glLightfv(GL_LIGHT1, GL_DIFFUSE,  light1c);
      glPopMatrix();
    }
  }
  if (projectionMode == PERSPECTIVE)
  {
    if (ground) drawGround();
    glEnable(GL_CLIP_PLANE0);
  }
  glTranslatef(xmov[MOLECULE], ymov[MOLECULE], zmov[MOLECULE]);
  glRotatef(xrot[MOLECULE], 1.0, 0.0, 0.0);
  glRotatef(yrot[MOLECULE], 0.0, 1.0, 0.0);
  glRotatef(zrot[MOLECULE], 0.0, 0.0, 1.0);

  found=renderMolecule((width+height)/2, TRUE);

  if (projectionMode == PERSPECTIVE) glDisable(GL_CLIP_PLANE0);

  if (shadows && (lights & 0x2))
  {
    glStencilFunc(GL_LESS, 2, 0xffffffff);
    glStencilOp(GL_REPLACE, GL_REPLACE, GL_REPLACE);
    glEnable(GL_BLEND);
    glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
    glColor4f(0.0, 0.0, 0.0, 0.5);
    glPassThrough((GLfloat)(ADD_DEPTH+(int)(2.0*windows[VIEWER].far)));
    glPopMatrix();
    ground0[1]=windows[VIEWER].bottom;
    ground1[1]=windows[VIEWER].bottom;
    ground2[1]=windows[VIEWER].bottom;
    transformCoordinates(LIGHTNO1, light1p, light1t);
    shadow(ground0, ground1, ground2, light1t);
    glTranslatef(xmov[MOLECULE], ymov[MOLECULE], zmov[MOLECULE]);
    glRotatef(xrot[MOLECULE], 1.0, 0.0, 0.0);
    glRotatef(yrot[MOLECULE], 0.0, 1.0, 0.0);
    glRotatef(zrot[MOLECULE], 0.0, 0.0, 1.0);
    found=renderMolecule((width+height)/2, FALSE);
    glDisable(GL_BLEND);
    glDisable(GL_STENCIL_TEST);
    glPassThrough((GLfloat)(ADD_DEPTH));
  }

  if (label) labelAtoms(LABEL);
  if (setins) labelAtoms(INS);
  if (swapBuffers) GLwDrawingAreaSwapBuffers(windows[VIEWER].widget);
  if (debug)
  {
    startTime=getCPUTime()-startTime;
    if (startTime != (clock_t)0)
      printf("%.1f fps (%.2f ms per frame)\n", (double)CLK_TCK/startTime,
  	       1000.*startTime/(double)CLK_TCK);
    else
	printf("> %d fps (< %.2f ms per frame)\n", CLK_TCK, 1000./(double)CLK_TCK);
  }
}

int renderMolecule(int width, int lighting)
{
  double boxf;
  const float black[4] = {0.0, 0.0, 0.0, 1.0};
  int prim=GL_LINE_LOOP;
  register int i, found=0;

  if (windows[VIEWER].mode == WIREMODEL || primitive == GLU_POINT)
  {
    glShadeModel(GL_FLAT);
    wireModel(width, lighting);
  }
  if (primitive != GLU_FILL || windows[VIEWER].mode == WIREMODEL)
    glShadeModel(GL_FLAT);
  else
  {
    glShadeModel(GL_SMOOTH);
    glCullFace(GL_BACK);
    glEnable(GL_DEPTH_TEST);
    glEnable(GL_CULL_FACE);
    glDepthFunc(GL_LESS);
    if (lighting)
    {
      glEnable(GL_LIGHTING);
      if (lights & 0x1) glEnable(GL_LIGHT0);
      if (lights & 0x2) glEnable(GL_LIGHT1);
    }
  }
  if (windows[VIEWER].mode == STICKMODEL || windows[VIEWER].mode == BALLMODEL)
    stickModel(FALSE, lighting);
  if (windows[VIEWER].mode == STICKMODEL)
  {
    if (lighting) glPassThrough((GLfloat)(ADD_DEPTH+(int)(windows[VIEWER].far)));
    balls(-atoms[na].rad, lighting);
    if (lighting) glPassThrough((GLfloat)(ADD_DEPTH));
  }
  if (windows[VIEWER].mode == BALLMODEL)
    balls(0.5, lighting);
  if (windows[VIEWER].mode == CUPMODEL)
  {
    balls(1.3, lighting);
    stickModel(TRUE, lighting);
  }
  if (primitive == GLU_FILL) glDisable(GL_CULL_FACE);
  if ((imo != -1 || ibasfu != -1 || iwavef != ALL_OFF) && !selectAtom)
  {
/*  if (drawBegin == glBegin)
    { */
      for (i=0; i<ngridobjects; i++)
      {
        if (gridObjects[i].type == iwavef)
        {
          if ((iwavef == MOLECULAR_ORBITAL && gridObjects[i].mo == imo) ||
              (iwavef == BASIS_IN_MO && gridObjects[i].mo == imo &&
                                        gridObjects[i].basisfunction == ibasfu) ||
              (iwavef == BASIS_FUNCTION && gridObjects[i].basisfunction == ibasfu) ||
              iwavef == DENSITY)
          {
            found=i+1;
            if (debug) printf("Found MO/basis function: %d\n", found);
            break;
          }
        } 
      }
/*  } */
    if (found)
    {
      boxf=windows[VIEWER].far;
      gridres=gridObjects[found-1].resolution;
      (*drawLineWidth)((GLfloat)1.);
      switch (primitive)
      {
        case GLU_POINT: prim=GL_POINTS;
                        break;
        case GLU_LINE:  prim=GL_LINE_LOOP;
                        break;
        case GLU_FILL:  prim=GL_TRIANGLE_STRIP;
                        break;
      }
      if (drawBegin == raytracerBegin) prim=GL_LINE_LOOP;
      if (primitive == GLU_FILL)
      {
        glShadeModel(GL_SMOOTH);
        glEnable(GL_DEPTH_TEST);
        glDepthFunc(GL_LESS);
        if (lighting)
        {
          glEnable(GL_LIGHTING);
          if (lights & 0x1) glEnable(GL_LIGHT0);
          if (lights & 0x2) glEnable(GL_LIGHT1);
        }
/*      glBlend(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
        glEnable(GL_BLEND);*/
      }
      for (i=0; i<ne; i++)
        if (!strcmp(elements[i].symbol, "Ps")) break;
      setAtomProperties(&elements[i], lighting);
      glPassThrough((GLfloat)VISIBILITY);
      marchingCube(-boxf, -boxf, -boxf, gridObjects[found-1].grid,
                   2.0*boxf/gridres, (int)(gridres), (int)(gridres),
                   (int)(gridres), level, prim, drawBegin, drawEnd,
                   drawVertex3d, drawNormal3d, interp, debug);
      if (iwavef != DENSITY)
      {
        for (i=0; i<ne; i++)
          if (!strcmp(elements[i].symbol, "Ms")) break;
        setAtomProperties(&elements[i], lighting);
        level=(-level);
        marchingCube(-boxf, -boxf, -boxf, gridObjects[found-1].grid,
                      2.0*boxf/gridres, (int)(gridres), (int)(gridres),
                      (int)(gridres), level, prim, drawBegin, drawEnd,
                      drawVertex3d, drawNormal3d, interp, debug);
        level=(-level);
      }
      glPassThrough((GLfloat)VISIBILITY);
    }
  }
  if (primitive == GLU_FILL)
  {
    glDisable(GL_DEPTH_TEST);
    glShadeModel(GL_FLAT);
    if (lighting)
    {
      glDisable(GL_LIGHTING);
      if (lights & 0x1) glDisable(GL_LIGHT0);
      if (lights & 0x2) glDisable(GL_LIGHT1);
    }
/*  glDisable(GL_BLEND); */
  }
  if (showForces && !picking) drawForces(lighting);
  if (showInertia)
  {
    (*drawLineWidth)((GLfloat)1.);
    if (lighting)
      setWindowColor(FOREGROUND, stdcol[BLACK], black);
    else
      shadowColor();
    ellipse(0.0, 0.0, 0.0, tinert[0][0], tinert[0][1], tinert[0][2],
            tinert[1][0], tinert[1][1], tinert[1][2], 40);
    ellipse(0.0, 0.0, 0.0, tinert[1][0], tinert[1][1], tinert[1][2],
            tinert[2][0], tinert[2][1], tinert[2][2], 40);
    ellipse(0.0, 0.0, 0.0, tinert[2][0], tinert[2][1], tinert[2][2],
            tinert[0][0], tinert[0][1], tinert[0][2], 40);
  }
  if (mode != -1 && animate == ARROWS && cnm != NULL) drawNormalMode(lighting);
  if (ninternal && !picking) drawIntern();
  return(found);
}

void wireModel(Dimension width, int lighting)
{ 
  double x, y, z;
  int first, second;
  register int i;

  if (lineWidth == 0.0)
    (*drawLineWidth)((GLfloat)width*0.01);
  else
    (*drawLineWidth)((GLfloat)lineWidth);
  for (i=0; i<nb; i++)
  {
    first=bonds[i].first;
    if (!strncmp(atoms[first].name, "Uc", 2) && !showUnitCell) continue;
    second=bonds[i].second;
    x=atoms[first].x+bonds[i].frac*(atoms[second].x-atoms[first].x);
    y=atoms[first].y+bonds[i].frac*(atoms[second].y-atoms[first].y);
    z=atoms[first].z+bonds[i].frac*(atoms[second].z-atoms[first].z);
    if (abs(bonds[i].order) != 2)
    {
      if (picking)
      {
        glLoadName(first+1);
        (*drawBegin)(GL_LINES);
      }
      else
        (*drawBegin)(GL_LINE_STRIP);
      setAtomProperties(atoms[first].element, lighting);
      (*drawVertex3d)(atoms[first].x, atoms[first].y, atoms[first].z);
      (*drawVertex3d)(x, y, z);
      if (picking)
      {
        (*drawEnd)();
        glLoadName(second+1);
        (*drawBegin)(GL_LINES);
        (*drawVertex3d)(x, y, z);
      }
      setAtomProperties(atoms[second].element, lighting);
      (*drawVertex3d)(atoms[second].x, atoms[second].y, atoms[second].z);
      (*drawEnd)();
    }
    if (abs(bonds[i].order) > 1)
    {
      if (picking)
      {
        glLoadName(first+1);
        (*drawBegin)(GL_LINES);
      }
      else
        (*drawBegin)(GL_LINE_STRIP);
      setAtomProperties(atoms[first].element, lighting);
      (*drawVertex3d)(atoms[first].x-bonds[i].x, atoms[first].y-bonds[i].y,
			    atoms[first].z-bonds[i].z);
      (*drawVertex3d)(x-bonds[i].x, y-bonds[i].y, z-bonds[i].z);
      if (picking)
      {
        (*drawEnd)();
        glLoadName(second+1);
        (*drawBegin)(GL_LINES);
        (*drawVertex3d)(x-bonds[i].x, y-bonds[i].y, z-bonds[i].z);
      }
      setAtomProperties(atoms[second].element, lighting);
      (*drawVertex3d)(atoms[second].x-bonds[i].x, atoms[second].y-bonds[i].y,
			    atoms[second].z-bonds[i].z);
      (*drawEnd)();
      if (bonds[i].order == (-2))
      {
        glEnable(GL_LINE_STIPPLE);            /* Dashed lines */
        (*drawLineStipple)(1, 0xf0f0);
      }
      if (picking)
      {
        glLoadName(first+1);
        (*drawBegin)(GL_LINES);
      }
      else
        (*drawBegin)(GL_LINE_STRIP);
      setAtomProperties(atoms[first].element, lighting);
      (*drawVertex3d)(atoms[first].x+bonds[i].x, atoms[first].y+bonds[i].y,
			    atoms[first].z+bonds[i].z);
      (*drawVertex3d)(x+bonds[i].x, y+bonds[i].y, z+bonds[i].z);
      if (picking)
      {
        (*drawEnd)();
        glLoadName(second+1);
        (*drawBegin)(GL_LINES);
        (*drawVertex3d)(x+bonds[i].x, y+bonds[i].y, z+bonds[i].z);
      }
      setAtomProperties(atoms[second].element, lighting);
      (*drawVertex3d)(atoms[second].x+bonds[i].x, atoms[second].y+bonds[i].y,
			    atoms[second].z+bonds[i].z);
      (*drawEnd)();
      if (bonds[i].order == (-2))
        glDisable(GL_LINE_STIPPLE);
    }
  }
  x=windows[VIEWER].far/100.;
  for (i=0; i<na; i++)
  {
    if (!strncmp(atoms[i].name, "Uc", 2) && !showUnitCell) continue;
    if (atoms[i].nbonds == 0)
    {
      if (picking) glLoadName(i+1);
      setAtomProperties(atoms[i].element, lighting);
      (*drawBegin)(GL_LINES);
      (*drawVertex3d)(atoms[i].x-x, atoms[i].y, atoms[i].z);
      (*drawVertex3d)(atoms[i].x+x, atoms[i].y, atoms[i].z);
      (*drawVertex3d)(atoms[i].x, atoms[i].y-x, atoms[i].z);
      (*drawVertex3d)(atoms[i].x, atoms[i].y+x, atoms[i].z);
      (*drawVertex3d)(atoms[i].x, atoms[i].y, atoms[i].z-x);
      (*drawVertex3d)(atoms[i].x, atoms[i].y, atoms[i].z+x);
      (*drawEnd)();
    }
  }
}

void stickModel(int onlyUnitCell, int lighting)
{
  double x, y, z;
  int first, second;
  register int i;

  (*drawLineWidth)(1.);
  for (i=0; i<nb; i++)
  {
    first=bonds[i].first;
    if (!strncmp(atoms[first].name, "Uc", 2))
    {
      if (!showUnitCell) continue;
    }
    else
    {
      if (onlyUnitCell) continue;
    }
    second=bonds[i].second;
    x=atoms[first].x+bonds[i].frac*(atoms[second].x-atoms[first].x);
    y=atoms[first].y+bonds[i].frac*(atoms[second].y-atoms[first].y);
    z=atoms[first].z+bonds[i].frac*(atoms[second].z-atoms[first].z);
    setAtomProperties(atoms[first].element, lighting);
    glLoadName(first+1);
    cylinder(atoms[first].x, atoms[first].y, atoms[first].z, x, y, z, atoms[na].rad, (int)sphereres, (GLenum)primitive);
    setAtomProperties(atoms[second].element, lighting);
    glLoadName(second+1);
    cylinder(atoms[second].x, atoms[second].y, atoms[second].z, x, y, z, atoms[na].rad, (int)sphereres, (GLenum)primitive);
  }
}

void balls(double fac, int lighting)
{
  GLUquadricObj *obj;
  register double rad;
  register int i;

  (*drawLineWidth)(1.);
  obj=gluNewQuadric();
  gluQuadricDrawStyle(obj, (GLenum)primitive);
  if (primitive == GLU_FILL) gluQuadricNormals(obj, (GLenum)GLU_SMOOTH);
  else                       gluQuadricNormals(obj, (GLenum)GLU_NONE);
  for (i=0; i<na; i++)
  {
    if (!strncmp(atoms[i].name, "Uc", 2))
    {
      if (!showUnitCell) continue;
      fac=1.0;
    }
    if (fac < 0.0)
      rad=-fac;
    else
      rad=fac*atoms[i].rad;
    glPushMatrix();
    glTranslated(atoms[i].x, atoms[i].y, atoms[i].z);
    setAtomProperties(atoms[i].element, lighting);
    glLoadName(i+1);
    (*drawSphere)(obj, rad, (int)sphereres, (int)sphereres);
    glPopMatrix();
  }
}

void drawIntern(void)
{
  const float black[4] = {0.0, 0.0, 0.0, 0.0};
  char line[10], *form;
  register double x, y, z;
  register int i, j, k;

  setWindowColor(FOREGROUND, stdcol[BLACK], black);
  glEnable(GL_LINE_STIPPLE);
  (*drawLineStipple)(1, 0xf0f0);
  (*drawLineWidth)((GLfloat)1.);
  for (i=0; i<ninternal; i++)
  {
    switch (internals[i].type)
    {
      case BONDAVERAGE: j=internals[i].atoms[0];
                        x=atoms[j].x+0.05;
                        y=atoms[j].y+0.05;
                        z=atoms[j].z+0.05;
                        form=formBondLength;
                        break;
      case BONDLENGTH:  j=internals[i].atoms[0];
                        k=internals[i].atoms[1];
                        x=(atoms[j].x+atoms[k].x)*0.5+0.05;
                        y=(atoms[j].y+atoms[k].y)*0.5+0.05;
                        z=(atoms[j].z+atoms[k].z)*0.5+0.05;
                        form=formBondLength;
                        (*drawBegin)(GL_LINES);
                        (*drawVertex3d)(atoms[j].x, atoms[j].y, atoms[j].z);
                        (*drawVertex3d)(atoms[k].x, atoms[k].y, atoms[k].z);
                        (*drawEnd)();
                        break;
      case ANGLE:       j=internals[i].atoms[1];
                        x=atoms[j].x+0.05;
                        y=atoms[j].y+0.05;
                        z=atoms[j].z+0.05;
                        form=formBondAngle;
                        (*drawBegin)(GL_LINE_STRIP);
                        j=internals[i].atoms[0];
                        (*drawVertex3d)(atoms[j].x, atoms[j].y, atoms[j].z);
                        j=internals[i].atoms[1];
                        (*drawVertex3d)(atoms[j].x, atoms[j].y, atoms[j].z);
                        j=internals[i].atoms[2];
                        (*drawVertex3d)(atoms[j].x, atoms[j].y, atoms[j].z);
                        (*drawEnd)();
                        break;
      case TORSION:     j=internals[i].atoms[1];
                        k=internals[i].atoms[2];
                        x=(atoms[j].x+atoms[k].x)*0.5+0.05;
                        y=(atoms[j].y+atoms[k].y)*0.5+0.05;
                        z=(atoms[j].z+atoms[k].z)*0.5+0.05;
                        form=formTorsionAngle;
                        (*drawBegin)(GL_LINE_STRIP);
                        j=internals[i].atoms[0];
                        (*drawVertex3d)(atoms[j].x, atoms[j].y, atoms[j].z);
                        j=internals[i].atoms[1];
                        (*drawVertex3d)(atoms[j].x, atoms[j].y, atoms[j].z);
                        j=internals[i].atoms[2];
                        (*drawVertex3d)(atoms[j].x, atoms[j].y, atoms[j].z);
                        j=internals[i].atoms[3];
                        (*drawVertex3d)(atoms[j].x, atoms[j].y, atoms[j].z);
                        (*drawEnd)();
                        break;
      default:          (*drawDisable)(GL_LINE_STIPPLE);
                        return;
    }
    sprintf(line, form, internals[i].value);
    (*drawString)(line, x, y, z, 0.0, windows[VIEWER].GLfontId);
  }
  (*drawDisable)(GL_LINE_STIPPLE);
}

void labelAtoms(int what)
{
  const float black[4] = {0.0, 0.0, 0.0, 0.0};
  char name[MAXLENLINE];
  register int i;

  setWindowColor(FOREGROUND, stdcol[BLACK], black);
  for (i=0; i<na; i++)
  {
    if (strncmp(atoms[i].name, "Uc", 2))
    {
      switch(what)
      {
        case LABEL: sprintf(name, "%s%d", atoms[i].name, i+1);
                    break;
        case INS:   sprintf(name, "%f", atoms[i].neutronScatterfac);
                    break;
      }
      glLoadName(i+1);
      (*drawString)(name, atoms[i].x+0.05, atoms[i].y+0.05, atoms[i].z+0.05, 0.0, windows[VIEWER].GLfontId);
    }
  }
}

void drawAnnotation()
{
  double xpix, ypix;
  register double h, l;
  register int i;

  pixelToWorld(VIEWER, &xpix, &ypix);
  h=(double)StringHeight(windows[VIEWER].font)*ypix;
  for (i=0; i<nAnnotations; i++)
  {
    if (picking)
    {
      if (annotation[i].flags & EDITABLE)
      {
        setWindowColor(BACKGROUND, windows[VIEWER].background, windows[VIEWER].background_rgb);
        glLoadName((GLuint)((i+1) | 0x80000000));
  	  l=(double)StringWidth(windows[VIEWER].font, annotation[i].text)*xpix;
  	  glBegin(GL_POLYGON);
	  glVertex3d(annotation[i].x, annotation[i].y, 0.0);
	  glVertex3d(annotation[i].x+l, annotation[i].y, 0.0);
	  glVertex3d(annotation[i].x+l, annotation[i].y+h, 0.0);
	  glVertex3d(annotation[i].x, annotation[i].y+h, 0.0);
	  glEnd();
      }
    }
    else
    {
      setWindowColor(FOREGROUND, annotation[i].color, annotation[i].color_rgb);
      (*drawString)(annotation[i].text, annotation[i].x, annotation[i].y, 0.0,
			  0.0, windows[VIEWER].GLfontId);
    }
  } 
}

void drawForces(int lighting)
{
  const float black[4] = {0.0, 0.0, 0.0, 0.0};
  int primitiveSave=primitive;
  register int i, j;

  if (existsUnitCell)
    j=(na-8)*((int)cycle-1);
  else
    j=na*((int)cycle-1);
  if (lighting)
    setWindowColor(FOREGROUND, stdcol[BLACK], black);
  else
    shadowColor();
  (*drawLineWidth)((GLfloat)1.);
  if (drawBegin != glBegin) primitive=GLU_LINE;
  for (i=0; i<na; i++)
    drawArrow(atoms[i].x, atoms[i].y, atoms[i].z, -100.0*forceScale*history[j+i].gx,
              -100.0*forceScale*history[j+i].gy, -100.0*forceScale*history[j+i].gz);
  if (drawBegin != glBegin) primitive=primitiveSave;
}

void drawNormalMode(int lighting)
{
  const float black[4] = {0.0, 0.0, 0.0, 0.0};
  int primitiveSave=primitive;
  register int i, j;

  if (lighting)
    setWindowColor(FOREGROUND, stdcol[BLACK], black);
  else
    shadowColor();
  j=0;
  if (drawBegin != glBegin) primitive=GLU_LINE;
  for (i=0; i<na; i++)
  {
    drawArrow(atoms[i].x, atoms[i].y, atoms[i].z, amplitude*cnm[mode+nmodes*j],
              amplitude*cnm[mode+nmodes*(j+1)], amplitude*cnm[mode+nmodes*(j+2)]);
    j+=3;
  }
  if (drawBegin != glBegin) primitive=primitiveSave;
}

void drawArrow(double x1, double y1, double z1, double x2, double y2, double z2)
{
  double length;

  if ((length=dist(x1, y1, z1, x1+x2, y1+y2, z1+z2)) > 1.0e-04)
  {
    if (length > 0.2*windows[VIEWER].top)
      cylinder(x1, y1, z1, x1+0.8*x2, y1+0.8*y2, z1+0.8*z2, 0.01*length,
              (int)sphereres, (GLenum)primitive);
    else
    {
      (*drawLineWidth)((GLfloat)1.);
      (*drawBegin)(GL_LINES);
      (*drawVertex3d)(x1, y1, z1);
      (*drawVertex3d)(x1+0.8*x2, y1+0.8*y2, z1+0.8*z2);
      (*drawEnd)();
    }
    cone(x1+0.8*x2, y1+0.8*y2, z1+0.8*z2, x1+x2, y1+y2, z1+z2,
         0.03*length, (int)sphereres);
  }
}

void drawGround(void)
{
  GLdouble plane[4]={0.0, 1.0, 0.0, 0.0};

  setWindowColor(FOREGROUND, windows[VIEWER].foreground,
		     windows[VIEWER].foreground_rgb);
  if (shadows)
  {
    glEnable(GL_STENCIL_TEST);
    glStencilFunc(GL_ALWAYS, 3, 0xffffffff);
    glStencilOp(GL_KEEP, GL_KEEP, GL_REPLACE);
  }
  glPassThrough((GLfloat)(ADD_DEPTH+(int)(3.0*windows[VIEWER].far)));
  glBegin(GL_POLYGON);
  glVertex3d(10.0*windows[VIEWER].left, windows[VIEWER].bottom, 10.0*windows[VIEWER].near);
  glVertex3d(10.0*windows[VIEWER].left, windows[VIEWER].bottom, 10.0*windows[VIEWER].far);
  glVertex3d(10.0*windows[VIEWER].right, windows[VIEWER].bottom, 10.0*windows[VIEWER].far);
  glVertex3d(10.0*windows[VIEWER].right, windows[VIEWER].bottom, 10.0*windows[VIEWER].near);
  glEnd();
  plane[3]=(-windows[VIEWER].bottom);
  glClipPlane(GL_CLIP_PLANE0, plane);
  glPassThrough((GLfloat)(ADD_DEPTH));
}

void shadow(GLfloat ground0[3], GLfloat ground1[3], GLfloat ground2[3], GLfloat lightpos[4])
{
  GLfloat vec0[3], vec1[3], plane[4];
  GLfloat shadowMat[4][4];
  register GLfloat dot;

  /* Need 2 vectors to find cross product. */
  vec0[0]=ground1[0]-ground0[0];
  vec0[1]=ground1[1]-ground0[1];
  vec0[2]=ground1[2]-ground0[2];

  vec1[0]=ground2[0]-ground0[0];
  vec1[1]=ground2[1]-ground0[1];
  vec1[2]=ground2[2]-ground0[2];

  /* find cross product to get A, B, and C of plane equation */
  plane[0]=vec0[1]*vec1[2]-vec0[2]*vec1[1];
  plane[1]=vec0[0]*vec1[2]-vec0[2]*vec1[0];
  plane[2]=vec0[0]*vec1[1]-vec0[1]*vec1[0];
  plane[3]=-(plane[0]*ground0[0]+plane[1]*ground0[1]+plane[2]*ground0[2]);

  /* Find dot product between light position vector and ground plane normal. */
  dot=plane[0]*lightpos[0]+plane[1]*lightpos[1]+plane[2]*lightpos[2]
     +plane[3]*lightpos[3];

  shadowMat[0][0]=dot-lightpos[0]*plane[0];
  shadowMat[1][0]=(-lightpos[0]*plane[1]);
  shadowMat[2][0]=(-lightpos[0]*plane[2]);
  shadowMat[3][0]=(-lightpos[0]*plane[3]);

  shadowMat[0][1]=(-lightpos[1]*plane[0]);
  shadowMat[1][1]=dot-lightpos[1]*plane[1];
  shadowMat[2][1]=(-lightpos[1]*plane[2]);
  shadowMat[3][1]=(-lightpos[1]*plane[3]);

  shadowMat[0][2]=(-lightpos[2]*plane[0]);
  shadowMat[1][2]=(-lightpos[2]*plane[1]);
  shadowMat[2][2]=dot-lightpos[2]*plane[2];
  shadowMat[3][2]=(-lightpos[2]*plane[3]);

  shadowMat[0][3]=(-lightpos[3]*plane[0]);
  shadowMat[1][3]=(-lightpos[3]*plane[1]);
  shadowMat[2][3]=(-lightpos[3]*plane[2]);
  shadowMat[3][3]=dot-lightpos[3]*plane[3];

  glMultMatrixf((const GLfloat *)shadowMat);
}

void setAtomProperties(struct ELEMENT *element, int lighting)
{
  GLfloat v[4];

  if (drawBegin == raytracerBegin) raytracerMaterial(element);
  if (!lighting)
  {
    shadowColor();
    return;
  }

  if (rgbMode)
  {
    v[0]=0.5*(element->dark[0]+element->light[0]);
    v[1]=0.5*(element->dark[1]+element->light[1]);
    v[2]=0.5*(element->dark[2]+element->light[2]);
    v[3]=1.0;
  }

  if (primitive == GLU_FILL && (windows[VIEWER].mode != WIREMODEL ||
      !strcmp(element->symbol, "Ps") || !strcmp(element->symbol, "Ms")))
  {
    if (rgbMode)
    {
      glMaterialfv(GL_FRONT_AND_BACK, GL_AMBIENT, element->ambient);
      glMaterialfv(GL_FRONT_AND_BACK, GL_DIFFUSE, v);
      glMaterialfv(GL_FRONT_AND_BACK, GL_SPECULAR, element->specular);
      glMaterialfv(GL_FRONT_AND_BACK, GL_EMISSION, element->emission);
      glMaterialf(GL_FRONT_AND_BACK, GL_SHININESS, element->shininess);
    }
    else
    {
      glMaterialiv(GL_FRONT_AND_BACK, GL_COLOR_INDEXES, element->colormap);
      glMaterialf(GL_FRONT_AND_BACK, GL_SHININESS, element->shininess);
    }
  }
  else
  {
    if (rgbMode)
      (*drawColor4fv)(v);
    else
      glIndexi(element->colormap[1]);
  }
}

void shadowColor(void)
{
  GLfloat v[4]={0.0, 0.0, 0.0, 0.5};

  glMaterialfv(GL_FRONT_AND_BACK, GL_DIFFUSE, v);
}

void viewerKeyAction(KeySym keysym)
{
  switch (keysym)
  {
    case XK_F1:          manual((Widget)0, (caddr_t)0, (caddr_t)0);
                         break;
    case XK_Print:       printDialog((Widget)0, (caddr_t)VIEWER, (XmAnyCallbackStruct *)0);
                         break;
    case XK_KP_Add:
    case XK_plus:        forceScale*=1.4;
                         break;
    case XK_KP_Subtract:
    case XK_minus:       forceScale/=1.4;
                         break;
    case XK_Up:          windows[VIEWER].top/=1.5;
                         windows[VIEWER].bottom/=1.5;
                         windows[VIEWER].right/=1.5;
                         windows[VIEWER].left/=1.5;
				 if (nAnnotations) scaleAnnotation(1.0/1.5);
                         break;
    case XK_Down:        windows[VIEWER].top*=1.5;
                         windows[VIEWER].bottom*=1.5;
                         windows[VIEWER].right*=1.5;
                         windows[VIEWER].left*=1.5;
				 if (nAnnotations) scaleAnnotation(1.5);
                         break;
  }
  redraw(VIEWER);
}
