/*******************************************************************************
*                                                                              *
*                                   Viewmol                                    *
*                                                                              *
*                           F I L E S E L E C T . C                            *
*                                                                              *
*                 Copyright (c) Joerg-R. Hill, December 1997                   *
*                                                                              *
********************************************************************************
*
* $Id: fileselect.c,v 1.2 1998/01/26 00:47:43 jrh Exp jrh $
* $Log: fileselect.c,v $
* Revision 1.2  1998/01/26 00:47:43  jrh
* Release 2.1
*
* Revision 1.1  1996/12/10  18:40:52  jrh
* Initial revision
*
*/
#include<X11/Intrinsic.h>
#include<Xm/Xm.h>
#include<Xm/DialogS.h>
#include<Xm/FileSB.h>
#include<Xm/MwmUtil.h>

static void GetFilename(Widget, char **, XmFileSelectionBoxCallbackStruct *);
static void Cancel(Widget, char **, caddr_t);
extern void MapBox(Widget, caddr_t, XmAnyCallbackStruct *);

extern XtAppContext app;
extern Widget topShell, fileBox;
static int cont;
static char *string;

void createFileselect(void)
{
  Widget helpbutton;
  Arg args[3];

  /* This function creates the file selection box */

  XtSetArg(args[0], XmNautoUnmanage, False);
  XtSetArg(args[1], XmNdefaultPosition, False);
  XtSetArg(args[2], XmNmwmDecorations, MWM_DECOR_RESIZEH | MWM_DECOR_TITLE);

  fileBox=XmCreateFileSelectionDialog(topShell, "fileSelectionBox", args, 3);
  XtVaSetValues(fileBox, XmNfileTypeMask, XmFILE_REGULAR, NULL);

  XtAddCallback(fileBox, XmNokCallback, (XtCallbackProc)GetFilename, &string);
  XtAddCallback(fileBox, XmNcancelCallback, (XtCallbackProc)Cancel, &string);
  XtAddCallback(fileBox, XmNmapCallback, (XtCallbackProc)MapBox, NULL);

  helpbutton=XmFileSelectionBoxGetChild(fileBox, XmDIALOG_HELP_BUTTON);
  XtUnmanageChild(helpbutton);
}

char *selectFile(char *filter, char *deflt)
{
  XEvent event;
  XmString text;

  text=XmStringCreateSimple(filter);
  XtVaSetValues(fileBox, XmNpattern, text, NULL);
  XmStringFree(text);
  text=XmStringCreateSimple(deflt);
  XtVaSetValues(fileBox, XmNtextString, text, NULL);
  XmStringFree(text);
  XtManageChild(fileBox);

  cont=TRUE;
  while (cont)
  {
    XtAppNextEvent(app, &event);
    XtDispatchEvent(&event);
  }
  XtUnmanageChild(fileBox);
  return(string);
}

static void GetFilename(Widget button, char **client_data,
				XmFileSelectionBoxCallbackStruct *call_data)
{
  char *text;

  XmStringGetLtoR(call_data->value, XmSTRING_DEFAULT_CHARSET, &text);
  *client_data=text;
  cont=FALSE;
}

static void Cancel(Widget button, char **client_data, caddr_t call_data)
{
  *client_data=(char *)NULL;
  cont=FALSE;
}
