/*******************************************************************************
*                                                                              *
*                                   Viewmol                                    *
*                                                                              *
*                               M A N U A L . C                                *
*                                                                              *
*                 Copyright (c) Joerg-R. Hill, December 1997                   *
*                                                                              *
********************************************************************************
*
* $Id: manual.c,v 1.2 1998/01/26 00:48:22 jrh Exp jrh $
* $Log: manual.c,v $
* Revision 1.2  1998/01/26 00:48:22  jrh
* Release 2.1
*
* Revision 1.1  1996/12/10  18:41:54  jrh
* Initial revision
*
*/
#include<stdio.h>
#include<stdlib.h>
#include<unistd.h>
#if !defined LINUX && !defined IRIX && !defined _HPUX_SOURCE
#include<sys/access.h>
#endif
#include<Xm/Xm.h>
#include "viewmol.h"
#include "dialog.h"

extern Widget topShell;
extern pid_t manual_pid;
extern char webbrowser[];
extern void GetMessageBoxButton(Widget, XtPointer, caddr_t);
extern char *getStringResource(Widget, char *);
extern int messgb(Widget, int, char *, struct PushButtonRow *, int);
extern int runProg(char *, int, char *, char *, char *, pid_t *);

void manual(Widget widget, caddr_t client_data, caddr_t call_data)
{
  static struct PushButtonRow buttons[] = {{"continue", GetMessageBoxButton, (XtPointer)0, NULL}};
  char command[MAXLENLINE], manualfile[MAXLENLINE], *word;

  if (*webbrowser == '\0')
  {
    word=getStringResource(topShell, "noBrowser");
    sprintf(manualfile, word, getStringResource(topShell, "webBrowser"));
    messgb(topShell, 1, manualfile, buttons, 1);
    return;
  }
  strcpy(manualfile, getenv("VIEWMOLPATH"));
  strcat(manualfile, "/man/viewmol.html");
  if (access(manualfile, 0))
  {
    word=getStringResource(topShell, "noManual");
    sprintf(command, word, manualfile);
    messgb(topShell, 1, command, buttons, 1);
    return;
  }
  sprintf(command, webbrowser, manualfile);

  if (runProg(command, FALSE, "/dev/null", "/dev/null", "/dev/null", &manual_pid))
  {
    word=getStringResource(topShell, "cannotDisplay");
    messgb(topShell, 1, word, buttons, 1);
  }
}
