/*******************************************************************************
*                                                                              *
*                                   Viewmol                                    *
*                                                                              *
*                                  R A Y . C                                   *
*                                                                              *
*                 Copyright (c) Joerg-R. Hill, December 1997                   *
*                                                                              *
********************************************************************************
*
* $Id: ray.c,v 1.2 1998/01/26 00:49:07 jrh Exp jrh $
* $Log: ray.c,v $
* Revision 1.2  1998/01/26 00:49:07  jrh
* Release 2.1
*
* Revision 1.1  1996/12/10  18:43:24  jrh
* Initial revision
*
*/
#include<math.h>
#include<stdio.h>
#include<unistd.h>
#include<GL/glu.h>
#include "viewmol.h"
#include "dialog.h"

extern void transformCoordinates(int, float input[4], float output[4]);
extern void *getmem(size_t, size_t);
extern void fremem(void **);

extern struct WINDOW windows[4];
extern struct ATOM *atoms;
extern struct ELEMENT *elements;
extern double tmat[4][4];
extern GLfloat light0p[], light1p[];
extern float xrot[4], yrot[4], zrot[4], xmov[2], ymov[2], zmov[2];
extern int na, ne, iwavef, lights, projectionMode;

static struct ELEMENT *material;
static double n[3];
static int printNormal=FALSE;
static FILE *f;

FILE *raytraceInit(char *filename, Dimension width, Dimension height)
{
  struct ELEMENT *element;
  FILE *file;
  double todeg=45.0/atan(1.0);
  GLfloat xview, zview, light[4], lookat[4]={0.0, 0.0, -1.0, 1.0}, up[4]={0.0, 1.0, 0.0, 1.0};
  int *done;
  register int i, j;

  if ((file=fopen(filename, "w")) == NULL) return(NULL);
  fprintf(file, "screen %d %d\n", width, height);
  glGetDoublev(GL_MODELVIEW_MATRIX, &tmat[0][0]);
  if (2.0*windows[VIEWER].far > zmov[VIEWPOINT])
    zview=2.0*windows[VIEWER].far-zmov[VIEWPOINT];
  else
    zview=0.1;
  xview=-0.75*windows[VIEWER].near*windows[VIEWER].top*(GLfloat)(width)/(windows[VIEWER].far
	 *(GLfloat)(height));
  fprintf(file, "eyep %12.7f %12.7f %12.7f\n", (-xmov[VIEWPOINT]), (-ymov[VIEWPOINT]),
	    zview+windows[VIEWER].far);
  transformCoordinates(VIEWPOINT, lookat, light);
  light[0]*=(float)(10.0*windows[VIEWER].far-zmov[VIEWPOINT]);
  light[1]*=(float)(10.0*windows[VIEWER].far-zmov[VIEWPOINT]);
  light[2]*=(float)(10.0*windows[VIEWER].far-zmov[VIEWPOINT]);
  fprintf(file, "lookp %12.7f %12.7f %12.7f\n", light[0]-xmov[VIEWPOINT],
          light[1]-ymov[VIEWPOINT], light[2]-zmov[VIEWPOINT]);
  fprintf(file, "fov %f\n", 2.0*todeg*atan((double)(xview/zview)));
  transformCoordinates(VIEWPOINT, up, light);
  fprintf(file, "up %12.7f %12.7f %12.7f\n", light[0], light[1], light[2]);
  fprintf(file, "background %6.3f %6.3f %6.3f\n", windows[VIEWER].background_rgb[0],
          windows[VIEWER].background_rgb[1], windows[VIEWER].background_rgb[2]);
  if (lights & 0x1)
  {
    transformCoordinates(LIGHTNO0, light0p, light);
    fprintf(file, "light 1.0 directional %10.5f %10.5f %10.5f noshadow\n",
            light[0], light[1], light[2]);
  }
  if (lights & 0x2)
  {
    transformCoordinates(LIGHTNO1, light1p, light);
    fprintf(file, "light 0.5 directional %10.5f %10.5f %10.5f\n", light[0],
            light[1], light[2]);
  }
  done=(int *)getmem(na, sizeof(int));
  for (i=0; i<na; i++)
  {
    if (!done[i])
    {
      element=atoms[i].element;
      fprintf(file, "surface %s\n", element->symbol);
      fprintf(file, "  diffuse %5.3f %5.3f %5.3f\n",
              (element->dark[0]+element->light[0])*0.5,
              (element->dark[1]+element->light[1])*0.5,
              (element->dark[2]+element->light[2])*0.5);
      fprintf(file, "  ambient %5.3f %5.3f %5.3f\n", element->ambient[0], element->ambient[1],
              element->ambient[2]);
      fprintf(file, "  specular %5.3f %5.3f %5.3f\n", element->specular[0], element->specular[1],
              element->specular[2]);
      fprintf(file, "  specpow %7.3f\n", element->shininess);
      fprintf(file, "  transp  %7.3f\n", element->alpha);
      for (j=i; j<na; j++)
      {
        if (atoms[j].element == element) done[j]=TRUE;
      }
    }
  }
  if (iwavef != ALL_OFF)
  {
    for (i=0; i<ne; i++)
    {
      if (!strcmp(elements[i].symbol, "Ps") || !strcmp(elements[i].symbol, "Ms"))
      {
        fprintf(file, "surface %s\n", elements[i].symbol);
        fprintf(file, "  diffuse %5.3f %5.3f %5.3f\n",
                (elements[i].dark[0]+elements[i].light[0])*0.5,
                (elements[i].dark[1]+elements[i].light[1])*0.5,
                (elements[i].dark[2]+elements[i].light[2])*0.5);
        fprintf(file, "  ambient %5.3f %5.3f %5.3f\n", elements[i].ambient[0], elements[i].ambient[1],
                elements[i].ambient[2]);
        fprintf(file, "  specular %5.3f %5.3f %5.3f\n", elements[i].specular[0], elements[i].specular[1],
                elements[i].specular[2]);
        fprintf(file, "  specpow %7.3f\n", elements[i].shininess);
        fprintf(file, "  transp  %7.3f\n", elements[i].alpha);
      }
    }
  }
  fremem((void **)&done);
  if (projectionMode == PERSPECTIVE)
  {
    fprintf(file, "surface ground\n");
    fprintf(file, "  diffuse %5.3f %5.3f %5.3f\n", windows[VIEWER].foreground_rgb[0],
            windows[VIEWER].foreground_rgb[1], windows[VIEWER].foreground_rgb[2]);
    fprintf(file, "plane ground 0.0 %10.5f 0.0 0.0 1.0 0.0\n", windows[VIEWER].bottom);
  }
  fprintf(file, "name molecule list\n");
  f=file;
  return(file);
}

void raytraceClose(FILE *file)
{
  fprintf(file, "end\n");
  fprintf(file, "object molecule\n");
  fclose(file);
}

void raytracerBegin(GLenum what)
{
  fprintf(f, "triangle %s ", material->symbol);
}

void raytracerEnd()
{
  fprintf(f, "\n");
}

void raytracerVertex3d(double vx, double vy, double vz)
{
  double t[3];

  t[0]=vx*tmat[0][0]+vy*tmat[0][1]+vz*tmat[0][2]+tmat[0][3];
  t[1]=vx*tmat[1][0]+vy*tmat[1][1]+vz*tmat[1][2]+tmat[1][3];
  t[2]=vx*tmat[2][0]+vy*tmat[2][1]+vz*tmat[2][2]+tmat[2][3];
  fprintf(f, "%10.6f %10.6f %10.6f ", t[0], t[1], t[2]);

  if (printNormal)
  {
    t[0]=n[0]*tmat[0][0]+n[1]*tmat[0][1]+n[2]*tmat[0][2]+tmat[0][3];
    t[1]=n[0]*tmat[1][0]+n[1]*tmat[1][1]+n[2]*tmat[1][2]+tmat[1][3];
    t[2]=n[0]*tmat[2][0]+n[1]*tmat[2][1]+n[2]*tmat[2][2]+tmat[2][3];
    fprintf(f, "%10.6f %10.6f %10.6f ", t[0], t[1], t[2]);
    printNormal=FALSE;
  }
}

void raytracerNormal3d(double vx, double vy, double vz)
{
  n[0]=vx;
  n[1]=vy;
  n[2]=vz;
  printNormal=TRUE;
}

void raytracerSphere(GLUquadricObj *object, GLdouble radius, GLint dummy1,
                     GLint dummy2)
{
  double matrix[4][4];

  glGetDoublev(GL_MODELVIEW_MATRIX, &matrix[0][0]);
  fprintf(f, "sphere %s %f %10.6f %10.6f %10.6f\n", material->symbol, radius,
          matrix[3][0], matrix[3][1], matrix[3][2]);
}

void raytracerCylinder(GLUquadricObj *object, GLdouble top, GLdouble bottom,
                       GLdouble height, GLint dummy1, GLint dummy2)
{
  double matrix[4][4];

  glGetDoublev(GL_MODELVIEW_MATRIX, &matrix[0][0]);
  fprintf(f, "cylinder %s %f %10.6f %10.6f %10.6f %10.6f %10.6f %10.6f\n",
          material->symbol, bottom, matrix[3][0], matrix[3][1], matrix[3][2],
          height*matrix[2][0]+matrix[3][0], height*matrix[2][1]+matrix[3][1],
          height*matrix[2][2]+matrix[3][2]);
}

void raytracerColor4fv(const GLfloat *color)
{
}

void raytracerClearColor(GLclampf red, GLclampf green , GLclampf blue, GLclampf alpha)
{
}

void raytracerMaterial(struct ELEMENT *e)
{
  material=e;
}
