/*******************************************************************************
*                                                                              *
*                                   Viewmol                                    *
*                                                                              *
*                                 S A V E . C                                  *
*                                                                              *
*                 Copyright (c) Joerg-R. Hill, December 1997                   *
*                                                                              *
********************************************************************************
*
* $Id: save.c,v 1.2 1998/01/26 00:49:30 jrh Exp jrh $
* $Log: save.c,v $
* Revision 1.2  1998/01/26 00:49:30  jrh
* Release 2.1
*
* Revision 1.1  1996/12/10  18:43:57  jrh
* Initial revision
*
*/
#include<math.h>
#include<stdio.h>
#include<stdlib.h>
#include<unistd.h>
#include<X11/Xlib.h>
#include<X11/Xutil.h>
#include<Xm/Xm.h>
#include<GL/glu.h>
#include "viewmol.h"
#include "dialog.h"

extern void GetMessageBoxButton(Widget, XtPointer, caddr_t);
extern char *selectFile(char *, char *);
extern char *getStringResource(Widget, char *);
extern int  getIntResource(Widget, char *);
extern void getRGBColor(Widget, Pixel, float *, float *, float *);
extern int  messgb(Widget, int, char *, struct PushButtonRow *, int);
extern int checkFile(char **);
extern void *getmem(size_t, size_t);
extern void *expmem(void *, size_t, size_t);
extern void fremem(void **);

void checkStringResource(char *, const char **, int, int, char **, int *);
void checkIntResource(char *, int, char **, int *);
void checkDoubleResource(char *, double, char **, int *);
void checkWindowResource(struct WINDOW *, char *, char **, int *);

extern struct ATOM *atoms;
extern struct BOND *bonds;
extern struct OPTION *output;
extern struct WINDOW windows[4];
extern double radfac, transx, transy, transz;
extern double sphereres, lineWidth, level, denres;
extern int na, nb, existsUnitCell, outputType;
extern int primitive, bondType, interp, simplify;
extern Widget topShell;

void saveMolecule(void)
{
  static struct PushButtonRow buttons[] = {{"continue", GetMessageBoxButton, (XtPointer)0, NULL}};
  FILE *file;
  double a2bohr=radfac/0.52917706;
  char *filename, *word, line[MAXLENLINE], command[MAXLENLINE];
  register int i, n;

  if ((filename=selectFile("*", "vm_coord")) != NULL)
  {
    strcpy(command, output[outputType].command);
    word=command;
    if (!(checkFile(&word)))
    {
      word=getStringResource(topShell, "noFile");
	strtok(command, " \t");                                                    
      sprintf(line, word, command);
      messgb(topShell, 3, line, buttons, 1);                                    
      return;
    }
    sprintf(line, word, filename);
    if ((file=popen(line, "w")) == NULL)
    {
      word=getStringResource(topShell, "cannotExecute");
      sprintf(line, word, command);
      messgb(topShell, 3, line, buttons, 1);
      return;
    }

    fprintf(file, "$coord\n");
    n=na;
    if (existsUnitCell) n-=8;
    for (i=0; i<n; i++)
    {
      fprintf(file, "%22.14f%22.14f%22.14f  %s\n", (atoms[i].x-transx)*a2bohr,
              (atoms[i].y-transy)*a2bohr, (atoms[i].z-transz)*a2bohr,
  	  	  atoms[i].name);
    }
    fprintf(file, "$bonds\n");
    for (i=0; i<nb; i++)
	fprintf(file, "%d %d %d\n", bonds[i].first+1, bonds[i].second+1,
		  bonds[i].order > 0 ? bonds[i].order : 1);
    fprintf(file, "$end\n");
    fclose(file);

    word=getStringResource(topShell, "MoleculeSaved");
    sprintf(line, word, filename);
    messgb(topShell, 0, line, buttons, 1);
  }
}

void saveConfiguration(Widget widget, caddr_t data1, caddr_t data2)
{
  static struct PushButtonRow buttons[] = {{"continue", GetMessageBoxButton, (XtPointer)0, NULL}};
  FILE *file, *tmp;
  const char *models[]={"wire", "stick", "ball", "cpk"};
  const char *primitives[]={"dot", "line", "surface"};
  const char *bondtypes[]={"single", "multiple", "conjugated"};
  const char *simplifyrotation[]={"False", "True"};
  const char *interpolation[]={"none", "linear", "logarithmic"};
  int nconfig=0;
  char *word, *config=NULL, *p;
  char *home, f[MAXLENLINE], line[MAXLENLINE];
  register int i, found;

  checkStringResource("model", models, 4, windows[VIEWER].mode, &config,
                      &nconfig);
  checkStringResource("drawingMode", primitives, 3, primitive-GLU_POINT+1, &config,
                      &nconfig);
  checkStringResource("bondType", bondtypes, 3, bondType, &config,
                      &nconfig);
  checkStringResource("simplifyWhileRotating", simplifyrotation, 2, simplify+1, &config,
                      &nconfig);
  checkStringResource("interpolation", interpolation, 3, interp, &config,
                      &nconfig);
  checkIntResource("sphereResolution", (int)sphereres, &config, &nconfig);
  checkIntResource("lineWidth", (int)lineWidth, &config, &nconfig);
  checkDoubleResource("isosurface", level, &config, &nconfig);
  checkDoubleResource("densityResolution", denres, &config, &nconfig);
  checkWindowResource(&windows[VIEWER], "viewer", &config, &nconfig);
  checkWindowResource(&windows[SPECTRUM], "spectrum", &config, &nconfig);
  checkWindowResource(&windows[HISTORY], "history", &config, &nconfig);
  checkWindowResource(&windows[MO], "MODiagram", &config, &nconfig);

  if ((home=getenv("HOME")) != NULL)
  {
    strcpy(f, home);
    strcat(f, "/.Xdefaults");
    tmp=tmpfile();
    if (!access(f, W_OK))
    {
	file=fopen(f, "r");
	while (fgets(line, MAXLENLINE, file) != NULL)
	{
	  if (!strstr(line, "Viewmol"))
	    fprintf(tmp, "%s", line);
        else
        {
          found=FALSE;
	    p=config;
          for (i=0; i<nconfig; i++)
          {
		if (*p != '\0')
		{
              word=strchr(p, ':')-1;
              if(!strncmp(line, p, word-p))
              {
                fprintf(tmp, "%s", p);
                *p='\0';
                found=TRUE;
                break;
              }
		}
		p+=MAXLENLINE;
          }
          if (!found) fprintf(tmp, "%s", line);
        }
	}
	fclose(file);
    }
    p=config;
    found=TRUE;
    for (i=0; i<nconfig; i++)
    {
      if (*p != '\0')
	{
	  if (found)
	  {
	    fprintf(tmp, "!-----------------------------------------------------------------\n");
	    fprintf(tmp, "! The following resources have been set automatically by Viewmol's\n");
	    fprintf(tmp, "! \"Save configuration\" feature\n");
	    fprintf(tmp, "!-----------------------------------------------------------------\n");
	    found=FALSE;
	  }
        fprintf(tmp, "%s", p);
	}
      p+=MAXLENLINE;
    }
    rewind(tmp);
    file=fopen(f, "w");
    while (fgets(line, MAXLENLINE, tmp) != NULL)
      fprintf(file, "%s", line);
    fclose(tmp);
    fclose(file);

    word=getStringResource(topShell, "ConfigurationSaved");
    messgb(topShell, 0, word, buttons, 1);
  }
  if (config)
    fremem((void *)&config);
}

void checkStringResource(char *resource, const char **types, int ntypes, int comp,
                         char **config, int *nconfig)
{
  char *word, *p;
  register int i;

  comp--;
  word=getStringResource(topShell, resource);
  for (i=0; i<ntypes; i++)
    if (strstr(word, types[i])) break;
  if (i != comp)
  {
    (*nconfig)++;
    if (*config == NULL)
    {
      *config=(char *)getmem(*nconfig, MAXLENLINE*sizeof(char));
      p=*config;
    }
    else
    {
      *config=(char *)expmem((void *)*config, *nconfig, MAXLENLINE*sizeof(char));
      p=*config+((*nconfig)-1)*MAXLENLINE;
    }
    strcpy(p, "Viewmol.");
    strcat(p, resource);
    strcat(p, ": ");
    strcat(p, types[comp]);
    strcat(p, "\n");
  }
}

void checkIntResource(char *resource, int comp, char **config, int *nconfig)
{
  char line[MAXLENLINE], *p;

  if (comp != getIntResource(topShell, resource))
  {
    (*nconfig)++;
    if (*config == NULL)
    {
      *config=(char *)getmem(*nconfig, MAXLENLINE*sizeof(char));
      p=*config;
    }
    else
    {
      *config=(char *)expmem((void *)*config, *nconfig, MAXLENLINE*sizeof(char));
      p=*config+((*nconfig)-1)*MAXLENLINE;
    }
    strcpy(p, "Viewmol.");
    strcat(p, resource);
    strcat(p, ": ");
    sprintf(line, "%d\n", comp);
    strcat(p, line);
  }
}

void checkDoubleResource(char *resource, double comp, char **config, int *nconfig)
{
  char line[MAXLENLINE], *p;

  if (comp != atof(getStringResource(topShell, resource)))
  {
    (*nconfig)++;
    if (*config == NULL)
    {
      *config=(char *)getmem(*nconfig, MAXLENLINE*sizeof(char));
      p=*config;
    }
    else
    {
      *config=(char *)expmem((void *)*config, *nconfig, MAXLENLINE*sizeof(char));
      p=*config+((*nconfig)-1)*MAXLENLINE;
    }
    strcpy(p, "Viewmol.");
    strcat(p, resource);
    strcat(p, ": ");
    sprintf(line, "%f\n", comp);
    strcat(p, line);
  }
}

void checkWindowResource(struct WINDOW *window, char *resource, char **config, int *nconfig)
{
  XWindowAttributes attributes;
  Window dummy;
  Screen *screen;
  Pixel pixel;
  int xw, yw;
  float r, g, b;
  int x, y, which, update=FALSE;
  unsigned int w, h;
  char line[MAXLENLINE], *p;

  if (window->widget != 0)
  {
    XtVaGetValues(window->widget, XmNbackground, &pixel, NULL);
    getRGBColor(window->widget, pixel, &r, &g, &b);
    if (r != window->background_rgb[0] || g != window->background_rgb[1] || b != window->background_rgb[2])
    {
      (*nconfig)++;
      if (*config == NULL)
      {
        *config=(char *)getmem(*nconfig, MAXLENLINE*sizeof(char));
        p=*config;
      }
      else
      {
        *config=(char *)expmem((void *)*config, *nconfig, MAXLENLINE*sizeof(char));
        p=*config+((*nconfig)-1)*MAXLENLINE;
      }
      strcpy(p, "Viewmol.");
      strcat(p, resource);
      strcat(p, ".canvas.background: rgb:");
      sprintf(line, "%4x/%4x/%4x\n", (int)(65535.*window->background_rgb[0]),
              (int)(65535.*window->background_rgb[1]), (int)(65535.*window->background_rgb[2]));
      strcat(p, line);
    }
    XtVaGetValues(window->widget, XmNforeground, &pixel, NULL);
    getRGBColor(window->widget, pixel, &r, &g, &b);
    if (r != window->foreground_rgb[0] || g != window->foreground_rgb[1] || b != window->foreground_rgb[2])
    {
      (*nconfig)++;
      if (*config == NULL)
      {
        *config=(char *)getmem(*nconfig, MAXLENLINE*sizeof(char));
        p=*config;
      }
      else
      {
        *config=(char *)expmem((void *)*config, *nconfig, MAXLENLINE*sizeof(char));
        p=*config+((*nconfig)-1)*MAXLENLINE;
      }
      strcpy(p, "Viewmol.");
      strcat(p, resource);
      strcat(p, ".canvas.foreground: rgb:");
      sprintf(line, "%4x/%4x/%4x\n", (int)(65535.*window->foreground_rgb[0]),
		  (int)(65535.*window->foreground_rgb[1]), (int)(65535.*window->foreground_rgb[2]));
      strcat(p, line);
    }
    XGetWindowAttributes(XtDisplay(window->widget), XtWindow(window->widget),
                         &attributes);
    XTranslateCoordinates(XtDisplay(window->widget), XtWindow(window->widget),
                          attributes.root, -attributes.border_width,
                          -attributes.border_width, &xw, &yw, &dummy);
    screen=XtScreen(window->widget);
    p=getStringResource(window->widget, "geometry");
    which=XParseGeometry(p, &x, &y, &w, &h);
    if (which & XValue)
    {
	if (which & XNegative)
	  x=WidthOfScreen(screen)-w+x;
      if (x != xw) update=TRUE;
    }
    if (which & YValue)
    {
	if (which & YNegative)
	  y=HeightOfScreen(screen)-h+y;
	if (y != yw) update=TRUE;
    }
    if (which & WidthValue)
	if (w != attributes.width) update=TRUE;
    if (which & HeightValue)
	if (h != attributes.height) update=TRUE;
    if (update)
    {
      (*nconfig)++;
      if (*config == NULL)
      {
        *config=(char *)getmem(*nconfig, MAXLENLINE*sizeof(char));
        p=*config;
      }
      else
      {
        *config=(char *)expmem((void *)*config, *nconfig, MAXLENLINE*sizeof(char));
        p=*config+((*nconfig)-1)*MAXLENLINE;
      }
      strcpy(p, "Viewmol.");
	if (strcmp(resource, "viewer"))
      {
        strcat(p, resource);
	  strcat(p, ".");
	}
      strcat(p, "geometry: ");
      sprintf(line, "%dx%d+%d+%d\n", attributes.width, attributes.height, xw, yw);
      strcat(p, line);
    }
  }
}
