/*******************************************************************************
*                                                                              *
*                                   Viewmol                                    *
*                                                                              *
*                             S A V E F O R M . C                              *
*                                                                              *
*                 Copyright (c) Joerg-R. Hill, December 1997                   *
*                                                                              *
********************************************************************************
*
* $Id: saveform.c,v 1.1 1998/01/26 00:35:25 jrh Exp jrh $
* $Log: saveform.c,v $
* Revision 1.1  1998/01/26 00:35:25  jrh
* Initial revision
*
*
*/
#include<X11/Intrinsic.h>
#include<Xm/Xm.h>
#include<Xm/BulletinB.h>
#include<Xm/DialogS.h>
#include<Xm/Form.h>
#include<Xm/Label.h>
#include<Xm/LabelG.h>
#include<Xm/MwmUtil.h>
#include<Xm/PanedW.h>
#include<Xm/PushB.h>
#include<Xm/PushBG.h>
#include<Xm/RowColumn.h>
#include<Xm/Separator.h>
#include<Xm/ToggleB.h>
#include "viewmol.h"
#include "dialog.h"

void saveMoleculeExit(Widget, caddr_t, XmPushButtonCallbackStruct *);
void GetOutputType(Widget, caddr_t, XmToggleButtonCallbackStruct *);

extern void MapBox(Widget, caddr_t, XmToggleButtonCallbackStruct *);
extern Widget CreatePushButtonRow(Widget, struct PushButtonRow *, int);
extern Widget CreateToggleBox(Widget, struct PushButtonRow *, int, int,
                              int, int, int);
extern void saveMolecule(void);
extern void setMenuItem(int, int, int);
extern void *getmem(size_t, size_t);
extern void fremem(void **);

extern struct WINDOW windows[];
extern struct OPTION *output;
extern Widget topShell;
extern int outputType, noutput;
static Widget dialog;
static int outputType_save;

void saveMoleculeDialog(Widget widget, caddr_t dummy, XmAnyCallbackStruct *data)
{
  Widget form, board, form1, togglebox, sep;
  Arg args[3];
  static struct PushButtonRow buttons[] = {
    { "ok", saveMoleculeExit, (XtPointer)TRUE, NULL },
    { "cancel", saveMoleculeExit, (XtPointer)FALSE, NULL },
  };
  struct PushButtonRow *togglebox_buttons;
  register int i;

  /* This function creates the dialog for the "Save molecule" option */

  switch (noutput)
  {
    case 0:  return;
             break;
    case 1:  saveMolecule();
             break;
    default: setMenuItem(VIEWER, 25, False);
             outputType_save=outputType;

             togglebox_buttons=(struct PushButtonRow *)getmem((size_t)noutput,
                                sizeof(struct PushButtonRow));
             for (i=0; i<noutput; i++)
             {
               togglebox_buttons[i].label=&output[i].flag[0];
               togglebox_buttons[i].callback=(void (*)())GetOutputType;
               togglebox_buttons[i].client_data=(XtPointer)i;
               togglebox_buttons[i].widget=NULL;
             }

             XtSetArg(args[0], XmNautoUnmanage, False);
             XtSetArg(args[1], XmNdefaultPosition, False);
             if (XmIsMotifWMRunning(topShell))
               XtSetArg(args[2], XmNmwmDecorations,
                        MWM_DECOR_RESIZEH | MWM_DECOR_TITLE);
             else
               XtSetArg(args[2], (char *)NULL, 0);
             dialog=XmCreateDialogShell(XtParent(windows[VIEWER].widget),
           		 		          "saveMoleculeForm_popup", args,
                                        XtNumber(args));
             board=XtVaCreateWidget("saveMoleculeForm",
                                    xmBulletinBoardWidgetClass, dialog,
                                    XmNautoUnmanage, False,
                                    XmNdefaultPosition, False,
                                    NULL);
             form=XtVaCreateWidget("rowcolumn", xmRowColumnWidgetClass, board,
                                   XmNorientation, XmVERTICAL,
                                   NULL);

             form1=XtVaCreateWidget("controlarea", xmFormWidgetClass, form,
                                    NULL);
             sep=XtVaCreateManagedWidget("sep", xmSeparatorWidgetClass, form,
                                         NULL);

             togglebox=CreateToggleBox(form1, togglebox_buttons, noutput,
                                       XmVERTICAL, 1, True, outputType);
             XtVaSetValues(togglebox, XmNleftAttachment, XmATTACH_FORM,
                                      XmNrightAttachment, XmATTACH_FORM,
                                      XmNtopAttachment, XmATTACH_FORM,
                                      NULL);
             XtManageChild(form1);

             CreatePushButtonRow(form, buttons, XtNumber(buttons));
             XtAddCallback(dialog, XmNpopupCallback, (XtCallbackProc)MapBox,
                           (XmAnyCallbackStruct *)NULL);
             XtManageChild(form);
             XtManageChild(board);
 
             fremem((void **)&togglebox_buttons);
             break;
  }
}

void saveMoleculeExit(Widget button, caddr_t which, XmPushButtonCallbackStruct *data)
{
  XtDestroyWidget(dialog);
  if (!(int)which) outputType=outputType_save;
  else             saveMolecule();
  setMenuItem(VIEWER, 25, True);
}

void GetOutputType(Widget button, caddr_t which, XmToggleButtonCallbackStruct *data)
{
  if (data->set) outputType=(int)which;
}
