/*******************************************************************************
*                                                                              *
*                                   Viewmol                                    *
*                                                                              *
*                                X F O N T . C                                 *
*                                                                              *
*                 Copyright (c) Joerg-R. Hill, December 1997                   *
*                                                                              *
********************************************************************************
*
* $Id: xfont.c,v 1.2 1998/01/26 00:49:52 jrh Exp jrh $
* $Log: xfont.c,v $
* Revision 1.2  1998/01/26 00:49:52  jrh
* Release 2.1
*
* Revision 1.1  1996/12/10  18:44:32  jrh
* Initial revision
*
*/
#include<stdlib.h>
#include<stdio.h>
#include<string.h>
#include<X11/Xlib.h>
#include<X11/Xutil.h>
#include<GL/gl.h>
#include<GL/glu.h>
#include<GL/glx.h>
#include "viewmol.h"

extern void *getmem(size_t, size_t);

extern struct WINDOW windows[];
extern int drawingDevice;
extern char *textPointer;

XFontStruct *makeRasterFont(Display *display, char *font, GLuint *base)
{
  XFontStruct *fontInfo, *f;
  Font id;
  unsigned int first, last;

  if ((fontInfo=XLoadQueryFont(display, font)) == NULL)
    return(fontInfo);

  id=fontInfo->fid;
  first=fontInfo->min_char_or_byte2;
  last=fontInfo->max_char_or_byte2;

  if ((*base=glGenLists((GLuint)last+1)) == 0)
  {
    XFreeFont(display, fontInfo);
    return((XFontStruct *)NULL);
  }

  f=(XFontStruct *)getmem((size_t)1, sizeof(XFontStruct));
  memcpy((void *)f, (void *)fontInfo, sizeof(XFontStruct));
  glXUseXFont(id, first, last-first+1, *base+first);
  return(f);
}

void printString(char *s, double x, double y, double z, double offset, GLuint base)
{
  glRasterPos3d(x+offset, y, z);
  glListBase(base);
  glCallLists(strlen(s), GL_UNSIGNED_BYTE, (GLubyte *)s);
}

int StringWidth(XFontStruct *font, char *string)
{
  return(XTextWidth(font, string, strlen(string)));
}

int StringHeight(XFontStruct *font)
{
  return(font->ascent+font->descent);
/*return(font->ascent); */
}

void deleteFontList(GLuint base, XFontStruct *font)
{
  glDeleteLists(base, font->max_char_or_byte2-font->min_char_or_byte2+1);
}
