/*******************************************************************************
*                                                                              *
*                                   Viewmol                                    *
*                                                                              *
*                             A N N O T A T E . C                              *
*                                                                              *
*                 Copyright (c) Joerg-R. Hill, December 1997                   *
*                                                                              *
********************************************************************************
*
* $Id: annotate.c,v 1.1 1998/01/26 00:33:05 jrh Exp jrh $
* $Log: annotate.c,v $
* Revision 1.1  1998/01/26 00:33:05  jrh
* Initial revision
*
*
*/
#include<stdio.h>
#include<X11/StringDefs.h>
#include<X11/cursorfont.h>
#include<Xm/Xm.h>
#include<Xm/Text.h>
#include<GL/GLwMDrawA.h>
#include "viewmol.h"

void modifyAnnotation(int, int, int);
void getAnnotation(Widget, caddr_t, caddr_t);
int  makeAnnotation(int, int, float, float, int, const GLfloat *, int, char *);
void deleteAnnotation(int *);
void setAnnotation(Widget, caddr_t, GLwDrawingAreaCallbackStruct *);

extern void drawMolecule(Widget, caddr_t, GLwDrawingAreaCallbackStruct *);
extern void pixelToWorld(int, double *, double *);
extern void setCursor(Widget, unsigned int);
extern int StringWidth(XFontStruct *, char *);
extern int StringHeight(XFontStruct *);
extern void *getmem(size_t, size_t);
extern void *expmem(void *, size_t, size_t);
extern void fremem(void **);
extern char *getStringResource(Widget, char *);

extern struct WINDOW windows[];
extern struct ANNOTATION *annotation;
extern int nAnnotations, annotate;
extern Pixel stdcol[9];

void modifyAnnotation(int which, int x, int y)
{
  XmFontListEntry entry;
  XmFontList fontlist;
  Dimension height;
  Widget text;
  double xpix, ypix;
  char *font;

  if ((which != (-1)) || annotate)
  {
    font=getStringResource(windows[VIEWER].widget, "font");
    entry=XmFontListEntryLoad(XtDisplay(windows[VIEWER].widget), font, XmFONT_IS_FONT, "TAG");
    fontlist=XmFontListAppendEntry(NULL, entry);
    XmFontListEntryFree(&entry);
    text=XtVaCreateWidget("annotation", xmTextWidgetClass, XtParent(windows[VIEWER].widget),
				  XmNfontList, fontlist,
                          XmNhighlightThickness, 0,
                          XmNshadowThickness, 0,
                          XmNmarginWidth, 3,
                          XmNmarginHeight, 0,
				  XmNcolumns, 1,
                          XmNresizeWidth, True,
                          NULL);
    height=XmTextGetBaseline(text);
    if (which == (-1)) XtVaSetValues(text, XmNx, x-3, XmNy, y-height, NULL);
    if (which != (-1))
    {
      pixelToWorld(VIEWER, &xpix, &ypix);
      XtVaSetValues(text, XmNvalue, annotation[which].text,
				  XmNx, (int)((annotation[which].x-windows[VIEWER].left)/xpix)-3,
	                    XmNy, (int)((windows[VIEWER].top-annotation[which].y)/ypix)-height,
				  NULL);
      deleteAnnotation(&which);
    }
    XtManageChild(text);
    XtAddCallback(text, XmNactivateCallback, (XtCallbackProc)getAnnotation, NULL);
    XmProcessTraversal(text, XmTRAVERSE_CURRENT);
  }
  setCursor(windows[VIEWER].widget, XC_top_left_arrow);
  annotate=FALSE;
}

void getAnnotation(Widget w, caddr_t dummy, caddr_t call_data)
{
  Dimension h;
  Position x, y;
  const GLfloat black[4] = {0.0, 0.0, 0.0, 0.0};
  double xpix, ypix;
  char *text;

  text=XmTextGetString(w);
  if (*text != '\0')
  {
    XtVaGetValues(w, XmNx, &x, XmNy, &y, NULL);
    pixelToWorld(VIEWER, &xpix, &ypix);
    h=XmTextGetBaseline(w);

    x+=3;
    y+=h+1;
    (void)makeAnnotation((-1), COORDINATES, (float)(windows[VIEWER].left+x*xpix),
                         (float)(windows[VIEWER].top-y*ypix), stdcol[BLACK], black,
                         EDITABLE | MOVEABLE, text);
  }
  XtFree(text);
  XtDestroyWidget(w);
}

int makeAnnotation(int which, int type, float x, float y, int color,
                   const GLfloat color_rgb[4], int flags, char *text)
{
  double xpix, ypix;
  register int i;

  if (which == (-1))
  {
    nAnnotations++;
    if (annotation == NULL)
      annotation=(struct ANNOTATION *)getmem(1, sizeof(struct ANNOTATION));
    else
      annotation=(struct ANNOTATION *)expmem((void *)annotation, nAnnotations,
                                               sizeof(struct ANNOTATION));
    which=nAnnotations-1;
  }

  strncpy(annotation[which].text, text, MAXLENLINE-1);
  if (type == CENTERED)
  {
    pixelToWorld(VIEWER, &xpix, &ypix);
    i=StringHeight(windows[VIEWER].font);
    annotation[which].x=(windows[VIEWER].left+windows[VIEWER].right
                        -xpix*(double)StringWidth(windows[VIEWER].font,
                        annotation[which].text))*0.5;
    annotation[which].y=windows[VIEWER].top-2.*(double)y*ypix*(double)i;
  }
  else
  {
    annotation[which].x=x;
    annotation[which].y=y;
  }
  annotation[which].color=color;
  annotation[which].color_rgb[0]=color_rgb[0];
  annotation[which].color_rgb[1]=color_rgb[1];
  annotation[which].color_rgb[2]=color_rgb[2];
  annotation[which].color_rgb[3]=color_rgb[3];
  annotation[which].flags=flags;

  return(which);
}

void deleteAnnotation(int *which)
{
  register int i;

  if (*which > (-1) && *which != nAnnotations-1)
  {
    for (i=(*which)+1; i<nAnnotations; i++)
    {
      annotation[i-1].x=annotation[i].x;
      annotation[i-1].y=annotation[i].y;
      annotation[i-1].color=annotation[i].color;
      annotation[i-1].color_rgb[0]=annotation[i].color_rgb[0];
      annotation[i-1].color_rgb[1]=annotation[i].color_rgb[1];
      annotation[i-1].color_rgb[2]=annotation[i].color_rgb[2];
      annotation[i-1].color_rgb[3]=annotation[i].color_rgb[3];
      annotation[i-1].flags=annotation[i].flags;
      strcpy(annotation[i-1].text, annotation[i].text);
    }
  }
  if (*which != (-1))
  {
    nAnnotations--;
    if (nAnnotations)
      annotation=(struct ANNOTATION *)expmem((void *)annotation, nAnnotations,
                  sizeof(struct ANNOTATION));
    else
      fremem((void *)&annotation);
    *which=(-1);
  }
}

void scaleAnnotation(float scale)
{
  register int i;

  for (i=0; i<nAnnotations; i++)
  {
    annotation[i].x*=scale;
    annotation[i].y*=scale;
  }
}

void setAnnotation(Widget w, caddr_t data, GLwDrawingAreaCallbackStruct *dummy)
{
  setCursor(windows[VIEWER].widget, XC_xterm);
  annotate=TRUE;
  drawMolecule((Widget)0, (caddr_t)0, (GLwDrawingAreaCallbackStruct *)0);
}
