/*******************************************************************************
*                                                                              *
*                                   Viewmol                                    *
*                                                                              *
*                              D I S T O R T . C                               *
*                                                                              *
*                 Copyright (c) Joerg-R. Hill, December 1997                   *
*                                                                              *
********************************************************************************
*
* $Id: distort.c,v 1.2 1998/01/26 00:47:24 jrh Exp jrh $
* $Log: distort.c,v $
* Revision 1.2  1998/01/26 00:47:24  jrh
* Release 2.1
*
* Revision 1.1  1996/12/10  18:40:16  jrh
* Initial revision
*
*/
#include<stdlib.h>
#include "viewmol.h"
#include "dialog.h"

extern struct ATOM *atoms;
extern double *cnm;
extern int existsUnitCell, na, mode, nmodes;

void distortGeometry(double);

extern void calcInternal(int);

extern int ninternal;

void distortGeometry(double factor)
{
  register int i, l, n;

  if (mode != -1)
  {
    l=0;
    n=na;
    if (existsUnitCell) n-=8;
    for (i=0; i<n; i++)
    {
      atoms[i].x+=factor*cnm[mode+nmodes*l];
      atoms[i].y+=factor*cnm[mode+nmodes*(l+1)];
      atoms[i].z+=factor*cnm[mode+nmodes*(l+2)];
      l+=3;
    }
    for (i=0; i<ninternal; i++)
      calcInternal(i);
  }
}
