/*******************************************************************************
*                                                                              *
*                                   Viewmol                                    *
*                                                                              *
*                               I N T E R N . C                                *
*                                                                              *
*                 Copyright (c) Joerg-R. Hill, December 1997                   *
*                                                                              *
********************************************************************************
*
* $Id: intern.c,v 1.2 1998/01/26 00:48:12 jrh Exp jrh $
* $Log: intern.c,v $
* Revision 1.2  1998/01/26 00:48:12  jrh
* Release 2.1
*
* Revision 1.1  1996/12/10  18:41:35  jrh
* Initial revision
*
*/
#include<math.h>
#include<stdio.h>
#include "viewmol.h"

double bondAverage(int);
double bondLength(int, int);
double bondAngle(int, int, int);
double torsionAngle(int, int, int, int);
double dist(double, double, double, double, double, double);
double angle(double, double, double, double, double, double, double,
             double, double);
double torsion(double, double, double, double, double, double, double,
               double, double, double, double, double);

extern struct ATOM *atoms;
extern struct BOND *bonds;
extern struct INTERNAL *internals;
extern double bndfac;
extern int nb, debug;

void calcInternal(int n)
{
  switch (internals[n].type)
  {
    case BONDAVERAGE: internals[n].value=bndfac*bondAverage(internals[n].atoms[0]);
                      break;
    case BONDLENGTH:  internals[n].value=bndfac*bondLength(internals[n].atoms[0],
                                                           internals[n].atoms[1]);
                      break;
    case ANGLE:       internals[n].value=bondAngle(internals[n].atoms[0],
                                                   internals[n].atoms[1],
                                                   internals[n].atoms[2]);
                      break;
    case TORSION:     internals[n].value=torsionAngle(internals[n].atoms[0],
                                                      internals[n].atoms[1],
                                                      internals[n].atoms[2],
                                                      internals[n].atoms[3]);
                      break;
  }
  if (debug) printf("Internal coordinate %d: %d-%d-%d-%d, %f\n", n,
                    internals[n].atoms[0], internals[n].atoms[1],
                    internals[n].atoms[2], internals[n].atoms[3],
                    internals[n].value);
}

double bondAverage(int i)
{
  register double value=0.0e0;
  register int j, k=0;

  for (j=0; j<nb; j++)
  {
    if (bonds[j].first == i || bonds[j].second == i)
    {
      value+=bondLength(bonds[j].first, bonds[j].second);
	k++;
    }
  }
  if (k > 0)
    value/=(double)k;
  else
    value=0.0;
  return(value);
}

double bondLength(int i, int j)
{
  return(dist(atoms[i].x, atoms[i].y, atoms[i].z, atoms[j].x, atoms[j].y,
              atoms[j].z));
}

double bondAngle(int i, int j, int k)
{
  return(angle(atoms[i].x, atoms[i].y, atoms[i].z, atoms[j].x, atoms[j].y,
               atoms[j].z, atoms[k].x, atoms[k].y, atoms[k].z));
}

double torsionAngle(int i, int j, int k, int l)
{
  return(torsion(atoms[i].x, atoms[i].y, atoms[i].z, atoms[j].x, atoms[j].y,
                 atoms[j].z, atoms[k].x, atoms[k].y, atoms[k].z, atoms[l].x,
                 atoms[l].y, atoms[l].z));
}

double dist(double x1, double y1, double z1, double x2, double y2, double z2)
{
  return(sqrt((x1-x2)*(x1-x2)+(y1-y2)*(y1-y2)+(z1-z2)*(z1-z2)));
}

double angle(double x1, double y1, double z1, double x2, double y2, double z2,
		 double x3, double y3, double z3)
{
  double todeg=45.0e0/atan(1.0e0);
  double xa, ya, za, xb, yb, zb, r;

  xa=x1-x2;
  ya=y1-y2;
  za=z1-z2;
  xb=x3-x2;
  yb=y3-y2;
  zb=z3-z2;
  r=dist(x1, y1, z1, x2, y2, z2)*dist(x3, y3, z3, x2, y2, z2);
  r=(xa*xb+ya*yb+za*zb)/r;
  return(todeg*acos(r));
}

double torsion(double x1, double y1, double z1, double x2, double y2, double z2,
		   double x3, double y3, double z3, double x4, double y4, double z4)
{
  double todeg=45.0e0/atan(1.0e0);
  double xa, ya, za, xb, yb, zb, xc, yc, zc, xd, yd, zd, xe, ye, ze, xf, yf, zf;
  double sgn, r;

  xa=x1-x2;
  ya=y1-y2;
  za=z1-z2;
  xb=x3-x2;
  yb=y3-y2;
  zb=z3-z2;
  xc=x4-x3;
  yc=y4-y3;
  zc=z4-z3;
  xd=ya*zb-yb*za;
  yd=xb*za-xa*zb;
  zd=xa*yb-xb*ya;
  xe=yc*zb-yb*zc;
  ye=xb*zc-xc*zb;
  ze=xc*yb-xb*yc;
  xf=yd*ze-ye*zd;
  yf=xe*zd-xd*ze;
  zf=xd*ye-xe*yd;
  sgn=xf*xb+yf*yb+zf*zb;
  r=sqrt((xd*xd+yd*yd+zd*zd)*(xe*xe+ye*ye+ze*ze));
  r=(xd*xe+yd*ye+zd*ze)/r;
  if (fabs(r) > 1.0e0) r/=fabs(r);
  if (sgn < 0.0e0)
    return(-todeg*acos(r));
  else
    return(todeg*acos(r));
}
