/*******************************************************************************
*                                                                              *
*                                   Viewmol                                    *
*                                                                              *
*                              M E N U D E F . H                               *
*                                                                              *
*                 Copyright (c) Joerg-R. Hill, December 1997                   *
*                                                                              *
********************************************************************************
*
* $Id: menudef.h,v 1.2 1998/01/26 00:48:32 jrh Exp jrh $
* $Log: menudef.h,v $
* Revision 1.2  1998/01/26 00:48:32  jrh
* Release 2.1
*
* Revision 1.1  1996/12/10  18:45:53  jrh
* Initial revision
*
*/
static struct MenuItem geometryMenu[] = {
  { "clear_all",  &xmPushButtonGadgetClass, clearGeometry, (XtPointer)TRUE,  NULL, NULL },
  { "clear_last", &xmPushButtonGadgetClass, clearGeometry, (XtPointer)FALSE, NULL, NULL },
  { NULL }};
static struct MenuItem bondTypeMenu[] = {
  { "single",      &xmPushButtonGadgetClass, setBondType, (XtPointer)SINGLE_BONDS,   NULL, NULL },
  { "multiple",    &xmPushButtonGadgetClass, setBondType, (XtPointer)MULTIPLE_BONDS, NULL, NULL },
  { "conjugated",  &xmPushButtonGadgetClass, setBondType, (XtPointer)CONJUGATION,    NULL, NULL },
  { NULL }};
static struct MenuItem viewerMenu[] = {
  { "wire_model",                &xmPushButtonGadgetClass,   setModel,           (XtPointer)WIREMODEL,  NULL, NULL },
  { "stick_model",               &xmPushButtonGadgetClass,   setModel,           (XtPointer)STICKMODEL, NULL, NULL },
  { "ball_and_stick_model",      &xmPushButtonGadgetClass,   setModel,           (XtPointer)BALLMODEL,  NULL, NULL },
  { "cpk_model",                 &xmPushButtonGadgetClass,   setModel,           (XtPointer)CUPMODEL,   NULL, NULL },
  { "sep1",                      &xmSeparatorGadgetClass,    NULL,               (XtPointer)0,          NULL, NULL },
  { "geometry_menu",             &xmPushButtonGadgetClass,   NULL,               (XtPointer)0,          NULL, geometryMenu },
  { "bondType_menu",             &xmPushButtonGadgetClass,   NULL,               (XtPointer)0,          NULL, bondTypeMenu },
  { "wave_function",             &xmPushButtonGadgetClass,   wavefunctionDialog, (XtPointer)0,          NULL, NULL },
  { "energy_level_diagram",      &xmPushButtonGadgetClass,   initMODiagram,      (XtPointer)0,          NULL, NULL },
  { "optimization_history",      &xmPushButtonGadgetClass,   initHistory,        (XtPointer)0,          NULL, NULL },
  { "show_forces",               &xmToggleButtonGadgetClass, changeBoolean,      (XtPointer)&showForces, NULL, NULL },
  { "spectrum",                  &xmPushButtonGadgetClass,   initSpectrum,       (XtPointer)0,          NULL, NULL },
  { "show_unit_cell",            &xmToggleButtonGadgetClass, changeBoolean,      (XtPointer)&showUnitCell, NULL, NULL },
  { "show_ellipsoid_of_inertia", &xmToggleButtonGadgetClass, changeBoolean,      (XtPointer)&showInertia, NULL, NULL },
  { "sep2",                      &xmSeparatorGadgetClass,    NULL,               (XtPointer)0,          NULL, NULL },
  { "drawing_modes",             &xmPushButtonGadgetClass,   drawingModeDialog,  (XtPointer)0,          NULL, NULL },
  { "foreground_color",          &xmPushButtonGadgetClass,   colorEditor,        (XtPointer)(FOREGROUND*8+VIEWER), NULL, NULL},
  { "background_color",          &xmPushButtonGadgetClass,   colorEditor,        (XtPointer)(BACKGROUND*8+VIEWER), NULL, NULL},
  { "label_atoms",               &xmToggleButtonGadgetClass, changeBoolean,      (XtPointer)&label,     NULL, NULL },
  { "annotate",                  &xmPushButtonGadgetClass,   setAnnotation,      (XtPointer)0,          NULL, NULL },
  { "sep3",                      &xmSeparatorGadgetClass,    NULL,               (XtPointer)0,          NULL, NULL },
  { "hardcopy",                  &xmPushButtonGadgetClass,   printDialog,        (XtPointer)VIEWER,     NULL, NULL },
  { "raytracing",                &xmPushButtonGadgetClass,   raytracer,          (XtPointer)0,          NULL, NULL },
  { "manual",                    &xmPushButtonGadgetClass,   manual,             (XtPointer)0,          NULL, NULL },
  { "sep4",                      &xmSeparatorGadgetClass,    NULL,               (XtPointer)0,          NULL, NULL },
  { "saveMolecule",              &xmPushButtonGadgetClass,   saveMoleculeDialog, (XtPointer)0,          NULL, NULL },
  { "saveConfiguration",         &xmPushButtonGadgetClass,   saveConfiguration,  (XtPointer)0,          NULL, NULL },
  { "quit",                      &xmPushButtonGadgetClass,   ende,               (XtPointer)0,          NULL, NULL },
  { NULL } };
static struct MenuItem spectrumMenu[] = {
  { "settings_spectrum",      &xmPushButtonGadgetClass,   spectrumDialog,   (XtPointer)0,        NULL, NULL },
  { "imaginary_wave_numbers", &xmPushButtonGadgetClass,   NULL,             (XtPointer)0,        NULL, NULL },
  { "observed_spectrum",      &xmPushButtonGadgetClass,   readSpectrum,     (XtPointer)0,        NULL, NULL },
  { "delete_spectrum",        &xmPushButtonGadgetClass,   deleteSpectrum,   (XtPointer)0,        NULL, NULL },
  { "zoom_out",               &xmPushButtonGadgetClass,   zoomOut,          (XtPointer)SPECTRUM, NULL, NULL },
  { "hardcopy",               &xmPushButtonGadgetClass,   printDialog,      (XtPointer)SPECTRUM, NULL, NULL },
  { "sep",                    &xmSeparatorGadgetClass,    NULL,             (XtPointer)0,        NULL, NULL },
  { "foreground_color",       &xmPushButtonGadgetClass,   colorEditor,      (XtPointer)(FOREGROUND*8+SPECTRUM), NULL, NULL},
  { "background_color",       &xmPushButtonGadgetClass,   colorEditor,      (XtPointer)(BACKGROUND*8+SPECTRUM), NULL, NULL},
  { "sep",                    &xmSeparatorGadgetClass,    NULL,             (XtPointer)0,        NULL, NULL },
  { "quit_spectrum",          &xmPushButtonGadgetClass,   quitSpectrum,     (XtPointer)SPECTRUM, NULL, NULL },
  { NULL } };
static struct MenuItem historyMenu[] = {
  { "settings_history", &xmPushButtonGadgetClass, optimizationDialog, (XtPointer)0,       NULL, NULL },
  { "hardcopy",         &xmPushButtonGadgetClass, printDialog,        (XtPointer)HISTORY, NULL, NULL },
  { "sep",              &xmSeparatorGadgetClass,  NULL,               (XtPointer)0,       NULL, NULL },
  { "energy_color",     &xmPushButtonGadgetClass, colorEditor,        (XtPointer)(ENERGY*8+HISTORY), NULL, NULL},
  { "gradient_color",   &xmPushButtonGadgetClass, colorEditor,        (XtPointer)(GNORM*8+HISTORY), NULL, NULL},
  { "background_color", &xmPushButtonGadgetClass, colorEditor,        (XtPointer)(BACKGROUND*8+HISTORY), NULL, NULL},
  { "sep",              &xmSeparatorGadgetClass,  NULL,               (XtPointer)0,       NULL, NULL },
  { "quit_history",     &xmPushButtonGadgetClass, quitHistory,        (XtPointer)HISTORY, NULL, NULL },
  { NULL } };
static struct MenuItem MODiagramMenu[] = {
  { "settings_modiagram", &xmPushButtonGadgetClass,   MODiagramDialog,  (XtPointer)0,  NULL, NULL },
  { "transition",         &xmToggleButtonGadgetClass, setTransition,    (XtPointer)0,  NULL, NULL },
  { "zoom_out",           &xmPushButtonGadgetClass,   zoomOut,          (XtPointer)MO, NULL, NULL },
  { "hardcopy",           &xmPushButtonGadgetClass,   printDialog,      (XtPointer)MO, NULL, NULL },
  { "energy_levels",      &xmToggleButtonGadgetClass, setDiagram,       (XtPointer)0,  NULL, NULL },
  { "sep",                &xmSeparatorGadgetClass,    NULL,             (XtPointer)0,  NULL, NULL },
  { "foreground_color",   &xmPushButtonGadgetClass,   colorEditor,      (XtPointer)(FOREGROUND*8+MO), NULL, NULL},
  { "background_color",   &xmPushButtonGadgetClass,   colorEditor,      (XtPointer)(BACKGROUND*8+MO), NULL, NULL},
  { "sep",                &xmSeparatorGadgetClass,    NULL,             (XtPointer)0,  NULL, NULL },
  { "quit_modiagram",     &xmPushButtonGadgetClass,   quitMODiagram,    (XtPointer)MO, NULL, NULL },
  { NULL } };
