/*******************************************************************************
*                                                                              *
*                                   Viewmol                                    *
*                                                                              *
*                               M K C O N N . C                                *
*                                                                              *
*                 Copyright (c) Joerg-R. Hill, December 1997                   *
*                                                                              *
********************************************************************************
*
* $Id: mkconn.c,v 1.2 1998/01/26 00:48:40 jrh Exp jrh $
* $Log: mkconn.c,v $
* Revision 1.2  1998/01/26 00:48:40  jrh
* Release 2.1
*
* Revision 1.1  1996/12/10  18:42:09  jrh
* Initial revision
*
*/
#include<math.h>
#include<stdio.h>
#include<X11/Intrinsic.h>
#include<Xm/Xm.h>
#include "viewmol.h"
#include "dialog.h"

extern struct ATOM *atoms;
extern struct BOND *bonds;
extern struct ORBITAL *orbitals;
extern struct BASISSET *basisset;
extern struct WINDOW windows[];
extern double amplitude, forceScale;
extern double transx, transy, transz;
extern int na, nb, ne;
extern int debug, needMoloch, bondType;
extern int existsUnitCell;
extern Widget topShell;

extern void saveGeometry(void);
extern double bondLength(int, int);
extern void GetMessageBoxButton(Widget, XtPointer, caddr_t);
extern char *getStringResource(Widget, char *);
extern void *getmem(size_t, size_t);
extern void *expmem(void *, size_t, size_t);
extern void fremem(void **);
extern void bondOrder(struct BOND *, int *, int, double);
extern void findConjugation(struct BOND *, int *, int, int, double);
extern void pixelToWorld(int, double *, double *);
extern void redraw(int);

int makeConnectivity(int uc)
{
  Dimension width, height;
  double r1, r2, box, xpix, ypix;
  int *connectivity, maxBondsPerAtom=8;
  size_t mnb=20;
  register int i, j, k;

  transx=0.0;
  transy=0.0;
  transz=0.0;
  for (i=0; i<na; i++)
  {
    transx+=atoms[i].x;
    transy+=atoms[i].y;
    transz+=atoms[i].z;
  }
  transx=-transx/(double)(na);
  transy=-transy/(double)(na);
  transz=-transz/(double)(na);
  for (i=0; i<na; i++)
  {
    atoms[i].x+=transx;
    atoms[i].y+=transy;
    atoms[i].z+=transz;
  }
  saveGeometry();

  repeat:
  connectivity=(int *)getmem((size_t)(maxBondsPerAtom*na), sizeof(int));
  box=0.0;
  for (i=0; i<na; i++)
  {
    atoms[i].nbonds=0;
    if (strncmp(atoms[i].name, "Uc", 2))
    {
      for (j=0; j<na; j++)
      {
        if (i != j && strncmp(atoms[j].name, "Uc", 2))
        {
          r1=bondLength(i, j);
          r2=atoms[i].rad+atoms[j].rad;
          box=box > r1+r2 ? box : r1+r2;
          if (r1 < r2)
          {
            atoms[i].nbonds++;
            if (atoms[i].nbonds > maxBondsPerAtom)
            {
		  maxBondsPerAtom+=5;
		  fremem((void **)&connectivity);
		  goto repeat;
            }
            connectivity[maxBondsPerAtom*i+atoms[i].nbonds-1]=j;
          }
        }
      } 
    }
    else
    {
	uc=i;
  	atoms[i].nbonds=3;
    }
  }
  if (box == 0.0) box=1.3*sqrt(3.)*atoms[0].rad;
  amplitude=box=forceScale=1.05*box/sqrt(3.);
  windows[VIEWER].left=(-box);
  windows[VIEWER].right=box;
  windows[VIEWER].bottom=(-box);
  windows[VIEWER].top=box;
  windows[VIEWER].near=(-box);
  windows[VIEWER].far=box;

  XtVaGetValues(windows[VIEWER].widget, XtNwidth, &width, XtNheight, &height, NULL);
  if (width > height)
  {
    r1=((double)width/(double)height-1.0)*windows[VIEWER].near;
    windows[VIEWER].left=windows[VIEWER].near+r1;
    windows[VIEWER].right=windows[VIEWER].far-r1;
    windows[VIEWER].bottom=windows[VIEWER].near;
    windows[VIEWER].top=windows[VIEWER].far;
  }
  else
  {
    r1=((double)height/(double)width-1.0)*windows[VIEWER].near;             
    windows[VIEWER].left=windows[VIEWER].near;                               
    windows[VIEWER].right=windows[VIEWER].far;
    windows[VIEWER].bottom=windows[VIEWER].near+r1;                         
    windows[VIEWER].top=windows[VIEWER].far-r1;
  }
  pixelToWorld(VIEWER, &xpix, &ypix);
  box=((double)width*xpix+(double)height*ypix)*0.01;

/* Fill the bonds structure. If an atom is only bond to one other atom
   assign bond order immediately since there can be no dependance on any
   other atom */

  bonds=(struct BOND *)getmem(mnb, sizeof(struct BOND));
  nb=0;
  for (i=0; i<na; i++)
  {
    for (j=0; j<atoms[i].nbonds; j++)
    {
      k=connectivity[maxBondsPerAtom*i+j];
      if (i < k)
      {
        bonds[nb].first=i;
        bonds[nb].second=k;
        if (bondType != SINGLE_BONDS)
        {
          if (atoms[i].nbonds == 1 || atoms[k].nbonds == 1)
            bondOrder(&bonds[nb], connectivity, maxBondsPerAtom, box);
          else
            bonds[nb].order=0;
        }
        else
          bonds[nb].order=1;
        bonds[nb++].frac=atoms[i].rad/bondLength(i, k);
      }
      if (nb >= mnb)
      {
        mnb+=20;
        bonds=(struct BOND *)expmem((void *)bonds, mnb, sizeof(struct BOND));
      }
    }
  }

/* Assign bond orders for the remaining bonds */

  for (i=0; i<nb; i++)
    if (bonds[i].order == 0) bondOrder(&bonds[i], connectivity, maxBondsPerAtom, box);

/* Check if there are conjugated double bonds */

  if (bondType == CONJUGATION) findConjugation(bonds, connectivity, maxBondsPerAtom, nb, box);

  fremem((void **)&connectivity);
  if (nb > 0)
    bonds=(struct BOND *)expmem((void *)bonds, nb, sizeof(struct BOND));

/* Add unit cell edges as "bonds" */

  if (uc)
  {
    bonds=(struct BOND *)expmem((void *)bonds, nb+12, sizeof(struct BOND));
    bonds[nb].first=uc-7;
    bonds[nb++].second=uc-6;
    bonds[nb].first=uc-7;
    bonds[nb++].second=uc-5;
    bonds[nb].first=uc-7;
    bonds[nb++].second=uc-4;
    bonds[nb].first=uc-6;
    bonds[nb++].second=uc-3;
    bonds[nb].first=uc-6;
    bonds[nb++].second=uc;
    bonds[nb].first=uc-5;
    bonds[nb++].second=uc-1;
    bonds[nb].first=uc-5;
    bonds[nb++].second=uc;
    bonds[nb].first=uc-4;
    bonds[nb++].second=uc-3;
    bonds[nb].first=uc-4;
    bonds[nb++].second=uc-1;
    bonds[nb].first=uc-3;
    bonds[nb++].second=uc-2;
    bonds[nb].first=uc-2;
    bonds[nb++].second=uc-1;
    bonds[nb].first=uc-2;
    bonds[nb++].second=uc;
    for (i=nb-12; i<nb; i++)
    {
	bonds[i].order=1;
      bonds[i].frac=0.5;
    }
  }
  if (debug == 1)
  {
    printf("Bonds:\n");
    for (i=0; i<nb; i++)
    {
      printf("%d: %s(%d)-%s(%d) = %d", i, atoms[bonds[i].first].name, bonds[i].first+1,
             atoms[bonds[i].second].name, bonds[i].second+1, bonds[i].order);
      if (bonds[i].order != 1)
        printf(", multiple bond shift %f %f %f\n", bonds[i].x, bonds[i].y,
               bonds[i].z);
      else
        printf("\n");
    }
  }
  return(TRUE);
}

void setBondType(Widget widget, caddr_t which, caddr_t dummy)
{
  bondType=(int)which;

  fremem((void *)&bonds);
  makeConnectivity(existsUnitCell);
  redraw(VIEWER);
}
