/*******************************************************************************
*                                                                              *
*                                   Viewmol                                    *
*                                                                              *
*                          M O U S E A C T I O N . C                           *
*                                                                              *
*                 Copyright (c) Joerg-R. Hill, December 1997                   *
*                                                                              *
********************************************************************************
*
* $Id: mouseaction.c,v 1.2 1998/01/26 00:48:50 jrh Exp jrh $
* $Log: mouseaction.c,v $
* Revision 1.2  1998/01/26 00:48:50  jrh
* Release 2.1
*
* Revision 1.1  1996/12/10  18:42:28  jrh
* Initial revision
*
*/
#include<math.h>
#include<stdio.h>
#include<stdlib.h>
#include<unistd.h>
#include<X11/X.h>
#include<X11/Xlib.h>
#include<X11/Intrinsic.h>
#include<Xm/Xm.h>
#include<Xm/PushBG.h>
#include<GL/glu.h>
#ifdef __osf__
#include<X11/GLw/GLwMDrawA.h>
#else
#include<GL/GLwMDrawA.h>
#endif
#include "viewmol.h"
#include "dialog.h"
#include "menu.h"

#define BUFFERSIZE 100

void viewerMouseAction(XEvent *, int);
void spectrumMouseAction(GLwDrawingAreaCallbackStruct *, int);
void historyMouseAction(unsigned int, int, int, int);
void MODiagramMouseAction(GLwDrawingAreaCallbackStruct *, int);
void setGeometry(int);
void restoreGeometry(void);
void ringBell(void);
GLint doPicking(int, int, void draw());
void getBasisfunction(Widget, caddr_t, caddr_t);
void setAnimation(int);

extern void drawMolecule(Widget, caddr_t, GLwDrawingAreaCallbackStruct *);
extern void drawSpectrum(Widget, caddr_t, GLwDrawingAreaCallbackStruct *);
extern void drawMODiagram(Widget, caddr_t, GLwDrawingAreaCallbackStruct *);
extern void doMenu(Widget, Widget, caddr_t);
extern void processInput(Widget, caddr_t, GLwDrawingAreaCallbackStruct *);
extern void calcIntern(int);
extern Boolean normalMode(XtPointer);
extern char *bfname(int);
extern Widget makeMenu(Widget, int, char *, struct MenuItem *);
extern void makeINSIntensity(void);
extern char *getStringResource(Widget, char *);
extern void GetMessageBoxButton(Widget, XtPointer, caddr_t);
extern void basisDialog(int);
extern void *getmem(size_t, size_t);
extern void *expmem(void *, size_t, size_t);
extern void fremem(void **);
extern void calcInternal(int);
extern void redraw(int);
extern int  messgb(Widget, int, char *, struct PushButtonRow *, int);
extern void initZoom(GLwDrawingAreaCallbackStruct *);
extern void endZoom(Dimension, int, int);
extern void pixelToWorld(int, double *, double *);
extern int  makeConnectivity(int);
extern void setMenuItem(int, int, int);
extern void distortGeometry(double);
extern int  makeAnnotation(int, int, float, float, int, const GLfloat *, int, char *);
extern void deleteAnnotation(int *);
extern void annotateWavefunction(void);
extern void modifyAnnotation(int, int, int);

extern XtAppContext app;
extern struct WINDOW windows[4];
extern struct ATOM *atoms;
extern struct BOND *bonds;
extern struct NORMAL_MODE *normal_modes;
extern struct COORDS *history;
extern struct INTERNAL *internals;
extern struct ORBITAL *orbitals;
extern struct OPTIMIZATION *optimization;
extern struct BASISSET *basisset;
extern double *coord, *grid, forceScale, amplitude;
extern double cycle, weight, *cnm, wnScale;
extern int picking, swapBuffers, setins;
extern int imo, imosav, bfatom, annotate;
extern int rotateXY, rotateZ, moveItem;
extern int debug, mode, needMoloch;
extern int na, ninternal, nhist, historyAnnotation;
extern int existsUnitCell, normalModeAnnotation;
extern XtAppContext app;
extern Widget topShell;
extern int showMenu, animate, selectAtom;
extern Pixel stdcol[9];

static int naSaved;

void viewerMouseAction(XEvent *event, int state)
{
  GLint picked;
  static int new=TRUE, intcoord, moveItemSave;
  static int clicked[4] = {-1, -1, -1, -1};
  register int i, j, k, l;

  if (!(moveItem & 0x80000000)) moveItemSave=moveItem;
  if (event->xbutton.button == Button1 && state == TRUE)
  {
    picking=TRUE;
    swapBuffers=FALSE;
    picked=doPicking(event->xbutton.x, event->xbutton.y, drawMolecule);
    picking=FALSE;
    swapBuffers=TRUE;
    if (picked != -1)
    {
      if (selectAtom)
      {
        ringBell();
	  basisDialog(picked);
        bfatom=picked;
        return;
      }
      if (setins)
      {
        ringBell();
        atoms[picked].neutronScatterfac=weight;
        makeINSIntensity();
        return;
      }
	if (picked & 0x80000000)
	{
	  if (!(event->xmotion.state & ShiftMask))
	    modifyAnnotation((picked & 0x7fffffff), event->xbutton.x, event->xbutton.y);
	  else
	  {
	    moveItem=picked;
	    rotateXY=(-1);
	  }
	  return;
	}
      if (new)
	{
        new=FALSE;
	  intcoord=0;
	}
      if (intcoord < TORSION)
      {
        j=FALSE;
        for (i=0; i<intcoord; i++)
        {
          if (picked == clicked[i])
          {
            j=TRUE;
            break;
          }
        }
        if (!j)
        {
          ringBell();
          clicked[intcoord++]=picked;
        }
        showMenu=FALSE;
        return;
      }
      else
      {
        if (internals != NULL)
        {
          if (internals == NULL)
            internals=(struct INTERNAL *)getmem(ninternal+1, sizeof(struct INTERNAL));
          else
            internals=(struct INTERNAL *)expmem((void *)internals, ninternal+1, sizeof(struct INTERNAL));
          internals[ninternal].atoms[0]=clicked[0];
          internals[ninternal].atoms[1]=clicked[1];
          internals[ninternal].atoms[2]=clicked[2];
          internals[ninternal].atoms[3]=clicked[3];
          internals[ninternal].type=TORSION;
          calcInternal(ninternal);
          ninternal++;
        }
        new=FALSE;
        intcoord=0;
        ringBell();
        clicked[intcoord++]=picked;
        return;
      }
    }
  }

  switch (event->xbutton.button)
  {
    case Button1:   if (annotate)
			    modifyAnnotation((-1), event->xbutton.x, event->xbutton.y);
			  else if (state == TRUE) rotateXY=(-1);
                    else
			  {
			    rotateXY=0;
			    moveItem=moveItemSave;
                    }
                    break;
    case Button2:   if (state == TRUE) rotateZ=(-1);
                    else               rotateZ=0;
                    break;
    case Button3:   if (state == TRUE)
                    {
                      new=TRUE;
                      for (i=0; i<ninternal; i++)
                      {
                        if (internals[i].type == intcoord)
                        {
                          k=l=0;
                          for (j=0; j<intcoord; j++)
                          {
                            if (internals[i].atoms[j] == clicked[j]) k++;
                            if (internals[i].atoms[j] == clicked[intcoord-j-1]) l++;
                          }
                          if (k == intcoord || l == intcoord)
                          {
                            for (j=i; j<ninternal; j++)
                            {
                              internals[j].type=internals[j+1].type;
                              internals[j].value=internals[j+1].value;
                              internals[j].atoms[0]=internals[j+1].atoms[0];
                              internals[j].atoms[1]=internals[j+1].atoms[1];
                              internals[j].atoms[2]=internals[j+1].atoms[2];
                              internals[j].atoms[3]=internals[j+1].atoms[3];
                            }
                            ninternal--;
                            if (ninternal == 0)
                              fremem((void **)&internals);
                            else
                              internals=(struct INTERNAL *)expmem((void *)internals, ninternal,
                                                                  sizeof(struct INTERNAL));
                            clicked[0]=(-1);
                            break;
                          }
                        }
                      } /* end of i-loop */
                      if (clicked[0] >= 0)
                      {
                        if (internals == NULL)
                          internals=(struct INTERNAL *)getmem(ninternal+1, sizeof(struct INTERNAL));
                        else
                          internals=(struct INTERNAL *)expmem((void *)internals, ninternal+1,
                                                              sizeof(struct INTERNAL));
                        internals[ninternal].atoms[0]=clicked[0];
                        internals[ninternal].atoms[1]=clicked[1];
                        internals[ninternal].atoms[2]=clicked[2];
                        internals[ninternal].atoms[3]=clicked[3];
                        internals[ninternal].type=intcoord;
                        intcoord=0;
                        calcInternal(ninternal);
                        ninternal++;
                      }
                      redraw(VIEWER);
                      showMenu=TRUE;
                    }
                    break;
  }
}

void clearGeometry(Widget widget, caddr_t all, XmAnyCallbackStruct *data)
{
  if ((int)all)
  {
    fremem((void **)&internals);
    ninternal=0;
  }
  else
  {
    ninternal--;
    if (ninternal > 0)
      internals=(struct INTERNAL *)expmem(internals, ninternal, sizeof(struct INTERNAL));
    else
    {
      free(internals);
      internals=NULL;
      ninternal=0;
    }
  }
  drawMolecule((Widget)0, (caddr_t)0, (GLwDrawingAreaCallbackStruct *)0);
}

void spectrumMouseAction(GLwDrawingAreaCallbackStruct *data, int state)
{
  const GLfloat black[4] = {0.0, 0.0, 0.0, 0.0};
  static struct PushButtonRow button[] = {{"continue", GetMessageBoxButton, (XtPointer)0, NULL}};
  char line[MAXLENLINE], *word;

  if (data->event->xbutton.button == Button1 && state == TRUE)
  {
    picking=TRUE;
    swapBuffers=FALSE;
    mode=doPicking(data->event->xbutton.x, data->event->xbutton.y, drawSpectrum);
    picking=FALSE;
    swapBuffers=TRUE;

    if (cnm == NULL)
    {
      word=getStringResource(topShell, "noNormalModes");
      messgb(topShell, 3, word, button, 1);
    }
    else
    {
      if (mode != -1)
      {
        ringBell();
        if (animate == ANIMATE) setAnimation(TRUE);
        else
        {
          restoreGeometry();
          if (animate == DISTORT) distortGeometry(amplitude);
          drawMolecule((Widget)0, (caddr_t)0, data);
        }
        word=getStringResource(topShell, "wavenumberTitle");
        sprintf(line, word, normal_modes[mode].sym, wnScale*normal_modes[mode].wavenumber);
	  normalModeAnnotation=makeAnnotation(normalModeAnnotation, CENTERED, 0.0,
							  1.0, stdcol[BLACK], black, 0, line);
      }
      else
      {
        if (animate == ANIMATE) setAnimation(FALSE);
	  deleteAnnotation(&normalModeAnnotation);
        restoreGeometry();
        drawMolecule((Widget)0, (caddr_t)0, data);
      }
    }
  } 
  else if (data->event->xbutton.button == Button2 && state == TRUE)
    initZoom(data);
  else if (data->event->xbutton.button == Button2 && state == FALSE)
    endZoom(data->height, data->event->xbutton.x, data->event->xbutton.y);
}

void getImaginaryMode(Widget widget, caddr_t which, caddr_t data)
{
  mode=(int)which;
  if (animate == ANIMATE) setAnimation(TRUE);
  else
  {
    restoreGeometry();
    drawMolecule((Widget)0, (caddr_t)0, (GLwDrawingAreaCallbackStruct *)data);
  }
}

void historyMouseAction(unsigned int button, int state, int x, int y)
{
  double xpix, ypix;

  if (button == Button1 && state == TRUE)
  {
    pixelToWorld(HISTORY, &xpix, &ypix);
    cycle=(double)x*xpix+1.0;
    redraw(HISTORY);
    if (cycle < 1.0) cycle=1.0;
    if (cycle > (double)nhist) cycle=(double)nhist;
  }
  if (button == Button1 && state == FALSE)
    cycle=ceil(cycle-0.5);

  setGeometry(TRUE);
  redraw(VIEWER);
}

void MODiagramMouseAction(GLwDrawingAreaCallbackStruct *data, int state)
{
  int imoSave=imo;

  if (data->event->xbutton.button == Button1 && state == TRUE)
  {
    picking=TRUE;
    swapBuffers=FALSE;
    imo=doPicking(data->event->xbutton.x, data->event->xbutton.y, drawMODiagram);
    picking=FALSE;
    swapBuffers=TRUE;
    if (imo != -1)
    {
      ringBell();
      if (imo != imoSave && grid != NULL)
        fremem((void **)&grid);
      if (orbitals[imo].occupation == 0.0 && needMoloch) setMenuItem(VIEWER, 7, False);
      else if (basisset != NULL)                         setMenuItem(VIEWER, 7, True);
      setMenuItem(MO, 1, True);
    }
    else
      setMenuItem(MO, 1, False);
    annotateWavefunction();
  }
  else if (data->event->xbutton.button == Button2 && state == TRUE)
    initZoom(data);
  else if (data->event->xbutton.button == Button2 && state == FALSE)
    endZoom(data->height, data->event->xbutton.x, data->event->xbutton.y);
}

GLint doPicking(int x, int y, void draw())
{
  GLfloat picksize;
  GLuint buffer[BUFFERSIZE], n, *p, z, zmax;
  GLint viewport[4], picked=(-1);
  GLint hits;
  register int i;

  if (draw == drawMolecule)
    picksize=1.0;
  else
    picksize=3.0;
  glGetIntegerv(GL_VIEWPORT, viewport);
  glSelectBuffer(BUFFERSIZE, buffer);
  glRenderMode(GL_SELECT);
  glInitNames();
  glPushName(0);
  glPushMatrix();
  glLoadIdentity();
  gluPickMatrix((GLdouble)x, (GLdouble)(viewport[3]-y), picksize, picksize, viewport);
  (*draw)((Widget)0, (caddr_t)0, (GLwDrawingAreaCallbackStruct *)0);
  glPopMatrix();
  hits=glRenderMode(GL_RENDER);
  p=buffer;
  zmax=0;
  if (debug) printf("%d hits\n", hits);
  for (i=0; i<hits; i++)
  {
    n=*p++;
    z=*p++;
    if (debug) printf("  z1 = %u, z2 = %u, names = ", z, *p);
    p++;
    while (n-- > 0)
    {
      if (debug) printf("%u, ", *p);
      if (*p && (int)(*p) != (-1) && z >= zmax)
      {
        picked=(GLint)(*p)-1;
        zmax=z;
      }
      p++;
    }
    if (debug) printf("\n");
  }
  if (debug) printf("picked: %d\n", picked);
  return(picked);
}

void setGeometry(int doConnectivity)
{
  const GLfloat black[4] = {0.0, 0.0, 0.0, 0.0};
  double top, bottom, right, left, force;
  char line[MAXLENLINE], *word;
  register int i, j;

  naSaved=na;
  j=((int)ceil(cycle-0.5)-1);
/*if (j > 0) na=optimization[j].natoms; */
  i=optimization[j].coords;
  for (j=0; j<na; j++, i++)
  {
    atoms[j].x=history[i].x;
    atoms[j].y=history[i].y;
    atoms[j].z=history[i].z;
  }
  word=getStringResource(topShell, "historyTitle");
  sprintf(line, word, (int)cycle, optimization[(int)cycle-1].energy,
	    optimization[(int)cycle-1].gnorm);
  historyAnnotation=makeAnnotation(historyAnnotation, CENTERED, 0.0, 1.0,
					     stdcol[BLACK], black, 0, line);

  if (!doConnectivity) return;
  top=windows[VIEWER].top;
  bottom=windows[VIEWER].bottom;
  right=windows[VIEWER].right;
  left=windows[VIEWER].left;
  force=forceScale;
  fremem((void **)&bonds);
  makeConnectivity(existsUnitCell);
  windows[VIEWER].top=top;
  windows[VIEWER].bottom=bottom;
  windows[VIEWER].right=right;
  windows[VIEWER].left=left;
  forceScale=force;
  for (i=0; i<ninternal; i++)
    calcInternal(i);
}

void restoreGeometry(void)
{
  register int i, j;

/*na=naSaved;*/
  j=0;
  for (i=0; i<na; i++)
  {
    atoms[i].x=coord[j++];
    atoms[i].y=coord[j++];
    atoms[i].z=coord[j++];
  }
}

void ringBell(void)
{
  char *command, bell='\007';

  if ((command=getStringResource(topShell, "Bell")) == NULL)
    write(fileno(stdout), &bell, 1);
  else
    system(command);
}

void setAnimation(int start)
{
  static XtWorkProcId id=0;

  restoreGeometry();
  if (start && !id) id=XtAppAddWorkProc(app, normalMode, (XtPointer)NULL);
  if (!start && id)
  {
    XtRemoveWorkProc(id);
    id=0;
  }
}
