/*******************************************************************************
*                                                                              *
*                                   Viewmol                                    *
*                                                                              *
*                              V I E W M O L . C                               *
*                                                                              *
*                 Copyright (c) Joerg-R. Hill, December 1997                   *
*                                                                              *
********************************************************************************
*
* $Id: viewmol.c,v 1.2 1998/01/26 00:49:40 jrh Exp jrh $
* $Log: viewmol.c,v $
* Revision 1.2  1998/01/26 00:49:40  jrh
* Release 2.1
*
* Revision 1.1  1996/12/10  18:44:18  jrh
* Initial revision
*
*/
#include<signal.h>
#include<stdio.h>
#include<X11/Xlib.h>
#include<X11/Intrinsic.h>
#include<Xm/Xm.h>
#include<Xm/DrawingA.h>
#include<GL/gl.h>
#include<GL/glu.h>
#include<GL/glx.h>
#ifdef __osf__
#include<X11/GLw/GLwMDrawA.h>
#else
#include<GL/GLwMDrawA.h>
#endif
#include "dialog.h"
#include "viewmol.h"
#include "fallbacks.h"

extern void processInput(Widget, caddr_t,  GLwDrawingAreaCallbackStruct *);
void reshape(Widget, caddr_t, XmDrawingAreaCallbackStruct *);
void drawMolecule(Widget, caddr_t, GLwDrawingAreaCallbackStruct *);
void getRotation(int, int);
void setDrawingDevice(int);
void ende(Widget, caddr_t, XmAnyCallbackStruct *);

extern void printString(char *, double, double, double, double, GLuint);
extern void feedbackString(char *, double, double, double, double, GLuint);
extern void feedbackLineStipple(GLint, GLushort);
extern void feedbackLineWidth(GLfloat);
extern void feedbackDisable(GLenum);
extern void raytracerBegin(GLenum), raytracerEnd(void), raytracerVertex3d(double, double, double);
extern void raytracerNormal3d(double, double, double);
extern void raytracerColor4fv(const GLfloat *);
extern void raytracerClearColor(GLclampf, GLclampf, GLclampf, GLclampf);
extern void raytracerSphere(GLUquadricObj *, GLdouble, GLint, GLint);
extern void raytracerCylinder(GLUquadricObj *qobj, GLdouble, GLdouble, GLdouble, GLint, GLint);
extern void GetMessageBoxButton(Widget, XtPointer, caddr_t);
extern char *getStringResource(Widget, char *);
extern void pixelToWorld(int, double *, double *);
extern int  messgb(Widget, int, char *, struct PushButtonRow *, int);
extern void loadColorMap(void);
extern int  getrc(void);
extern void showTitle(Dimension, Dimension);
extern int  initViewer(int, char **, Widget);
extern void redraw(int);
extern void fremem(void **);
extern void scaleAnnotation(float);

void (*drawBegin)(GLenum), (*drawEnd)(void), (*drawVertex3d)(double, double, double);
void (*drawVertex2d)(double, double), (*drawNormal3d)(double, double, double);
void (*drawColor4fv)(const GLfloat *);
void (*drawClearColor)(GLclampf, GLclampf, GLclampf, GLclampf);
void (*drawSphere)(GLUquadricObj *, GLdouble, GLint, GLint);
void (*drawCylinder)(GLUquadricObj *qobj, GLdouble, GLdouble, GLdouble, GLint, GLint);
void (*drawString)(char *, double, double, double, double, GLuint);
void (*drawLineStipple)(GLint, GLushort);
void (*drawLineWidth)(GLfloat);
void (*drawDisable)(GLenum);

struct ATOM *atoms;
struct BOND *bonds;
struct ELEMENT *elements;
struct NORMAL_MODE *normal_modes=NULL;
struct WINDOW windows[4];
struct OPTION *options=NULL;
struct OPTION *output=NULL;
struct COORDS *history=NULL;
struct INTERNAL *internals=NULL;
struct OPTIMIZATION *optimization=NULL;
struct ORBITAL *orbitals=NULL;
struct BASISSET *basisset=NULL;
struct GRIDOBJECT *gridObjects=NULL;
struct ANNOTATION *annotation=NULL;
Pixel stdcol[9], historyColor;
char title[MAXLENLINE], webbrowser[MAXLENLINE]={""};
int na, nb, ne, nmodes, nopt=0, noutput=0, nhist=0, ninternal=0, ngridobjects=0;
double *cnm=NULL, *coord, *exponents=NULL, *grid=NULL;
double radfac, bndfac=1.0, amplitude, forceScale, wnScale=1.0;
double transx, transy, transz;
double tinert[3][3], tmat[4][4];
double paperWidth=0.0, paperHeight=0.0, sphereres=10., lineWidth=0.0;
double temp, weight=0.0;
double emax, emin, cycle;
double e1, e2, denres=(1.);
double level=0.05, gridres=(-1.);
float xrot[4]={0.0, 0.0, 0.0, 0.0}, yrot[4]={0.0, 0.0, 0.0, 0.0};
float zrot[4]={0.0, 0.0, 0.0, 0.0};
float xmov[2]={0.0, 0.0}, ymov[2]={0.0, 0.0}, zmov[2]={0.0, 0.0};
float historyColor_rgb[4] = {0.0, 0.0, 1.0, 0.0};
GLfloat light0p[4] = {0.0, 0.0, 1.0, 0.0};
GLfloat light1p[4] = {0.0, 1.0, 0.0, 0.0};
int rotateXY=FALSE, rotateZ=FALSE;
int primitive, animate=ANIMATE, lights=3, moveItem=0, projectionMode=ORTHO;
int lines=TRUE, mode=(-1), showForces=FALSE, setins=FALSE;
int existsUnitCell=FALSE, showUnitCell=TRUE;
int showInertia=FALSE, selectAtom=FALSE, simplify=TRUE;
int rgbMode, picking=FALSE, swapBuffers=TRUE, shadows=FALSE;
int drawingDevice, bondType=CONJUGATION;
int label, imag=0, outputType=0;
int debug, annotate=FALSE;
int nhist, nAnnotations=0, normalModeAnnotation=(-1), selectAtomAnnotation=(-1);
int historyAnnotation=(-1), setinsAnnotation=(-1), wavefunctionAnnotation[4]={-1, -1, -1, -1};
int nbasfu, unit, imo=(-1), imosav=(-1), ibasfu=(-1), bfatom;
char *formBondLength, *formBondAngle, *formTorsionAngle;
char *text, *textPointer;
XtAppContext app;
Widget topShell, fileBox, bfMenu;
int showMenu=TRUE;
int iwavef=ALL_OFF, interp=IP_LINEAR;
int needMoloch=FALSE, gaussian=FALSE;
char moloch[MAXLENLINE];
pid_t manual_pid=0, raypid=0;
int format=TIFFFILE, landscape=TRUE;

int main(int argc, char** argv)
{
  Display *display;
  Widget viewer;
  Colormap colormap;
  XVisualInfo *vi;
  Dimension width, height;
  int attrib[] = {GLX_RED_SIZE, 1,
                  GLX_GREEN_SIZE, 1,
                  GLX_BLUE_SIZE, 1,
                  GLX_DEPTH_SIZE, 1,
                  GLX_DOUBLEBUFFER,
                  GLX_RGBA,
                  GLX_STENCIL_SIZE, 2,
                  None};
  static struct PushButtonRow buttons[] = {{"exit", GetMessageBoxButton, (XtPointer)0, NULL}};
  char *line;

  topShell=XtVaAppInitialize(&app, "Viewmol", NULL, 0, &argc, argv, fallbacks, NULL);
  if (topShell == NULL)
  {
    fprintf(stderr, "%s: ERROR: Cannot connect to X server.\n", PROGRAM);
    exit(-1);
  }
  display=XtDisplay(topShell);
  rgbMode=TRUE;
  if ((vi=glXChooseVisual(display, DefaultScreen(display), attrib)) == NULL)
  {
    attrib[9]=None;
    rgbMode=FALSE;
    if ((vi=glXChooseVisual(display, DefaultScreen(display), attrib)) == NULL)
    {
      line=getStringResource(topShell, "noVisual");
      messgb(topShell, 3, line, buttons, 1);
      exit(-1);
    }
  }
  viewer=XtVaCreateManagedWidget("viewer", xmDrawingAreaWidgetClass, topShell,
                                 XmNmarginHeight, 0,
                                 XmNmarginWidth, 0,
                                 NULL);
  XtRealizeWidget(topShell);

  XtVaGetValues(viewer, XmNwidth, &width, XmNheight, &height, NULL);
  windows[VIEWER].widget=XtVaCreateManagedWidget("canvas", glwMDrawingAreaWidgetClass, viewer,
                                                 GLwNvisualInfo, vi,
                                                 XmNwidth, width,
                                                 XmNheight, height,
                                                 NULL);
#ifndef LINUX
  if (!rgbMode)
  {
#endif
    if (vi->visual == DefaultVisual(display, DefaultScreen(display)))
      colormap=DefaultColormap(display, DefaultScreen(display));
    else
      colormap=XCreateColormap(display, XtWindow(viewer), vi->visual, AllocNone);
    XtVaSetValues(windows[VIEWER].widget, XmNcolormap, colormap, NULL);
#ifndef LINUX
  }
#endif
  windows[VIEWER].context=glXCreateContext(XtDisplay(windows[VIEWER].widget), vi, 0, GL_FALSE);
  GLwDrawingAreaMakeCurrent(windows[VIEWER].widget, windows[VIEWER].context);

  loadColorMap();

  if (getrc())
  {
    setDrawingDevice(SCREEN);
    showTitle(width, height);
    if (initViewer(argc, argv, XtParent(windows[VIEWER].widget)))
    {
      XtAddCallback(windows[VIEWER].widget, GLwNinputCallback, (XtCallbackProc)processInput, NULL);
      XtAddCallback(viewer,                 XmNresizeCallback, (XtCallbackProc)reshape, (XtPointer)VIEWER);
      XtAddCallback(windows[VIEWER].widget, GLwNexposeCallback, (XtCallbackProc)drawMolecule, NULL);
      XSelectInput(XtDisplay(windows[VIEWER].widget), XtWindow(windows[VIEWER].widget),
                   ButtonPressMask | ButtonReleaseMask | KeyPressMask | ExposureMask | Button1MotionMask | Button2MotionMask);
    }
  }
  XtAppMainLoop(app);
  return(0);
}

void reshape(Widget widget, caddr_t window, XmDrawingAreaCallbackStruct *data)
{
  Dimension width, height;
  double rel;
  int w;

  XtVaGetValues(widget, XmNwidth, &width, XmNheight, &height, NULL);
  w=(int)window;
  XtVaSetValues(windows[w].widget, XmNwidth, width, XmNheight, height, NULL);
  GLwDrawingAreaMakeCurrent(windows[w].widget, windows[w].context);
  glViewport(0, 0, width, height);
  if (w == VIEWER)
  {
    if (width > height)
    {
      rel=((double)width/(double)height-1.0)*windows[VIEWER].near;
      windows[VIEWER].left=windows[VIEWER].near+rel;
      windows[VIEWER].right=windows[VIEWER].far-rel;
      windows[VIEWER].bottom=windows[VIEWER].near;
      windows[VIEWER].top=windows[VIEWER].far;
    }
    else
    {
      rel=((double)height/(double)width-1.0)*windows[VIEWER].near;
      windows[VIEWER].left=windows[VIEWER].near;
      windows[VIEWER].right=windows[VIEWER].far;
      windows[VIEWER].bottom=windows[VIEWER].near+rel;
      windows[VIEWER].top=windows[VIEWER].far-rel;
    }
  }
}

void getRotation(int x, int y)
{
  static int xold, yold;

  if (rotateXY == 1)
  {
    xrot[moveItem]+=(float)(y-yold);
    yrot[moveItem]+=(float)(x-xold);
  }
  else if (rotateZ == 1)
    zrot[moveItem]+=(float)(x-xold);

  if (rotateXY == -1)
    rotateXY=1;
  else if (rotateZ == -1)
    rotateZ=1;
 
  xold=x;
  yold=y;
}

void getTranslation(int x, int y)
{
  static int xold, yold;
  double xpix, ypix;

  if (rotateXY == 1)
  {
    pixelToWorld(VIEWER, &xpix, &ypix);
    if (moveItem & 0x80000000)
    {
	annotation[moveItem & 0x7fffffff].x+=(double)(x-xold)*xpix;
	annotation[moveItem & 0x7fffffff].y+=(double)(yold-y)*ypix;
    }
    else
    {
      xmov[moveItem]+=(float)(x-xold)*xpix;
      ymov[moveItem]+=(float)(yold-y)*ypix;
    }
  }
  if (rotateXY == -1) rotateXY=1;

  xold=x;
  yold=y;
}

void getEnlargement(int x)
{
  static int xold=(-1);
  float  scale;

  if (rotateZ == 1)
  {
    if (projectionMode == ORTHO)
    {
      scale=1.+(float)(x-xold)*0.025;
      windows[VIEWER].top*=scale;
      windows[VIEWER].bottom*=scale;
      windows[VIEWER].right*=scale;
      windows[VIEWER].left*=scale;
      if (nAnnotations) scaleAnnotation(scale);
    }
    else
      zmov[moveItem]+=(float)(x-xold);
  }
  if (rotateZ == -1) rotateZ=1;
  xold=x;
  redraw(VIEWER);
}

void setDrawingDevice(int device)
{
  drawingDevice=device;

  switch (device)
  {
    case SCREEN:     drawBegin=glBegin;
                     drawEnd=glEnd;
                     drawVertex3d=glVertex3d;
                     drawVertex2d=glVertex2d;
                     drawNormal3d=glNormal3d;
                     drawColor4fv=glColor4fv;
                     drawClearColor=glClearColor;
                     drawSphere=gluSphere;
                     drawCylinder=gluCylinder;
			   drawString=printString;
			   drawLineStipple=glLineStipple;
			   drawLineWidth=glLineWidth;
			   drawDisable=glDisable;
                     break;
    case HPGL:
    case POSTSCRIPT: drawBegin=glBegin;
                     drawEnd=glEnd;
                     drawVertex3d=glVertex3d;
                     drawVertex2d=glVertex2d;
                     drawNormal3d=glNormal3d;
                     drawColor4fv=glColor4fv;
                     drawClearColor=glClearColor;
                     drawLineStipple=glLineStipple;
                     drawLineWidth=glLineWidth;
                     drawDisable=glDisable;
                     drawSphere=gluSphere;
                     drawCylinder=gluCylinder;
			   drawString=feedbackString;
			   drawLineStipple=feedbackLineStipple;
			   drawLineWidth=feedbackLineWidth;
			   drawDisable=feedbackDisable;
                     break;
    case RAYTRACER:  drawBegin=raytracerBegin;
                     drawEnd=raytracerEnd;
                     drawVertex3d=raytracerVertex3d;
                     drawVertex2d=glVertex2d;
                     drawNormal3d=raytracerNormal3d;
                     drawColor4fv=raytracerColor4fv;
                     drawClearColor=raytracerClearColor;
                     drawSphere=raytracerSphere;
                     drawCylinder=raytracerCylinder;
			   drawString=printString;
			   drawLineStipple=glLineStipple;
			   drawLineWidth=glLineWidth;
			   drawDisable=glDisable;
                     break;
  }
}

void ende(Widget widget, caddr_t client_data, XmAnyCallbackStruct *call_data)
{
  fremem((void **)&windows[VIEWER].font);
  fremem((void **)&atoms);
  fremem((void **)&bonds);
  if (cnm != NULL) fremem((void **)&cnm);
  if (normal_modes != NULL) fremem((void **)&normal_modes);
  if (history != NULL) fremem((void **)&history);
  if (optimization != NULL) fremem((void **)&optimization);
  if (orbitals != NULL) fremem((void **)&orbitals);
  if (basisset != NULL) fremem((void **)&basisset);
  if (exponents != NULL) fremem((void **)&exponents);
  if (options != NULL) fremem((void **)&options);
  if (manual_pid && kill(manual_pid, 0) != -1) kill(manual_pid, SIGTERM);
  if (raypid && kill(raypid, 0) != -1) kill(raypid, SIGTERM);
  exit(0);
}
