/*****
This file is part of the Babel Program
Copyright (C) 1992-96 W. Patrick Walters and Matthew T. Stahl 
All Rights Reserved 
All Rights Reserved 
All Rights Reserved 
All Rights Reserved 

For more information please contact :

babel@mercury.aichem.arizona.edu
--------------------------------------------------------------------------------

FILE : rdvm.c
AUTHOR(S) : Jrg-Rdiger Hill
DATE : 1-99
PURPOSE : routine to read the Viewmol format
	
******/


#include<stdlib.h>
#include "bbltyp.h"

int 
read_viewmol(FILE *file1, ums_type *mol)
{
  struct ATOM {double x, y, z;
	         char   symbol[3];
              } *atoms;
  char the_line[BUFF_SIZE];
  float bo;
  int mna=50, b1, b2;
  int i;

  while (fgets(the_line,sizeof(the_line),file1) != NULL)
    if (the_line[0] == '$') break;

  if ((atoms=(struct ATOM *)calloc((size_t)mna, sizeof(struct ATOM))) == NULL)
  {
    show_warning("Unable to allocate memory.");
    return(FALSE);
  }
  if (strstr(the_line, "$coord"))
  {
    Atoms=0;
    while (fgets(the_line,sizeof(the_line),file1) != NULL)
    {
	if (the_line[0] == '$') break;
	atoms[Atoms].x=atof(strtok(the_line, " \t"));
	atoms[Atoms].y=atof(strtok(NULL, " \t"));
	atoms[Atoms].z=atof(strtok(NULL, " \t"));
	strcpy(atoms[Atoms].symbol, strtok(NULL, " \t"));
	if (++Atoms > mna)
	{
	  mna+=50;
        if ((atoms=(struct ATOM *)realloc((void *)atoms, (size_t)(mna*sizeof(struct ATOM)))) == NULL)
        {
	    show_warning("Unable to allocate memory.");
	    return(FALSE);
	  }
	}
    }
    ShowProgress(Atoms,"Reading Atoms");
    initialize_ums(&mol);
    for (i=0; i<Atoms; i++)
    {
      UpdateProgress();
	X(i+1)=atoms[i].x*0.52917706;
	Y(i+1)=atoms[i].y*0.52917706;
	Z(i+1)=atoms[i].z*0.52917706;
	strcpy(Type(i+1), atoms[i].symbol);
      clean_atom_type(Type(i+1));
    }
    free(atoms);
    assign_radii(mol);
  }
  else if (strstr(the_line, "$bonds"))
  {
    Bonds=0;
    while (fgets(the_line,sizeof(the_line),file1) != NULL)
    {
	if (the_line[0] == '$') break;
	sscanf(the_line, "%d %d %f", &b1, &b2, &bo);
	if (bo != (-1))
	{
	  Start(Bonds)=b1;
	  End(Bonds)=b2;
	  if (bo > 1)
	    Bond_order(Bonds)=(int)bo;
        else
	    Bond_order(Bonds)=1;
	  Bonds++;
	}
    }
  }
  else
    return(FALSE);
  while (fgets(the_line,sizeof(the_line),file1) != NULL);

  assign_types(mol);
  build_connection_table(mol); 
  return(TRUE);
}

