/*******************************************************************************
*                                                                              *
*                                   Viewmol                                    *
*                                                                              *
*                             B O N D F O R M . C                              *
*                                                                              *
*                 Copyright (c) Joerg-R. Hill, December 1998                   *
*                                                                              *
********************************************************************************
*
* $Id: bondform.c,v 1.1 1999/02/07 21:44:32 jrh Exp $
* $Log: bondform.c,v $
* Revision 1.1  1999/02/07 21:44:32  jrh
* Initial revision
*
*
*/
#include<math.h>
#include<stdlib.h>
#include<X11/Intrinsic.h>
#include<Xm/Xm.h>
#include<Xm/Form.h>
#include<Xm/Label.h>
#include<Xm/LabelG.h>
#include<Xm/PanedW.h>
#include<Xm/PushB.h>
#include<Xm/PushBG.h>
#include<Xm/RowColumn.h>
#include<Xm/Scale.h>
#include<Xm/Separator.h>
#include<Xm/Text.h>
#include<Xm/ToggleB.h>
#include "viewmol.h"
#include "dialog.h"

void bondDialog(Widget, caddr_t, XmAnyCallbackStruct *);
void bondDialogExit(Widget, caddr_t, XmPushButtonCallbackStruct *);
void GetHBond(Widget, caddr_t, XmToggleButtonCallbackStruct *);
void GetHBondThreshold(Widget, struct SLIDER *, XmScrollBarCallbackStruct *);

extern void MapBox(Widget, caddr_t, XmAnyCallbackStruct *);
extern Widget CreateToggleBox(Widget, struct PushButtonRow *, int, int,
                              int, int, int);
extern void CreatePushButtonRow(Widget, struct PushButtonRow *, int);
extern char *getStringResource(Widget, char *);
extern void GetMessageBoxButton(Widget, XtPointer, caddr_t);
extern int  messgb(Widget, int, char *, struct PushButtonRow *, int);
extern void setBondType(Widget, caddr_t, XmToggleButtonCallbackStruct *);
extern void GetSlider(Widget, struct SLIDER *, XmScrollBarCallbackStruct *);
extern void redraw(int);
extern int makeConnectivity(struct MOLECULE *, int);
extern Widget initShell(Widget, char *, Widget *, Widget *);

extern struct WINDOW windows[];
extern struct MOLECULE *molecules;
extern Widget topShell;
extern double hbondThreshold;
extern int nmolecule, bondType, showHBond;

static Widget dialog, slider;
static double hbondThreshold_save;
static int bondType_save, showHBond_save;

void bondDialog(Widget widget, caddr_t which, XmAnyCallbackStruct *data)
{
  Widget board, form, sep, hb;
  Widget radiobox;
  short decimals;
  static struct SLIDER threshold;
  static struct PushButtonRow buttons[] = {
    { "ok", bondDialogExit, (XtPointer)TRUE, NULL },
    { "cancel", bondDialogExit, (XtPointer)FALSE, NULL }
  };
  static struct PushButtonRow radiobox_buttons[] = {
    { "single", setBondType, (XtPointer)SINGLE_BONDS, NULL },
    { "multiple", setBondType, (XtPointer)MULTIPLE_BONDS, NULL },
    { "conjugated", setBondType, (XtPointer)CONJUGATION, NULL },
  };

  /* This function creates the bond order dialog */

  bondType_save=bondType;
  showHBond_save=showHBond;
  hbondThreshold_save=hbondThreshold;

  dialog=initShell(XtParent(windows[VIEWER].widget), "bondForm", &board, &form);
  radiobox=CreateToggleBox(form, radiobox_buttons, XtNumber(radiobox_buttons),
                           XmVERTICAL, 1, True, bondType-1);
  sep=XtVaCreateManagedWidget("sep", xmSeparatorWidgetClass, form,
                              XmNorientation, XmHORIZONTAL,
                              XmNtraversalOn, False,
                              NULL);
  hb=XtVaCreateManagedWidget("showHydrogenBonds", xmToggleButtonWidgetClass, form,
                             NULL);
  if (showHBond) XtVaSetValues(hb, XmNset, True, NULL); 
  XtAddCallback(hb, XmNvalueChangedCallback, (XtCallbackProc)GetHBond, &showHBond);

  sep=XtVaCreateManagedWidget("sep", xmSeparatorWidgetClass, form,
                              XmNorientation, XmHORIZONTAL,
                              XmNtraversalOn, False,
                              NULL);
  (void)XtVaCreateManagedWidget("HydrogenBondLabel", xmLabelWidgetClass, form, NULL);
  slider=XtVaCreateManagedWidget("thresholdSlider", xmScaleWidgetClass, form,
                                  XmNorientation, XmHORIZONTAL,
                                  XmNshowValue, True,
                                  XmNsensitive, True,
                                  NULL);
  XtVaGetValues(slider, XmNdecimalPoints, &decimals, NULL);
  XtVaSetValues(slider, XmNvalue, (int)(hbondThreshold*pow(10.0, (double)decimals)), NULL);
  threshold.number=&hbondThreshold;
  threshold.decimals=decimals;
  threshold.draw=NULL;
  XtAddCallback(slider, XmNvalueChangedCallback, (XtCallbackProc)GetHBondThreshold, &threshold);
  XtAddCallback(slider, XmNdragCallback, (XtCallbackProc)GetHBondThreshold, &threshold);
  if (!showHBond) XtVaSetValues(slider, XmNsensitive, False, NULL);
  sep=XtVaCreateManagedWidget("sep", xmSeparatorWidgetClass, form,
                              XmNorientation, XmHORIZONTAL,
                              XmNtraversalOn, False,
                              NULL);

  CreatePushButtonRow(form, buttons, XtNumber(buttons));
  XtAddCallback(dialog, XmNpopupCallback, (XtCallbackProc)MapBox, (XmAnyCallbackStruct *)NULL);
  XtManageChild(form);
  XtManageChild(board);
}

void bondDialogExit(Widget button, caddr_t which, XmPushButtonCallbackStruct *data)
{
  if (!(int)which)
  {
    bondType=bondType_save;
    showHBond=showHBond_save;
    hbondThreshold=hbondThreshold_save;
  }
  XtDestroyWidget(dialog);
}

void GetHBond(Widget w, caddr_t which, XmToggleButtonCallbackStruct *data)
{
  register int i;

  if (data->set)
  {
    *(int *)which=TRUE;
    XtVaSetValues(slider, XmNsensitive, True, NULL);
  }
  else
  {
    *(int *)which=FALSE;
    XtVaSetValues(slider, XmNsensitive, False, NULL);
  }

  for (i=0; i<nmolecule; i++)
    makeConnectivity(&molecules[i], FALSE);
  redraw(VIEWER);
}

void GetHBondThreshold(Widget w, struct SLIDER *slider, XmScrollBarCallbackStruct *data)
{
  register int i;

  GetSlider(w, slider, data);
  for (i=0; i<nmolecule; i++)
    makeConnectivity(&molecules[i], FALSE);
  redraw(VIEWER);
}
