/*******************************************************************************
*                                                                              *
*                                   Viewmol                                    *
*                                                                              *
*                             C E L L F O R M . C                              *
*                                                                              *
*                 Copyright (c) Joerg-R. Hill, December 1998                   *
*                                                                              *
********************************************************************************
*
* $Id: cellform.c,v 1.1 1999/02/07 21:45:28 jrh Exp $
* $Log: cellform.c,v $
* Revision 1.1  1999/02/07 21:45:28  jrh
* Initial revision
*
*
*/
#include<math.h>
#include<stdio.h>
#include<X11/Intrinsic.h>
#include<Xm/Xm.h>
#include<Xm/BulletinB.h>
#include<Xm/Form.h>
#include<Xm/Label.h>
#include<Xm/LabelG.h>
#include<Xm/PanedW.h>
#include<Xm/PushB.h>
#include<Xm/PushBG.h>
#include<Xm/RowColumn.h>
#include<Xm/Scale.h>
#include<Xm/Separator.h>
#include<Xm/Text.h>
#include<Xm/ToggleB.h>
#include "GLwMDrawA.h"
#include "viewmol.h"
#include "dialog.h"

void unitcellExit(Widget, caddr_t, XmPushButtonCallbackStruct *);
void makeNewCell(Widget, struct SLIDER *, XmScrollBarCallbackStruct *);

extern void GetSlider(Widget, struct SLIDER *, XmScrollBarCallbackStruct *);
extern void drawMolecule(Widget, caddr_t, GLwDrawingAreaCallbackStruct *);
extern int redraw(int);
extern void expandCell(void);
extern void MapBox(Widget, caddr_t, XmToggleButtonCallbackStruct *);
extern Widget CreatePushButtonRow(Widget, struct PushButtonRow *, int);
extern Widget CreateToggleBox(Widget, struct PushButtonRow *, int, int,
                              int, int, int);
extern void changeBoolean(Widget, int *, GLwDrawingAreaCallbackStruct *);
extern Widget initShell(Widget, char *, Widget *, Widget *);
extern void setMenuItem(int, int);
extern void *getmem(size_t, size_t);
extern void fremem(void **);

extern struct WINDOW windows[];
extern Widget topShell;
extern double unitcellh, unitcellk, unitcelll;
extern int showUnitCell;

static Widget dialog;
static int showUnitCell_save;
static double unitcellh_save, unitcellk_save, unitcelll_save;

void unitcellDialog(Widget widget, caddr_t dummy, XmAnyCallbackStruct *data)
{
  Widget form, board, togglebox, sep, aWidget, bWidget, cWidget;
  short decimals;
  static struct SLIDER aSlider, bSlider, cSlider;
  static struct PushButtonRow checkbox_button[] = {{"visible", changeBoolean,
                                                    (XtPointer)&showUnitCell, NULL}};
  static struct PushButtonRow buttons[] = {
    { "ok", unitcellExit, (XtPointer)TRUE, NULL },
    { "cancel", unitcellExit, (XtPointer)FALSE, NULL },
  };

  /* This function creates the dialog for the "Unit cell" option */

  setMenuItem(VIEWER_UNITCELL, False);
  showUnitCell_save=showUnitCell;
  unitcellh_save=unitcellh;
  unitcellk_save=unitcellk;
  unitcelll_save=unitcelll;

  dialog=initShell(XtParent(windows[VIEWER].widget), "unitcellForm", &board,
			 &form);
  togglebox=CreateToggleBox(form, checkbox_button, XtNumber(checkbox_button),
                            XmVERTICAL, 1, False, showUnitCell);
  XtVaSetValues(togglebox, XmNleftAttachment, XmATTACH_FORM,
                           XmNrightAttachment, XmATTACH_FORM,
                           XmNtopAttachment, XmATTACH_FORM,
                           NULL);

  sep=XtVaCreateManagedWidget("sep", xmSeparatorWidgetClass, form,
                              XmNleftAttachment, XmATTACH_FORM,
                              XmNrightAttachment, XmATTACH_FORM,
                              XmNtopAttachment, XmATTACH_WIDGET,
                              XmNtopWidget, togglebox,
                              NULL);
  aWidget=XtVaCreateManagedWidget("avalue", xmScaleWidgetClass, form,
                                  XmNorientation, XmHORIZONTAL,
                                  XmNshowValue, True,
                                  XmNsensitive, True,
                                  NULL);
  XtVaGetValues(aWidget, XmNdecimalPoints, &decimals, NULL);
  XtVaSetValues(aWidget, XmNvalue, (int)(unitcellh*pow(10.0, (double)decimals)),
                NULL);
  aSlider.number=&unitcellh;
  aSlider.decimals=decimals;
  aSlider.draw=(void (*)())drawMolecule;
  XtAddCallback(aWidget, XmNvalueChangedCallback, (XtCallbackProc)makeNewCell, &aSlider);
  bWidget=XtVaCreateManagedWidget("bvalue", xmScaleWidgetClass, form,
                                  XmNorientation, XmHORIZONTAL,
                                  XmNshowValue, True,
                                  XmNsensitive, True,
                                  NULL);
  XtVaGetValues(bWidget, XmNdecimalPoints, &decimals, NULL);
  XtVaSetValues(bWidget, XmNvalue, (int)(unitcellk*pow(10.0, (double)decimals)),
                NULL);
  bSlider.number=&unitcellk;
  bSlider.decimals=decimals;
  bSlider.draw=(void (*)())drawMolecule;
  XtAddCallback(bWidget, XmNvalueChangedCallback, (XtCallbackProc)makeNewCell, &bSlider);
  cWidget=XtVaCreateManagedWidget("cvalue", xmScaleWidgetClass, form,
                                  XmNorientation, XmHORIZONTAL,
                                  XmNshowValue, True,
                                  XmNsensitive, True,
                                  NULL);
  XtVaGetValues(cWidget, XmNdecimalPoints, &decimals, NULL);
  XtVaSetValues(cWidget, XmNvalue, (int)(unitcelll*pow(10.0, (double)decimals)),
                NULL);
  cSlider.number=&unitcelll;
  cSlider.decimals=1;
  cSlider.draw=(void (*)())drawMolecule;
  XtAddCallback(cWidget, XmNvalueChangedCallback, (XtCallbackProc)makeNewCell, &cSlider);
  sep=XtVaCreateManagedWidget("sep", xmSeparatorWidgetClass, form,
                              XmNleftAttachment, XmATTACH_FORM,
                              XmNrightAttachment, XmATTACH_FORM,
                              XmNtopAttachment, XmATTACH_WIDGET,
                              XmNtopWidget, form,
                              NULL);

  CreatePushButtonRow(form, buttons, XtNumber(buttons));
  XtAddCallback(dialog, XmNpopupCallback, (XtCallbackProc)MapBox,
                (XmAnyCallbackStruct *)NULL);
  XtManageChild(form);
  XtManageChild(board);
}

void unitcellExit(Widget button, caddr_t which, XmPushButtonCallbackStruct *data)
{
  XtDestroyWidget(dialog);
  if (!(int)which)
  {
    showUnitCell=showUnitCell_save;
    unitcellh=unitcellh_save;
    unitcellk=unitcellk_save;
    unitcelll=unitcelll_save;
    expandCell();
    redraw(VIEWER);
  }
  setMenuItem(VIEWER_UNITCELL, True);
}

void makeNewCell(Widget w, struct SLIDER *slider, XmScrollBarCallbackStruct *data)
{
  GetSlider(w, slider, data);
  if (unitcellh != unitcellh_save || unitcellk != unitcellk_save ||
      unitcelll != unitcelll_save) expandCell();
  redraw(VIEWER);
}
