/*******************************************************************************
*                                                                              *
*                                   Viewmol                                    *
*                                                                              *
*                               M A T R I X . C                                *
*                                                                              *
*                 Copyright (c) Joerg-R. Hill, December 1998                   *
*                                                                              *
********************************************************************************
*
* $Id: matrix.c,v 1.2 1999/02/07 21:52:01 jrh Exp $
* $Log: matrix.c,v $
* Revision 1.2  1999/02/07 21:52:01  jrh
* Release 2.2
*
* Revision 1.1  1998/01/26 00:35:07  jrh
* Initial revision
*
*/
#include<stdio.h>
#include<GL/gl.h>
#include<GL/glu.h>
#include "viewmol.h"

void getMatrix(double matrix[4][4]);
void multMatrix(double matrix1[4][4], double matrix2[4][4], double matrix3[4][4]);
void transformCoordinates(int, float input[4], float output[4]);

extern struct WINDOW windows[];
extern float *rotObject;

void getMatrix(double matrix[4][4])
{
  double mvmat[4][4], prmat[4][4];

  glGetDoublev(GL_MODELVIEW_MATRIX, &mvmat[0][0]);
  glGetDoublev(GL_PROJECTION_MATRIX, &prmat[0][0]);
  multMatrix(mvmat, prmat, matrix);
}

void multMatrix(double matrix1[4][4], double matrix2[4][4], double matrix3[4][4])
{
  register int i, j, k;

  for (i=0; i<4; i++)
  {
    for (j=0; j<4; j++)
    {
      matrix3[i][j]=0.0;
      for (k=0; k<4; k++)
        matrix3[i][j]+=matrix1[i][k]*matrix2[k][j];
    }
  }
}

void transposeMatrix(double matrix[4][4])
{
  double help;
  register int i, j;

  for (i=0; i<4; i++)
  {
    for (j=i+1; j<4; j++)
    {
      help=matrix[i][j];
      matrix[i][j]=matrix[j][i];
      matrix[j][i]=help;
    }
  }
}

void transformCoordinates(int which, float input[4], float output[4])
{
  float matrix[4][4];

  glPushMatrix();
  glLoadIdentity();
  switch (which)
  {
    case VIEWPOINT: glRotatef(0.25*rotObject[3*which],   1.0, 0.0, 0.0);
                    glRotatef(0.25*rotObject[3*which+1], 0.0, 1.0, 0.0);
                    glRotatef(0.25*rotObject[3*which+2], 0.0, 0.0, 1.0);
                    break;
    default:        glRotatef(rotObject[3*which],   1.0, 0.0, 0.0);
                    glRotatef(rotObject[3*which+1], 0.0, 1.0, 0.0);
                    glRotatef(rotObject[3*which+2], 0.0, 0.0, 1.0);
                    break;
  }
  glGetFloatv(GL_MODELVIEW_MATRIX, &matrix[0][0]);
  glPopMatrix();

  output[0]=matrix[0][0]*input[0]+matrix[1][0]*input[1]+matrix[2][0]*input[2]+matrix[3][0]*input[3];
  output[1]=matrix[0][1]*input[0]+matrix[1][1]*input[1]+matrix[2][1]*input[2]+matrix[3][1]*input[3];
  output[2]=matrix[0][2]*input[0]+matrix[1][2]*input[1]+matrix[2][2]*input[2]+matrix[3][2]*input[3];
  output[3]=matrix[0][3]*input[0]+matrix[1][3]*input[1]+matrix[2][3]*input[2]+matrix[3][3]*input[3];
}

void getScreenCoordinates(double xw, double yw, double zw, double *xs,
                          double *ys, double *zs)
{
  GLdouble mvMatrix[16], prMatrix[16];
  GLint viewport[4];

  glGetDoublev(GL_MODELVIEW_MATRIX, mvMatrix);
  glGetDoublev(GL_PROJECTION_MATRIX, prMatrix);
  glGetIntegerv(GL_VIEWPORT, viewport);
  gluProject(xw, yw, zw, mvMatrix, prMatrix, viewport, xs, ys, zs);
  *ys=(double)viewport[3]-(*ys);
}
