/*******************************************************************************
*                                                                              *
*                                   Viewmol                                    *
*                                                                              *
*                            R A Y T R A C E R . C                             *
*                                                                              *
*                 Copyright (c) Joerg-R. Hill, December 1998                   *
*                                                                              *
********************************************************************************
*
* $Id: raytracer.c,v 1.3 1999/02/07 21:55:23 jrh Exp $
* $Log: raytracer.c,v $
* Revision 1.3  1999/02/07 21:55:23  jrh
* Release 2.2
*
* Revision 1.2  1998/01/26 00:49:09  jrh
* Release 2.1
*
* Revision 1.1  1996/12/10  18:43:29  jrh
* Initial revision
*
*/
#include<stdio.h>
#include<stdlib.h>
#include<string.h>
#include<unistd.h>
#include<X11/Intrinsic.h>
#include "viewmol.h"
#include "dialog.h"

extern char *getStringResource(Widget, char *);
extern void GetMessageBoxButton(Widget, XtPointer, caddr_t);
extern char *selectFile(char *, char *);
extern int messgb(Widget, int, char *, struct PushButtonRow *, int);
extern char *saveVectorFile(int, char *, int);
extern int runProg(char *, int, char *, char *, char *, pid_t *);
extern int checkFile(char **);

extern Widget topShell;
extern pid_t raypid;
extern char *rayshade, *displayRLE;

void raytracer(Widget widget, caddr_t data1, caddr_t data2)
{
  static struct PushButtonRow buttons1[] = {{"continue", GetMessageBoxButton, (XtPointer)0, NULL},
                                            {"cancel", GetMessageBoxButton, (XtPointer)1, NULL}};
  static struct PushButtonRow buttons2[] = {{"doRaytracing", GetMessageBoxButton, (XtPointer)0, NULL},
                                            {"stopRaytracing", GetMessageBoxButton, (XtPointer)1, NULL}};
  static struct PushButtonRow buttons3[] = {{"continue", GetMessageBoxButton, (XtPointer)0, NULL}};
  static char *rayfile="vm_image.ray";
  pid_t pid;
  char line[MAXLENLINE];
  char rlefile[MAXLENLINE], *dot;

  if ((rayfile=selectFile("*", rayfile)) == NULL) return;
  saveVectorFile(VIEWER, rayfile, RAYTRACER);
  strcpy(rlefile, rayfile);
  if ((dot=strrchr(rlefile,'.')) != NULL)
    strcpy(dot, ".rle");
  else
    strcat(rlefile, ".rle");
  if (!access(rlefile, F_OK))
  {
    dot=getStringResource(topShell, "FileExists");
    sprintf(line, dot, rlefile);
    if (messgb(topShell, 1, line, buttons1, 2) == 1) return;
  }

  if (*rayshade != '\0')
  {
    if (*displayRLE == '\0')
    {
      dot=getStringResource(topShell, "noDisplay");
      if (messgb(topShell, 3, dot, buttons2, 2) == 1) return;
    }
    if ((raypid=fork()) == (pid_t)0)
    {
      runProg(rayshade, TRUE, rayfile, rlefile, "/dev/null", &pid);
      if (*displayRLE != '\0')
      {
        sprintf(line, displayRLE, rlefile);
        runProg(line, FALSE, NULL, NULL, "/dev/null", &pid);
      }
      exit(0);
    }
  }
  else
  {
    dot=getStringResource(topShell, "noRayshade");
    messgb(topShell, 3, dot, buttons3, 1);
  }
}
