/*******************************************************************************
*                                                                              *
*                                   Viewmol                                    *
*                                                                              *
*                              V I E W M O L . C                               *
*                                                                              *
*                 Copyright (c) Joerg-R. Hill, December 1998                   *
*                                                                              *
********************************************************************************
*
* $Id: viewmol.c,v 1.3 1999/02/07 21:58:09 jrh Exp $
* $Log: viewmol.c,v $
* Revision 1.3  1999/02/07 21:58:09  jrh
* Release 2.2
*
* Revision 1.2  1998/01/26 00:49:40  jrh
* Release 2.1
*
* Revision 1.1  1996/12/10  18:44:18  jrh
* Initial revision
*
*/
#include<signal.h>
#include<stdio.h>
#include<X11/Xlib.h>
#include<X11/Intrinsic.h>
#ifdef IRIX
#include<X11/SGIFastAtom.h>
#endif
#include<Xm/Xm.h>
#include<Xm/XmStrDefs.h>
#include<Xm/DrawingA.h>
#include<GL/gl.h>
#include<GL/glu.h>
#include<GL/glx.h>
#include "GLwMDrawA.h"
#include "dialog.h"
#include "viewmol.h"
#include "fallbacks.h"

#ifdef LINUX
#define PARENT(x) (x)
#else
#define PARENT(x) XtParent(x)
#endif

void reshape(Widget, caddr_t, GLwDrawingAreaCallbackStruct *);
void getRotation(int, int, int, int);
void setDrawingDevice(int);
void ende(Widget, caddr_t, XmAnyCallbackStruct *);
void setIcon(Widget, XtPointer, XEvent *);
void signalHandler(int);
void installColormap(void);

extern void drawMolecule(Widget, caddr_t, GLwDrawingAreaCallbackStruct *);
extern void processInput(Widget, caddr_t, GLwDrawingAreaCallbackStruct *);
extern void printString(char *, double, double, double, double, GLuint);
extern void feedbackString(char *, double, double, double, double, GLuint);
extern void feedbackLineStipple(GLint, GLushort);
extern void feedbackLineWidth(GLfloat);
extern void feedbackDisable(GLenum);
extern void raytracerBegin(GLenum), raytracerEnd(void), raytracerVertex3d(double, double, double);
extern void raytracerNormal3d(double, double, double);
extern void raytracerColor4fv(const GLfloat *);
extern void raytracerClearColor(GLclampf, GLclampf, GLclampf, GLclampf);
extern void raytracerSphere(GLUquadricObj *, GLdouble, GLint, GLint);
extern void raytracerCylinder(GLUquadricObj *qobj, GLdouble, GLdouble, GLdouble, GLint, GLint);
extern void GetMessageBoxButton(Widget, XtPointer, caddr_t);
extern char *getStringResource(Widget, char *);
extern void pixelToWorld(int, double *, double *);
extern int  messgb(Widget, int, char *, struct PushButtonRow *, int);
extern void loadColorMap(void);
extern void findInputDevices(Widget);
extern int  getrc(void);
extern void showTitle(Widget, caddr_t, GLwDrawingAreaCallbackStruct *);
extern int  initViewer(int, char **, Widget);
extern void redraw(int);
extern void fremem(void **);
extern void scaleAnnotation(float);
extern void processSpaceballEvent(XEvent *);
extern void load(Widget, caddr_t, XmAnyCallbackStruct *);
extern void allocWindowColors(void);
extern XVisualInfo *getVisualInfo(Display *, Visual *);
extern Colormap getRGBcolormap(Display *, int, XVisualInfo *);

void (*drawBegin)(GLenum), (*drawEnd)(void), (*drawVertex3d)(double, double, double);
void (*drawVertex2d)(double, double), (*drawNormal3d)(double, double, double);
void (*drawColor4fv)(const GLfloat *);
void (*drawClearColor)(GLclampf, GLclampf, GLclampf, GLclampf);
void (*drawSphere)(GLUquadricObj *, GLdouble, GLint, GLint);
void (*drawCylinder)(GLUquadricObj *qobj, GLdouble, GLdouble, GLdouble, GLint, GLint);
void (*drawString)(char *, double, double, double, double, GLuint);
void (*drawLineStipple)(GLint, GLushort);
void (*drawLineWidth)(GLfloat);
void (*drawDisable)(GLenum);

struct MOLECULE *molecules=NULL;
struct ELEMENT *elements;
struct WINDOW windows[4];
struct OPTION *options=NULL;
struct OPTION *output=NULL;
struct ANNOTATION *annotation=NULL;
struct UNDO *undo=NULL;
Pixel stdcol[9], historyColor;
XtAppContext app;
Widget topShell, fileBox, bfMenu, undoButton=NULL;
double *grid=NULL;
double bndfac=1.0, amplitude, forceScale, wnScale=1.0, hbondThreshold=2.0;
double tmat[4][4];
double paperWidth=0.0, paperHeight=0.0, sphereres=10., lineWidth=0.0;
double temp, weight=0.0;
double e1, e2, denres=(1.);
double level=0.05, gridres=(-1.), torsionDefault=180.0;
double unitcellh=1.0, unitcellk=1.0, unitcelll=1.0;
float *transObject=NULL, *rotObject=NULL;
float historyColor_rgb[4] = {0.0, 0.0, 1.0, 0.0};
GLfloat light0p[4] = {0.0, 0.0, 1.0, 0.0};
GLfloat light1p[4] = {0.0, 1.0, 0.0, 0.0};
int ne, nopt=0, noutput=0, nUndo=0;
int nmolecule=0, imol;
int rotateXY=FALSE, rotateZ=FALSE;
int primitive, animate=ANIMATE, lights=3, moveItem=MOLECULES, projectionMode=ORTHO;
int lines=TRUE, showForces=FALSE, setins=FALSE;
int showUnitCell=TRUE, bondOrderDefault=1;
int showInertia=FALSE, selectAtom=FALSE, simplify=TRUE;
int rgbMode, picking=FALSE, swapBuffers=TRUE, shadows=FALSE, ground=TRUE, drawIcon=FALSE;
int drawingDevice, bondType=CONJUGATION, showHBond=TRUE, localGeometry=TRUE;
int label, outputType=0, automaticRecalculate=FALSE;
int debug, annotate=FALSE;
int nAnnotations=0, normalModeAnnotation=(-1), selectAtomAnnotation=(-1);
int historyAnnotation=(-1), setinsAnnotation=(-1);
int unit, bfatom, element=0, modifyMolecule=NOTHING;
int spaceballButtonPress, spaceballMotionNotify;
int showMenu=TRUE, saveLanguage=FALSE;
int iwavef=ALL_OFF, interp=IP_LINEAR;
int format=TIFFFILE, landscape=TRUE;
char *formBondLength, *formBondAngle, *formTorsionAngle;
char *text, *textPointer;
char language[20];
char webbrowser[MAXLENLINE]={""}, moloch[MAXLENLINE]={""};
char rayshade[MAXLENLINE]={""}, displayRLE[MAXLENLINE]={""};
pid_t manual_pid=0, raypid=0;

int main(int argc, char** argv)
{
  Display *display;
  Widget viewer;
  XVisualInfo *vi;
  Colormap colormap;
  XEvent event;
  Dimension width, height;
/*String translations="<KeyDown>:    DrawingAreaInput()\n\
                       <Btn1Motion>: DrawingAreaInput()\n\
                       <Btn2Motion>: DrawingAreaInput()\n\
                       <BtnDown>:    DrawingAreaInput()\n\
                       <BtnUp>:      DrawingAreaInput()"; */
  int attrib[] = {GLX_RED_SIZE, 1,
                  GLX_GREEN_SIZE, 1,
                  GLX_BLUE_SIZE, 1,
                  GLX_DEPTH_SIZE, 1,
                  GLX_DOUBLEBUFFER,
                  GLX_RGBA,
                  GLX_STENCIL_SIZE, 2,
                  None};
  static struct PushButtonRow buttons[] = {{"exit", GetMessageBoxButton,
                                           (XtPointer)0, NULL}};
  char *line;

  signal(SIGBUS,  signalHandler);
  signal(SIGFPE,  signalHandler);
  signal(SIGSEGV, signalHandler);

  topShell=XtVaAppInitialize(&app, "Viewmol", NULL, 0, &argc, argv, fallbacks,
                             NULL);
  if (topShell == NULL)
  {
    fprintf(stderr, "%s: ERROR: Cannot connect to X server.\n", PROGRAM);
    exit(-1);
  }
  display=XtDisplay(topShell);
  rgbMode=TRUE;
  if ((vi=glXChooseVisual(display, XScreenNumberOfScreen(XtScreen(topShell)),
       attrib)) == NULL)
  {
    attrib[9]=None;
    rgbMode=FALSE;
    if ((vi=glXChooseVisual(display, XScreenNumberOfScreen(XtScreen(topShell)),
         attrib)) == NULL)
    {
      line=getStringResource(topShell, "noVisual");
      messgb(topShell, 3, line, buttons, 1);
      exit(-1);
    }
  }
  viewer=XtVaCreateManagedWidget("viewer", xmDrawingAreaWidgetClass, topShell,
                                 XmNmarginHeight, 0,
                                 XmNmarginWidth, 0,
                                 NULL);
  XtRealizeWidget(topShell);

  XtVaGetValues(viewer, XmNwidth, &width, XmNheight, &height, NULL);

  windows[VIEWER].widget=XtVaCreateManagedWidget("canvas", glwMDrawingAreaWidgetClass,
                                                 viewer,
                                                 GLwNvisualInfo, vi,
                                                 XmNheight, width,
                                                 XmNwidth, height,
                                                 NULL);
  colormap=getRGBcolormap(display, vi->screen, vi);

/* AIX doesn't return anything meanigful here, but also requires that
   the color map is not set */
  if (strlen(glXQueryServerString(display, vi->screen, GLX_VERSION)) > 0)
    XtVaSetValues(windows[VIEWER].widget, XmNcolormap, colormap, NULL);

  windows[VIEWER].context=glXCreateContext(XtDisplay(windows[VIEWER].widget),
                                           vi, None, GL_TRUE);
  GLwDrawingAreaMakeCurrent(windows[VIEWER].widget, windows[VIEWER].context);

  loadColorMap();
  findInputDevices(windows[VIEWER].widget);
  XtAddEventHandler(topShell, PropertyChangeMask, False,
                    (XtEventHandler)setIcon, (XtPointer)NULL);

  if (getrc())
  {
    setDrawingDevice(SCREEN);
    XtAddCallback(windows[VIEWER].widget, GLwNexposeCallback, (XtCallbackProc)showTitle, NULL);
    XtAddCallback(windows[VIEWER].widget, GLwNinputCallback,  (XtCallbackProc)processInput, NULL);
    XtAddCallback(viewer, XmNresizeCallback, (XtCallbackProc)reshape, (XtPointer)VIEWER);
    showTitle((Widget)0, (caddr_t)0, (GLwDrawingAreaCallbackStruct *)0);
    allocWindowColors();
    windows[VIEWER].menu=NULL;
    if (!initViewer(argc, argv, PARENT(windows[VIEWER].widget)))
      load((Widget)0, (caddr_t)0, (XmAnyCallbackStruct *)0);
    if (molecules)
    {
      XtRemoveAllCallbacks(windows[VIEWER].widget, GLwNexposeCallback);
      XtAddCallback(windows[VIEWER].widget, GLwNexposeCallback, (XtCallbackProc)drawMolecule, NULL);
    }
  }
  while (TRUE)
  {                                                    
    XtAppNextEvent(app, &event);
    if (event.type == spaceballMotionNotify || event.type == spaceballButtonPress)
      processSpaceballEvent(&event);
    else
      XtDispatchEvent(&event);
  }
}

void reshape(Widget widget, caddr_t window, GLwDrawingAreaCallbackStruct *data)
{
  Dimension width, height;
  double rel;
  int w;

  XtVaGetValues(widget, XmNwidth, &width, XmNheight, &height, NULL);
  w=(int)window;
  XtVaSetValues(windows[w].widget, XmNwidth, width, XmNheight, height, NULL);
  GLwDrawingAreaMakeCurrent(windows[w].widget, windows[w].context);
  glViewport(0, 0, width, height);
  if (w == VIEWER)
  {
    if (width > height)
    {
      rel=((double)width/(double)height-1.0)*windows[VIEWER].near;
      windows[VIEWER].left=windows[VIEWER].near+rel;
      windows[VIEWER].right=windows[VIEWER].far-rel;
      windows[VIEWER].bottom=windows[VIEWER].near;
      windows[VIEWER].top=windows[VIEWER].far;
    }
    else
    {
      rel=((double)height/(double)width-1.0)*windows[VIEWER].near;
      windows[VIEWER].left=windows[VIEWER].near;
      windows[VIEWER].right=windows[VIEWER].far;
      windows[VIEWER].bottom=windows[VIEWER].near+rel;
      windows[VIEWER].top=windows[VIEWER].far-rel;
    }
  }
}

void getRotation(int x, int y, int z, int mode)
{
  static int xold, yold, zold;

  if (mode == 2)
  {
    xold=x;
    yold=y;
    zold=z;
    return;
  }

  if (x < 0) x=xold;
  if (y < 0) y=yold;
  if (z < 0) z=zold;
  if (mode == 1)
  {
    rotObject[3*moveItem]+=(float)y;
    rotObject[3*moveItem+1]+=(float)x;
    rotObject[3*moveItem+2]+=(float)z;
  }
  else
  {
    rotObject[3*moveItem]+=(float)(y-yold);
    rotObject[3*moveItem+1]+=(float)(x-xold);
    rotObject[3*moveItem+2]+=(float)(z-zold);
  }
  if (mode == 0)
  {
    xold=x;
    yold=y;
    zold=z;
  }
}

void getTranslation(int x, int y, int mode)
{
  static int xold, yold;
  double xpix, ypix;

  if (rotateXY == 1)
  {
    pixelToWorld(VIEWER, &xpix, &ypix);
    if (moveItem & 0x80000000)
    {
      if (mode == 1)
      {
        annotation[moveItem & 0x7fffffff].x+=(double)x*xpix;
        annotation[moveItem & 0x7fffffff].y+=(double)y*ypix;
      }
      else
      {
        annotation[moveItem & 0x7fffffff].x+=(double)(x-xold)*xpix;
        annotation[moveItem & 0x7fffffff].y+=(double)(yold-y)*ypix;
      }
    }
    else
    {
      if (mode == 1)
      {
        transObject[3*moveItem]+=(float)x*xpix;
        transObject[3*moveItem+1]+=(float)y*ypix;
      }
      else
      {
        transObject[3*moveItem]+=(float)(x-xold)*xpix;
        transObject[3*moveItem+1]+=(float)(yold-y)*ypix;
      }
    }
  }
  if (rotateXY == -1) rotateXY=1;

  xold=x;
  yold=y;
}

void getEnlargement(int x, int mode)
{
  static int xold=(-1);
  float  scale;

  if (rotateZ == 1)
  {
    if (projectionMode == ORTHO)
    {
      if (mode == 1)
        scale=1.+(float)x*0.025;
      else
        scale=1.+(float)(x-xold)*0.025;
      windows[VIEWER].top*=scale;
      windows[VIEWER].bottom*=scale;
      windows[VIEWER].right*=scale;
      windows[VIEWER].left*=scale;
      if (nAnnotations) scaleAnnotation(scale);
    }
    else
    {
      if (mode == 1)
        transObject[3*moveItem+2]+=(float)x;
      else
        transObject[3*moveItem+2]+=(float)(x-xold);
    }
  }
  if (rotateZ == -1) rotateZ=1;
  xold=x;
  redraw(VIEWER);
}

void setDrawingDevice(int device)
{
  drawingDevice=device;

  switch (device)
  {
    case SCREEN:     drawBegin=glBegin;
                     drawEnd=glEnd;
                     drawVertex3d=glVertex3d;
                     drawVertex2d=glVertex2d;
                     drawNormal3d=glNormal3d;
                     drawColor4fv=glColor4fv;
                     drawClearColor=glClearColor;
                     drawSphere=gluSphere;
                     drawCylinder=gluCylinder;
                     drawString=printString;
                     drawLineStipple=glLineStipple;
                     drawLineWidth=glLineWidth;
                     drawDisable=glDisable;
                     break;
    case HPGL:
    case POSTSCRIPT: drawBegin=glBegin;
                     drawEnd=glEnd;
                     drawVertex3d=glVertex3d;
                     drawVertex2d=glVertex2d;
                     drawNormal3d=glNormal3d;
                     drawColor4fv=glColor4fv;
                     drawClearColor=glClearColor;
                     drawLineStipple=glLineStipple;
                     drawLineWidth=glLineWidth;
                     drawDisable=glDisable;
                     drawSphere=gluSphere;
                     drawCylinder=gluCylinder;
                     drawString=feedbackString;
                     drawLineStipple=feedbackLineStipple;
                     drawLineWidth=feedbackLineWidth;
                     drawDisable=feedbackDisable;
                     break;
    case RAYTRACER:  drawBegin=raytracerBegin;
                     drawEnd=raytracerEnd;
                     drawVertex3d=raytracerVertex3d;
                     drawVertex2d=glVertex2d;
                     drawNormal3d=raytracerNormal3d;
                     drawColor4fv=raytracerColor4fv;
                     drawClearColor=raytracerClearColor;
                     drawSphere=raytracerSphere;
                     drawCylinder=raytracerCylinder;
                     drawString=printString;
                     drawLineStipple=glLineStipple;
                     drawLineWidth=glLineWidth;
                     drawDisable=glDisable;
                     break;
  }
}

void ende(Widget widget, caddr_t client_data, XmAnyCallbackStruct *call_data)
{
  struct MOLECULE *mol;
  register int i;

  fremem((void **)&windows[VIEWER].font);
  if (windows[SPECTRUM].font != NULL) fremem((void **)&windows[SPECTRUM].font);
  if (windows[HISTORY].font != NULL) fremem((void **)&windows[HISTORY].font);
  if (windows[MO].font != NULL) fremem((void **)&windows[MO].font);
  for (i=0; i<nmolecule; i++)
  {
    mol=&molecules[i];
    fremem((void **)&(mol->atoms));
    fremem((void **)&(mol->bonds));
    if (mol->cnm != NULL)          fremem((void **)&(mol->cnm));
    if (mol->normal_modes != NULL) fremem((void **)&(mol->normal_modes));
    if (mol->history != NULL)      fremem((void **)&(mol->history));
    if (mol->optimization != NULL) fremem((void **)&(mol->optimization));
    if (mol->orbitals != NULL)     fremem((void **)&(mol->orbitals));
    if (mol->basisset != NULL)     fremem((void **)&(mol->basisset));
    if (mol->exponents != NULL)    fremem((void **)&(mol->exponents));
  }
  if (options != NULL) fremem((void **)&options);
  fremem((void **)&molecules);
  if (manual_pid && kill(manual_pid, 0) != -1) kill(manual_pid, SIGTERM);
  if (raypid && kill(raypid, 0) != -1) kill(raypid, SIGTERM);
  exit(0);
}

void setIcon(Widget widget, XtPointer dummy, XEvent *e)
{
  Display *display;
  Screen *screen;
  XVisualInfo *visualInfo;
  XPropertyEvent *event=(XPropertyEvent *)e;
  Atom wmStateAtom=(Atom)0;
  XIconSize *sizes;
  Pixmap pixmap;
  GLXPixmap glxPixmap;
  GLXContext context;
  int count, w, h;

#ifdef IRIX
  wmStateAtom=SGI_XA_WM_STATE;
#endif
#ifdef Linux
  wmStateAtom=XInternAtom(XtDisplay(topShell), XmSWM_STATE, True);
#endif
  if (event->atom == wmStateAtom)
  {
    display=XtDisplay(topShell);
    screen=XtScreen(topShell);
    if (XGetIconSizes(display, RootWindowOfScreen(screen), &sizes, &count))
    {
/*    printf("%d %d %d %d %d %d\n", sizes[0].min_width, sizes[0].min_height,
             sizes[0].max_width, sizes[0].max_height, sizes[0].width_inc,
             sizes[0].height_inc); */
      w=sizes[0].max_width;
      h=sizes[0].max_height;
      XFree(sizes);
    }
    else
    {
      w=85;
      h=67;
    }
    XtVaGetValues(topShell, GLwNvisualInfo, &visualInfo, NULL);
/*  visualInfo=getVisualInfo(display, vi); */
    pixmap=XCreatePixmap(display, RootWindowOfScreen(screen), w, h, visualInfo->depth);
    glxPixmap=glXCreateGLXPixmap(display, visualInfo, pixmap);
    context=glXCreateContext(display, visualInfo, NULL, FALSE);
    drawIcon=TRUE;
    glXMakeCurrent(display, glxPixmap, context);
    glViewport(0, 0, w, h);
/*  drawMolecule((Widget)0, (caddr_t)0, (GLwDrawingAreaCallbackStruct *)0);*/
    glClearColor(1.0, 0.0, 0.0, 0.0);
    glClearDepth(GL_COLOR_BUFFER_BIT);
    drawIcon=FALSE;
    XtVaSetValues(topShell, XtNiconPixmap, pixmap, NULL);
  }
}

void signalHandler(int signalNumber)
{
  struct PushButtonRow buttons[] = {{"exit", GetMessageBoxButton, (XtPointer)0, NULL}};
  char *word=NULL;

  switch (signalNumber)
  {
    case SIGBUS:  word=getStringResource(topShell, "BusError");
                  break;
    case SIGFPE:  word=getStringResource(topShell, "FloatingPointException");
                  break;
    case SIGSEGV: word=getStringResource(topShell, "SegmentationViolation");
                  break;
  }
  messgb(topShell, 3, word, buttons, 1);
  exit(-1);                                                             
}

void installColormap(void)
{
  int status;
  Window windows[1], *windowsReturn, *windowList;
  int countReturn, i;

  status=XGetWMColormapWindows(XtDisplay(topShell), XtWindow(topShell),
                               &windowsReturn, &countReturn);
  if(!status)
  {
    windows[0]=XtWindow(topShell);
    XSetWMColormapWindows(XtDisplay(topShell),XtWindow(topShell),windows,1);
  }

      /* there was a property, add myself to the beginning */
  else
  {
    windowList=(Window *)XtMalloc((sizeof(Window))*(countReturn+1));
    windowList[0]=XtWindow(topShell);
    for(i=0; i<countReturn; i++)
      windowList[i+1]=windowsReturn[i];
    XSetWMColormapWindows(XtDisplay(topShell),XtWindow(topShell),windowList,countReturn+1);
    XtFree((char*)windowList);
    XtFree((char*)windowsReturn);
  }
}
