// ERRUTIL.CPP

// Copyright (C) 2000 Geoff Hutchison

// This program is free software; you can redistribute it and/or modify it
// under the terms of the license (GNU GPL) which comes with this package.

/*################################################################################################*/

#include "errutil.h"

#include <fstream>
#include <iostream>
using namespace std;

/*################################################################################################*/

// Constructor -- shouldn't need to do anything
console_err_util::console_err_util(void) : err_util()
{
}

// Destructor --shouldn't need to do anything
console_err_util::~console_err_util(void)
{
}

// Print the message and wait for a yes/no response
// Requires: message
// Provides: boolean of user response
bool console_err_util::Question(const char * msg)
{
	cout << msg << endl;
	
	char response; cin >> response;
	
	if (response == 'Y' || response == 'y') return true;
	else return false;
}

// Print the message (no problems)
// Requires: message
// Provides: nothing
void console_err_util::Message(const char *msg)
{
	cout << msg << endl;
}

// Print the message (lower severity)
// Requires: message
// Provides: nothing
void console_err_util::WarningMessage(const char *msg)
{
	cout << msg << endl;
}

// Print the message (higher severity)
// Requires: message
// Provides: nothing
void console_err_util::ErrorMessage(const char *msg)
{
	cout << msg << endl;
}

/*################################################################################################*/

// eof
