// INTERFACE.H : here we define some common interfaces between different models.

// Copyright (C) 2001 Tommi Hassinen.

// This program is free software; you can redistribute it and/or modify it
// under the terms of the license (GNU GPL) which comes with this package.

////////////////////////////////////////////////////////////////////////////////////////////////////

#ifndef INTERFACE_H
#define INTERFACE_H

class all_atoms_interface;
class trajectory_interface;

#include "typedef.h"

#include <fstream>
using namespace std;

////////////////////////////////////////////////////////////////////////////////////////////////////

class all_atoms_interface
{
	protected:
	
// this is just an interface definition -> there is no relevant common data?!?!?
// this is just an interface definition -> there is no relevant common data?!?!?
// this is just an interface definition -> there is no relevant common data?!?!?

	public:
	
	all_atoms_interface(void);
	virtual ~all_atoms_interface(void);
	
	// add_atom() ???
	// remove_atom() ???
	// etc...
};

////////////////////////////////////////////////////////////////////////////////////////////////////

class trajectory_interface
{
	protected:
	
	ifstream * trajfile;
	
	i32s total_traj_frames;
	i32s current_traj_frame;
	
	public:
	
	trajectory_interface(void);
	virtual ~trajectory_interface(void);
	
	i32s GetTotalFrames(void);
	ifstream * GetTrajectoryFile(void);
	
	i32s GetCurrentFrame(void);
	void SetCurrentFrame(i32s);
	
	virtual void OpenTrajectory(const char *) = 0;
	virtual void CloseTrajectory(void) = 0;
	
	virtual void ReadFrame(void) = 0;
};

////////////////////////////////////////////////////////////////////////////////////////////////////

#endif	// INTERFACE_H

// eof
