// MM1ALG.H : algorithms for mm1-models.

// Copyright (C) 1998 Tommi Hassinen.

// This program is free software; you can redistribute it and/or modify it
// under the terms of the license (GNU GPL) which comes with this package.

/*################################################################################################*/

#include "config.h"	// this is target-dependent...

#ifndef MM1ALG_H
#define MM1ALG_H

class mm1_geomopt;
class mm1_geomopt_param;

class mm1_moldyn;
class mm1_moldyn_param;

#define UPDATEFRQ 25
class mm1_random_search;	// DO WE NEED TO RANDOMIZE THE RANDOM NUMBER GENERATOR SOMEWAY???
class mm1_systematic_search;	// DO WE NEED TO RANDOMIZE THE RANDOM NUMBER GENERATOR SOMEWAY???

/*################################################################################################*/

#include "mm1ic.h"
#include "mm1eng.h"
#include "conjgrad.h"

/*################################################################################################*/

/// A geometry optimization class for MM models.

class mm1_geomopt : public conjugate_gradient
{
	protected:
	
	mm1_eng * eng;
	
	public:
	
	mm1_geomopt(mm1_eng *, i32s, f64);
	~mm1_geomopt(void);
	
	f64 GetValue(void);		// virtual
	f64 GetGradient(void);		// virtual
};

class mm1_geomopt_param
{
//	protected:
	public:		// in TARGET3 we have to access this from a function -> gets complicated. fix later...
	
	bool confirm;
	
	friend class mm1_mdl;
	friend class glut_mm1_docv;
	
	public:
	
	i32s nsteps;
	
	public:
	
	mm1_geomopt_param(void) { confirm = false; }
	~mm1_geomopt_param(void) { }
};

/*################################################################################################*/

/**	A molecular dynamics class for MM models.

	So far very long simulations have not been tested, so possile translation/rotation 
	problems are not solved... current solution is to start simulations from 0 K -> 
	no translation/rotation in the initial state -> conservation of linear and angular 
	momentum -> no need to worry at all... but for how long it will work???
*/

class mm1_moldyn
{
	protected:
	
	mm1_eng * eng;
	
	f64 * vel;
	f64 * acc;
	
	f64 * mass;
	
	f64 temp;
	
	f64 step1; f64 step2;
	f64 kin; f64 pot;
	
	friend class mm1_mdl;
	
	public:
	
	mm1_moldyn(mm1_eng *, f64, f64);
	~mm1_moldyn(void);
	
	/**	This is a "velocity-Verlet"-type integrator...
	
		Allen MP, Tildesley DJ : "##Computer Simulation of Liquids", Clarendon Press, 1987
	*/
	
	void TakeMDStep(void);
	
	f64 KineticEnergy(void);
	
	f64 ConvTempEKin(f64);
	f64 ConvEKinTemp(f64);
	
	void SetEKin(f64);
};

class mm1_moldyn_param
{
//	protected:
	public:		// in TARGET3 we have to access this from a function -> gets complicated. fix later...
	
	bool confirm;
	
	friend class mm1_mdl;
	friend class glut_mm1_docv;
	
	public:
	
	i32s nsteps;
	f64 temperature;
	f64 timestep;
	
	char filename[256];
	
	public:
	
	mm1_moldyn_param(void) { confirm = false; }
	~mm1_moldyn_param(void) { }
};

/*################################################################################################*/

/// A random conformational search (intcrd based).

class mm1_random_search
{
	protected:
	
	mm1_mdl * mdl; i32s molnum;
	i32s in_crdset; i32s out_crdset;
	
	i32s cycles;
	i32s optsteps;
	
	mm1_intcrd * ic;
	
	mm1_eng * eng;
	mm1_geomopt * go;
	
	i32s counter1;
	i32s counter2;
	
	f64 min_energy;
	
	public:
	
	mm1_random_search(mm1_mdl *, i32s, i32s, i32s, i32s, i32s);
	~mm1_random_search(void);
	
	// the search is split in small steps to make it "look nice" in graphic environment.
	// you should just keep callig TakeStep() until it returns a negative value...
	
	i32s TakeStep(void);
};

/*################################################################################################*/

/// A systematic conformational search (intcrd based).

class mm1_systematic_search
{
	protected:

	mm1_mdl * mdl; i32s molnum;
	i32s in_crdset; i32s out_crdset;
	
	i32s divisions;
	i32s optsteps;
	
	public:
	
	mm1_systematic_search(mm1_mdl *, i32s, i32s, i32s, i32s, i32s);
	~mm1_systematic_search(void);
	
	// the search is split in small steps to make it "look nice" in graphic environment.
	// you should just keep callig TakeStep() until it returns a negative value...
	
	i32s TakeStep(void);
};

/*################################################################################################*/

#endif	// MM1ALG_H

// eof
