// MM1ENG.H : calculations for "all atoms"-models (molecular mechanics).

// Copyright (C) 1998 Tommi Hassinen.

// This program is free software; you can redistribute it and/or modify it
// under the terms of the license (GNU GPL) which comes with this package.

/*################################################################################################*/

#include "config.h"	// this is target-dependent...

#ifndef MM1ENG_H
#define MM1ENG_H

struct mm1_bt1_data;
struct mm1_bt2_data;

class mm1_eng;
class mm1_eng_pbc;

/*################################################################################################*/

#include "engine.h"
#include "mm1mdl.h"

#include <vector>
using namespace std;

/*################################################################################################*/

struct mm1_bt1_data
{
	f64 len;
	f64 dlen[2][3];
};

struct mm1_bt2_data
{
	f64 csa;
	f64 dcsa[3][3];
};

void CopyCRD(mm1_mdl *, mm1_eng *, i32u);
void CopyCRD(mm1_eng *, mm1_mdl *, i32u);

/*################################################################################################*/

/// A base engine class for mm1_mdl.

class mm1_eng : public engine
{
	private:
	
	mm1_mdl & mdl;
	
	protected:
	
	i32s natm;
	i32s np; i32s pid;
	
	mm1_atom ** index;
	
	vector<i32s> cr1; i32s * range_cr1;
	vector<i32s> cr2; i32s * range_cr2;
	
	f64_a3 * crd; f64_a3 * d1;
	
	public:		// why public!?!?!!?
	
	f64 energy;
	f64 energy_bt1;
	f64 energy_bt2;
	f64 energy_bt3;
	f64 energy_nbt1;
	
	public:
	
	friend void CopyCRD(mm1_mdl *, mm1_eng *, i32u);
	friend void CopyCRD(mm1_eng *, mm1_mdl *, i32u);
	
	mm1_eng(mm1_mdl &, i32s, i32s);
	virtual ~mm1_eng(void);
	
	mm1_mdl * GetModel(void) { return & mdl; }
	
	void Compute(i32s);		// virtual
	void Check(i32s);		// virtual
	
	f64 GetGradientVectorLength(void);	// virtual
	
	private:
	
	void SearchCR1a(iter_mm1al);
	void SearchCR1b(iter_mm1cl, mm1_atom *);
	void SearchCR2(iter_mm1cl, mm1_atom *);
	
	protected:
	
	virtual void ComputeBT1(i32s) = 0;
	virtual void ComputeBT2(i32s) = 0;
	virtual void ComputeBT3(i32s) = 0;
	
	virtual void ComputeNBT1(i32s) = 0;
	
	public:
	
	friend class exp1_tables;
	friend class exp9_tables;
	friend class prmfit_tables;	// for target1 / parameter fitting only...
	
	friend class mm1_geomopt;
	friend class mm1_moldyn;
};

/*################################################################################################*/

/// A base periodic engine class for mm1_mdl.

class mm1_eng_pbc : virtual public mm1_eng
{
	protected:
	
	i32s nmol;
	i32s * mrange;
	
	public:
	
	mm1_eng_pbc(mm1_mdl &, i32s, i32s);
	virtual ~mm1_eng_pbc(void);
	
	/**	This will check that molecules have not escaped from the periodic box. 
		If we doing geometry optimization or molecular dynamics for periodic models, 
		we should remember to call this at suitable intervals...
	*/
	
	void CheckLocations(void);
};

/*################################################################################################*/

#endif	// MM1ENG_H

// eof
