// MM1ENG9.CPP

// Copyright (C) 1998 Tommi Hassinen.

// This program is free software; you can redistribute it and/or modify it
// under the terms of the license (GNU GPL) which comes with this package.

/*################################################################################################*/

#include "mm1eng9.h"
#include "mm1tab9.h"

#include <algorithm>
using namespace std;

/*################################################################################################*/

mm1_eng_exp9::mm1_eng_exp9(mm1_mdl & p1, i32s p2, i32s p3) : mm1_eng(p1, p2, p3)
{
	exp9_tables::GetInstance()->UpdateTypes(GetModel());
	
/*##############################################*/
/*##############################################*/
	
	// create bt1-terms...
	
	if (GetModel()->ostr != NULL) (* GetModel()->ostr) << "creating bt1-terms: ";
	i32s bt1_err = 0;
	
	for (iter_mm1bl it1 = GetModel()->GetBondsBegin();it1 != GetModel()->GetBondsEnd();it1++)
	{
		mm1_exp9_bt1 newbt1;
		newbt1.atmi[0] = (* it1).atmr[0]->index;
		newbt1.atmi[1] = (* it1).atmr[1]->index;
		
		i32s bt = (* it1).bt.GetValue();
		
		(* it1).index = bt1_vector.size();	// the bond objects are modified here!!!!!
		
		bt1_err += !exp9_tables::GetInstance()->Init(this, & newbt1, bt);
		bt1_vector.push_back(newbt1);
	}
	
	if (GetModel()->ostr != NULL)
	{
		(* GetModel()->ostr) << bt1_vector.size() << " terms, ";
		(* GetModel()->ostr) << bt1_err << " errors." << endl;
	}
	
	bt1data = new mm1_bt1_data[bt1_vector.size()];
	
/*##############################################*/
/*##############################################*/
	
	// create bt2-terms...
	
	if (GetModel()->ostr != NULL) (* GetModel()->ostr) << "creating bt2-terms: ";
	i32s bt2_err = 0;
	
	for (iter_mm1al it1 = GetModel()->GetAtomsBegin();it1 != GetModel()->GetAtomsEnd();it1++)
	{
		if ((* it1).cr_list.size() < 2) continue;
		
		// central atom is known, now find all possible combinations of bonds...
		
		bool dir[2];
		iter_mm1cl ita; iter_mm1cl rnga[2];
		iter_mm1cl itb; iter_mm1cl rngb[2];
		
		rngb[1] = (* it1).cr_list.end();
		
		rnga[0] = (* it1).cr_list.begin();
		rnga[1] = rngb[1]; rnga[1]--;
		
		for (ita = rnga[0];ita != rnga[1];ita++)
		{
			rngb[0] = ita; rngb[0]++;
			dir[0] = (& (* it1) == (* ita).bndr->atmr[0]);
			
			for (itb = rngb[0];itb != rngb[1];itb++)
			{
				dir[1] = (& (* it1) == (* itb).bndr->atmr[0]);
				
				mm1_exp9_bt2 newbt2;
				newbt2.index1[0] = (* ita).bndr->index; newbt2.dir1[0] = dir[0];
				newbt2.index1[1] = (* itb).bndr->index; newbt2.dir1[1] = dir[1];
				
				newbt2.atmi[0] = bt1_vector[(* ita).bndr->index].get_atmi(1, dir[0]);
				newbt2.atmi[2] = bt1_vector[(* itb).bndr->index].get_atmi(1, dir[1]);
				
				newbt2.atmi[1] = bt1_vector[(* ita).bndr->index].get_atmi(0, dir[0]);
				
				i32s bt[2];
				bt[0] = (* ita).bndr->bt.GetValue();
				bt[1] = (* itb).bndr->bt.GetValue();
				
				bt2_err += !exp9_tables::GetInstance()->Init(this, & newbt2, bt);
				bt2_vector.push_back(newbt2);
			}
		}
	}
	
	if (GetModel()->ostr != NULL)
	{
		(* GetModel()->ostr) << bt2_vector.size() << " terms, ";
		(* GetModel()->ostr) << bt2_err << " errors." << endl;
	}
	
	bt2data = new mm1_bt2_data[bt2_vector.size()];
	
/*##############################################*/
/*##############################################*/
	
	// create bt3-terms...

	if (GetModel()->ostr != NULL) (* GetModel()->ostr) << "creating bt3-terms: ";
	i32s bt3_err = 0;
	
	for (iter_mm1al it1 = GetModel()->GetAtomsBegin();it1 != GetModel()->GetAtomsEnd();it1++)
	{
		if ((* it1).cr_list.size() < 2) continue;
		
		for (iter_mm1cl it2 = (* it1).cr_list.begin();it2 != (* it1).cr_list.end();it2++)
		{
			bool another = (& (* it1) == (* it2).bndr->atmr[0]);
			mm1_atom * atmr = (* it2).bndr->atmr[another];
			
			if (atmr->cr_list.size() < 2) continue;
			if (atmr->index > (* it1).index) continue;
			
			// central atoms are known, now find all possible combinations of bonds...
			
			vector<i32s> ind1a; vector<bool> dir1a;		// search for the 1st group...
			for (iter_mm1cl it3 = (* it1).cr_list.begin();it3 != (* it1).cr_list.end();it3++)
			{
				if ((* it3) == (* it2)) continue;
				
				ind1a.push_back((* it3).bndr->index);
				dir1a.push_back(& (* it1) == (* it3).bndr->atmr[0]);
			}
			
			vector<i32s> ind2a; vector<bool> dir2a;
			for (i32u n1 = 0;n1 < ind1a.size();n1++)
			{
				i32s tmp1 = 0; i32s tmp2 = NOT_DEFINED;
				while (true)
				{
					i32s bt1[2] = { bt2_vector[tmp1].index1[0], bt2_vector[tmp1].index1[1] };
					i32s bt2[2] = { bt2_vector[tmp1].dir1[0], bt2_vector[tmp1].dir1[1] };
					
					if (bt1[0] == ind1a[n1] && bt2[0] == dir1a[n1] && bt1[1] == (* it2).bndr->index && bt2[1] == another) tmp2 = true;
					if (bt1[1] == ind1a[n1] && bt2[1] == dir1a[n1] && bt1[0] == (* it2).bndr->index && bt2[0] == another) tmp2 = false;
					if (tmp2 < 0) tmp1++; else break;
				}
				
				ind2a.push_back(tmp1);
				dir2a.push_back(tmp2);
			}
			
			vector<i32s> ind1b; vector<bool> dir1b;		// search for the 2nd group...
			for (iter_mm1cl it3 = atmr->cr_list.begin();it3 != atmr->cr_list.end();it3++)
			{
				if ((* it3) == (* it2)) continue;
				
				ind1b.push_back((* it3).bndr->index);
				dir1b.push_back(atmr == (* it3).bndr->atmr[0]);
			}
			
			vector<i32s> ind2b; vector<bool> dir2b;
			for (i32u n1 = 0;n1 < ind1b.size();n1++)
			{
				i32s tmp1 = 0; i32s tmp2 = NOT_DEFINED;
				while (true)
				{
					i32s bt1[2] = { bt2_vector[tmp1].index1[0], bt2_vector[tmp1].index1[1] };
					i32s bt2[2] = { bt2_vector[tmp1].dir1[0], bt2_vector[tmp1].dir1[1] };
					
					if (bt1[0] == ind1b[n1] && bt2[0] == dir1b[n1] && bt1[1] == (* it2).bndr->index && bt2[1] != another) tmp2 = false;
					if (bt1[1] == ind1b[n1] && bt2[1] == dir1b[n1] && bt1[0] == (* it2).bndr->index && bt2[0] != another) tmp2 = true;
					if (tmp2 < 0) tmp1++; else break;
				}
				
				ind2b.push_back(tmp1);
				dir2b.push_back(tmp2);
			}
			
			// now finally create the terms!!!!!
			
			for (i32u n1 = 0;n1 < ind2a.size();n1++)
			{
				for (i32u n2 = 0;n2 < ind2b.size();n2++)
				{
					mm1_exp9_bt3 newbt3;
					newbt3.index2[0] = ind2a[n1];
					newbt3.index2[1] = ind2b[n2];
					
					newbt3.index1[0] = bt2_vector[newbt3.index2[0]].get_index(0, dir2a[n1]);
					newbt3.dir1[0] = bt2_vector[newbt3.index2[0]].get_dir(0, dir2a[n1]);
					
					newbt3.index1[1] = bt2_vector[newbt3.index2[0]].get_index(1, dir2a[n1]);
					newbt3.dir1[1] = bt2_vector[newbt3.index2[0]].get_dir(1, dir2a[n1]);
					
					newbt3.index1[2] = bt2_vector[newbt3.index2[1]].get_index(0, dir2b[n2]);
					newbt3.dir1[2] = bt2_vector[newbt3.index2[1]].get_dir(0, dir2b[n2]);
					
					newbt3.index1[3] = bt2_vector[newbt3.index2[1]].get_index(1, dir2b[n2]);
					newbt3.dir1[3] = bt2_vector[newbt3.index2[1]].get_dir(1, dir2b[n2]);
					
					newbt3.atmi[0] = bt1_vector[newbt3.index1[0]].get_atmi(1, newbt3.dir1[0]);
					newbt3.atmi[1] = bt1_vector[newbt3.index1[0]].get_atmi(0, newbt3.dir1[0]);
					newbt3.atmi[2] = bt1_vector[newbt3.index1[3]].get_atmi(0, newbt3.dir1[3]);
					newbt3.atmi[3] = bt1_vector[newbt3.index1[3]].get_atmi(1, newbt3.dir1[3]);
					
					// easiest way to get bondtypes is to find the bonds...
					// easiest way to get bondtypes is to find the bonds...
					// easiest way to get bondtypes is to find the bonds...
					
	mm1_bond tmpb1 = mm1_bond(index[newbt3.atmi[0]], index[newbt3.atmi[1]], bondtype());
	iter_mm1bl itb1 = find(GetModel()->GetBondsBegin(), GetModel()->GetBondsEnd(), tmpb1);
	
	mm1_bond tmpb2 = mm1_bond(index[newbt3.atmi[1]], index[newbt3.atmi[2]], bondtype());
	iter_mm1bl itb2 = find(GetModel()->GetBondsBegin(), GetModel()->GetBondsEnd(), tmpb2);
	
	mm1_bond tmpb3 = mm1_bond(index[newbt3.atmi[2]], index[newbt3.atmi[3]], bondtype());
	iter_mm1bl itb3 = find(GetModel()->GetBondsBegin(), GetModel()->GetBondsEnd(), tmpb3);
	
					i32s bt[3];
					bt[0] = (* itb1).bt.GetValue();
					bt[1] = (* itb2).bt.GetValue();
					bt[2] = (* itb3).bt.GetValue();
					
	bt3_err += !exp9_tables::GetInstance()->Init(this, & newbt3, bt);
	if (newbt3.k == 0.0) continue;		// these have bad optimal geometries -> SKIP!!!
	
					bt3_vector.push_back(newbt3);
				}
			}
		}
	}
	
	if (GetModel()->ostr != NULL)
	{
		(* GetModel()->ostr) << bt3_vector.size() << " terms, ";
		(* GetModel()->ostr) << bt3_err << " errors." << endl;
	}
	
/*##############################################*/
/*##############################################*/

	// this is temporary arrangement...
	// this is temporary arrangement...
	// this is temporary arrangement...
	
	for (i32s n1 = 0;n1 < natm;n1++) index[n1]->charge = 0.0;
	
	if (GetModel()->ostr != NULL) (* GetModel()->ostr) << "setting up partial charges..." << endl;
	for (iter_mm1bl it1 = GetModel()->GetBondsBegin();it1 != GetModel()->GetBondsEnd();it1++)
	{
		f64 delta = exp9_tables::GetInstance()->GetChargeInc(& (* it1), GetModel()->ostr);
		(* it1).atmr[0]->charge -= delta; (* it1).atmr[1]->charge += delta;
	}
	
	// this is temporary arrangement...
	// this is temporary arrangement...
	// this is temporary arrangement...
	
	if (GetModel()->ostr != NULL) (* GetModel()->ostr) << "creating nbt1-terms: ";
	i32s nbt1_err = 0;
	
	for (i32s ind1 = 0;ind1 < natm - 1;ind1++)
	{
		for (i32s ind2 = ind1 + 1;ind2 < natm;ind2++)
		{
			i32s test = range_cr1[ind1];
			while (test < range_cr1[ind1 + 1])
			{
				if (cr1[test] == ind2) break;
				else test++;
			}
			
			if (test == range_cr1[ind1 + 1])
			{
				test = range_cr1[ind1];
				while (test < range_cr2[ind1 + 1])
				{
					if (cr2[test] == ind2) break;
					else test++;
				}
				
				bool is14 = (test != range_cr2[ind1 + 1]);
				
				mm1_exp9_nbt1 newnbt1;
				newnbt1.atmi[0] = ind1;
				newnbt1.atmi[1] = ind2;
				
				nbt1_err += !exp9_tables::GetInstance()->Init(this, & newnbt1, is14);
				nbt1_vector.push_back(newnbt1);
			}
		}
	}
	
	if (GetModel()->ostr != NULL)
	{
		(* GetModel()->ostr) << nbt1_vector.size() << " terms, ";
		(* GetModel()->ostr) << nbt1_err << " errors." << endl;
	}
	
/*##############################################*/
/*##############################################*/

	// report possible errors... THIS IS NOT GOOD IN TARGET3 -> let the GUI handle this!!!
	
	i32s total_err = bt1_err + bt2_err + bt3_err;
	if (total_err)
	{
		cout << "there were total of " << total_err << " errors in the bonded-terms." << endl;
		cout << endl;
		cout << "topology of the system is either incorrect or outside the scope of the" << endl;
		cout << "force field parametrization. some lower-quality default parameters must" << endl;
		cout << "be used, and if problems are severe enough the computation may fail." << endl;
		cout << endl;
		cout << "answer Q to quit or any other character to go on ??? ";
		
		char eee; cin >> eee;
		if (eee == 'q' || eee == 'Q') exit(EXIT_FAILURE);
	}
	
	// load-balancing?!?!?!
	// load-balancing?!?!?!
	// load-balancing?!?!?!

	bt1_range[0] = 0; bt1_range[1] = bt1_vector.size();
	bt2_range[0] = 0; bt2_range[1] = bt2_vector.size();
	bt3_range[0] = 0; bt3_range[1] = bt3_vector.size();
	
	nbt1_range[0] = 0; nbt1_range[1] = nbt1_vector.size();
}

mm1_eng_exp9::~mm1_eng_exp9(void)
{
	delete[] bt1data;
	delete[] bt2data;
}

void mm1_eng_exp9::ComputeBT1(i32s p1)
{
	energy_bt1 = 0.0;
	
	// len -> length of the bond vector, in nanometers [nm].
	
	// the bond is a vector, since it has unique begin and end points.
	// if a bond vector needs to be reversed, it's begin and end points are swapped.
	// all data for both forward and reverse vectors are calculated and stored...
	
	// dlen[0] -> grad[0-2]: for atom 1 when direction = 0, for atom 0 when direction = 1
	// dlen[1] -> grad[0-2]: for atom 0 when direction = 0, for atom 1 when direction = 1
	
	// the end point gradient of a vector is always the same as components of the unit vector!!!
	
	for (i32s n1 = bt1_range[0];n1 < bt1_range[1];n1++)
	{
		i32s * atmi = bt1_vector[n1].atmi;
		
		f64 t1a[3]; f64 t1b = 0.0;
		for (i32s n2 = 0;n2 < 3;n2++)
		{
			f64 t9a = crd[atmi[0]][n2];
			f64 t9b = crd[atmi[1]][n2];
			
			t1a[n2] = t9a - t9b;
			t1b += t1a[n2] * t1a[n2];
		}
		
		f64 t1c = sqrt(t1b);
		bt1data[n1].len = t1c;
		for (i32s n2 = 0;n2 < 3;n2++)
		{
			f64 t9a = t1a[n2] / t1c;
			
			bt1data[n1].dlen[0][n2] = +t9a;
			bt1data[n1].dlen[1][n2] = -t9a;
		}
		
		// f = a(x-b)^2
		// df/dx = 2a(x-b)
		
		f64 t2a = t1c - bt1_vector[n1].opt;
		f64 t2b = bt1_vector[n1].fc * t2a * t2a;
		
		energy_bt1 += t2b;
		
		if (p1 > 0)
		{
			f64 t2c = 2.0 * bt1_vector[n1].fc * t2a;
			
			for (i32s n2 = 0;n2 < 3;n2++)
			{
				f64 t2d = bt1data[n1].dlen[0][n2] * t2c;
				
				d1[atmi[0]][n2] += t2d;
				d1[atmi[1]][n2] -= t2d;
			}
		}
	}
}

void mm1_eng_exp9::ComputeBT2(i32s p1)
{
	energy_bt2 = 0.0;
	
	// ang -> cosine of the bond angle, in the usual range [-1.0, +1.0]
	
	// we need directions also here... the angle consists of three points, say A-B-C.
	// when we reverse the angle, we will swap the end points: now they will be C-B-A.
	
	// dang[0] -> grad[0-2]: for atom 2 when direction = 0, for atom 0 when direction = 1
	// dang[1] -> grad[0-2]: for atom 1 when direction = 0, for atom 1 when direction = 1
	// dang[2] -> grad[0-2]: for atom 0 when direction = 0, for atom 2 when direction = 1
	
	for (i32s n1 = bt2_range[0];n1 < bt2_range[1];n1++)
	{
		i32s * atmi = bt2_vector[n1].atmi;
		
		i32s * index1 = bt2_vector[n1].index1;
		bool * dir1 = bt2_vector[n1].dir1;
		
		f64 * t1a = bt1data[index1[0]].dlen[dir1[0]];
		f64 * t1b = bt1data[index1[1]].dlen[dir1[1]];
		
		f64 t1c = t1a[0] * t1b[0] + t1a[1] * t1b[1] + t1a[2] * t1b[2];
		
		if (t1c < -1.0) t1c = -1.0;		// domain check...
		if (t1c > +1.0) t1c = +1.0;		// domain check...
		
		bt2data[n1].csa = t1c;
		
		for (i32s n2 = 0;n2 < 3;n2++)
		{
			f64 t9a = (t1b[n2] - t1c * t1a[n2]) / bt1data[index1[0]].len;
			f64 t9b = (t1a[n2] - t1c * t1b[n2]) / bt1data[index1[1]].len;
			
			bt2data[n1].dcsa[0][n2] = t9a;
			bt2data[n1].dcsa[1][n2] = -(t9a + t9b);
			bt2data[n1].dcsa[2][n2] = t9b;
		}
		
		f64 t2a;	// df/dx
		
		if (bt2_vector[n1].opt > M_PI * 170.0 / 180.0)
		{
			// f = a(1 + x)
			// df/dx = a
			
			f64 t3b = 1.0 * bt2_vector[n1].fc;	// CHECK THE VALUE!!!
			energy_bt2 += t3b * (1.0 + t1c);
			
			t2a = t3b;
		}
		else
		{
			// f = a(acos(x)-b)^2
			// df/dx = -2a(x-b)/sqrt(1-x*x)
			
			f64 t3b = acos(t1c) - bt2_vector[n1].opt;
			f64 t3c = bt2_vector[n1].fc * t3b * t3b;
			
			energy_bt2 += t3c;
			
			t2a = -2.0 * bt2_vector[n1].fc * t3b / sqrt(1.0 - t1c * t1c);
		}
		
		if (p1 > 0)
		{
			for (i32s n2 = 0;n2 < 3;n2++)
			{
				d1[atmi[0]][n2] += bt2data[n1].dcsa[0][n2] * t2a;
				d1[atmi[1]][n2] += bt2data[n1].dcsa[1][n2] * t2a;
				d1[atmi[2]][n2] += bt2data[n1].dcsa[2][n2] * t2a;
			}
		}
	}
}

void mm1_eng_exp9::ComputeBT3(i32s p1)
{
	energy_bt3 = 0.0;
	
	for (i32s n1 = bt3_range[0];n1 < bt3_range[1];n1++)
	{
		i32s * atmi = bt3_vector[n1].atmi;
		
		i32s * index2 = bt3_vector[n1].index2;
		i32s * index1 = bt3_vector[n1].index1;
		bool * dir1 = bt3_vector[n1].dir1;
		
		f64 t1a[2] = { bt2data[index2[0]].csa, bt2data[index2[1]].csa };
		f64 t1b[2] = { 1.0 - t1a[0] * t1a[0], 1.0 - t1a[1] * t1a[1] };
		
		f64 t1c[2][3];
		t1c[0][0] = bt1data[index1[0]].dlen[dir1[0]][0] - t1a[0] * bt1data[index1[1]].dlen[dir1[1]][0];
		t1c[0][1] = bt1data[index1[0]].dlen[dir1[0]][1] - t1a[0] * bt1data[index1[1]].dlen[dir1[1]][1];
		t1c[0][2] = bt1data[index1[0]].dlen[dir1[0]][2] - t1a[0] * bt1data[index1[1]].dlen[dir1[1]][2];
		t1c[1][0] = bt1data[index1[3]].dlen[dir1[3]][0] - t1a[1] * bt1data[index1[2]].dlen[dir1[2]][0];
		t1c[1][1] = bt1data[index1[3]].dlen[dir1[3]][1] - t1a[1] * bt1data[index1[2]].dlen[dir1[2]][1];
		t1c[1][2] = bt1data[index1[3]].dlen[dir1[3]][2] - t1a[1] * bt1data[index1[2]].dlen[dir1[2]][2];
		
		f64 t1d = t1c[0][0] * t1c[1][0] + t1c[0][1] * t1c[1][1] + t1c[0][2] * t1c[1][2];
		f64 t1e = t1d / sqrt(t1b[0] * t1b[1]);
		
		if (t1e < -1.0) t1e = -1.0;		// domain check...
		if (t1e > +1.0) t1e = +1.0;		// domain check...
		
		f64 t1f[3];
		t1f[0] = acos(t1e);
		
		// now we still have to determine the sign of the result...
		// now we still have to determine the sign of the result...
		// now we still have to determine the sign of the result...
		
		f64 t1g[3];
		t1g[0] = bt1data[index1[2]].dlen[dir1[2]][1] * bt1data[index1[3]].dlen[dir1[3]][2] - bt1data[index1[2]].dlen[dir1[2]][2] * bt1data[index1[3]].dlen[dir1[3]][1];
		t1g[1] = bt1data[index1[2]].dlen[dir1[2]][2] * bt1data[index1[3]].dlen[dir1[3]][0] - bt1data[index1[2]].dlen[dir1[2]][0] * bt1data[index1[3]].dlen[dir1[3]][2];
		t1g[2] = bt1data[index1[2]].dlen[dir1[2]][0] * bt1data[index1[3]].dlen[dir1[3]][1] - bt1data[index1[2]].dlen[dir1[2]][1] * bt1data[index1[3]].dlen[dir1[3]][0];
		
		f64 t1h = t1c[0][0] * t1g[0] + t1c[0][1] * t1g[1] + t1c[0][2] * t1g[2];
		if (t1h < 0.0) t1f[0] = -t1f[0];
		
		t1f[1] = t1f[0] + t1f[0];
		t1f[2] = t1f[1] + t1f[0];
		
		// f = a(1+cos(x))+b(1-cos(2x))+c(1+cos(3x))
		// df/dx = -a*sin(x)+2b*sin(2x)-3c*sin(3x)
		
		// here we make a quick conversion into a fourier series...
		// here we make a quick conversion into a fourier series...
		// here we make a quick conversion into a fourier series...
		
		f64 fc[3] = { 0.0, 0.0, 0.0 }; i32s zzz1 = (i32s) bt3_vector[n1].s;
		i32u zzz2 = abs(zzz1); if (zzz2 < 1) zzz2 = 1; zzz2 -= 1; if (zzz2 == 1) zzz1 = -zzz1;
		fc[zzz2] = bt3_vector[n1].k; if (zzz1 < 0) fc[zzz2] = -fc[zzz2];
		
		f64 t8a = fc[0] * (1.0 + cos(t1f[0]));
		f64 t8b = fc[1] * (1.0 - cos(t1f[1]));
		f64 t8c = fc[2] * (1.0 + cos(t1f[2]));
		f64 t8d = t8a + t8b + t8c;
		
		energy_bt3 += t8d;
		
		if (p1 > 0)
		{
			f64 t9a = fc[0] * sin(t1f[0]);
			f64 t9b = fc[1] * sin(t1f[1]) * 2.0;
			f64 t9c = fc[2] * sin(t1f[2]) * 3.0;
			f64 t9d = t9b - (t9a + t9c);
			
			f64 t2a = bt1data[index1[0]].len * t1b[0];
			f64 t2b = bt1data[index1[0]].len * t1a[0] / bt1data[index1[1]].len;
			
			f64 t3a = bt1data[index1[3]].len * t1b[1];
			f64 t3b = bt1data[index1[3]].len * t1a[1] / bt1data[index1[2]].len;
			
			f64 t4c[3]; f64 t5c[3]; f64 t6a[3]; f64 t7a[3];
			const i32s cp[3][3] = { { 0, 1, 2 }, { 1, 2, 0 }, { 2, 0, 1 } };
			
			for (i32s n2 = 0;n2 < 3;n2++)
			{
				f64 t4a = bt1data[index1[0]].dlen[dir1[0]][cp[n2][1]] * bt1data[index1[1]].dlen[dir1[1]][cp[n2][2]];
				f64 t4b = bt1data[index1[0]].dlen[dir1[0]][cp[n2][2]] * bt1data[index1[1]].dlen[dir1[1]][cp[n2][1]];
				t4c[n2] = (t4a - t4b) / t2a;
				
				f64 t5a = bt1data[index1[2]].dlen[dir1[2]][cp[n2][2]] * bt1data[index1[3]].dlen[dir1[3]][cp[n2][1]];
				f64 t5b = bt1data[index1[2]].dlen[dir1[2]][cp[n2][1]] * bt1data[index1[3]].dlen[dir1[3]][cp[n2][2]];
				t5c[n2] = (t5a - t5b) / t3a;
				
				d1[atmi[0]][n2] += t4c[n2] * t9d;
				d1[atmi[3]][n2] += t5c[n2] * t9d;
				
				t6a[n2] = (t2b - 1.0) * t4c[n2] - t3b * t5c[n2];
				t7a[n2] = (t3b - 1.0) * t5c[n2] - t2b * t4c[n2];
				
				d1[atmi[1]][n2] += t6a[n2] * t9d;
				d1[atmi[2]][n2] += t7a[n2] * t9d;
			}
		}
	}
}

void mm1_eng_exp9::ComputeNBT1(i32s p1)
{
	energy_nbt1 = 0.0;
	
	for (i32s n1 = nbt1_range[0];n1 < nbt1_range[1];n1++)
	{
		i32s * atmi = nbt1_vector[n1].atmi;
		
		f64 t1a[3]; f64 t1b = 0.0;
		for (i32s n2 = 0;n2 < 3;n2++)
		{
			f64 t2a = crd[atmi[0]][n2];
			f64 t2b = crd[atmi[1]][n2];
			
			t1a[n2] = t2a - t2b;
			t1b += t1a[n2] * t1a[n2];
		}
		
		f64 t1c = sqrt(t1b);
		
		// f1 = (r/a)^-12 - (r/b)^-6
		// df1/dr = -12/a(r/a)^-13 + 6/b(r/b)^-7
		
		f64 t3a = t1c / nbt1_vector[n1].k1;
		f64 t3b = t1c / nbt1_vector[n1].k2;
		
		f64 t4a = t3a * t3a * t3a; f64 t4b = t4a * t4a; f64 t4c = t4b * t4b;	// ^3 ^6 ^12
		f64 t5a = t3b * t3b * t3b; f64 t5b = t5a * t5a;				// ^3 ^6
		
		f64 t6a = 1.0 / (t4c) - 1.0 / (t5b);
		
		// f2 = Q/r
		// df2/dr = -Q/r^2
		
		f64 t6b = nbt1_vector[n1].qq / t1c;
		
		energy_nbt1 += t6a + t6b;
		
		if (p1 > 0)
		{
			f64 t7a = 12.0 / (nbt1_vector[n1].k1 * t4c * t3a);
			f64 t7b = 6.0 / (nbt1_vector[n1].k2 * t5b * t3b);
			
			f64 t8a = nbt1_vector[n1].qq / t1b;
			
			f64 t9a = t7b - t7a - t8a;
			for (i32s n2 = 0;n2 < 3;n2++)
			{
				f64 t9b = (t1a[n2] / t1c) * t9a;
				
				d1[atmi[0]][n2] += t9b;
				d1[atmi[1]][n2] -= t9b;
			}
		}
	}
}

/*################################################################################################*/

// eof
