// MM1ENG9.H : stable Tripos5.2/MMFF94-like force field and computation engine.

// Copyright (C) 1998 Tommi Hassinen.

// This program is free software; you can redistribute it and/or modify it
// under the terms of the license (GNU GPL) which comes with this package.

/*################################################################################################*/

#include "config.h"	// this is target-dependent...

#ifndef MM1ENG9_H
#define MM1ENG9_H

struct mm1_exp9_bt1;		// bond stretching
struct mm1_exp9_bt2;		// angle bending
struct mm1_exp9_bt3;		// torsion

struct mm1_exp9_nbt1;		// nonbonded

class mm1_eng_exp9;

/*################################################################################################*/

class exp9_tables;		// mm1tab9.h

#include "mm1eng.h"

#include <vector>
using namespace std;

/*################################################################################################*/

struct mm1_exp9_bt1
{
	i32s atmi[2];
	
	f64 opt;
	f64 fc;
	
	i32s get_atmi(i32s index, bool dir)
	{
		return atmi[dir ? index : !index];
	}
};

struct mm1_exp9_bt2
{
	i32s atmi[3];
	
	i32s index1[2];
	bool dir1[2];
	
	f64 opt;
	f64 fc;
	
	i32s get_index(i32s index, bool dir)
	{
		return index1[dir ? index : !index];
	}
	
	bool get_dir(i32s index, bool dir)
	{
		return dir1[dir ? index : !index];
	}
};

struct mm1_exp9_bt3
{
	i32s atmi[4];
	
	i32s index2[2];
	i32s index1[4];
	bool dir1[4];
	
	f64 k; f64 s;
};

struct mm1_exp9_nbt1
{
	i32s atmi[2];
	
	float k1; float k2;
	float qq;
};

/*################################################################################################*/

/**	"##STABLE", bonded + nonbonded parts.

	Parameters for this experimental force field come mainly from the Tripos 5.2 
	parameter set. Some extra patameters (like the ones for 4- and 5-membered rings) 
	come from MMFF94 parameters and are only approximate. The system responsible for 
	atomic charges also come from a separate source... THIS FORCEFIELD IS ONLY 
	APPROXIMATE, AND IS FOR NEUTRAL ORGANIC MOLECULES ONLY!!!
	
	Clark M, Cramer III RD, Van Obdenbosch N : "Validation of the General-Purpose Tripos 
	5.2 Force Field", J. Comp. Chem. 10, 982-1012, (1989)
	
	Halgren TA : "Merck Molecular Force Field. I. Basis, Form, Scope, Parameterization, 
	and Performance of MMFF94", J. Comp. Chem. 17, 490-, (1996) [there are many parts in this paper]
	
	Tuzun RE, Noid DW, Sumpter BG : "Efficient computation of potential energy first and 
	second derivatives for molecular dynamics, normal coordinate analysis, and molecular 
	mechanics calculations", Macromol. Theory Simul. 5, 771-778, (1996)
	
	Bekker H, Berendsen HJC, van Gunsteren WF : "Force and virial of Torsional-Angle-Dependent 
	Potentials", J. Comp. Chem. 16, 527-533, (1995)
*/

class mm1_eng_exp9 : public mm1_eng
{
	protected:
	
	mm1_bt1_data * bt1data; mm1_bt2_data * bt2data;
	
	vector<mm1_exp9_bt1> bt1_vector; i32s bt1_range[2];
	vector<mm1_exp9_bt2> bt2_vector; i32s bt2_range[2];
	vector<mm1_exp9_bt3> bt3_vector; i32s bt3_range[2];
	
	vector<mm1_exp9_nbt1> nbt1_vector; i32s nbt1_range[2];
	
	public:
	
	mm1_eng_exp9(mm1_mdl &, i32s, i32s);
	virtual ~mm1_eng_exp9(void);
	
	protected:
	
	void ComputeBT1(i32s);		// virtual
	void ComputeBT2(i32s);		// virtual
	void ComputeBT3(i32s);		// virtual
	
	void ComputeNBT1(i32s);		// virtual
};

/*################################################################################################*/

#endif	// MM1ENG9_H

// eof
