// MM1TAB9.H : tables for the Tripos5.2/MMFF94-like force field.

// Copyright (C) 1998 Tommi Hassinen.

// This program is free software; you can redistribute it and/or modify it
// under the terms of the license (GNU GPL) which comes with this package.

/*################################################################################################*/

#include "config.h"	// this is target-dependent...

#ifndef MM1TAB9_H
#define MM1TAB9_H

class exp9_tables;

/*################################################################################################*/

class mm1_mdl;			// mm1mdl.h
class mm1_typerule;		// mm1util.h

#include "mm1eng9.h"

#include <vector>
using namespace std;

/*################################################################################################*/

struct exp9_at		// atomtype
{
	i32s atomtype;
	mm1_typerule * typerule;
	char * description;
};

struct exp9_bs		// bond stretching
{
	i32s atmtp[2];
	bondtype bndtp;
	f64 param[2];
};

struct exp9_ab		// angle bending
{
	i32s atmtp[3];
	bondtype bndtp[2];
	f64 param[2];
};

struct exp9_tr		// torsion
{
	i32s atmtp[4];
	bondtype bndtp[3];
	f64 k; f64 s;
};

struct exp9_lj		// lennard-jones
{
	i32s type;
	f64 r; f64 k;
};

struct exp9_ci		// charge increment
{
	i32s atmtp[2];
	bondtype bndtp;
	f64 delta;
};

/*################################################################################################*/

/// Parameter tables and initialization for "##STABLE".

class exp9_tables
{
	private:
	
	static exp9_tables * instance;
	
	vector<exp9_at> at_vector;
	
	vector<exp9_bs> bs_vector;
	vector<exp9_ab> ab_vector;
	vector<exp9_tr> tr_vector;
	vector<exp9_lj> lj_vector;
	vector<exp9_ci> ci_vector;
	
	private:
	
	exp9_tables(void);
	
	public:
	
	~exp9_tables(void);
	static exp9_tables * GetInstance(void);
	
	f64 GetChargeInc(mm1_bond *, ostream *);
	
	bool Init(mm1_eng *, mm1_exp9_bt1 *, i32s);
	bool Init(mm1_eng *, mm1_exp9_bt2 *, i32s *);
	bool Init(mm1_eng *, mm1_exp9_bt3 *, i32s *);
	
	bool Init(mm1_eng *, mm1_exp9_nbt1 *, bool);
	
	i32s UpdateTypes(mm1_mdl *);
	void PrintAllTypeRules(ostream &);
};

/*################################################################################################*/

#endif	// MM1TAB9_H

// eof
