// MM2ALG.H : algorithms for mm2-models.

// Copyright (C) 1998 Tommi Hassinen.

// This program is free software; you can redistribute it and/or modify it
// under the terms of the license (GNU GPL) which comes with this package.

/*################################################################################################*/

#include "config.h"	// this is target-dependent...

#ifndef MM2ALG_H
#define MM2ALG_H

class mm2_geomopt;
class mm2_geomopt_param;

class mm2_moldyn;
class mm2_moldyn_param;

/*################################################################################################*/

#include "mm2eng.h"
#include "conjgrad.h"

/*################################################################################################*/

class mm2_geomopt : public conjugate_gradient
{
	protected:
	
	mm2_eng * eng;
	
	public:
	
	mm2_geomopt(mm2_eng *, i32s, f64);
	~mm2_geomopt(void);
	
	f64 GetValue(void);		// virtual
	f64 GetGradient(void);		// virtual
};

class mm2_geomopt_param
{
//	protected:
	public:		// in TARGET3 we have to access this from a function -> gets complicated. fix later...
	
	bool confirm;
	
	friend class mm2_mdl;
	friend class glut_mm2_docv;
	
	public:
	
	i32s nsteps;
	
	public:
	
	mm2_geomopt_param(void) { confirm = false; }
	~mm2_geomopt_param(void) { }
};

/*################################################################################################*/

class mm2_moldyn
{
	protected:
	
	mm2_eng * eng;
	
	f64_a3 * vel;
	f64_a3 * acc;
	
	f64 temp;
	
	f64 step1;
	f64 step2;
	
	f64 kin;
	f64 pot;
	
	friend class mm2_mdl;
//	friend class glut_mm2_docv;
	
	public:
	
	mm2_moldyn(mm2_eng *, f64, f64);
	~mm2_moldyn(void);
	
	f64 GetEKin(void) { return kin; }
	f64 GetEPot(void) { return pot; }
	f64 GetTemp(void) { return temp; }
	
	void TakeMDStep(void);
	
	f64 KineticEnergy(void);
	
	f64 ConvTempEKin(f64);
	f64 ConvEKinTemp(f64);
	
	void SetEKin(f64);
};

class mm2_moldyn_param
{
//	protected:
	public:		// in TARGET3 we have to access this from a function -> gets complicated. fix later...
	
	bool confirm;
	
	friend class mm2_mdl;
	friend class glut_mm2_docv;
	
	public:
	
	i32s nsteps;
	f64 temperature;
	f64 timestep;
	
	char filename[256];
	
	public:
	
	mm2_moldyn_param(void) { confirm = false; }
	~mm2_moldyn_param(void) { }
};

/*################################################################################################*/

#endif	// MM2ALG_H

// eof
