// QM1ALG.CPP

// Copyright (C) 2001 Tommi Hassinen.

// This program is free software; you can redistribute it and/or modify it
// under the terms of the license (GNU GPL) which comes with this package.

/*################################################################################################*/

#include "qm1alg.h"

/*################################################################################################*/

qm1_geomopt::qm1_geomopt(qm1_eng * p1, i32s p2, f64 p3) : conjugate_gradient(p2, p3)
{
	eng = p1;
	
	for (i32u n1 = 0;n1 < eng->GetModel()->atom_list.size();n1++)
	{
		for (i32u n2 = 0;n2 < 3;n2++)
		{
			AddVar(& eng->crd[n1 * 3 + n2], & eng->d1[n1 * 3 + n2]);
		}
	}
}

qm1_geomopt::~qm1_geomopt(void)
{
}

f64 qm1_geomopt::GetValue(void)
{
	eng->Compute(0);	// request energy
	return eng->energy;
}

f64 qm1_geomopt::GetGradient(void)
{
	eng->Compute(1);	// request energy and gradient
	return eng->energy;
}

/*################################################################################################*/

// eof
