// QM1ALG.H : algorithms for qm1-models.

// Copyright (C) 2001 Tommi Hassinen.

// This program is free software; you can redistribute it and/or modify it
// under the terms of the license (GNU GPL) which comes with this package.

/*################################################################################################*/

#include "config.h"	// this is target-dependent...

#ifndef QM1ALG_H
#define QM1ALG_H

class qm1_geomopt;
class qm1_geomopt_param;

/*################################################################################################*/

#include "qm1eng.h"
#include "conjgrad.h"

/*################################################################################################*/

/// A geometry optimization class for MM models.

class qm1_geomopt : public conjugate_gradient
{
	protected:
	
	qm1_eng * eng;
	
	public:
	
	qm1_geomopt(qm1_eng *, i32s, f64);
	~qm1_geomopt(void);
	
	f64 GetValue(void);		// virtual
	f64 GetGradient(void);		// virtual
};

class qm1_geomopt_param
{
//	protected:
	public:		// in TARGET3 we have to access this from a function -> gets complicated. fix later...
	
	bool confirm;
	
	friend class qm1_mdl;
	friend class glut_qm1_docv;
	
	public:
	
	i32s nsteps;
	
	public:
	
	qm1_geomopt_param(void) { confirm = false; }
	~qm1_geomopt_param(void) { }
};

/*################################################################################################*/

#endif	// QM1ALG_H

// eof
