// MM1DOCV.CPP

// Copyright (C) 1998 Tommi Hassinen.

// This program is free software; you can redistribute it and/or modify it
// under the terms of the license (GNU GPL) which comes with this package.

/*################################################################################################*/

#include "mm1docv.h"	// config.h is here -> we get ENABLE-macros here...

#ifdef ENABLE_GRAPHICS
#include "mm1alg.h"
#include "mm1eng1.h"
#include "mm1eng9.h"

#include "mm1rbn.h"

#include "plane.h"
#include "surface.h"

#include "color.h"
#include "views.h"

#include "Vector.h" // OELib utils for torsion, angle measure

#include <fstream>
#include <strstream>
using namespace std;

/*################################################################################################*/

mm1_cm_element mm1_docv::cm_element = mm1_cm_element();
mm1_cm_state mm1_docv::cm_state = mm1_cm_state();

mm1_docv::mm1_docv(ostream * p1, graphics_class_factory & p2) :
	docview(p1, p2), mm1_mdl(p1, p2), model_simple(p1, p2)
{
}

mm1_docv::~mm1_docv(void)
{
}

fGL mm1_docv::GetDefaultFocus(void)
{
	return 2.0;
}

const char * mm1_docv::GetType(void)
{
	return "MM, all-atoms model";
}

color_mode * mm1_docv::GetDefaultColorMode(void)
{
	return & mm1_docv::cm_element;
}

void mm1_docv::SelectAll(void)
{
	if (selected_object != NULL)
	{
		selected_object = NULL;
		event_SelectedObjectChanged();
	}
	
	iter_mm1al it1 = atom_list.begin();
	while (it1 != atom_list.end()) (* it1++).selected = true;
	
	UpdateAllGraphicsViews();
}

void mm1_docv::InvertSelection(void)
{
	if (selected_object != NULL)
	{
		selected_object = NULL;
		event_SelectedObjectChanged();
	}
	
	iter_mm1al it1 = atom_list.begin();
	while (it1 != atom_list.end())
	{
		bool flag = (* it1).selected;
		(* it1++).selected = !flag;
	}
	
	UpdateAllGraphicsViews();
}

bool mm1_docv::TestAtom(mm1_atom * ref, rmode rm)
{
	// what about the "visible"-flag???
	
	if (rm == Transform1 && ref->selected) return false;
	if (rm == Transform2 && !ref->selected) return false;
	
	return true;
}

bool mm1_docv::TestBond(mm1_bond * ref, rmode rm)
{
	// what about the "visible"-flag???
	
	if (rm == Transform1 && ref->atmr[0]->selected) return false;
	if (rm == Transform2 && !ref->atmr[0]->selected) return false;
	
	bool test = (ref->atmr[0]->selected != ref->atmr[1]->selected);
	if (rm != Normal && test) return false;
	
	return true;
}

void mm1_docv::SetColor(color_mode * cm, mm1_atom * ref)
{
	const fGL default_sel_color[3] = { 1.0, 0.0, 1.0 };
	fGL *select_color = model_prefs->ColorRGB("Graphics/SelectColor", default_sel_color);
  
	if (ref->selected) glColor3f(select_color[0], select_color[1], select_color[2]);
	else
	{
		fGL_a4 color;
		cm->GetColor(ref, color, model_prefs);
		glColor3fv(color);
	}
}

// it seems that there is something common for all models (like the sel-buffer) -> move to the docview?!?!
// it seems that there is something common for all models (like the sel-buffer) -> move to the docview?!?!
// it seems that there is something common for all models (like the sel-buffer) -> move to the docview?!?!

void mm1_docv::Render(graphics_view * gv, rmode rm)
{
	int tmp;
	const fGL default_label_color[3] = { 1.0, 1.0, 1.0 };
	fGL *label_color = model_prefs->ColorRGB("Graphics/LabelColor", default_label_color);
	
bool accum = gv->accumulate; if (rm != Normal) accum = false;
//if (accum) { glClear(GL_ACCUM_BUFFER_BIT); UpdateAccumValues(); }
//else if (rm != Transform2) glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);

	if (periodic && rm == Normal)
	{
		glLineWidth(1.0);
		glColor3f(1.0, 0.0, 1.0);
		glBegin(GL_LINES);
		
		glVertex3f(-box_hdim[0], -box_hdim[1], +box_hdim[2]);
		glVertex3f(+box_hdim[0], -box_hdim[1], +box_hdim[2]);
		
		glVertex3f(-box_hdim[0], +box_hdim[1], +box_hdim[2]);
		glVertex3f(+box_hdim[0], +box_hdim[1], +box_hdim[2]);
		
		glVertex3f(-box_hdim[0], -box_hdim[1], -box_hdim[2]);
		glVertex3f(+box_hdim[0], -box_hdim[1], -box_hdim[2]);
		
		glVertex3f(-box_hdim[0], +box_hdim[1], -box_hdim[2]);
		glVertex3f(+box_hdim[0], +box_hdim[1], -box_hdim[2]);
		
		glVertex3f(-box_hdim[0], -box_hdim[1], -box_hdim[2]);
		glVertex3f(-box_hdim[0], -box_hdim[1], +box_hdim[2]);
		
		glVertex3f(-box_hdim[0], +box_hdim[1], -box_hdim[2]);
		glVertex3f(-box_hdim[0], +box_hdim[1], +box_hdim[2]);
		
		glVertex3f(+box_hdim[0], -box_hdim[1], -box_hdim[2]);
		glVertex3f(+box_hdim[0], -box_hdim[1], +box_hdim[2]);
		
		glVertex3f(+box_hdim[0], +box_hdim[1], -box_hdim[2]);
		glVertex3f(+box_hdim[0], +box_hdim[1], +box_hdim[2]);
		
		glVertex3f(-box_hdim[0], -box_hdim[1], -box_hdim[2]);
		glVertex3f(-box_hdim[0], +box_hdim[1], -box_hdim[2]);
		
		glVertex3f(-box_hdim[0], -box_hdim[1], +box_hdim[2]);
		glVertex3f(-box_hdim[0], +box_hdim[1], +box_hdim[2]);
		
		glVertex3f(+box_hdim[0], -box_hdim[1], -box_hdim[2]);
		glVertex3f(+box_hdim[0], +box_hdim[1], -box_hdim[2]);
		
		glVertex3f(+box_hdim[0], -box_hdim[1], +box_hdim[2]);
		glVertex3f(+box_hdim[0], +box_hdim[1], +box_hdim[2]);
		
		glEnd();
	}
	
	if (gv->enable_fog) glEnable(GL_FOG);
	
	i32s layers = 0;
	if (periodic && rm == Normal) layers = 1;
	
	for (i32s r1 = -layers;r1 < (layers + 1);r1++)
	{
		for (i32s r2 = -layers;r2 < (layers + 1);r2++)
		{
			for (i32s r3 = -layers;r3 < (layers + 1);r3++)
			{
				glPushMatrix();
				
				fGL trans1 = r1 * box_fdim[0];
				fGL trans2 = r2 * box_fdim[1];
				fGL trans3 = r3 * box_fdim[2];
				
				glTranslated(trans1, trans2, trans3);
				
				RenderScene(gv, rm, accum);
				
				glPopMatrix();
			}
		}
	}
	
	if (accum) glAccum(GL_RETURN, 1.0);
	else if (rm != Transform2) gv->cam->RenderObjects(gv);
	
	if (gv->label == LABEL_ELEMENT)
	{
		glDisable(GL_DEPTH_TEST);  char string[32]; 
		glColor3f(label_color[0], label_color[1], label_color[2]);
		for (iter_mm1al it1 = atom_list.begin();it1 != atom_list.end();it1++)
		{
			glRasterPos3fv((* it1).crd_vector[0].data);
			
			ostrstream str(string, sizeof(string));
			str << (* it1).el.GetSymbol() << ends;
			gv->WriteBitmapString(GLUT_BITMAP_9_BY_15, string);
		}
		glEnable(GL_DEPTH_TEST);  
	}
	else if (gv->label == LABEL_ATOMID)
	{
		glDisable(GL_DEPTH_TEST);  char string[32]; 
		glColor3f(label_color[0], label_color[1], label_color[2]);
		tmp = 0;
		for (iter_mm1al it1 = atom_list.begin();it1 != atom_list.end();it1++)
		{
			glRasterPos3fv((* it1).crd_vector[0].data);
			
			ostrstream str(string, sizeof(string));
			str << tmp++ << ends;
			gv->WriteBitmapString(GLUT_BITMAP_9_BY_15, string);
		}
		glEnable(GL_DEPTH_TEST);  
	}
	else if (gv->label == LABEL_BONDTYPE)
	{
		glDisable(GL_DEPTH_TEST);  char string[32]; 
		glColor3f(label_color[0], label_color[1], label_color[2]);
		for (iter_mm1bl it1 = bond_list.begin();it1 != bond_list.end();it1++)
		{
			fGL rpos[3];
			for (i32s n1 = 0;n1 < 3;n1++)
			{
				fGL tmp1 = (* it1).atmr[0]->crd_vector[0][n1];
				fGL tmp2 = (* it1).atmr[1]->crd_vector[0][n1];
				rpos[n1] = (tmp1 + tmp2) / 2.0;
			} glRasterPos3fv(rpos);
			
			ostrstream str(string, sizeof(string));
			str << (* it1).bt.GetSymbol1() << ends;
			gv->WriteBitmapString(GLUT_BITMAP_9_BY_15, string);
		}
		glEnable(GL_DEPTH_TEST);  
	}
	
	if (gv->enable_fog) glDisable(GL_FOG);
	
	// finally call this to handle transparency...
	// finally call this to handle transparency...
	// finally call this to handle transparency...
	
	RenderAllTPs(gv, rm);
}

void mm1_docv::RenderScene(graphics_view * gv, rmode rm, bool accum)
{
	for (i32u n1 = 0;n1 < cs_vector.size();n1++)
	{
		if (!cs_vector[n1].visible) continue;
if (accum) glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);		// FIXME!!!

		if (gv->render == RENDER_WIREFRAME)
		{
			glPointSize(3.0); glLineWidth(1.0);
			for (iter_mm1al it1 = atom_list.begin();it1 != atom_list.end();it1++)		// wireframe atoms
			{
				if (!TestAtom(& (* it1), rm)) continue;
				glPushName(GLNAME_MD_TYPE1); glPushName((i32u) & (* it1));
				
				glBegin(GL_POINTS);
				SetColor(gv->colormode, & (* it1));
				glVertex3fv((* it1).crd_vector[n1].data);
				glEnd();
				
				glPopName(); glPopName();
			}
			
			glEnable(GL_LINE_STIPPLE);
			for (iter_mm1bl it2 = bond_list.begin();it2 != bond_list.end();it2++)		// wireframe bonds
			{
				if (!TestBond(& (* it2), rm)) continue;
				
				switch ((* it2).bt.GetSymbol1())
				{
					case 'S': glLineStipple(1, 0xFFFF); break;
					case 'C': glLineStipple(1, 0x3FFF); break;
					case 'D': glLineStipple(1, 0x3F3F); break;
					case 'T': glLineStipple(1, 0x3333); break;
				}
				
				glBegin(GL_LINES);
				SetColor(gv->colormode, (* it2).atmr[0]);
				glVertex3fv((* it2).atmr[0]->crd_vector[n1].data);
				SetColor(gv->colormode, (* it2).atmr[1]);
				glVertex3fv((* it2).atmr[1]->crd_vector[n1].data);
				glEnd();
			}
			glDisable(GL_LINE_STIPPLE);
		}
		
		if (gv->render != RENDER_WIREFRAME && gv->render != RENDER_NOTHING)
		{
			glEnable(GL_LIGHTING);
			
			for (iter_mm1al it1 = atom_list.begin();it1 != atom_list.end();it1++)		// atoms as spheres
			{
				if (!TestAtom(& (* it1), rm)) continue;
				
				SetColor(gv->colormode, & (* it1));
				
				float rad = 0.0; int res = 0;
				switch (gv->render)
				{
					case RENDER_BALL_AND_STICK:
					rad = model_prefs->Double("MM1Graphics/BallSize", 0.035);
					if (model_prefs->Boolean("MM1Graphics/BallVdWScale", false))
					    rad *= (* it1).el.GetVDWRadius() * 4.0;
					res = model_prefs->Value("MM1Graphics/BallResolution", 12);
					break;
					
					case RENDER_VAN_DER_WAALS:
					rad = (* it1).el.GetVDWRadius();
					res = model_prefs->Value("MM1Graphics/VdWResolution", 22);
					break;
					
					case RENDER_CYLINDERS:
					rad = model_prefs->Double("MM1Graphics/CylinderSize", 0.035);
					res = model_prefs->Value("MM1Graphics/CylinderResolution", 12);
					break;
				}
				
				glPushName(GLNAME_MD_TYPE1); glPushName((i32u) & (* it1));
				
				GLUquadricObj * qo = gluNewQuadric();
				gluQuadricDrawStyle(qo, (GLenum) GLU_FILL);
				
				glPushMatrix();
				glTranslated((* it1).crd_vector[n1][0], (* it1).crd_vector[n1][1], (* it1).crd_vector[n1][2]);
				gluSphere(qo, rad, res, res / 2);
				glPopMatrix();
				gluDeleteQuadric(qo);
				
				glPopName(); glPopName();
			}
			
			glDisable(GL_LIGHTING);
		}
		
		if (gv->render == RENDER_BALL_AND_STICK || gv->render == RENDER_CYLINDERS)
		{
			glEnable(GL_LIGHTING);
			
			for (iter_mm1bl it1 = bond_list.begin();it1 != bond_list.end();it1++)		// bonds as cylinders
			{
				if (!TestBond(& (* it1), rm)) continue;
				
				fGL vdwr[2] =
				{
					(* it1).atmr[0]->el.GetVDWRadius(),
					(* it1).atmr[1]->el.GetVDWRadius()
				};
				
				fGL vdwrsum = vdwr[0] + vdwr[1];
				
				for (i32s n2 = 0;n2 < 2;n2++)
				{
					fGL * crd1 = (* it1).atmr[n2]->crd_vector[n1].data;
					fGL * crd2 = (* it1).atmr[!n2]->crd_vector[n1].data;
					v3d<fGL> crt1 = v3d<fGL>(crd1);
					v3d<fGL> crt2 = v3d<fGL>(crd2);
					v3d<fGL> crt = crt2 - crt1;
					
					fGL pol[3]; crt2pol(crt.data, pol);
					
					SetColor(gv->colormode, (* it1).atmr[n2]);
					
					float trans, rad = 0.0; int res = 0;
					switch (gv->render)
					{
						case RENDER_BALL_AND_STICK:
						rad = model_prefs->Double("MM1Graphics/StickSize", 0.01);
						res = model_prefs->Value("MM1Graphics/StickResolution", 6);
						break;
						
						case RENDER_CYLINDERS:
						rad = model_prefs->Double("MM1Graphics/CylinderSize", 0.035);
						res = model_prefs->Value("MM1Graphics/CylinderResolution", 12);
						break;
					}
					
					glPushName(GLNAME_MD_TYPE1); glPushName((i32u) (* it1).atmr[n2]);
					
					GLUquadricObj * qo = gluNewQuadric();
					gluQuadricDrawStyle(qo, (GLenum) GLU_FILL);
					glPushMatrix();
					
					glTranslated(crd1[0], crd1[1], crd1[2]);
					
					glRotated(180.0 * pol[1] / M_PI, 0.0, 1.0, 0.0);
					glRotated(180.0 * pol[2] / M_PI, sin(-pol[1]), 0.0, cos(-pol[1]));
					
					// any chance to further define the orientation of, for example, double bonds???
					// one more rotation would be needed. but what is the axis, and how much to rotate???
					
					fGL length = crt.len() * vdwr[n2] / vdwrsum;
					
					if (gv->render == RENDER_BALL_AND_STICK)
					switch ((* it1).bt.GetValue())
					{
						case BONDTYPE_DOUBLE:
						trans = rad;
						rad = rad / 1.5;
						
						if (n2)
							glTranslated(0.0, trans, 0.0);
						else
							glTranslated(0.0, -trans, 0.0);
						gluCylinder(qo, rad, rad, length, res, 1);					
						if (n2)
							glTranslated(0.0, -2.0 * trans, 0.0);
						else
							glTranslated(0.0, 2.0 * trans, 0.0);
						gluCylinder(qo, rad, rad, length, res, 1);
						break;
						
						case BONDTYPE_CNJGTD:
						trans = rad;
						rad = rad / 1.5;
						
						if (n2)
							glTranslated(0.0, trans, 0.0);
						else
							glTranslated(0.0, -trans, 0.0);
						gluCylinder(qo, rad, rad, length, res, 1);
						if (n2)
							glTranslated(0.0, -2.0 * trans, 0.0);
						else
							glTranslated(0.0, 2.0 * trans, 0.0);
						
						glEnable(GL_LINE_STIPPLE);
						glLineStipple(1, 0x3F3F);
						gluQuadricDrawStyle(qo, (GLenum) GLU_LINE);
						gluCylinder(qo, rad, rad, length, res, 1);
						glDisable(GL_LINE_STIPPLE);
						break;
						
						case BONDTYPE_TRIPLE:
						trans = rad;
						rad = rad / 2.0;
						
						if (n2)
							glTranslated(0.0, trans, 0.0);
						else
							glTranslated(0.0, -trans, 0.0);
						gluCylinder(qo, rad, rad, length, res, 1);
						if (n2)
							glTranslated(0.0, -trans, 0.0);
						else
							glTranslated(0.0, trans, 0.0);
						gluCylinder(qo, rad, rad, length, res, 1);
						if (n2)
							glTranslated(0.0, -trans, 0.0);
						else
							glTranslated(0.0, trans, 0.0);
						gluCylinder(qo, rad, rad, length, res,1);
						break;
						
						default:
						gluCylinder(qo, rad, rad, length, res, 1);
					}
					else
						gluCylinder(qo, rad, rad, length, res, 1);
					
					glPopMatrix();
					gluDeleteQuadric(qo);
					
					glPopName(); glPopName();
				}
			}
			
			glDisable(GL_LIGHTING);
		}
		
		if (accum)
		{
			gv->cam->RenderObjects(gv);
			glAccum(GL_ACCUM, cs_vector[n1].accum_value);
		}
	}
}

void mm1_docv::Center(transformer * p1)
{
	i32s sum = 0;
	p1->GetLocDataRW()->crd[0] = 0.0;
	p1->GetLocDataRW()->crd[1] = 0.0;
	p1->GetLocDataRW()->crd[2] = 0.0;
	
	for (iter_mm1al it1 = atom_list.begin();it1 != atom_list.end();it1++)
	{
		if (!(* it1).selected) continue;
		for (i32u n1 = 0;n1 < cs_vector.size();n1++)
		{
			sum++;
			p1->GetLocDataRW()->crd[0] += (* it1).crd_vector[n1][0];
			p1->GetLocDataRW()->crd[1] += (* it1).crd_vector[n1][1];
			p1->GetLocDataRW()->crd[2] += (* it1).crd_vector[n1][2];
		}
	}
	
	if (!sum) return;
	
	p1->GetLocDataRW()->crd[0] /= (fGL) sum;
	p1->GetLocDataRW()->crd[1] /= (fGL) sum;
	p1->GetLocDataRW()->crd[2] /= (fGL) sum;
	
	for (iter_mm1al it1 = atom_list.begin();it1 != atom_list.end();it1++)
	{
		if (!(* it1).selected) continue;
		for (i32u n1 = 0;n1 < cs_vector.size();n1++)
		{
			(* it1).crd_vector[n1][0] -= p1->GetLocData()->crd[0];
			(* it1).crd_vector[n1][1] -= p1->GetLocData()->crd[1];
			(* it1).crd_vector[n1][2] -= p1->GetLocData()->crd[2];
		}
	}
}

void mm1_docv::Transform(transformer * p1)
{
	fGL matrix[16]; p1->GetMatrix(matrix);
	
	for (iter_mm1al it1 = atom_list.begin();it1 != atom_list.end();it1++)
	{
		if (!(* it1).selected) continue;
		
		for (i32u n1 = 0;n1 < cs_vector.size();n1++)
		{
			v3d<fGL> posv = v3d<fGL>((* it1).crd_vector[n1].data);
			TransformVector(posv, matrix);
			
			(* it1).crd_vector[n1][0] = posv[0];
			(* it1).crd_vector[n1][1] = posv[1];
			(* it1).crd_vector[n1][2] = posv[2];
		}
	}
}

void mm1_docv::DrawEvent(graphics_view * gv, vector<iGLu> & names)
{
	if (ogl_view::button == mouse_tool::Right) return;	// the right button is for popup menus...
	
	i32s mouse[2] =
	{
		gv->current_tool->latest_x,
		gv->current_tool->latest_y
	};
	
	if (ogl_view::state == mouse_tool::Down)
	{
		if (names.size() > 1 && names[0] == GLNAME_MD_TYPE1)
		{
			draw_data[0] = (mm1_atom *) names[1];
		}
		else
		{
			fGL tmp1[3]; gv->GetCRD(mouse, tmp1);
			mm1_atom newatom(element::current_element, tmp1, cs_vector.size());
			AddAtom(newatom); draw_data[0] = & atom_list.back();
		}
	}
	else
	{
		if (names.size() > 1 && names[0] == GLNAME_MD_TYPE1)
		{
			draw_data[1] = (mm1_atom *) names[1];
		}
		else
		{
			fGL tmp1[3]; gv->GetCRD(mouse, tmp1);
			mm1_atom newatom(element::current_element, tmp1, cs_vector.size());
			AddAtom(newatom); draw_data[1] = & atom_list.back();
		}
		
		// if different: update bondtype or add a new bond.
		// if not different: change atom to different element.
		
		if (draw_data[0] != draw_data[1])
		{
			mm1_bond newbond(draw_data[0], draw_data[1], bondtype::current_bondtype);
			iter_mm1bl it1 = find(bond_list.begin(), bond_list.end(), newbond);
			if (it1 != bond_list.end()) (* it1).bt = bondtype::current_bondtype;
			else AddBond(newbond);
		}
		else
		{
			draw_data[0]->el = element::current_element;
		}
		
		UpdateAllGraphicsViews();
	}
}

void mm1_docv::EraseEvent(graphics_view * gv, vector<iGLu> & names)
{
	if (ogl_view::button == mouse_tool::Right) return;	// the right button is for popup menus...
	
	if (ogl_view::state == mouse_tool::Down)
	{
		if (names.size() > 1 && names[0] == GLNAME_MD_TYPE1)
		{
			draw_data[0] = (mm1_atom *) names[1];
		}
		else
		{
			draw_data[0] = NULL;
		}
	}
	else
	{
		if (names.size() > 1 && names[0] == GLNAME_MD_TYPE1)
		{
			draw_data[1] = (mm1_atom *) names[1];
		}
		else
		{
			draw_data[1] = NULL;
		}
		
		if (!draw_data[0] || !draw_data[1]) return;
		
		// if different: try to find and remove a bond.
		// if not different: remove atom.
		
		if (draw_data[0] != draw_data[1])
		{
			mm1_bond tmpbond(draw_data[0], draw_data[1], bondtype::current_bondtype);
			iter_mm1bl it1 = find(bond_list.begin(), bond_list.end(), tmpbond);
			if (it1 != bond_list.end()) RemoveBond(it1); else return;
		}
		else
		{
			iter_mm1al it1 = find(atom_list.begin(), atom_list.end(), (* draw_data[0]));
			if (it1 != atom_list.end()) RemoveAtom(it1); else exit(EXIT_FAILURE);
		}
		
		UpdateAllGraphicsViews();
	}
}

void mm1_docv::SelectEvent(graphics_view *, vector<iGLu> & names)
{
	if (names[0] == GLNAME_MD_TYPE1)
	{
		mm1_atom * ref = (mm1_atom *) names[1];
		ref->selected = !ref->selected;
		UpdateAllGraphicsViews();
		
		//		cout << "atomtype is " << hex << ref->atmtp << dec << endl;
	}
}

void mm1_docv::MeasureEvent(graphics_view *, vector<iGLu> & names)
{
        static mm1_atom *a1 = NULL;
	static mm1_atom *a2 = NULL;
	static mm1_atom *a3 = NULL;

	if (names[0] == GLNAME_MD_TYPE1)
	{
		mm1_atom * ref = (mm1_atom *) names[1];
		ref->selected = !ref->selected;
		UpdateAllGraphicsViews();
		
		if (a1 == NULL)
		  {
		    a1 = ref;
		    cout << "charge: " << ref->charge << endl;
		  }
		else if (a1 != NULL && a2 == NULL)
		  {
		    if (a1 == ref)
		      {
			a1->selected = false; a1 = NULL;
			return;
		      }

		    a2 = ref;
		    float * p1 = a1->crd_vector[0].data;
		    float * p2 = a2->crd_vector[0].data;
		    v3d<float> v1(p1, p2);
		    cout << "distance: " << v1.len() << " nm" << endl;
		  }
		else if (a1 != NULL && a2 != NULL && a3 == NULL)
		  {
		    if (a1 == ref)
		      {
			a1->selected = false; a1 = a2; a2 = NULL;
			return;
		      }
		    else if (a2 == ref)
		      {
			a2->selected = false; a2 = NULL;
			return;
		      }

		    Vector v1, v2;
		    v1 = Vector(a1->crd_vector[0][0] - a2->crd_vector[0][0],
				a1->crd_vector[0][1] - a2->crd_vector[0][1],
				a1->crd_vector[0][2] - a2->crd_vector[0][2]);
		    v2 = Vector(ref->crd_vector[0][0] - a2->crd_vector[0][0],
				ref->crd_vector[0][1] - a2->crd_vector[0][1],
				ref->crd_vector[0][2] - a2->crd_vector[0][2]);

		    a3 = ref;
		    cout << "angle: " << VectorAngle(v1, v2) << endl;
		  }
		else
		  {
		    if (a1 == ref)
		      {
			a1->selected = false; a1 = a2; a2 = a3; a3 = NULL;
			return;
		      }
		    else if (a2 == ref)
		      {
			a2->selected = false; a2 = a3; a3 = NULL;
			return;
		      }
		    else if (a3 == ref)
		      {
			a3->selected = false; a3 = NULL;
			return;
		      }
		    Vector v1, v2, v3, v4;
		    v1 = Vector(a1->crd_vector[0][0],
				a1->crd_vector[0][1],
				a1->crd_vector[0][2]) * 10.0f;
		    v2 = Vector(a2->crd_vector[0][0],
				a2->crd_vector[0][1],
				a2->crd_vector[0][2]) * 10.0f;
		    v3 = Vector(a3->crd_vector[0][0],
				a3->crd_vector[0][1],
				a3->crd_vector[0][2]) * 10.0f;
		    v4 = Vector(ref->crd_vector[0][0],
				ref->crd_vector[0][1],
				ref->crd_vector[0][2]) * 10.0f;

		    float tor = CalcTorsionAngle(v1, v2, v3, v4);
		    cout << "torsion: " << tor << endl;

		    a1->selected = false; a1 = NULL;
		    a2->selected = false; a2 = NULL;
		    a3->selected = false; a3 = NULL;
		    ref->selected = false;
		    UpdateAllGraphicsViews();
		  }

	}
}

/*################################################################################################*/

void mm1_cm_element::GetColor(const void * p1, fGL_a4 & p2, prefs *p3)
{
	mm1_atom * ref = (mm1_atom *) p1;
	const fGL * color = ref->el.GetColor(p3);
	p2[0] = color[0]; p2[1] = color[1]; p2[2] = color[2];
}

/*################################################################################################*/

void mm1_cm_state::GetColor(const void * p1, fGL_a4 & p2, prefs *p3)
{
//	mm1_atom * ref = (mm1_atom *) p1;
//	mm1_mdl * mdl = ref->mdl;		// CURRENTLY BROKEN...
	
	p2[0] = 0.0; p2[1] = 0.0; p2[2] = 1.0;		// loop
	
/*	if (mdl->chn_info == NULL) return;
	vector<mm1_chn_info *> & ci = * mdl->chn_info;
	
	if (ref->id[1] < 0 || ref->id[2] < 0) return;
	if (ci[ref->id[1]]->state == NULL) return;
	
	char state = ci[ref->id[1]]->state[ref->id[2]];
	
	switch (state)
	{
		case '4':
		p2[0] = 1.0; p2[1] = 0.0; p2[2] = 0.0;		// helix
		return;
		
		case 'S':
		p2[0] = 0.0; p2[1] = 1.0; p2[2] = 0.0;		// strand
		return;
	}*/
}

/*################################################################################################*/

#endif	// ENABLE_GRAPHICS

// eof
