// QM1GUI.CPP

// Copyright (C) 2000 Tommi Hassinen.

// This program is free software; you can redistribute it and/or modify it
// under the terms of the license (GNU GPL) which comes with this package.

/*################################################################################################*/

#include "qm1docv.h"	// config.h is here -> we get ENABLE-macros here...

#ifdef ENABLE_GRAPHICS
#include "qm1e_mopac.h"
#include "qm1e_mpqc.h"

#include "plane.h"
#include "surface.h"

#include "Vector.h" // OELib utils for torsion, angle measure
using namespace std;
using namespace OpenEye;

#include "color.h"
#include "views.h"

/*################################################################################################*/

qm1_cm_element qm1_docv::cm_element = qm1_cm_element();

qm1_docv::qm1_docv(ostream * p1, graphics_class_factory & p2) :
	docview(p1, p2), qm1_mdl(p1, p2), model_simple(p1, p2)
{
}

qm1_docv::~qm1_docv(void)
{
}

void qm1_docv::DiscardCurrentEng(void)
{
	i32u n1 = 0;
	while (n1 < object_vector.size())
	{
		bool flag = false;
		
		color_plane_object * cpo_ref = dynamic_cast<color_plane_object *>(object_vector[n1]);
		if (cpo_ref != NULL && cpo_ref->GetRef() == current_eng) flag = true;
		
		volume_rendering_object * vro_ref = dynamic_cast<volume_rendering_object *>(object_vector[n1]);
		if (vro_ref != NULL && vro_ref->GetRef() == current_eng) flag = true;
		
		color_surface_object * cso_ref = dynamic_cast<color_surface_object *>(object_vector[n1]);
		if (cso_ref != NULL && cso_ref->GetRef() == current_eng) flag = true;
		
		if (flag)
		{
			if (selected_object == object_vector[n1]) selected_object = NULL;
			RemoveObject(object_vector[n1]);
		}
		else n1++;
	}
	
	qm1_mdl::DiscardCurrentEng();
	UpdateEnLevDiagViews();
}

// here we just send a notification to energy-level diagrams...
// here we just send a notification to energy-level diagrams...
// here we just send a notification to energy-level diagrams...

void qm1_docv::SetupPlotting(void)
{
	qm1_mdl::SetupPlotting();
	UpdateEnLevDiagViews();
}

fGL qm1_docv::GetDefaultFocus(void)
{
	return 2.0;
}

const char * qm1_docv::GetType(void)
{
	return "QM, molecular calculations";
}

color_mode * qm1_docv::GetDefaultColorMode(void)
{
	return & qm1_docv::cm_element;
}

void qm1_docv::SelectAll(void)
{
	if (selected_object != NULL)
	{
		selected_object = NULL;
		event_SelectedObjectChanged();
	}
	
	iter_qm1al it1 = atom_list.begin();
	while (it1 != atom_list.end()) (* it1++).selected = true;
	
	UpdateAllGraphicsViews();
}

void qm1_docv::InvertSelection(void)
{
	if (selected_object != NULL)
	{
		selected_object = NULL;
		event_SelectedObjectChanged();
	}
	
	iter_qm1al it1 = atom_list.begin();
	while (it1 != atom_list.end())
	{
		bool flag = (* it1).selected;
		(* it1++).selected = !flag;
	}
	
	UpdateAllGraphicsViews();
}

bool qm1_docv::TestAtom(qm1_atom * ref, rmode rm)
{
	// what about the "visible"-flag???
	
	if (rm == Transform1 && ref->selected) return false;
	if (rm == Transform2 && !ref->selected) return false;
	
	return true;
}

void qm1_docv::SetColor(color_mode * cm, qm1_atom * ref)
{
	if (ref->selected) glColor3f(1.0, 0.0, 1.0);
	else
	{
		fGL_a4 color;
		cm->GetColor(ref, color, model_prefs);
		glColor3fv(color);
	}
}

void qm1_docv::Render(graphics_view * gv, rmode rm)
{
bool accum = gv->accumulate; if (rm != Normal) accum = false;
//if (accum) { glClear(GL_ACCUM_BUFFER_BIT); UpdateAccumValues(); }
//else if (rm != Transform2) glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
	
	if (gv->enable_fog) glEnable(GL_FOG);
	
	/*################*/
	/*################*/
	
	for (i32u n1 = 0;n1 < cs_vector.size();n1++)
	{
		if (!cs_vector[n1].visible) continue;
if (accum) glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);		// FIXME!!!

		if (gv->render == RENDER_WIREFRAME)
		{
			glPointSize(3.0); glLineWidth(1.0);
			for (iter_qm1al it1 = atom_list.begin();it1 != atom_list.end();it1++)
			{
				if (!TestAtom(& (* it1), rm)) continue;
				
				glPushName(GLNAME_MD_TYPE1);
				glPushName((i32u) & (* it1));
				
				glBegin(GL_POINTS);
				SetColor(gv->colormode, & (* it1));
				glVertex3fv((* it1).crd_vector[n1].data);
				glEnd();
				
				glPopName();
				glPopName();
			}
		}
		
glEnable(GL_LINE_STIPPLE);
for (iter_qm1bl it2 = bond_list.begin();it2 != bond_list.end();it2++)		// wireframe bonds
{
//	switch ((* it2).bt.GetSymbol1())
//	{
//		case 'S': glLineStipple(1, 0xFFFF); break;
//		case 'C': glLineStipple(1, 0x3FFF); break;
//		case 'D': glLineStipple(1, 0x3F3F); break;
//		case 'T': glLineStipple(1, 0x3333); break;
//	}
	glLineStipple(1, 0x3FFF);	// like in 'C' case...
	
	glBegin(GL_LINES);
	SetColor(gv->colormode, (* it2).atmr[0]);
	glVertex3fv((* it2).atmr[0]->crd_vector[n1].data);
	SetColor(gv->colormode, (* it2).atmr[1]);
	glVertex3fv((* it2).atmr[1]->crd_vector[n1].data);
	glEnd();
	}
glDisable(GL_LINE_STIPPLE);

		if (gv->render != RENDER_WIREFRAME && gv->render != RENDER_NOTHING)
		{
			glEnable(GL_LIGHTING);
			
			for (iter_qm1al it1 = atom_list.begin();it1 != atom_list.end();it1++)
			{
				if (!TestAtom(& (* it1), rm)) continue;
				
				SetColor(gv->colormode, & (* it1));
				
					float rad = model_prefs->Double("QM1Graphics/BallSize", 0.035);
					if (model_prefs->Boolean("QM1Graphics/BallVdWScale", true))
					    rad *= (* it1).el.GetVDWRadius() * 4.0;
					int res = model_prefs->Value("QM1Graphics/BallResolution", 12);
				
				glPushName(GLNAME_MD_TYPE1); glPushName((i32u) & (* it1));
				
				GLUquadricObj * qo = gluNewQuadric();
				gluQuadricDrawStyle(qo, (GLenum) GLU_FILL);
				glPushMatrix();
				glTranslated((* it1).crd_vector[n1][0], (* it1).crd_vector[n1][1], (* it1).crd_vector[n1][2]);
				gluSphere(qo, rad, res, res / 2);
				glPopMatrix();
				gluDeleteQuadric(qo);
				
				glPopName(); glPopName();
			}
			
			glDisable(GL_LIGHTING);
		}
		
		if (accum)
		{
			gv->cam->RenderObjects(gv);
			glAccum(GL_ACCUM, cs_vector[n1].accum_value);
		}
	}
	
	/*################*/
	/*################*/
	
	if (accum) glAccum(GL_RETURN, 1.0);
	else if (rm != Transform2) gv->cam->RenderObjects(gv);
	
//	if (gv->label == LABEL_ELEMENT)
//	{
//		glDisable(GL_DEPTH_TEST); glColor3f(1.0, 1.0, 1.0); char string[32];
//		for (iter_mm1al it1 = atom_list.begin();it1 != atom_list.end();it1++)
//		{
//			glRasterPos3fv((* it1).crd_vector[0].data);
//			
//			ostrstream str(string, sizeof(string));
//			str << (* it1).el.GetSymbol() << ends;
//			gv->WriteBitmapString(GLUT_BITMAP_9_BY_15, string);
//		}
//		glEnable(GL_DEPTH_TEST);  
//	}
	
	if (gv->enable_fog) glDisable(GL_FOG);
	
	// finally call this to handle transparency...
	// finally call this to handle transparency...
	// finally call this to handle transparency...
	
	RenderAllTPs(gv, rm);
}

void qm1_docv::Center(transformer * p1)
{
	i32s sum = 0;
	p1->GetLocDataRW()->crd[0] = 0.0;
	p1->GetLocDataRW()->crd[1] = 0.0;
	p1->GetLocDataRW()->crd[2] = 0.0;
	
	for (iter_qm1al it1 = atom_list.begin();it1 != atom_list.end();it1++)
	{
		if (!(* it1).selected) continue;
		for (i32u n1 = 0;n1 < cs_vector.size();n1++)
		{
			sum++;
			p1->GetLocDataRW()->crd[0] += (* it1).crd_vector[n1][0];
			p1->GetLocDataRW()->crd[1] += (* it1).crd_vector[n1][1];
			p1->GetLocDataRW()->crd[2] += (* it1).crd_vector[n1][2];
		}
	}
	
	if (!sum) return;
	
	p1->GetLocDataRW()->crd[0] /= (fGL) sum;
	p1->GetLocDataRW()->crd[1] /= (fGL) sum;
	p1->GetLocDataRW()->crd[2] /= (fGL) sum;
	
	for (iter_qm1al it1 = atom_list.begin();it1 != atom_list.end();it1++)
	{
		if (!(* it1).selected) continue;
		for (i32u n1 = 0;n1 < cs_vector.size();n1++)
		{
			(* it1).crd_vector[n1][0] -= p1->GetLocData()->crd[0];
			(* it1).crd_vector[n1][1] -= p1->GetLocData()->crd[1];
			(* it1).crd_vector[n1][2] -= p1->GetLocData()->crd[2];
		}
	}
}

void qm1_docv::Transform(transformer * p1)
{
	fGL matrix[16]; p1->GetMatrix(matrix);
	
	for (iter_qm1al it1 = atom_list.begin();it1 != atom_list.end();it1++)
	{
		if (!(* it1).selected) continue;
		
		for (i32u n1 = 0;n1 < cs_vector.size();n1++)
		{
			v3d<fGL> posv = v3d<fGL>((* it1).crd_vector[n1].data);
			TransformVector(posv, matrix);
			
			(* it1).crd_vector[n1][0] = posv[0];
			(* it1).crd_vector[n1][1] = posv[1];
			(* it1).crd_vector[n1][2] = posv[2];
		}
	}
}

// this comes directly from mm1_mdl, the bonds are just disabled...
// this comes directly from mm1_mdl, the bonds are just disabled...
// this comes directly from mm1_mdl, the bonds are just disabled...

void qm1_docv::DrawEvent(graphics_view * gv, vector<iGLu> & names)
{
	if (ogl_view::button == mouse_tool::Right) return;	// the right button is for popup menus...
	
	i32s mouse[2] =
	{
		gv->current_tool->latest_x,
		gv->current_tool->latest_y
	};
	
	if (ogl_view::state == mouse_tool::Down)
	{
		if (names.size() > 1 && names[0] == GLNAME_MD_TYPE1)
		{
			draw_data[0] = (qm1_atom *) names[1];
		}
		else
		{
			fGL tmp1[3]; gv->GetCRD(mouse, tmp1);
			qm1_atom newatom(element::current_element, tmp1, cs_vector.size());
			
			AddAtom(newatom);	// DiscardCurrentEng() is called here...
			
			draw_data[0] = & atom_list.back();
		}
	}
	else
	{
		if (names.size() > 1 && names[0] == GLNAME_MD_TYPE1)
		{
			draw_data[1] = (qm1_atom *) names[1];
		}
		else
		{
			fGL tmp1[3]; gv->GetCRD(mouse, tmp1);
			qm1_atom newatom(element::current_element, tmp1, cs_vector.size());
			
			AddAtom(newatom);	// DiscardCurrentEng() is called here...
			
			draw_data[1] = & atom_list.back();
		}
		
		// if different: update bondtype or add a new bond.
		// if not different: change atom to different element.
		
		if (draw_data[0] != draw_data[1])
		{
	//		mm1_bond newbond(draw_data[0], draw_data[1], bondtype::current_bondtype);
	//		iter_mm1bl it1 = find(bond_list.begin(), bond_list.end(), newbond);
	//		if (it1 != bond_list.end()) (* it1).bt = bondtype::current_bondtype;
	//		else AddBond(newbond);
		}
		else
		{
			draw_data[0]->el = element::current_element;
			DiscardCurrentEng();	// here we must call this explicitly...
		}
		
		UpdateAllGraphicsViews();
	}
}

// this comes directly from mm1_mdl, the bonds are just disabled...
// this comes directly from mm1_mdl, the bonds are just disabled...
// this comes directly from mm1_mdl, the bonds are just disabled...

void qm1_docv::EraseEvent(graphics_view * gv, vector<iGLu> & names)
{
	if (ogl_view::button == mouse_tool::Right) return;	// the right button is for popup menus...
	
	if (ogl_view::state == mouse_tool::Down)
	{
		if (names.size() > 1 && names[0] == GLNAME_MD_TYPE1)
		{
			draw_data[0] = (qm1_atom *) names[1];
		}
		else
		{
			draw_data[0] = NULL;
		}
	}
	else
	{
		if (names.size() > 1 && names[0] == GLNAME_MD_TYPE1)
		{
			draw_data[1] = (qm1_atom *) names[1];
		}
		else
		{
			draw_data[1] = NULL;
		}
		
		if (!draw_data[0] || !draw_data[1]) return;
		
		// if different: try to find and remove a bond.
		// if not different: remove atom.
		
		if (draw_data[0] != draw_data[1])
		{
//			mm1_bond tmpbond(draw_data[0], draw_data[1], bondtype::current_bondtype);
//			iter_mm1bl it1 = find(bond_list.begin(), bond_list.end(), tmpbond);
//			if (it1 != bond_list.end()) RemoveBond(it1); else return;
		}
		else
		{
			iter_qm1al it1 = find(atom_list.begin(), atom_list.end(), (* draw_data[0]));
			if (it1 != atom_list.end()) RemoveAtom(it1); else exit(EXIT_FAILURE);
		}
		
		UpdateAllGraphicsViews();
	}
}

void qm1_docv::SelectEvent(graphics_view *, vector<iGLu> & names)
{
	if (names[0] == GLNAME_MD_TYPE1)
	{
		qm1_atom * ref = (qm1_atom *) names[1];
		ref->selected = !ref->selected;
		UpdateAllGraphicsViews();
	}
}

void qm1_docv::MeasureEvent(graphics_view *, vector<iGLu> & names)
{
        static qm1_atom *a1 = NULL;
	static qm1_atom *a2 = NULL;
	static qm1_atom *a3 = NULL;

	if (names[0] == GLNAME_MD_TYPE1)
	{
		qm1_atom * ref = (qm1_atom *) names[1];
		ref->selected = !ref->selected;
		UpdateAllGraphicsViews();
		
		if (a1 == NULL)
		  a1 = ref;
		else if (a1 != NULL && a2 == NULL)
		  {
		    if (a1 == ref)
		      {
			a1->selected = false; a1 = NULL;
			return;
		      }

		    a2 = ref;
		    float * p1 = a1->crd_vector[0].data;
		    float * p2 = a2->crd_vector[0].data;
		    v3d<float> v1(p1, p2);
		    cout << "distance: " << v1.len() << " nm" << endl;
		  }
		else if (a1 != NULL && a2 != NULL && a3 == NULL)
		  {
		    if (a1 == ref)
		      {
			a1->selected = false; a1 = a2; a2 = NULL;
			return;
		      }
		    else if (a2 == ref)
		      {
			a2->selected = false; a2 = NULL;
			return;
		      }

		    Vector v1, v2;
		    v1 = Vector(a1->crd_vector[0][0] - a2->crd_vector[0][0],
				a1->crd_vector[0][1] - a2->crd_vector[0][1],
				a1->crd_vector[0][2] - a2->crd_vector[0][2]);
		    v2 = Vector(ref->crd_vector[0][0] - a2->crd_vector[0][0],
				ref->crd_vector[0][1] - a2->crd_vector[0][1],
				ref->crd_vector[0][2] - a2->crd_vector[0][2]);

		    a3 = ref;
		    cout << "angle: " << VectorAngle(v1, v2) << endl;
		  }
		else
		  {
		    if (a1 == ref)
		      {
			a1->selected = false; a1 = a2; a2 = a3; a3 = NULL;
			return;
		      }
		    else if (a2 == ref)
		      {
			a2->selected = false; a2 = a3; a3 = NULL;
			return;
		      }
		    else if (a3 == ref)
		      {
			a3->selected = false; a3 = NULL;
			return;
		      }
		    Vector v1, v2, v3, v4;
		    v1 = Vector(a1->crd_vector[0][0],
				a1->crd_vector[0][1],
				a1->crd_vector[0][2]) * 10.0f;
		    v2 = Vector(a2->crd_vector[0][0],
				a2->crd_vector[0][1],
				a2->crd_vector[0][2]) * 10.0f;
		    v3 = Vector(a3->crd_vector[0][0],
				a3->crd_vector[0][1],
				a3->crd_vector[0][2]) * 10.0f;
		    v4 = Vector(ref->crd_vector[0][0],
				ref->crd_vector[0][1],
				ref->crd_vector[0][2]) * 10.0f;

		    float tor = CalcTorsionAngle(v1, v2, v3, v4);
		    cout << "torsion: " << tor << endl;

		    a1->selected = false; a1 = NULL;
		    a2->selected = false; a2 = NULL;
		    a3->selected = false; a3 = NULL;
		    ref->selected = false;
		    UpdateAllGraphicsViews();
		  }

	}
}

enlevdiag_view * qm1_docv::AddEnLevDiagView(void)
{
	enlevdiag_view * eldv = graphics_factory->ProduceEnLevDiagView(this);
	eldv_list.push_back(eldv);
	
	return eldv;
}

void qm1_docv::UpdateEnLevDiagViews(void)
{
	list<enlevdiag_view *>::iterator iter;
	for (iter = eldv_list.begin();iter != eldv_list.end();iter++)
	{
		(* iter)->SetCenterAndScale();
		(* iter)->Update();
	}
}

/*################################################################################################*/

void qm1_cm_element::GetColor(const void * p1, fGL_a4 & p2, prefs *p3)
{
	qm1_atom * ref = (qm1_atom *) p1;
	const fGL * color = ref->el.GetColor(p3);
	for (i32s n1 = 0;n1 < 3;n1++) p2[n1] = color[n1];
}

/*################################################################################################*/

#endif	// ENABLE_GRAPHICS

// eof
