// VIEWS.CPP

// Copyright (C) 1998 Tommi Hassinen, Jarno Huuskonen.

// This program is free software; you can redistribute it and/or modify it
// under the terms of the license (GNU GPL) which comes with this package.

/*################################################################################################*/

#include "views.h"	// config.h is here -> we get ENABLE-macros here...

#ifdef ENABLE_GRAPHICS
#include "docview.h"
#include "camera.h"

#include <strstream>
using namespace std;

/*################################################################################################*/

view::view(void)
{
}

view::~view(void)
{
}

/*################################################################################################*/

mouse_tool::state ogl_view::state = mouse_tool::Unknown;
mouse_tool::button ogl_view::button = mouse_tool::None;

bool ogl_view::shift_down = false;
bool ogl_view::ctrl_down = false;

draw_tool ogl_view::tool_draw;
erase_tool ogl_view::tool_erase;

select_tool ogl_view::tool_select;
zoom_tool ogl_view::tool_zoom;

translate_xy_tool ogl_view::tool_translate_xy;
translate_z_tool ogl_view::tool_translate_z;

orbit_xy_tool ogl_view::tool_orbit_xy;
orbit_z_tool ogl_view::tool_orbit_z;

rotate_xy_tool ogl_view::tool_rotate_xy;
rotate_z_tool ogl_view::tool_rotate_z;

measure_tool ogl_view::tool_measure;

// tool_orbit_xy is the default tool...
// tool_orbit_xy is the default tool...
// tool_orbit_xy is the default tool...

mouse_tool * ogl_view::current_tool = & ogl_view::tool_orbit_xy;

ogl_view::ogl_view() : view()
{
}

ogl_view::~ogl_view(void)
{
}

// later, before stereo views were added, glViewport() was called here...
// but now, this is no longer the practice; now call glViewport() when rendering!!!

void ogl_view::SetSize(i32s p1, i32s p2)
{
	size[0] = p1; size[1] = p2;
	if (!size[0] || !size[1]) size[0] = NOT_DEFINED;
	Update(false);
}

void ogl_view::WriteBitmapString(void * font, const char * str)
{
	i32u count = 0;
	while (count < strlen(str))
	{
		glutBitmapCharacter(font, str[count++]);
	}
}

i32s ogl_view::GetBitmapStringWidth(void * font, const char * str)
{
	i32s width = 0;
	
	i32u count = 0;
	while (count < strlen(str))
	{
		width += glutBitmapWidth(font, str[count++]);
	}
	
	return width;
}

/*################################################################################################*/

bool graphics_view::quick_update = false;
bool graphics_view::draw_info = true;

graphics_view::graphics_view(camera * p1) : ogl_view()
{
	cam = p1;
	
//	render = RENDER_WIREFRAME;		// make this model-dependent like the coloring...
	render = RENDER_BALL_AND_STICK;		// make this model-dependent like the coloring...
	label = LABEL_NOTHING;
	
	colormode = cam->docv->GetDefaultColorMode();
	
	enable_fog = false;
	accumulate = false;
}

graphics_view::~graphics_view(void)
{
}

void graphics_view::GetCRD(i32s * p1, fGL * p2)
{
	v3d<fGL> xdir = (cam->GetLocData()->ydir).vpr(cam->GetLocData()->zdir); xdir = xdir / xdir.len();
	v3d<fGL> tmpv = v3d<fGL>(cam->GetLocData()->crd); tmpv = tmpv + (cam->GetLocData()->zdir * cam->focus);
	tmpv = tmpv + xdir * (2.0 * range[0] * (fGL) (size[0] / 2 - p1[0]) / (fGL) size[0]);
	tmpv = tmpv + cam->GetLocData()->ydir * (2.0 * range[1] * (fGL) (size[1] / 2 - p1[1]) / (fGL) size[1]);
	for (i32s n1 = 0;n1 < 3;n1++) p2[n1] = tmpv[n1];
}

void graphics_view::InitGL(void)
{
	SetCurrent();
	GetDV()->InitGL();
}

void graphics_view::Render(void)
{
	SetCurrent();
	cam->RenderWindow(this);
}

/*################################################################################################*/

enlevdiag_view::enlevdiag_view(qm1_mdl * p1)
{
	mdl = p1;
	select_buffer = new iGLu[SB_SIZE];
	
	SetCenterAndScale();
}

enlevdiag_view::~enlevdiag_view(void)
{
	delete[] select_buffer;
}

void enlevdiag_view::SetCenterAndScale(void)
{
	if (mdl->current_eng != NULL)
	{
		f64 mine = mdl->current_eng->GetOrbitalEnergy(0);
		f64 maxe = mdl->current_eng->GetOrbitalEnergy(mdl->current_eng->GetOrbitalCount() - 1);
		
		// above we assumed that the first orbital has lowest and the last orbital has highest energy...
		
		center = (mine + maxe) / 2.0;
		scale = (maxe - mine) * 1.5;
	}
	else
	{
		center = 0.0;
		scale = 1.0;
	}
}

void enlevdiag_view::InitGL(void)
{
	SetCurrent();
	
	prefs * model_prefs = mdl->model_prefs;		// needed elsewhere???

	const fGL default_background[4] = { 0.0, 0.0, 0.0, 1.0};
	fGL *background = model_prefs->ColorRGBA("Graphics/BkgndColor", default_background);
	glClearColor(background[0], background[1], background[2], background[3]);
	glDepthFunc(GL_LESS); glEnable(GL_DEPTH_TEST);
	
	glMateriali(GL_FRONT_AND_BACK, GL_SHININESS, 64);
	const fGL default_reflectance[4] = { 0.9, 0.9, 0.9, 1.0 };
	fGL *specular_reflectance = model_prefs->ColorRGBA("Graphics/SpecularReflectance", default_reflectance);
	glMaterialfv(GL_FRONT_AND_BACK, GL_SPECULAR, specular_reflectance);
	glColorMaterial(GL_FRONT_AND_BACK, GL_AMBIENT_AND_DIFFUSE);
	glEnable(GL_COLOR_MATERIAL);
	
// this is not needed here, I guess...
// this is not needed here, I guess...
// this is not needed here, I guess...
//const fGL default_ambient[4] = { 0.2, 0.2, 0.2, 1.0 };
//fGL *ambient_intensity = model_prefs->ColorRGBA("Graphics/AmbientIntensity", default_ambient);
//glLightModelfv(GL_LIGHT_MODEL_AMBIENT, ambient_intensity);
//glLightModeli(GL_LIGHT_MODEL_LOCAL_VIEWER, true);
//glFogi(GL_FOG_MODE, GL_EXP); 
//glFogf(GL_FOG_DENSITY, model_prefs->Double("Graphics/FogDensity",0.15));
//const fGL default_fog[4] = { 0.0, 0.0, 0.0, 0.0 };
//fGL *fog_color = model_prefs->ColorRGBA("Graphics/FogColor", default_fog);
//glFogfv(GL_FOG_COLOR, fog_color);

	glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
	
	glSelectBuffer(SB_SIZE, select_buffer);
}

void enlevdiag_view::Render(void)
{
	if (size[0] < 0) return;	// skip rendering if invalid window!!!
	prefs * model_prefs = mdl->model_prefs;		// needed elsewhere???

	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	
/*	// projection matrix is now initialized. if this is a selection operation, we must do
	// some furter manipulations (gluPickMatrix() is used to "zoom" into the selection area).
	
	if (rm == Draw || rm == Erase || rm == Select || rm == Measure)
	{
		glRenderMode(GL_SELECT);
		iGLs vp[4]; glGetIntegerv(GL_VIEWPORT, vp);	// is this ok??? why not use the values directly?!?!!?
		
		// is this dependent on screen resolution or what???
		// there are some problems with selection in wireframe models...
		// GRH: This seems to help a bit, but the wireframe 
		// is stil "clipped" short, so you can't pick atoms
		// too far back
		gluPickMatrix(x, vp[3] - y, 2.0, 2.0, vp);	// is 2.0 ok???
	}	*/
	
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
	
	// set projection and call gluLookAt() to set up our "eye".
	
// PREFS: making this value bigger will make the left margin (for displaying text) bigger.
	fGL diagram_left_margin = 0.2 + 0.5;
	
	i32s width = size[0]; i32s height = size[1]; glViewport(0, 0, width, height);
	glOrtho(-diagram_left_margin, +1.2, center - scale * 0.5, center + scale * 0.5, -0.5, +1.5);
	glMatrixMode(GL_MODELVIEW); glLoadIdentity();
	
	gluLookAt(0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0);
	
// render...
// render...
// render...

	const fGL default_label_color[3] = { 1.0, 1.0, 1.0 };
	fGL *label_color = model_prefs->ColorRGB("Graphics/LabelColor", default_label_color);

	glInitNames();
	if (!mdl->current_eng)		// print out a message if we have no data...
	{
		glColor3f(label_color[0], label_color[1], label_color[2]);
		glDisable(GL_DEPTH_TEST);
		
		glPushMatrix();
		glLoadIdentity();
		
		glMatrixMode(GL_PROJECTION);
		glPushMatrix(); glLoadIdentity();
		gluOrtho2D(0, size[0], 0, size[1]);
		
		fGL xpos; fGL ypos;
		void * font = GLUT_BITMAP_TIMES_ROMAN_24;
		
		const char * txt1 = "No data available,";
		xpos = (size[0] - GetBitmapStringWidth(font, txt1)) / 2.0; ypos = (size[1] - 24) / 2.0 + 14;
		glRasterPos2f(xpos, ypos); WriteBitmapString(font, txt1);
		
		const char * txt2 = "please calculate energy!";
		xpos = (size[0] - GetBitmapStringWidth(font, txt2)) / 2.0; ypos = (size[1] - 24) / 2.0 - 14;
		glRasterPos2f(xpos, ypos); WriteBitmapString(font, txt2);
		
		glPopMatrix();
		glMatrixMode(GL_MODELVIEW);
		
		glPopMatrix();
		glEnable(GL_DEPTH_TEST);
	}
	else	// ...or otherwise render the diagram.
	{
		fGL one_pixel_height = scale / (fGL) height;
		
// PREFS: making this value bigger will make lines thicker (the value is in pixels).
		fGL diagram_line_thickness = model_prefs->Double("ELGraphics/LineWidth", 2.0);
// PREFS: making this value bigger will make triangles taller (the value is in pixels).
		fGL diagram_triangle_height = model_prefs->Double("ELGraphics/TriangleHeight", 30.0);
// PREFS: making this value bigger will make lines wider.
		fGL diagram_triangle_width = model_prefs->Double("ELGraphics/TriangleWidth", 0.1);
		
		for (i32s n1 = 0;n1 < mdl->current_eng->GetOrbitalCount();n1++)
		{
			fGL energy = mdl->current_eng->GetOrbitalEnergy(n1);
			
			// draw the line...
			// draw the line...
			// draw the line...
			
			glColor3f(0.0, 1.0, 0.0);	// green
			glBegin(GL_QUADS);
			
			glVertex3f(1.0, energy, 0.1);
			glVertex3f(0.0, energy, 0.1);
			glVertex3f(0.0, energy + one_pixel_height * diagram_line_thickness, 0.1);
			glVertex3f(1.0, energy + one_pixel_height * diagram_line_thickness, 0.1);
			
			glEnd();
			
			// draw the electrons...
			// draw the electrons...
			// draw the electrons...
			
			if (n1 < mdl->current_eng->GetElectronCount() / 2)
			{
				glColor3f(1.0, 1.0, 0.0);	// yellow
				glBegin(GL_TRIANGLES);
				
				glVertex3f(0.3 - diagram_triangle_width, energy - one_pixel_height * diagram_triangle_height / 3.0, 0.0);
				glVertex3f(0.3, energy + one_pixel_height * diagram_triangle_height / 1.5, 0.0);
				glVertex3f(0.3 + diagram_triangle_width, energy - one_pixel_height * diagram_triangle_height / 3.0, 0.0);
				
				glVertex3f(0.7 - diagram_triangle_width, energy + one_pixel_height * diagram_triangle_height / 3.0, 0.0);
				glVertex3f(0.7, energy - one_pixel_height * diagram_triangle_height / 1.5, 0.0);
				glVertex3f(0.7 + diagram_triangle_width, energy + one_pixel_height * diagram_triangle_height / 3.0, 0.0);
				
				glEnd();
			}
			
			// print out the text...
			// print out the text...
			// print out the text...
			
			glColor3f(label_color[0], label_color[1], label_color[2]);
			glDisable(GL_DEPTH_TEST);
			
			glPushMatrix();
			glLoadIdentity();
			
			glMatrixMode(GL_PROJECTION);
			glPushMatrix(); glLoadIdentity();
			gluOrtho2D(0, size[0], 0, size[1]);
			
			fGL xpos; fGL ypos;
			void * font = GLUT_BITMAP_TIMES_ROMAN_10;
			
			char txt[256];
			ostrstream str(txt, sizeof(txt));
			str << "i = " << n1 << " e = " << energy << ends;
			
			xpos = 10;
			ypos = ((energy - center) / scale + 0.5) * size[1] - 5;		// 5 comes from font height 10...
			glRasterPos2f(xpos, ypos); WriteBitmapString(font, txt);
			
			glPopMatrix();
			glMatrixMode(GL_MODELVIEW);
			
			glPopMatrix();
			glEnable(GL_DEPTH_TEST);
		}
	}
	
	// if this was a selection operation, read the information from the selection buffer.
/*
	if (rm == Draw || rm == Erase || rm == Select || rm == Measure)
	{
		i32s tmp1 = glRenderMode(GL_RENDER);
		i32s tmp2 = NOT_DEFINED;
		
		iGLu tmp3 = 0xffffffff;		// original, lowest z-value...
		//iGLu tmp3 = 0x00000000;	// modified, highest z-value...
	
		// here we examine the selection buffer and select the hit with lowest
		// z-value (since we assume that this object was visible to the user).
		
// HAS THIS SELECTION-LOGIC CHANGED LATELY?!?!?! THIS WAS DONE AT 1998 "BY THE BOOK" AND I THINK
// IT WORKED CORRECTLY. BUT NOW THE OLD CODE SEEMS TO PICK ALWAYS FROM BACK, NOT FROM FRONT?!?!?!

// 2001-june : now it works again wrong -> changed back to original settings. maybe it's now it should be...

		i32s tmp4[2] = { 0, 0 };
		while (tmp4[0] < tmp1)
		{
			if (gv->GetDV()->select_buffer[tmp4[1] + 1] < tmp3)	// original, lowest z-value...
			//if (gv->GetDV()->select_buffer[tmp4[1] + 2] > tmp3)	// modified, highest z-value...
			{
				tmp2 = tmp4[1];
				tmp3 = gv->GetDV()->select_buffer[tmp4[1] + 1];		// original, lowest z-value...
				//tmp3 = gv->GetDV()->select_buffer[tmp4[1] + 2];	// modified, highest z-value...
			}
			
			tmp4[0]++;
			tmp4[1] += gv->GetDV()->select_buffer[tmp4[1]] + 3;
		}
		
		// now we copy all name records of the selected hit...
		
		vector<iGLu> name_vector;
		if (tmp2 != NOT_DEFINED)
		{
			for (i32u i1 = 0;i1 < gv->GetDV()->select_buffer[tmp2];i1++)
			{
				name_vector.push_back(gv->GetDV()->select_buffer[tmp2 + i1 + 3]);
			}
		}
		
		// "draw"- and "erase"-events are always forwarded to the docv-object:
		// "draw"- and "erase"-events are always forwarded to the docv-object:
		// "draw"- and "erase"-events are always forwarded to the docv-object:
		
		if (rm == Draw) gv->GetDV()->DrawEvent(gv, name_vector);
		if (rm == Erase) gv->GetDV()->EraseEvent(gv, name_vector);
		
		if (rm == Measure && name_vector.size() > 1)
		{
			bool test = (name_vector[0] & GLNAME_MODEL_DEPENDENT);
			if (test)
			{
				if (gv->GetDV()->selected_object != NULL)
				{
					gv->GetDV()->selected_object = NULL;
					gv->GetDV()->event_SelectedObjectChanged();
				}
				
				gv->GetDV()->MeasureEvent(gv, name_vector);
			}
		}

		// "select"-events are forwarded only if they are MODEL_DEPENDENT:
		// "select"-events are forwarded only if they are MODEL_DEPENDENT:
		// "select"-events are forwarded only if they are MODEL_DEPENDENT:
		
		if (rm == Select && name_vector.size() > 1)
		{
			bool test = (name_vector[0] & GLNAME_MODEL_DEPENDENT);
			if (test)
			{
				if (gv->GetDV()->selected_object != NULL)
				{
					gv->GetDV()->selected_object = NULL;
					gv->GetDV()->event_SelectedObjectChanged();
				}
				
				gv->GetDV()->SelectEvent(gv, name_vector);
			}
			else
			{
				switch (name_vector[0])
				{
					case GLNAME_LIGHT:
					gv->GetDV()->SelectLight((const dummy_object *) name_vector[1]);
					break;
					
					case GLNAME_OBJECT:
					gv->GetDV()->SelectObject((const dummy_object *) name_vector[1]);
					break;
				} // switch
			} // test
		} // select
	}*/
}

/*################################################################################################*/

#ifdef ENABLE_TREELIST_VIEW

treelist_view::treelist_view() : view()
{
}

treelist_view::~treelist_view(void)
{
}

#endif	// ENABLE_TREELIST_VIEW

/*################################################################################################*/

#endif	// ENABLE_GRAPHICS

// eof
