// T1MAIN.CPP

// Copyright (C) 1998 Tommi Hassinen.

// This program is free software; you can redistribute it and/or modify it
// under the terms of the license (GNU GPL) which comes with this package.

/*################################################################################################*/

#include "t1main.h"
#include "notice.h"

#include "mm1mdl.h"
#include "mm1eng9.h"
#include "mm1alg.h"

/*################################################################################################*/

int main(int, char **)
{
	print_full_copyright_notice(cout);
	
	// this is just an example: will open a file and optimize geometry...
	// this is just an example: will open a file and optimize geometry...
	// this is just an example: will open a file and optimize geometry...
	
	// create a model object, and read in a file:
	
	mm1_mdl * mdl = new mm1_mdl(& cout, * console_class_factory::GetInstance());
	
	cout << "trying to open a file... ";
	
	ifstream ifile;
	ifile.open("examples/2-chlorobutane.mm1gp", ios::in);
	
	if (ifile.fail())
	{
		cout << "failed!!!" << endl;
		
		ifile.close();
		delete mdl;
		
		return -1;
	}
	
	cout << "ok!!!" << endl;
	
	mdl->ReadStream(ifile);
	ifile.close();
	
	// if everything went fine, then create a computation engine object, initialize it,
	// and create a geometry optimizer object using the computation engine object:
	
	mm1_eng * eng = new mm1_eng_exp9((* mdl), 1, 0);
	
	CopyCRD(mdl, eng, 0);
	
	mm1_geomopt * opt = new mm1_geomopt(eng, 100, 0.025);
	
	// then take 100 geometry optimization steps, and print out some data about progess:
	
	for (int n1 = 0;n1 < 100;n1++)
	{
		opt->TakeCGStep(conjugate_gradient::Newton2An);
		
		cout << "step = " << (n1 + 1) << "   ";
		cout << "energy = " << opt->optval << "   ";
		cout << "step length = " << opt->optstp << endl;
	}
	
	// finally release all allocated memory and leave:
	
	delete opt;
	delete eng;
	
	delete mdl;
	
	return 0;
}

/*################################################################################################*/

// eof
