// T2MM1DOCV.CPP

// Copyright (C) 1998 Tommi Hassinen.

// This program is free software; you can redistribute it and/or modify it
// under the terms of the license (GNU GPL) which comes with this package.

/*################################################################################################*/

#include "t2mm1docv.h"

#include "mm1ic.h"
#include "mm1alg.h"
#include "mm1eng1.h"
#include "mm1eng9.h"

#include "mm1rbn.h"

#include "plane.h"
#include "surface.h"

#include "color.h"
#include "views.h"

#include "filetrans.h"

#include <fstream>
#include <strstream>
using namespace std;

/*################################################################################################*/

glut_mm1_docv::glut_mm1_docv(ostream * p1, glut_class_factory & p2) :
	glut_docv(p1, p2), mm1_docv(p1, p2), docview(p1, p2), model_simple(p1, p2)
{
}

glut_mm1_docv::~glut_mm1_docv(void)
{
}

void glut_mm1_docv::KeyEvent(graphics_view * gv, char key, int, int)
{
	ifstream ifile;
	ofstream ofile;
	
	i32s n1;
	i32s t1a; //i32s t1b;
	char input;
	
	mm1_eng * eng;

	mm1_readpdb_mdata * mdata;
	
	char seq[1024];
	f64 aab_ah[] = { 302.0 * M_PI / 180.0, 313.0 * M_PI / 180.0, M_PI };
	f64 aab_bs[] = { 180.0 * M_PI / 180.0, 180.0 * M_PI / 180.0, M_PI };
	
	f64 nab[] =
	{
		44.6 * M_PI / 180.0, 261.0 * M_PI / 180.0, 320.8 * M_PI / 180.0, 208.6 * M_PI / 180.0,
		273.8 * M_PI / 180.0, 105.6 * M_PI / 180.0, 356.0 * M_PI / 180.0, 24.7 * M_PI / 180.0,
		88.7 * M_PI / 180.0, 264.6 * M_PI / 180.0
	};
	
	fGL tmp1; fGL tmp2;
	i32s sz[3] = { 50, 50, 50 };
	fGL dm[3] = { 0.55, 0.50, 0.45 };
	
	cp_param cpp;
	cpp.np = 30; cpp.docv = this; cpp.ref = (mm1_docv *) this;
	
	cs_param csp1;
	csp1.np = sz; csp1.dim = dm; csp1.ostr = & cout;
	csp1.docv = this; csp1.ref = (mm1_docv *) this; csp1.next = NULL;
	
	cs_param csp2a; cs_param csp2b;
	csp2a.np = sz; csp2a.dim = dm; csp2a.ostr = & cout;
	csp2a.docv = this; csp2a.ref = (mm1_docv *) this; csp2a.next = & csp2b;
	csp2b.np = sz; csp2b.dim = dm; csp2b.ostr = & cout;
	csp2b.docv = this; csp2b.ref = (mm1_docv *) this; csp2b.next = NULL;
	
	mm1_geomopt_param goparam;
	mm1_moldyn_param mdparam;
	
	char txtbuff[1024];
	
	switch (key)
	{
		case 'h':
		cout << "+ -       -> change the current element" << endl;
		cout << "< >       -> change the current bondtype" << endl;
		cout << "b B       -> build sequences (amino/nucleic acids)" << endl;
		cout << "C         -> change color modes" << endl;
		cout << "r         -> change rendering modes (without updating view)" << endl;
		cout << "Q         -> change labels" << endl;
		cout << "i         -> import ENT files" << endl;
		cout << "O         -> open a file" << endl;
		cout << "S         -> save to a file" << endl;
		cout << "H         -> hydrogens, add or remove" << endl;
		cout << "p         -> add (or \"push\") a new coordinate set" << endl;
		cout << "e w n m   -> make some nice planes/surfaces..." << endl;
		cout << "t         -> build a protein ribbon model" << endl;
		cout << "z         -> compare numerical and analytical gradient" << endl;
	//	cout << "W         -> change the default_eng" << endl;
		cout << "E         -> compute energy [kJ/mol]" << endl;
		cout << "o         -> geometry optimization..." << endl;
		cout << "d         -> molecular dynamics..." << endl;
		cout << "R         -> random conformational search" << endl;
		cout << "X         -> trajectory mode on/off" << endl;
		cout << "1 2 7     -> (in traj-mode) get prev/next/desired frame" << endl;
		cout << "5         -> (in traj-mode) play the trajectory file" << endl;
		break;
		
		case '+': ++element::current_element;
		cout << "current element = " << element::current_element.GetAtomicNumber();
		cout << " " << element::current_element.GetSymbol() << endl;
		break;
		
		case '-': --element::current_element;
		cout << "current element = " << element::current_element.GetAtomicNumber();
		cout << " " << element::current_element.GetSymbol() << endl;
		break;
		
		case '<': ++bondtype::current_bondtype;
		cout << "current bondtype = " << bondtype::current_bondtype << endl;
		break;
		
		case '>': --bondtype::current_bondtype;
		cout << "current bondtype = " << bondtype::current_bondtype << endl;
		break;
		
		case 'b':
		cout << "give the sequence using symbols ARNDCQEGHILKMFPSTWYV ???"; cin >> seq;
		cout << "please select the conformation : H = helix, S = sheet ???"; cin >> input;
		mm1_mdl::amino_builder.Build(this, seq, input == 'h' || input == 'H' ? aab_ah : aab_bs);
		UpdateAllGraphicsViews();
		break;
		
		case 'B':
		cout << "give the sequence using symbols AGTC and aguc ???"; cin >> seq;
		mm1_mdl::nucleic_builder.Build(this, seq, nab);
		UpdateAllGraphicsViews();
		break;
		
		case 'C':
		if (gv->colormode == & mm1_docv::cm_element) gv->colormode = & mm1_docv::cm_state;
		else if (gv->colormode == & mm1_docv::cm_state) gv->colormode = & mm1_docv::cm_element;
		UpdateAllGraphicsViews();
		break;
		
		case 'r':
		cout << "rendering = ";
		switch (gv->render)
		{
			case RENDER_NOTHING:
			gv->render = RENDER_WIREFRAME;
			cout << "RENDER_WIREFRAME";
			break;
			
			case RENDER_WIREFRAME:
			gv->render = RENDER_BALL_AND_STICK;
			cout << "RENDER_BALL_AND_STICK";
			break;
			
			case RENDER_BALL_AND_STICK:
			gv->render = RENDER_VAN_DER_WAALS;
			cout << "RENDER_VAN_DER_WAALS";
			break;
			
			case RENDER_VAN_DER_WAALS:
			gv->render = RENDER_CYLINDERS;
			cout << "RENDER_CYLINDERS";
			break;
			
			case RENDER_CYLINDERS:
			gv->render = RENDER_NOTHING;
			cout << "RENDER_NOTHING";
			break;
		}
		cout << endl;
		break;
		
		case 'Q':
		cout << "label = ";
		switch (gv->label)
		{
			case LABEL_NOTHING:
			gv->label = LABEL_ELEMENT;
			cout << "LABEL_ELEMENT";
			break;
			
			case LABEL_ELEMENT:
			gv->label = LABEL_BONDTYPE;
			cout << "LABEL_BONDTYPE";
			break;
			
			case LABEL_BONDTYPE:
			gv->label = LABEL_NOTHING;
			cout << "LABEL_NOTHING";
			break;
		}
		cout << endl;
		break;
		
		case 'i':
		cout << "name of ENT file to import ??? "; cin >> txtbuff;
		
		mdata = readpdb_ReadMData(txtbuff);
		cout << "give the index of chain to be imported, or -1 to import all ??? "; cin >> n1;
		readpdb_ReadData(txtbuff, mdata, n1); delete mdata;
		
		UpdateAllGraphicsViews();
		break;
		
		case 'O':
		cout << "name of file to open ??? "; cin >> buffer;
		ifile.open(buffer, ios::in); ReadStream(ifile); ifile.close();
		UpdateAllGraphicsViews();
		break;
		
		case 'S':
		cout << "name of file to save ??? "; cin >> buffer;
		ofile.open(buffer, ios::out); WriteStream(ofile); ofile.close();
		break;
		
		case 'H':
		cout << "hydrogens, add or remove ? (a/r) ";
		cin >> input;
		
		if (input == 'a')
		{
			cout << "adding hydrogens..." << endl;
			AddHydrogens(); UpdateAllGraphicsViews();
		}
		
		if (input == 'r')
		{
			cout << "removing hydrogens..." << endl;
			RemoveHydrogens(); UpdateAllGraphicsViews();
		}
		break;

		case 'p':
		PushCRDSets(1); t1a = cs_vector.size() - 1;
		while (t1a > 0) { CopyCRDSet(t1a - 1, t1a); t1a -= 1; }
		cs_vector.back().visible = true;
		UpdateAllGraphicsViews();
		break;
		
		case 'e':
		cout << "give dimension of the plane [nm] (1.0 might be ok) ??? "; cin >> tmp1;
		
		cpp.dim = tmp1; cpp.transparent = true;
		cpp.vf = (ValueFunction *) mm1_GetESPValue; cpp.cf = (ColorFunction *) GetRBRange1;
		cpp.value = 138.9354518 * 1.0; cpp.alpha = 0.75;
		
		AddObject(new color_plane_object(ol_static(), cpp, "ESP-"));
	//	UpdateAllGraphicsViews();
		break;
		
		case 'w':
		cout << "give dimension of the volume [nm] (1.0 might be ok) ??? "; cin >> tmp1;
		
		cpp.dim = tmp1; cpp.transparent = true;
		cpp.vf = (ValueFunction *) mm1_GetESPValue; cpp.cf = (ColorFunction *) GetRBRange2;
		cpp.value = 138.9354518 * 1.0; cpp.alpha = 0.25;
		
		AddObject(new volume_rendering_object(ol_static(), cpp, 20, tmp1 / 2.0, (* gv->cam), "ESP-"));
	//	UpdateAllGraphicsViews();
		break;
		
		case 'n': tmp1 = 138.9354518 / 4.0;
		cout << "give dimension of the surface [nm] (2.5 might be ok) ??? ";
		cin >> tmp2; dm[0] = dm[1] = dm[2] = tmp2;
		
		cout << "choose the type of surface : solid or wireframe ? (s/w) ";
		cin >> input; csp2a.wireframe = csp2b.wireframe = (input == 'w' || input == 'W');
		
		csp2a.transparent = !true;
		csp2a.vf1 = (ValueFunction *) mm1_GetESPValue; csp2a.vf2 = (ValueFunction *) GetUnity;
		csp2a.cvalue = 1.0; csp2a.alpha = 0.25; csp2a.toler = 1.0e-6 * tmp1; csp2a.maxc = 500;
			csp2a.cf = (ColorFunction *) GetRedColor; csp2a.svalue = +tmp1;
			
		csp2b.transparent = !true;
		csp2b.vf1 = (ValueFunction *) mm1_GetESPValue; csp2b.vf2 = (ValueFunction *) GetUnity;
		csp2b.cvalue = 1.0; csp2b.alpha = 0.25; csp2b.toler = 1.0e-6 * tmp1; csp2b.maxc = 500;
			csp2b.cf = (ColorFunction *) GetBlueColor; csp2b.svalue = -tmp1;
			
		AddObject(new color_surface_object(ol_static(), csp2a, "ESP-"));
	//	UpdateAllGraphicsViews();
		break;
		
		case 'm': tmp1 = 138.9354518 / 2.0;
		cout << "give dimension of the surface [nm] (2.5 might be ok) ??? ";
		cin >> tmp2; dm[0] = dm[1] = dm[2] = tmp2;
		
		cout << "choose the type of surface : solid or wireframe ? (s/w) ";
		cin >> input; csp1.wireframe = (input == 'w' || input == 'W');
		
		csp1.transparent = true; csp1.cf = (ColorFunction *) GetRBRange1;
		csp1.vf1 = (ValueFunction *) mm1_GetVDWSValue; csp1.vf2 = (ValueFunction *) mm1_GetESPValue;
		csp1.svalue = 1.0; csp1.cvalue = tmp1; csp1.alpha = 0.50; csp1.toler = 1.0e-6 * tmp1; csp1.maxc = 500;
		
		AddObject(new color_surface_object(ol_static(), csp1, "ESP-colored VDW-"));
	//	UpdateAllGraphicsViews();
		break;
				
		case 't':
		mm1_mdl::amino_builder.Identify(this);
		DefineSecondaryStructure(this);
		
		{	// USE LOCAL VARIABLES HERE...
			vector<mm1_chn_info> & ci_vector = (* this->ref_civ);
			for (i32u n1 = 0;n1 < ci_vector.size();n1++)
			{
				if (ci_vector[n1].length < 3) continue;
				else AddObject(new mm1_ribbon(this, gv->colormode, n1, 4));	// min. order is 2!!!
			}
		}
		
	//	UpdateAllGraphicsViews();
		break;
		
		case 'z':
/*	{	//LOCAL
		file_trans ft;
		OEMol * oem = ft.CopyAll(this);
		
	//	oem->SetOutputType(GHEMICAL);
	//	cout << (* oem) << endl;
	
		oem->AddHydrogens(false, false);
		
		ft.Synchronize();
		UpdateAllGraphicsViews();
	}	//LOCAL */
		eng = CreateDefaultEngine();
		CopyCRD(this, eng, 0); eng->Check(1);
		delete eng;
		break;
		
	//	case 'W':
	//	default_eng++; if (default_eng > 1) default_eng = 0;
	//	cout << "default_eng = " << engtab1[default_eng] << endl;
	//	break;
		
		case 'E':
		DoEnergy();
		break;
		
		case 'o':
		goparam.nsteps = 500;
		DoGeomOpt(goparam);
		break;
		
		case 'd':
		mdparam.nsteps = 10000;
		mdparam.temperature = 300.0;
		mdparam.timestep = 0.5;
		DoMolDyn(mdparam);
		break;
		
		case 'R':
		DoRandomSearch();
		break;
		
		case 'X':
		if (GetTrajectoryFile() != NULL)
		{
			cout << "traj mode off" << endl;
			CloseTrajectory();
		}
		else
		{
			cout << "traj mode on" << endl;
			cout << "traj-file name ??? "; cin >> buffer;
			OpenTrajectory(buffer);
		}
		break;
		
		case '1':
		case '2':
		case '7':
		if (GetTrajectoryFile() != NULL)
		{
			i32s frame = GetCurrentFrame();
			
			switch (key)
			{
				case '1':
				frame--; if (frame < 0) frame = 0;
				break;
				
				case '2':
				frame++; if (frame == GetTotalFrames()) frame = GetTotalFrames() - 1;
				break;
				
				default:
				cout << "give the frame (in correct range) ??? "; cin >> frame;
			}
			
			cout << "frame = " << frame << endl;
			
			SetCurrentFrame(frame);
			ReadFrame();
			
			UpdateAllGraphicsViews();
		} else cout << "in traj-mode only!!!" << endl;
		break;
		
		case '5':
		if (GetTrajectoryFile() != NULL)
		{
			for (i32s loop = 0;loop < GetTotalFrames();loop++)
			{
				SetCurrentFrame(loop);
				ReadFrame();
				
				UpdateAllGraphicsViews(true);
			}
		} else cout << "in traj-mode only!!!" << endl;
		break;
		
		default:
		cout << "unknown command '" << key << "'" << endl;
	}
}

/*##############################################*/
/*##############################################*/

void glut_mm1_docv::GeomOptGetParam(mm1_geomopt_param & param)
{
	cout << "how many cg-steps (" << param.nsteps << " might be Ok, -1 = cancel) ??? ";
	cin >> param.nsteps;
	
	param.confirm = !(param.nsteps < 0);
}

#define START 10000	// see mm1docv.cpp!!!!!!!!

void glut_mm1_docv::MolDynGetParam(mm1_moldyn_param & param)
{
	cout << "how many md-steps for simulation (" << param.nsteps << " might be Ok, -1 = cancel) ??? ";
	cin >> param.nsteps;
	
	param.confirm = !(param.nsteps < 0);
	if (!param.confirm) return;
	
	cout << "there are also " << START << " heating steps, total steps = " << (START + param.nsteps) << endl;
	cout << "the trajectory file will contain " << (param.nsteps / 100) << " frames!!!" << endl;
	
	cout << "simulation temperature [K] (" << param.temperature << " might be Ok) ??? ";
	cin >> param.temperature;
	
	cout << "time-step length [fs] (" << param.timestep << " might be Ok) ??? ";
	cin >> param.timestep;
	
	cout << "traj-file name ??? ";
	cin >> param.filename;
}

/*################################################################################################*/

// eof
