// T2QM1DOCV.CPP

// Copyright (C) 2000 Tommi Hassinen.

// This program is free software; you can redistribute it and/or modify it
// under the terms of the license (GNU GPL) which comes with this package.

/*################################################################################################*/

#include "t2qm1docv.h"

#include "qm1e_mopac.h"
#include "qm1e_mpqc.h"

#include "plane.h"
#include "surface.h"

#include "color.h"
#include "views.h"

/*################################################################################################*/

glut_qm1_docv::glut_qm1_docv(ostream * p1, glut_class_factory & p2) :
	glut_docv(p1, p2), qm1_docv(p1, p2), docview(p1, p2), model_simple(p1, p2)
{
}

glut_qm1_docv::~glut_qm1_docv(void)
{
}

void glut_qm1_docv::KeyEvent(graphics_view * gv, char key, int, int)
{
	fGL tmp1; fGL tmp2;
	
	// we use less points here in planes, surfaces and such things to make them work faster...
	// we use less points here in planes, surfaces and such things to make them work faster...
	// we use less points here in planes, surfaces and such things to make them work faster...
	
	i32s sz[3] = { 25, 25, 25 };
	fGL dm[3] = { 0.55, 0.50, 0.45 };
	
	cp_param cpp;
	cpp.np = 15; cpp.docv = this; cpp.ref = current_eng;
	
	cs_param csp1;
	csp1.np = sz; csp1.dim = dm; csp1.ostr = & cout;
	csp1.docv = this; csp1.ref = current_eng; csp1.next = NULL;
	
	cs_param csp2a; cs_param csp2b;
	csp2a.np = sz; csp2a.dim = dm; csp2a.ostr = & cout;
	csp2a.docv = this; csp2a.ref = current_eng; csp2a.next = & csp2b;
	csp2b.np = sz; csp2b.dim = dm; csp2b.ostr = & cout;
	csp2b.docv = this; csp2b.ref = current_eng; csp2b.next = NULL;
	
	char input;

	qm1_geomopt_param goparam;
	
	switch (key)
	{
		case 'h':
		cout << "+ -       -> change the current element" << endl;
		cout << "< >       -> change the current orbital" << endl;
		cout << "r         -> change rendering modes (without updating view)" << endl;
		cout << "i         -> import MM1-files" << endl;
		cout << "z         -> compare numerical and analytical gradient" << endl;
		cout << "W         -> change the default_eng" << endl;
		cout << "E         -> compute energy [Hartrees]" << endl;
		cout << "Q         -> add an energy-level diagram" << endl;
		cout << "f F       -> create electrostatic potential plane/surface" << endl;
		cout << "B         -> create ESP-colored VDW-surface" << endl;
		cout << "g G       -> create electron density plane/surface" << endl;
		cout << "n N J     -> create molecular orbital plane/surface/volume" << endl;
		cout << "m M       -> create MO-density plane/surface" << endl;
		break;
		
		case '+': ++element::current_element;
		cout << "current element = " << element::current_element.GetAtomicNumber();
		cout << " " << element::current_element.GetSymbol() << endl;
		break;
		
		case '-': --element::current_element;
		cout << "current element = " << element::current_element.GetAtomicNumber();
		cout << " " << element::current_element.GetSymbol() << endl;
		break;
		
		case '>': current_orbital++;
		cout << "current orbital = " << current_orbital << " ";
		cout << "(BE CAREFUL, THERE'S NO BOUNDS CHECKING YET!!!)" << endl;
		break;
		
		case '<': current_orbital--;
		cout << "current orbital = " << current_orbital << " ";
		cout << "(BE CAREFUL, THERE'S NO BOUNDS CHECKING YET!!!)" << endl;
		break;
		
		case 'r':
		cout << "rendering = ";
		switch (gv->render)
		{
			case RENDER_NOTHING:
			gv->render = RENDER_WIREFRAME;
			cout << "RENDER_WIREFRAME";
			break;
			
			case RENDER_WIREFRAME:
			gv->render = RENDER_BALL_AND_STICK;
			cout << "RENDER_BALL_AND_STICK";
			break;
			
			case RENDER_BALL_AND_STICK:
			gv->render = RENDER_NOTHING;
			cout << "RENDER_NOTHING";
			break;
		}
		cout << endl;
		break;
		
		case 'i':
		cout << "name of file to import ??? ";
		cin >> buffer;
		
		ImportMM1(buffer);
		UpdateAllGraphicsViews();
		break;

		case 'z':
		if (!current_eng) current_eng = CreateDefaultEngine();
		CopyCRD(this, current_eng, 0); current_eng->Check(1);
		break;
		
		case 'W':
		default_eng++; if (default_eng > 1) default_eng = 0;
		cout << "default_eng = " << engtab1[default_eng] << endl;
		break;
		
		case 'E':
		DoEnergy();
		break;
		
		case 'Q':
		AddEnLevDiagView();
		break;
		
		case 'o':
		goparam.nsteps = 250;
		DoGeomOpt(goparam);
		break;
		
		case 'f':
if (!current_eng) { cout << "calculate energy first!!!" << endl; break; }
		cout << "give dimension of the plane [nm] (0.5 might be ok) ??? "; cin >> tmp1;
		
		cpp.dim = tmp1; cpp.transparent = true;
		cpp.vf = (ValueFunction *) qm1_eng::getESP; cpp.cf = (ColorFunction *) GetRBRange1;
		cpp.value = 138.9354518 * 1.0; cpp.alpha = 0.75;
		
		AddObject(new color_plane_object(ol_static(), cpp, "ESP-"));
	//	UpdateAllGraphicsViews();
		break;
		
		case 'F': tmp1 = 138.9354518 / 4.0;
if (!current_eng) { cout << "calculate energy first!!!" << endl; break; }
		cout << "give dimension of the surface [nm] (1.0 might be ok) ??? ";
		cin >> tmp2; dm[0] = dm[1] = dm[2] = tmp2;
		
		cout << "choose the type of surface : solid or wireframe ? (s/w) ";
		cin >> input; csp2a.wireframe = csp2b.wireframe = (input == 'w' || input == 'W');
		
		csp2a.transparent = !true;
		csp2a.vf1 = (ValueFunction *) qm1_eng::getESP; csp2a.vf2 = (ValueFunction *) GetUnity;
		csp2a.cvalue = 1.0; csp2a.alpha = 0.35; csp2a.toler = 1.0e-6 * tmp1; csp2a.maxc = 50;	// slow!!!
			csp2a.cf = (ColorFunction *) GetRedColor; csp2a.svalue = +tmp1;
			
		csp2b.transparent = !true;
		csp2b.vf1 = (ValueFunction *) qm1_eng::getESP; csp2b.vf2 = (ValueFunction *) GetUnity;
		csp2b.cvalue = 1.0; csp2b.alpha = 0.35; csp2b.toler = 1.0e-6 * tmp1; csp2b.maxc = 50;	// slow!!!
			csp2b.cf = (ColorFunction *) GetBlueColor; csp2b.svalue = -tmp1;
			
		AddObject(new color_surface_object(ol_static(), csp2a, "ESP-"));
	//	UpdateAllGraphicsViews();
		break;
		
		case 'B': tmp1 = 138.9354518 / 2.0;
if (!current_eng) { cout << "calculate energy first!!!" << endl; break; }
		cout << "give dimension of the surface [nm] (1.0 might be ok) ??? ";
		cin >> tmp2; dm[0] = dm[1] = dm[2] = tmp2;
		
		cout << "choose the type of surface : solid or wireframe ? (s/w) ";
		cin >> input; csp1.wireframe = (input == 'w' || input == 'W');
		
		csp1.transparent = true; csp1.cf = (ColorFunction *) GetRBRange1;
		csp1.vf1 = (ValueFunction *) qm1_eng::getVDWSurface; csp1.vf2 = (ValueFunction *) qm1_eng::getESP;
		csp1.svalue = 1.0; csp1.cvalue = tmp1; csp1.alpha = 0.50; csp1.toler = 1.0e-6 * tmp1; csp1.maxc = 250;
		
		AddObject(new color_surface_object(ol_static(), csp1, "ESP-colored VDW-"));
	//	UpdateAllGraphicsViews();
		break;
		
		case 'g':
if (!current_eng) { cout << "calculate energy first!!!" << endl; break; }
		cout << "give dimension of the plane [nm] (0.5 might be ok) ??? "; cin >> tmp1;
		
		cpp.dim = tmp1; cpp.transparent = true;
		cpp.vf = (ValueFunction *) qm1_eng::getElDens; cpp.cf = (ColorFunction *) GetGreenColor;
		cpp.value = 0.05; cpp.alpha = 0.75;
		
		AddObject(new color_plane_object(ol_static(), cpp, "E-density "));
	//	UpdateAllGraphicsViews();
		break;
		
		case 'G': tmp1 = 0.05;
if (!current_eng) { cout << "calculate energy first!!!" << endl; break; }
		cout << "give dimension of the surface [nm] (1.0 might be ok) ??? ";
		cin >> tmp2; dm[0] = dm[1] = dm[2] = tmp2;
		
		cout << "choose the type of surface : solid or wireframe ? (s/w) ";
		cin >> input; csp1.wireframe = (input == 'w' || input == 'W');
		
		csp1.transparent = true; csp1.cf = (ColorFunction *) GetGreenColor;
		csp1.vf1 = (ValueFunction *) qm1_eng::getElDens; csp1.vf2 = (ValueFunction *) GetUnity;
		csp1.svalue = tmp1; csp1.cvalue = 1.0; csp1.alpha = 0.50; csp1.toler = 1.0e-6 * tmp1; csp1.maxc = 250;
		
		AddObject(new color_surface_object(ol_static(), csp1, "E-density "));
	//	UpdateAllGraphicsViews();
		break;
		
		case 'n':
if (!current_eng) { cout << "calculate energy first!!!" << endl; break; }
		cout << "give dimension of the plane [nm] (0.5 might be ok) ??? "; cin >> tmp1;
		
		cpp.dim = tmp1; cpp.transparent = true;
		cpp.vf = (ValueFunction *) qm1_eng::getOrbital; cpp.cf = (ColorFunction *) GetRBRange1;
		cpp.value = 0.05; cpp.alpha = 0.75;
		
		AddObject(new color_plane_object(ol_static(), cpp, "molecular orbital "));
	//	UpdateAllGraphicsViews();
		break;
		
		case 'N': tmp1 = 0.05;
if (!current_eng) { cout << "calculate energy first!!!" << endl; break; }
		cout << "give dimension of the surface [nm] (1.0 might be ok) ??? ";
		cin >> tmp2; dm[0] = dm[1] = dm[2] = tmp2;
		
		cout << "choose the type of surface : solid or wireframe ? (s/w) ";
		cin >> input; csp2a.wireframe = csp2b.wireframe = (input == 'w' || input == 'W');
		
		csp2a.transparent = !true;
		csp2a.vf1 = (ValueFunction *) qm1_eng::getOrbital; csp2a.vf2 = (ValueFunction *) GetUnity;
		csp2a.cvalue = 1.0; csp2a.alpha = 0.50; csp2a.toler = 1.0e-6 * tmp1; csp2a.maxc = 250;
			csp2a.cf = (ColorFunction *) GetRedColor; csp2a.svalue = +tmp1;
			
		csp2b.transparent = !true;
		csp2b.vf1 = (ValueFunction *) qm1_eng::getOrbital; csp2b.vf2 = (ValueFunction *) GetUnity;
		csp2b.cvalue = 1.0; csp2b.alpha = 0.50; csp2b.toler = 1.0e-6 * tmp1; csp2b.maxc = 250;
			csp2b.cf = (ColorFunction *) GetBlueColor; csp2b.svalue = -tmp1;
			
		AddObject(new color_surface_object(ol_static(), csp2a, "MO "));
	//	UpdateAllGraphicsViews();
		break;
		
		case 'J':
		cout << "give dimension of the volume [nm] (1.0 might be ok) ??? "; cin >> tmp1;
		
		cpp.dim = tmp1; cpp.transparent = true;
		cpp.vf = (ValueFunction *) qm1_eng::getOrbital; cpp.cf = (ColorFunction *) GetRBRange2;
		cpp.value = 0.05; cpp.alpha = 0.25;
		
		AddObject(new volume_rendering_object(ol_static(), cpp, 20, tmp1 / 2.0, (* gv->cam), "MO "));
	//	UpdateAllGraphicsViews();
		break;
		
		case 'm':
if (!current_eng) { cout << "calculate energy first!!!" << endl; break; }
		cout << "give dimension of the plane [nm] (0.5 might be ok) ??? "; cin >> tmp1;
		
		cpp.dim = tmp1; cpp.transparent = true;
		cpp.vf = (ValueFunction *) qm1_eng::getOrbDens; cpp.cf = (ColorFunction *) GetGreenColor;
		cpp.value = 0.0125; cpp.alpha = 0.75;
		
		AddObject(new color_plane_object(ol_static(), cpp, "MO-density "));
	//	UpdateAllGraphicsViews();
		break;
		
		case 'M': tmp1 = 0.0125;
if (!current_eng) { cout << "calculate energy first!!!" << endl; break; }
		cout << "give dimension of the surface [nm] (1.0 might be ok) ??? ";
		cin >> tmp2; dm[0] = dm[1] = dm[2] = tmp2;
		
		cout << "choose the type of surface : solid or wireframe ? (s/w) ";
		cin >> input; csp1.wireframe = (input == 'w' || input == 'W');
		
		csp1.transparent = true; csp1.cf = (ColorFunction *) GetGreenColor;
		csp1.vf1 = (ValueFunction *) qm1_eng::getOrbDens; csp1.vf2 = (ValueFunction *) GetUnity;
		csp1.svalue = tmp1; csp1.cvalue = 1.0; csp1.alpha = 0.50; csp1.toler = 1.0e-6 * tmp1; csp1.maxc = 250;
		
		AddObject(new color_surface_object(ol_static(), csp1, "MO-density "));
	//	UpdateAllGraphicsViews();
		break;
	}
}

void glut_qm1_docv::GeomOptGetParam(qm1_geomopt_param & param)
{
	cout << "how many cg-steps (" << param.nsteps << " might be Ok, -1 = cancel) ??? ";
	cin >> param.nsteps;
	
	param.confirm = !(param.nsteps < 0);
}

/*################################################################################################*/

// eof
