#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>

/*################*/
/*################*/

#include <iomanip>
#include <strstream>
using namespace std;

#include "filetrans.h"
#include "t3qm1docv.h"
#include "t3mm1docv.h"
#include "t3mm2docv.h"

/*################*/
/*################*/

#include "glade_callbacks.h"
#include "glade_interface.h"
#include "glade_support.h"

void
on_e1_button_ok_clicked                (GtkButton       *button,
                                        gpointer         user_data)
{
	gnome_qm1_docv * owner = dynamic_cast<gnome_qm1_docv *>(gnome_docv::glade_modal_dialog_owner);
	if (!owner) cout << "ERROR: cast failed in on_e1_button_ok_clicked()." << endl;
	else
	{
		// get the total charge...
		
		GtkWidget * entry = lookup_widget(GTK_WIDGET(button), "e1_entry_tc");
		gchar * buffer = gtk_entry_get_text(GTK_ENTRY(entry));
		
		istrstream istr(buffer, strlen(buffer) + 1);
		i32s value; istr >> value;
		
		owner->SetTotalCharge(value);
		
		// get the engine index, and do the necessary settings...
		
		GtkWidget * optionmenu = lookup_widget(GTK_WIDGET(button), "e1_optionmenu_eng");
		GtkWidget * menu = gtk_option_menu_get_menu(GTK_OPTION_MENU(optionmenu));
		GtkWidget * item = gtk_menu_get_active(GTK_MENU(menu));
		
		int index = g_list_index(GTK_MENU_SHELL(menu)->children, item);
		owner->default_eng = index;
		
		owner->DiscardCurrentEng();
		
		// perform a sanity check to give feedback to user, and don't close dialog if failed...
		// perform a sanity check to give feedback to user, and don't close dialog if failed...
		// perform a sanity check to give feedback to user, and don't close dialog if failed...
		
		if (owner->CheckEngSettings() == false) return;
	}
	
	// close the dialog...
	
	GtkWidget * dialog = lookup_widget(GTK_WIDGET(button), "e1_dialog_qm1_setup");
	gtk_widget_destroy(dialog);
}


void
on_e1_button_cancel_clicked            (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget * dialog = lookup_widget(GTK_WIDGET(button), "e1_dialog_qm1_setup");
	gtk_widget_destroy(dialog);
}


void
on_e2_button_ok_clicked                (GtkButton       *button,
                                        gpointer         user_data)
{
	gnome_mm1_docv * owner = dynamic_cast<gnome_mm1_docv *>(gnome_docv::glade_modal_dialog_owner);
	if (!owner) cout << "ERROR: cast failed in on_e2_button_ok_clicked()." << endl;
	else
	{
		// get the periodic box dimensions...
		
		for (int n1 = 0;n1 < 3;n1++)
		{
			GtkWidget * entry;
			
			switch (n1)
			{
				case 0:
				entry = lookup_widget(GTK_WIDGET(button), "e2_entry_dimx");
				break;
				
				case 1:
				entry = lookup_widget(GTK_WIDGET(button), "e2_entry_dimy");
				break;
				
				default:
				entry = lookup_widget(GTK_WIDGET(button), "e2_entry_dimz");
			}
			
			gchar * buffer = gtk_entry_get_text(GTK_ENTRY(entry));
			
			istrstream istr(buffer, strlen(buffer) + 1);
			double value; istr >> value;
			
			owner->box_hdim[n1] = value / 2.0;
			owner->box_fdim[n1] = value;
		}
		
		// get the engine index, and do the necessary settings...
		
		GtkWidget * optionmenu = lookup_widget(GTK_WIDGET(button), "e2_optionmenu_eng");
		GtkWidget * menu = gtk_option_menu_get_menu(GTK_OPTION_MENU(optionmenu));
		GtkWidget * item = gtk_menu_get_active(GTK_MENU(menu));
		
		int index = g_list_index(GTK_MENU_SHELL(menu)->children, item);
		owner->default_eng = index;
		
		bool old_periodic = owner->periodic;
		
		if (!old_periodic)	// previous was not periodic...
		{
			switch (mm1_mdl::engtab2[index])
			{
				case ENG_MM1_PERIODIC:
				owner->periodic = true;
				break;
			}
		}
		else			// previous was periodic...
		{
			switch (mm1_mdl::engtab2[index])
			{
				case ENG_MM1_NORMAL:
				owner->periodic = false;
				break;
			}
		}
		
		bool update = false;
		if (owner->periodic) update = true;			// dimensions???
		if (old_periodic != owner->periodic) update = true;	// state changed...
		if (update) owner->UpdateAllGraphicsViews();
	}
	
	// close the dialog...
	
	GtkWidget * dialog = lookup_widget(GTK_WIDGET(button), "e2_dialog_mm1_setup");
	gtk_widget_destroy(dialog);
}


void
on_e2_button_cancel_clicked            (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget * dialog = lookup_widget(GTK_WIDGET(button), "e2_dialog_mm1_setup");
	gtk_widget_destroy(dialog);
}


void
on_f1_button_ok_clicked                (GtkButton       *button,
                                        gpointer         user_data)
{
	gnome_mm1_docv * owner = dynamic_cast<gnome_mm1_docv *>(gnome_docv::glade_modal_dialog_owner);
	if (!owner) cout << "ERROR: cast failed in on_f1_button_ok_clicked()." << endl;
	else
	{
  GtkWidget *optionmenu = lookup_widget(GTK_WIDGET(button), "f1_optionmenu");
  GtkWidget *menu = gtk_option_menu_get_menu(GTK_OPTION_MENU(optionmenu));
  GtkWidget *item = gtk_menu_get_active(GTK_MENU(menu));
  int index = g_list_index(GTK_MENU_SHELL(menu)->children, item);
  
  GtkWidget *fileentry = lookup_widget(GTK_WIDGET(button), "f1_fileentry");
  gchar *filename = gnome_file_entry_get_full_path(GNOME_FILE_ENTRY(fileentry),
						 FALSE);
  gnome_mm1_docv *docv = owner;
  ifstream ifile;
  ostrstream intermed;
  file_trans translator;

  if (index == 0) // Automatic detection
    {
      if (!translator.CanImport(filename))
	{
	  docv->err->ErrorMessage("Cannot import that file type.");
	  return;
	}

      ifile.open(filename, ios::in);
      translator.Import(filename, ifile, intermed);
      ifile.close();
    }
  else // By type picked by the user
    {
      ifile.open(filename, ios::in);
      translator.Import(filename, index - 1, ifile, intermed);
      ifile.close();
    }

  istrstream interInput(intermed.str());
  docv->ReadStream(interInput);
  docv->ParseProjectFileNameAndPath(filename);
  docv->UpdateAllWindowTitles();
  docv->UpdateAllGraphicsViews();
	}
	
	// close the dialog...
	
	GtkWidget * dialog = lookup_widget(GTK_WIDGET(button), "f1_dialog_mm1_import");
	gtk_widget_destroy(dialog);
}


void
on_f1_button_cancel_clicked            (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget * dialog = lookup_widget(GTK_WIDGET(button), "f1_dialog_mm1_import");
  gtk_widget_destroy(dialog);
}


void
on_f2_button_ok_clicked                (GtkButton       *button,
                                        gpointer         user_data)
{
	gnome_mm1_docv * owner = dynamic_cast<gnome_mm1_docv *>(gnome_docv::glade_modal_dialog_owner);
	if (!owner) cout << "ERROR: cast failed in on_f2_button_ok_clicked()." << endl;
	else
	{
  GtkWidget *optionmenu = lookup_widget(GTK_WIDGET(button), "f2_optionmenu");
  GtkWidget *menu = gtk_option_menu_get_menu(GTK_OPTION_MENU(optionmenu));
  GtkWidget *item = gtk_menu_get_active(GTK_MENU(menu));
  int index = g_list_index(GTK_MENU_SHELL(menu)->children, item);
  
  GtkWidget *fileentry = lookup_widget(GTK_WIDGET(button), "f2_fileentry");
  gchar *filename = gnome_file_entry_get_full_path(GNOME_FILE_ENTRY(fileentry),
						 FALSE);
  gnome_mm1_docv *docv = owner;
  ofstream ofile;
  strstream intermed;
  file_trans translator;

  docv->WriteStream(intermed);
  istrstream interInput(intermed.str());

  if (index == 0) // Automatic detection
    {
      if (!translator.CanExport(filename))
	{
	  docv->err->ErrorMessage("Cannot export that file type.");
	  return;
	}

      ofile.open(filename, ios::out);
      translator.Export(filename, interInput, ofile);
      ofile.close();
    }
  else // By type picked by the user
    {
       ofile.open(filename, ios::out);
       translator.Export(filename, index - 1, interInput, ofile);
       ofile.close();
    }

  docv->ParseProjectFileNameAndPath(filename);
  docv->UpdateAllWindowTitles();
	}
	
	// close the dialog...
	
	GtkWidget * dialog = lookup_widget(GTK_WIDGET(button), "f2_dialog_mm1_export");
	gtk_widget_destroy(dialog);
}


void
on_f2_button_cancel_clicked            (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget * dialog = lookup_widget(GTK_WIDGET(button), "f2_dialog_mm1_export");
  gtk_widget_destroy(dialog);
}


void
on_a1_button_ok_clicked                (GtkButton       *button,
                                        gpointer         user_data)
{
	// get the number of steps...
	
	GtkWidget * entry = lookup_widget(GTK_WIDGET(button), "a1_entry_nsteps");
	gchar * buffer = gtk_entry_get_text(GTK_ENTRY(entry));
	
	istrstream istr(buffer, strlen(buffer) + 1);
	int value; istr >> value;
	
	// store the values...
	
	gnome_mm1_docv * owner_mm1 = dynamic_cast<gnome_mm1_docv *>(gnome_docv::glade_modal_dialog_owner);
	if (owner_mm1 != NULL && owner_mm1->goparam != NULL)
	{
		owner_mm1->goparam->confirm = true;
		owner_mm1->goparam->nsteps = value;
	}
	
	gnome_mm2_docv * owner_mm2 = dynamic_cast<gnome_mm2_docv *>(gnome_docv::glade_modal_dialog_owner);
	if (owner_mm2 != NULL && owner_mm2->goparam != NULL)
	{
		owner_mm2->goparam->confirm = true;
		owner_mm2->goparam->nsteps = value;
	}
	
	// close the dialog...
	
	GtkWidget * dialog = lookup_widget(GTK_WIDGET(button), "a1_dialog_geomopt");
	gtk_widget_destroy(dialog);
}


void
on_a1_button_cancel_clicked            (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget * dialog = lookup_widget(GTK_WIDGET(button), "a1_dialog_geomopt");
	gtk_widget_destroy(dialog);
}


void
on_a2_button_ok_clicked                (GtkButton       *button,
                                        gpointer         user_data)
{
	// get the number of steps...
	
	GtkWidget * entry1 = lookup_widget(GTK_WIDGET(button), "a2_entry_nsteps");
	gchar * buffer1 = gtk_entry_get_text(GTK_ENTRY(entry1));
	
	istrstream istr1(buffer1, strlen(buffer1) + 1);
	int value1; istr1 >> value1;
	
	// get the temperature...
	
	GtkWidget * entry2 = lookup_widget(GTK_WIDGET(button), "a2_entry_temperature");
	gchar * buffer2 = gtk_entry_get_text(GTK_ENTRY(entry2));
	
	istrstream istr2(buffer2, strlen(buffer2) + 1);
	float value2; istr2 >> value2;
	
	// get the timestep...
	
	GtkWidget * entry3 = lookup_widget(GTK_WIDGET(button), "a2_entry_timestep");
	gchar * buffer3 = gtk_entry_get_text(GTK_ENTRY(entry3));
	
	istrstream istr3(buffer3, strlen(buffer3) + 1);
	float value3; istr3 >> value3;
	
	// get the filename...
	
	GtkWidget * entry4 = lookup_widget(GTK_WIDGET(button), "a2_fileentry_traj");
	gchar * buffer4 = gnome_file_entry_get_full_path(GNOME_FILE_ENTRY(entry4), FALSE);
	
	// store the values...
	
	gnome_mm1_docv * owner_mm1 = dynamic_cast<gnome_mm1_docv *>(gnome_docv::glade_modal_dialog_owner);
	if (owner_mm1 != NULL && owner_mm1->mdparam != NULL)
	{
		owner_mm1->mdparam->confirm = true;
		owner_mm1->mdparam->nsteps = value1;
		owner_mm1->mdparam->temperature = value2;
		owner_mm1->mdparam->timestep = value3;
		strcpy(owner_mm1->mdparam->filename, buffer4);
	}
	
	gnome_mm2_docv * owner_mm2 = dynamic_cast<gnome_mm2_docv *>(gnome_docv::glade_modal_dialog_owner);
	if (owner_mm2 != NULL && owner_mm2->mdparam != NULL)
	{
		owner_mm2->mdparam->confirm = true;
		owner_mm2->mdparam->nsteps = value1;
		owner_mm2->mdparam->temperature = value2;
		owner_mm2->mdparam->timestep = value3;
		strcpy(owner_mm2->mdparam->filename, buffer4);
	}
	
	// close the dialog...
	
	GtkWidget * dialog = lookup_widget(GTK_WIDGET(button), "a2_dialog_moldyn");
	gtk_widget_destroy(dialog);
}


void
on_a2_button_cancel_clicked            (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget * dialog = lookup_widget(GTK_WIDGET(button), "a2_dialog_moldyn");
	gtk_widget_destroy(dialog);
}


void
on_t1_button_begin_clicked             (GtkButton       *button,
                                        gpointer         user_data)
{
	trajectory_interface * traj = dynamic_cast<trajectory_interface *>(gnome_docv::glade_modal_dialog_owner);
	if (!traj) cout << "ERROR: cast failed in on_t?_button_???_clicked()." << endl;
	
	i32s frame = 0;
	traj->SetCurrentFrame(frame);
	traj->ReadFrame();
	
	cout << "frame = " << traj->GetCurrentFrame() << endl;
	gnome_docv::glade_modal_dialog_owner->UpdateAllGraphicsViews();
}


void
on_t1_button_prev_clicked              (GtkButton       *button,
                                        gpointer         user_data)
{
	trajectory_interface * traj = dynamic_cast<trajectory_interface *>(gnome_docv::glade_modal_dialog_owner);
	if (!traj) cout << "ERROR: cast failed in on_t?_button_???_clicked()." << endl;

	i32s frame = traj->GetCurrentFrame() - 1;
	i32s max = traj->GetTotalFrames();
	
	if (frame < 0) frame = 0;
	if (frame >= max) frame = max - 1;
	
	traj->SetCurrentFrame(frame);
	traj->ReadFrame();
	
	cout << "frame = " << traj->GetCurrentFrame() << endl;
	gnome_docv::glade_modal_dialog_owner->UpdateAllGraphicsViews();
}


void
on_t1_button_play_clicked              (GtkButton       *button,
                                        gpointer         user_data)
{
	trajectory_interface * traj = dynamic_cast<trajectory_interface *>(gnome_docv::glade_modal_dialog_owner);
	if (!traj) cout << "ERROR: cast failed in on_t?_button_???_clicked()." << endl;

	i32s max = traj->GetTotalFrames();
	for (i32s loop = 0;loop < max;loop++)
	{
		traj->SetCurrentFrame(loop);
		traj->ReadFrame();
		
		gnome_docv::glade_modal_dialog_owner->UpdateAllGraphicsViews();
	}
}


void
on_t1_button_next_clicked              (GtkButton       *button,
                                        gpointer         user_data)
{
	trajectory_interface * traj = dynamic_cast<trajectory_interface *>(gnome_docv::glade_modal_dialog_owner);
	if (!traj) cout << "ERROR: cast failed in on_t?_button_???_clicked()." << endl;

	i32s frame = traj->GetCurrentFrame() + 1;
	i32s max = traj->GetTotalFrames();
	
	if (frame < 0) frame = 0;
	if (frame >= max) frame = max - 1;
	
	traj->SetCurrentFrame(frame);
	traj->ReadFrame();
	
	cout << "frame = " << traj->GetCurrentFrame() << endl;
	gnome_docv::glade_modal_dialog_owner->UpdateAllGraphicsViews();
}


void
on_t1_button_end_clicked               (GtkButton       *button,
                                        gpointer         user_data)
{
	trajectory_interface * traj = dynamic_cast<trajectory_interface *>(gnome_docv::glade_modal_dialog_owner);
	if (!traj) cout << "ERROR: cast failed in on_t?_button_???_clicked()." << endl;

	i32s frame = traj->GetTotalFrames() - 1;
	traj->SetCurrentFrame(frame);
	traj->ReadFrame();
	
	cout << "frame = " << traj->GetCurrentFrame() << endl;
	gnome_docv::glade_modal_dialog_owner->UpdateAllGraphicsViews();
}


void
on_t1_button_close_clicked             (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget * dialog = lookup_widget(GTK_WIDGET(button), "t1_dialog_trajectory");
	gtk_widget_destroy(dialog);
}
