// T3MAIN.H : main for TARGET3 (the GNOME version).

// Copyright (C) 1999 Tommi Hassinen, Ville Heikkil.

// This program is free software; you can redistribute it and/or modify it
// under the terms of the license (GNU GPL) which comes with this package.

/*################################################################################################*/

#include "config.h"	// this is for TARGET3...

#ifndef T3MAIN_H
#define T3MAIN_H

class gnome_mdi_app;

/*################################################################################################*/

#include "t3views.h"

#include "t3qm1docv.h"
#include "t3mm1docv.h"
#include "t3mm2docv.h"

#include <gnome.h>

/*################################################################################################*/

struct gnome_app_data
{
	GnomeApp * app;
	
	GtkWidget * tool_widget[11];
	static i32s current_tool_index;
	
	GtkWidget * statusbar;
	i32u context_id;
};

/// A "##GNOME application" object; holds the GnomeMDI object and contains tons of callback handler functions...

class gnome_mdi_app
{
	private:	// main menu...
	
	static GnomeUIInfo file_new_submenu[];		// file
	static GnomeUIInfo file_open_submenu[];		// file
	static GnomeUIInfo file_submenu[];
	
	static GnomeUIInfo win_mdimode_submenu[];	// windows
	static GnomeUIInfo windows_submenu[];
	
	static GnomeUIInfo help_submenu[];
	
	static GnomeUIInfo menubar_info[];
	
	private:	// toolbar...
	
	static GnomeUIInfo mousetools_toolbar_info[];
	static GnomeUIInfo shortcuts_toolbar_info[];
	
	protected:

	static GnomeMDI * mdi;
	static vector<gnome_app_data> app_vector;
	
	static bool block_toolbar;
	
	friend class gnome_class_factory;	// will need mdi...
	
	friend class gnome_ogl_view;		// will need mdi...
	friend class gnome_graphics_view;	// will need mdi...
	friend class gnome_treelist_view;	// will need mdi...
	
	friend class gnome_docv;		// will need mdi...
	friend class gnome_qm1_docv;		// will need mdi...
	friend class gnome_mm1_docv;		// will need mdi...
	friend class gnome_mm2_docv;		// will need mdi...
	
	private:
	
	static gnome_mdi_app * instance;
	gnome_mdi_app(void);
	
	public:
	
	~gnome_mdi_app(void);
	static gnome_mdi_app * GetInstance(void);
	
	void HelpHelp(void);
	void HelpAbout(void);
	
// perhaps it would be more elegant to have only a single handler for menu events and
// for toolbar events, but there seems to be so many problems in passing the "user_data"
// records from GNOMEUIINFO to the event hander, so it's best to have own event handler
// for each menu/toolbar item...

	// the menu event handlers...
	// the menu event handlers...
	// the menu event handlers...
	
	static void menu_DummyEvent(GtkWidget *, gpointer);
	
	static void menu_FileNewQM1(GtkWidget *, gpointer);
	static void menu_FileNewMM1(GtkWidget *, gpointer);

	static void menu_FileOpenQM1(GtkWidget *, gpointer);
	static void menu_FileOpenMM1(GtkWidget *, gpointer);
	static void menu_FileOpenMM2(GtkWidget *, gpointer);
	
	static void menu_FileExit(GtkWidget *, gpointer);
	
	static void menu_MDINotebook(GtkWidget *, gpointer);
	static void menu_MDIToplevel(GtkWidget *, gpointer);
	static void menu_MDIModal(GtkWidget *, gpointer);
	
	static void menu_HelpHelp(GtkWidget *, gpointer);
	static void menu_HelpAbout(GtkWidget *, gpointer);
	
	// the toolbar event handlers...
	// the toolbar event handlers...
	// the toolbar event handlers...
	
	static void toolbar_Draw(GtkWidget *, gpointer);
	static void toolbar_Erase(GtkWidget *, gpointer);
	static void toolbar_Select(GtkWidget *, gpointer);
	static void toolbar_Zoom(GtkWidget *, gpointer);
	static void toolbar_TranslateXY(GtkWidget *, gpointer);
	static void toolbar_TranslateZ(GtkWidget *, gpointer);
	static void toolbar_OrbitXY(GtkWidget *, gpointer);
	static void toolbar_OrbitZ(GtkWidget *, gpointer);
	static void toolbar_RotateXY(GtkWidget *, gpointer);
	static void toolbar_RotateZ(GtkWidget *, gpointer);
	static void toolbar_Measure(GtkWidget *, gpointer);
	
	/**	We handle all toolbar button events here. We just first deactivate the 
		old button in all toolbars, and then activate the new button in all 
		toolbars. To prevent an infinite cascade of events, we must block the 
		event propagation. There is also a mechanism in GTK to do that, but 
		this simple blocking seems also work fine...
	*/
	
	static void ToolButtonHandler(i32s);
	
	// the shortcut event handlers...
	// the shortcut event handlers...
	// the shortcut event handlers...
	
	static void shortcut_Element(GtkWidget *, gpointer);
	static void shortcut_BondType(GtkWidget *, gpointer);
	
	static void shortcut_SelectAll(GtkWidget *, gpointer);
	static void shortcut_InvertSelection(GtkWidget *, gpointer);
	
	// other handlers...
	// other handlers...
	// other handlers...
	
	static void AppCreateHandler(GnomeMDI *, GnomeApp *, gpointer);
	static void AppDestroyHandler(GtkWidget *, gpointer);
	
	static void ChildChangeHandler(GnomeMDI *, GnomeMDIChild *, gpointer);
	static gboolean RemoveChildHandler(GnomeMDI *, GnomeMDIChild *, gpointer);
	static void DestroyChildHandler(GtkObject *, gpointer);
	
	static void DestroyHandler(GtkObject *, gpointer);
};

/*################################################################################################*/

int main(int, char **);

/*################################################################################################*/

#endif	// T3MAIN_H

// eof
