// T3PREFS.CPP: Handle user preferences/configuration 
//              using gnome_config methods

// Copyright (C) 2001 Geoffrey Hutchison

// This program is free software; you can redistribute it and/or modify it
// under the terms of the license (GNU GPL) which comes with this package.

/*################################################################################################*/

#include "t3prefs.h"
#include "utility.h"

#include <string.h>
#include <gnome.h>

#include <fstream>
#include <strstream>
using namespace std;

/*################################################################################################*/

// Constructor -- shouldn't need to do anything
gnome_prefs::gnome_prefs(void) : prefs()
{
}

// Destructor -- shouldn't need to do anything
gnome_prefs::~gnome_prefs(void)
{
}

void gnome_prefs::Add(const char *key, const char *val)
{
  ostrstream fullkey(keybuffer, sizeof(keybuffer));
  fullkey << "/ghemical/" << key << ends;
  gnome_config_set_string(keybuffer, val);
  gnome_config_sync();
}

void gnome_prefs::Add(const char *key, const int val)
{
  ostrstream fullkey(keybuffer, sizeof(keybuffer));
  fullkey << "/ghemical/" << key << ends;
  gnome_config_set_int(keybuffer, val);
  gnome_config_sync();
}

void gnome_prefs::Add(const char *key, const double val)
{
  ostrstream fullkey(keybuffer, sizeof(keybuffer));
  fullkey << "/ghemical/" << key << ends;
  gnome_config_set_float(keybuffer, val);
  gnome_config_sync();
}

void gnome_prefs::Add(const char *key, const bool val)
{
  ostrstream fullkey(keybuffer, sizeof(keybuffer));
  fullkey << "/ghemical/" << key << ends;
  gnome_config_set_bool(keybuffer, val);
  gnome_config_sync();
}

void gnome_prefs::Add(const char *key, const float v1, const float v2, const float v3)
{
  char valbuffer[1024];
  ostrstream fullkey(keybuffer, sizeof(keybuffer));
  fullkey << "/ghemical/" << key << ends;

  sprintf(valbuffer, "%f %f %f", v1, v2, v3);
  gnome_config_set_string(keybuffer, valbuffer);
  gnome_config_sync();
}

void gnome_prefs::Add(const char *key, 
		      const float v1, const float v2, const float v3, const float v4)
{
  char valbuffer[1024];
  ostrstream fullkey(keybuffer, sizeof(keybuffer));
  fullkey << "/ghemical/" << key << ends;

  sprintf(valbuffer, "%f %f %f %f", v1, v2, v3, v4);
  gnome_config_set_string(keybuffer, valbuffer);
  gnome_config_sync();
}

char * gnome_prefs::Find(const char *key, const char * def)
{
  ostrstream fullkey(keybuffer, sizeof(keybuffer));
  fullkey << "/ghemical/" << key << "=" << def << ends;  
  return gnome_config_get_string(keybuffer);
}

int    gnome_prefs::Value(const char *key, const int def)
{
  ostrstream fullkey(keybuffer, sizeof(keybuffer));
  fullkey << "/ghemical/" << key << "=" << def << ends;  
  return gnome_config_get_int(keybuffer);
}

double gnome_prefs::Double(const char *key, const double def)
{
  ostrstream fullkey(keybuffer, sizeof(keybuffer));
  fullkey << "/ghemical/" << key << "=" << def << ends;
  return gnome_config_get_float(keybuffer);
}

bool   gnome_prefs::Boolean(const char *key, const bool def)
{
  ostrstream fullkey(keybuffer, sizeof(keybuffer));
  fullkey << "/ghemical/" << key << "=" << def << ends;
  return gnome_config_get_bool(keybuffer);
}

float *gnome_prefs::ColorRGB(const char *key, const float def[3])
{
  float *temp = new float[3];
  char *valbuffer = new char[1024];
  ostrstream fullkey(keybuffer, sizeof(keybuffer));
  sprintf(valbuffer, "%f %f %f", def[0], def[1], def[2]);
  fullkey << "/ghemical/" << key << "=" << valbuffer << ends;

  valbuffer = gnome_config_get_string(keybuffer);
  sscanf(valbuffer, "%f %f %f", &temp[0], &temp[1], &temp[2]);
  return temp;
}
	
float *gnome_prefs::ColorRGBA(const char *key, const float def[4])
{
  float *temp = new float[4];
  char *valbuffer = new char[1024];
  ostrstream fullkey(keybuffer, sizeof(keybuffer));
  sprintf(valbuffer, "%f %f %f %f", def[0], def[1], def[2], def[3]);
  fullkey << "/ghemical/" << key << "=" << valbuffer << ends;

  valbuffer = gnome_config_get_string(keybuffer);
  sscanf(valbuffer, "%f %f %f %f", &temp[0], &temp[1], &temp[2], &temp[3]);
  return temp;
}

/*################################################################################################*/

// eof
