// T3QM1DOCV.CPP

// Copyright (C) 2000 Tommi Hassinen, Geoff Hutchison.

// This program is free software; you can redistribute it and/or modify it
// under the terms of the license (GNU GPL) which comes with this package.

/*################################################################################################*/

#include "t3qm1docv.h"

#include "glade_interface.h"

#include "t3main.h"
#include "t3dialog.h"
#include "t3errutil.h"
#include "t3views.h"

#include "qm1e_mopac.h"
#include "qm1e_mpqc.h"

#include "plane.h"
#include "surface.h"

#include "color.h"
#include "views.h"

#include <fstream>
using namespace std;

/*################################################################################################*/

const char qm1_file_open_dialog::title[] = "Open Project File - qm1gp";
gnome_qm1_docv * qm1_file_open_dialog::docv = NULL;

qm1_file_open_dialog::qm1_file_open_dialog(gnome_qm1_docv * p1) : file_dialog(title, NULL, NULL)
{
	docv = p1;
}

qm1_file_open_dialog::~qm1_file_open_dialog(void)
{
}

bool qm1_file_open_dialog::OkEvent(const char * filename)
{
	if (docv == NULL)
	{
		docv = new gnome_qm1_docv(& cout, * gnome_class_factory::GetInstance());
		docv->InitGnomeMDIChild();
	}
	
//	ifstream ifile;
//	ifile.open(filename, ios::in);
//	docv->ReadStream(ifile);
//	ifile.close();

	docv->UpdateAllGraphicsViews();
	
	return true;
}

void qm1_file_open_dialog::CancelEvent(void)
{
}

/*################################################################################################*/

const char qm1_importmm1_dialog::title[] = "Import File - mm1gp";
gnome_qm1_docv * qm1_importmm1_dialog::docv = NULL;

qm1_importmm1_dialog::qm1_importmm1_dialog(gnome_qm1_docv * p1) : file_dialog(title, NULL, NULL)
{
	docv = p1;
}

qm1_importmm1_dialog::~qm1_importmm1_dialog(void)
{
}

bool qm1_importmm1_dialog::OkEvent(const char * filename)
{
	if (docv != NULL)
	{
	  // Update titlebar
		docv->ParseProjectFileNameAndPath(filename);
		docv->ImportMM1(filename);

		docv->UpdateAllWindowTitles();
		docv->UpdateAllGraphicsViews();
	}
	
	return true;
}

void qm1_importmm1_dialog::CancelEvent(void)
{
}

/*################################################################################################*/

GnomeUIInfo gnome_qm1_docv::fileimport_submenu[] =
{
	GNOMEUIINFO_ITEM("mm1gp...", "mm1gp",
		popup_FileImport, NULL),
		
	GNOMEUIINFO_END
};

GnomeUIInfo gnome_qm1_docv::file_submenu[] =
{
	GNOMEUIINFO_MENU_OPEN_ITEM(popup_FileOpen, NULL),
	GNOMEUIINFO_SUBTREE("_Import", fileimport_submenu),
	
	GNOMEUIINFO_SEPARATOR,
	
	GNOMEUIINFO_MENU_SAVE_AS_ITEM(popup_FileSaveAs, NULL),
	
	GNOMEUIINFO_SEPARATOR,
	
	GNOMEUIINFO_MENU_CLOSE_ITEM(gnome_graphics_view::popup_FileClose, NULL),
	GNOMEUIINFO_END
};

GnomeUIInfo gnome_qm1_docv::select_submenu[] =
{
	GNOMEUIINFO_ITEM("Select All", "select all atoms...",
		gnome_graphics_view::popup_SelectAll, NULL),
		
	GNOMEUIINFO_ITEM("Invert Selection", "invert the selection...",
		gnome_graphics_view::popup_InvertSelection, NULL),
		
	GNOMEUIINFO_END
};

GnomeUIInfo gnome_qm1_docv::settings_submenu[] =
{
	GNOMEUIINFO_ITEM("Set Current Element", "el...",
		gnome_mdi_app::shortcut_Element, NULL),
		
	GNOMEUIINFO_END
};

GnomeUIInfo gnome_qm1_docv::viewscreate_submenu[] =
{
	GNOMEUIINFO_ITEM("New Camera", "create a new view with a new camera...",
		gnome_graphics_view::popup_ViewsNewCam, NULL),
		
	GNOMEUIINFO_ITEM("New View", "create a new view using the current camera...",
		gnome_graphics_view::popup_ViewsNewView, NULL),
		
	GNOMEUIINFO_SEPARATOR,

	GNOMEUIINFO_ITEM("Energy-level Diagram", "create a new energy-level diagram view.",
		popup_ViewsNewEnLevDiag, NULL),
		
	GNOMEUIINFO_END
};

GnomeUIInfo gnome_qm1_docv::views_submenu[] =
{
	GNOMEUIINFO_SUBTREE("_Create", viewscreate_submenu),
	
	GNOMEUIINFO_ITEM("Delete This View", "remove this view...",
		gnome_graphics_view::popup_ViewsDeleteView, NULL),
		
	GNOMEUIINFO_END
};

GnomeUIInfo gnome_qm1_docv::lights_submenu[] =
{
	GNOMEUIINFO_ITEM("Create New Light", "create a new light object...",
		gnome_graphics_view::popup_LightsNewLight, NULL),
		
	GNOMEUIINFO_SEPARATOR,
	
	GNOMEUIINFO_ITEM("Switch Local Lights", "loc",
		gnome_graphics_view::popup_LightsSwitchLoc, NULL),
		
	GNOMEUIINFO_ITEM("Switch Global Lights", "glob",
		gnome_graphics_view::popup_LightsSwitchGlob, NULL),
		
	GNOMEUIINFO_END
};

GnomeUIInfo gnome_qm1_docv::rendermode_submenu[] =
{
	GNOMEUIINFO_ITEM("Wireframe", "wf",
		popup_RModeWireFrame, NULL),
		
	GNOMEUIINFO_ITEM("Ball & Stick", "bs",
		popup_RModeBallAndStick, NULL),
		
	GNOMEUIINFO_ITEM("Nothing", "null",
		popup_RModeNothing, NULL),
		
	GNOMEUIINFO_END
};

GnomeUIInfo gnome_qm1_docv::projection_submenu[] =
{
	GNOMEUIINFO_ITEM("Orthographic", "ortho",
		gnome_graphics_view::popup_ProjOrthographic, NULL),
		
	GNOMEUIINFO_ITEM("Perspective", "persp",
		gnome_graphics_view::popup_ProjPerspective, NULL),

	GNOMEUIINFO_ITEM("Red-Green Stereo", "redgre",
		gnome_graphics_view::popup_ProjRedGreen, NULL),
		
	GNOMEUIINFO_ITEM("Relaxed-Eye Stereo", "releye",
		gnome_graphics_view::popup_ProjRelaxedEye, NULL),
		
	GNOMEUIINFO_END
};

GnomeUIInfo gnome_qm1_docv::render_submenu[] =
{
	GNOMEUIINFO_SUBTREE("_Views", views_submenu),
	GNOMEUIINFO_SUBTREE("_Lights", lights_submenu),
	GNOMEUIINFO_SUBTREE("_Rendering Mode", rendermode_submenu),
	GNOMEUIINFO_SUBTREE("_Projection", projection_submenu),
	
	GNOMEUIINFO_ITEM("Quick Update Mode", "quick update...",
		gnome_graphics_view::popup_RenderQuickUpdate, NULL),
		
	GNOMEUIINFO_END
};

GnomeUIInfo gnome_qm1_docv::objects_submenu[] =
{
	GNOMEUIINFO_ITEM("ESP-plane", "...",
		popup_ObjEPlane, NULL),
		
	GNOMEUIINFO_ITEM("ESP-surface", "...",
		popup_ObjESurface, NULL),
		
	GNOMEUIINFO_ITEM("ESP-colored vdW-surface", "...",
		popup_ObjVDWSurface, NULL),
		
	GNOMEUIINFO_ITEM("Electron density plane", "...",
		popup_ObjEDPlane, NULL),
		
	GNOMEUIINFO_ITEM("Electron density surface", "...",
		popup_ObjEDSurface, NULL),
		
	GNOMEUIINFO_ITEM("Molecular orbital plane", "...",
		popup_ObjMOPlane, NULL),
		
	GNOMEUIINFO_ITEM("Molecular orbital volume", "...",
		popup_ObjMOVolume, NULL),
		
	GNOMEUIINFO_ITEM("Molecular orbital surface", "...",
		popup_ObjMOSurface, NULL),
		
	GNOMEUIINFO_ITEM("MO-density plane", "...",
		popup_ObjMODPlane, NULL),
		
	GNOMEUIINFO_ITEM("MO-density volume", "...",
		popup_ObjMODVolume, NULL),
		
	GNOMEUIINFO_ITEM("MO-density surface", "...",
		popup_ObjMODSurface, NULL),
		
	GNOMEUIINFO_SEPARATOR,
	
	GNOMEUIINFO_ITEM("Delete Current Object", "delete",
		gnome_graphics_view::popup_ObjectsDeleteCurrent, NULL),
		
	GNOMEUIINFO_END
};

GnomeUIInfo gnome_qm1_docv::compute_submenu[] =
{
	GNOMEUIINFO_ITEM("Setup...", "...",
		popup_CompSetup, NULL),
		
	GNOMEUIINFO_SEPARATOR,
	
	GNOMEUIINFO_ITEM("Energy", "...",
		popup_CompEnergy, NULL),
		
	GNOMEUIINFO_ITEM("Geometry Optimization...", "...",
		popup_CompGeomOpt, NULL),
		
	GNOMEUIINFO_END
};

GnomeUIInfo gnome_qm1_docv::popupmenu_info[] =
{
	// a "tearoff" item would be nice here at the beginning !?!?!?!??!?!?!?!?!?!?!?!!!!???!??!!!
	// a "tearoff" item would be nice here at the beginning !?!?!?!??!?!?!?!?!?!?!?!!!!???!??!!!
	// a "tearoff" item would be nice here at the beginning !?!?!?!??!?!?!?!?!?!?!?!!!!???!??!!!
	
	GNOMEUIINFO_SUBTREE("_File", file_submenu),
	GNOMEUIINFO_SUBTREE("_Select", select_submenu),
	
	GNOMEUIINFO_SEPARATOR,
	
	GNOMEUIINFO_SUBTREE("_Settings...", settings_submenu),
	
	GNOMEUIINFO_SEPARATOR,
	
	GNOMEUIINFO_SUBTREE("_Render", render_submenu),
	GNOMEUIINFO_SUBTREE("_Objects", objects_submenu),
	
	GNOMEUIINFO_SEPARATOR,
	
	GNOMEUIINFO_SUBTREE("_Compute", compute_submenu),
	
	GNOMEUIINFO_ITEM("Set Current Orbital", "...",
		popup_SetOrbital, NULL),
	
	GNOMEUIINFO_SEPARATOR,
	
	GNOMEUIINFO_ITEM("Convert to MM project", "Convert this project into a mm1gp project.",
		popup_ConvertMM, NULL),
	
	GNOMEUIINFO_END
};

/*################################################################################################*/

gnome_qm1_docv::gnome_qm1_docv(ostream * p1, gnome_class_factory & p2) :
	gnome_docv(p1, p2), qm1_docv(p1, p2), docview(p1, p2), model_simple(p1, p2)
{
	popupmenu = gnome_popup_menu_new(popupmenu_info);
}

gnome_qm1_docv::~gnome_qm1_docv(void)
{
}

/*##############################################*/
/*##############################################*/

// the qm1-dependent popup-menu callbacks are here...
// the qm1-dependent popup-menu callbacks are here...
// the qm1-dependent popup-menu callbacks are here...

void gnome_qm1_docv::popup_FileOpen(GtkWidget *, gpointer data)
{
	gnome_graphics_view * gv = gnome_graphics_view::GetGV((GtkWidget *) data);
	gnome_qm1_docv * docv = dynamic_cast<gnome_qm1_docv *>(gv->docv);
	docv->err->Message("Sorry, this feature is not yet implemented.");
}

void gnome_qm1_docv::popup_FileImport(GtkWidget *, gpointer data)
{
	gnome_graphics_view * gv = gnome_graphics_view::GetGV((GtkWidget *) data);
	gnome_qm1_docv * docv = dynamic_cast<gnome_qm1_docv *>(gv->docv);
	if (docv)
	{
		new qm1_importmm1_dialog(docv)		;
//cout << "name of MM1 file to import ??? ";
//cin >> docv->buffer; docv->ImportMM1(docv->buffer);
//docv->UpdateAllGraphicsViews();
	}
}

void gnome_qm1_docv::popup_FileSaveAs(GtkWidget *, gpointer data)
{
	gnome_graphics_view * gv = gnome_graphics_view::GetGV((GtkWidget *) data);
	gnome_qm1_docv * docv = dynamic_cast<gnome_qm1_docv *>(gv->docv);
	
	docv->err->Message("Sorry, this feature is not yet implemented.");
}

void gnome_qm1_docv::popup_ViewsNewEnLevDiag(GtkWidget *, gpointer data)
{
	gnome_graphics_view * gv = gnome_graphics_view::GetGV((GtkWidget *) data);
	gnome_qm1_docv * docv = dynamic_cast<gnome_qm1_docv *>(gv->docv);
	
	docv->AddEnLevDiagView();
}

void gnome_qm1_docv::popup_RModeWireFrame(GtkWidget *, gpointer data)
{
	gnome_graphics_view * gv = gnome_graphics_view::GetGV((GtkWidget *) data);
	gv->render = RENDER_WIREFRAME; gv->docv->UpdateAllGraphicsViews();
}

void gnome_qm1_docv::popup_RModeBallAndStick(GtkWidget *, gpointer data)
{
	gnome_graphics_view * gv = gnome_graphics_view::GetGV((GtkWidget *) data);
	gv->render = RENDER_BALL_AND_STICK; gv->docv->UpdateAllGraphicsViews();
}

void gnome_qm1_docv::popup_RModeNothing(GtkWidget *, gpointer data)
{
	gnome_graphics_view * gv = gnome_graphics_view::GetGV((GtkWidget *) data);
	gv->render = RENDER_NOTHING; gv->docv->UpdateAllGraphicsViews();
}

void gnome_qm1_docv::popup_ObjEPlane(GtkWidget *, gpointer data)
{
	gnome_graphics_view * gv = gnome_graphics_view::GetGV((GtkWidget *) data);
	gnome_qm1_docv * docv = dynamic_cast<gnome_qm1_docv *>(gv->docv);
	if (docv)
	{
		fGL tmp1;
		cp_param cpp; cpp.np = docv->model_prefs->Value("QM1Graphics/PlaneResolution", 30); 
		cpp.docv = docv; cpp.ref = docv->current_eng;
		
	if (!docv->current_eng) { docv->err->ErrorMessage("Calculate energy first!!!"); return; }
	
		cout << "give dimension of the plane [nm] (0.5 might be ok) ??? "; cin >> tmp1;
		
		cpp.dim = tmp1; cpp.transparent = true;
		cpp.vf = (ValueFunction *) qm1_eng::getESP; cpp.cf = (ColorFunction *) GetRBRange1;
		cpp.value = 138.9354518 * 1.0; cpp.alpha = 0.75;
		
		docv->AddObject(new color_plane_object(ol_static(), cpp, "ESP-"));
		docv->UpdateAllGraphicsViews();
	}
}

void gnome_qm1_docv::popup_ObjESurface(GtkWidget *, gpointer data)
{
	gnome_graphics_view * gv = gnome_graphics_view::GetGV((GtkWidget *) data);
	gnome_qm1_docv * docv = dynamic_cast<gnome_qm1_docv *>(gv->docv);
	if (docv)
	{
		fGL tmp1; fGL tmp2; char input;
		
		i32s size = docv->model_prefs->Value("QM1Graphics/SurfaceResolution", 50);
		i32s sz[3] = { size, size, size };
		fGL dm[3] = { 0.55, 0.50, 0.45 };
		
		cs_param csp2a; cs_param csp2b;
		csp2a.np = sz; csp2a.dim = dm; csp2a.ostr = & cout;
		csp2a.docv = docv; csp2a.ref = docv->current_eng; csp2a.next = & csp2b;
		csp2b.np = sz; csp2b.dim = dm; csp2b.ostr = & cout;
		csp2b.docv = docv; csp2b.ref = docv->current_eng; csp2b.next = NULL;
		
	if (!docv->current_eng) { docv->err->ErrorMessage("Calculate energy first!!!"); return; }
	
		tmp1 = 138.9354518 / 4.0;
		cout << "give dimension of the surface [nm] (1.0 might be ok) ??? ";
		cin >> tmp2; dm[0] = dm[1] = dm[2] = tmp2;
		
		cout << "choose the type of surface : solid or wireframe ? (s/w) ";
		cin >> input; csp2a.wireframe = csp2b.wireframe = (input == 'w' || input == 'W');
		
		csp2a.transparent = !true;
		csp2a.vf1 = (ValueFunction *) qm1_eng::getESP; csp2a.vf2 = (ValueFunction *) GetUnity;
		csp2a.cvalue = 1.0; csp2a.alpha = 0.50; csp2a.toler = 1.0e-6 * tmp1; csp2a.maxc = 50;	// slow!!!
			csp2a.cf = (ColorFunction *) GetRedColor; csp2a.svalue = +tmp1;
			
		csp2b.transparent = !true;
		csp2b.vf1 = (ValueFunction *) qm1_eng::getESP; csp2b.vf2 = (ValueFunction *) GetUnity;
		csp2b.cvalue = 1.0; csp2b.alpha = 0.50; csp2b.toler = 1.0e-6 * tmp1; csp2b.maxc = 50;	// slow!!!
			csp2b.cf = (ColorFunction *) GetBlueColor; csp2b.svalue = -tmp1;
			
		docv->AddObject(new color_surface_object(ol_static(), csp2a, "ESP-"));
		docv->UpdateAllGraphicsViews();
	}
}

void gnome_qm1_docv::popup_ObjVDWSurface(GtkWidget *, gpointer data)
{
	gnome_graphics_view * gv = gnome_graphics_view::GetGV((GtkWidget *) data);
	gnome_qm1_docv * docv = dynamic_cast<gnome_qm1_docv *>(gv->docv);
	if (docv)
	{
		fGL tmp1; fGL tmp2; char input;
		
		i32s size = docv->model_prefs->Value("QM1Graphics/SurfaceResolution", 50);
		i32s sz[3] = { size, size, size };
		fGL dm[3] = { 0.55, 0.50, 0.45 };
		
		cs_param csp1;
		csp1.np = sz; csp1.dim = dm; csp1.ostr = & cout;
		csp1.docv = docv; csp1.ref = docv->current_eng; csp1.next = NULL;
		
	if (!docv->current_eng) { docv->err->ErrorMessage("Calculate energy first!!!"); return; }
	
		tmp1 = 138.9354518 / 2.0;
		cout << "give dimension of the surface [nm] (1.0 might be ok) ??? ";
		cin >> tmp2; dm[0] = dm[1] = dm[2] = tmp2;
		
		cout << "choose the type of surface : solid or wireframe ? (s/w) ";
		cin >> input; csp1.wireframe = (input == 'w' || input == 'W');
		
		csp1.transparent = true; csp1.cf = (ColorFunction *) GetRBRange1;
		csp1.vf1 = (ValueFunction *) qm1_eng::getVDWSurface; csp1.vf2 = (ValueFunction *) qm1_eng::getESP;
		csp1.svalue = 1.0; csp1.cvalue = tmp1; csp1.alpha = 0.50; csp1.toler = 1.0e-6 * tmp1; csp1.maxc = 250;
		
		docv->AddObject(new color_surface_object(ol_static(), csp1, "ESP-colored VDW-"));
		docv->UpdateAllGraphicsViews();
	}
}

void gnome_qm1_docv::popup_ObjEDPlane(GtkWidget *, gpointer data)
{
	gnome_graphics_view * gv = gnome_graphics_view::GetGV((GtkWidget *) data);
	gnome_qm1_docv * docv = dynamic_cast<gnome_qm1_docv *>(gv->docv);
	if (docv)
	{
		fGL tmp1;
		cp_param cpp; cpp.np = docv->model_prefs->Value("QM1Graphics/PlaneResolution", 30); 
		cpp.docv = docv; cpp.ref = docv->current_eng;
		
	if (!docv->current_eng) { docv->err->ErrorMessage("Calculate energy first!!!"); return; }
	
		cout << "give dimension of the plane [nm] (0.5 might be ok) ??? "; cin >> tmp1;
		
		cpp.dim = tmp1; cpp.transparent = true;
		cpp.vf = (ValueFunction *) qm1_eng::getElDens; cpp.cf = (ColorFunction *) GetGreenColor;
		cpp.value = 0.05; cpp.alpha = 0.75;
		
		docv->AddObject(new color_plane_object(ol_static(), cpp, "E-density "));
		docv->UpdateAllGraphicsViews();
	}
}

void gnome_qm1_docv::popup_ObjEDSurface(GtkWidget *, gpointer data)
{
	gnome_graphics_view * gv = gnome_graphics_view::GetGV((GtkWidget *) data);
	gnome_qm1_docv * docv = dynamic_cast<gnome_qm1_docv *>(gv->docv);
	if (docv)
	{
		fGL tmp1; fGL tmp2; char input;
		
		i32s size = docv->model_prefs->Value("QM1Graphics/SurfaceResolution", 50);
		i32s sz[3] = { size, size, size };
		fGL dm[3] = { 0.55, 0.50, 0.45 };
		
		cs_param csp1;
		csp1.np = sz; csp1.dim = dm; csp1.ostr = & cout;
		csp1.docv = docv; csp1.ref = docv->current_eng; csp1.next = NULL;
		
	if (!docv->current_eng) { docv->err->ErrorMessage("Calculate energy first!!!"); return; }
	
		tmp1 = 0.05;
		cout << "give dimension of the surface [nm] (1.0 might be ok) ??? ";
		cin >> tmp2; dm[0] = dm[1] = dm[2] = tmp2;
		
		cout << "choose the type of surface : solid or wireframe ? (s/w) ";
		cin >> input; csp1.wireframe = (input == 'w' || input == 'W');
		
		csp1.transparent = true; csp1.cf = (ColorFunction *) GetGreenColor;
		csp1.vf1 = (ValueFunction *) qm1_eng::getElDens; csp1.vf2 = (ValueFunction *) GetUnity;
		csp1.svalue = tmp1; csp1.cvalue = 1.0; csp1.alpha = 0.50; csp1.toler = 1.0e-6 * tmp1; csp1.maxc = 250;
		
		docv->AddObject(new color_surface_object(ol_static(), csp1, "E-density "));
		docv->UpdateAllGraphicsViews();
	}
}

void gnome_qm1_docv::popup_ObjMOPlane(GtkWidget *, gpointer data)
{
	gnome_graphics_view * gv = gnome_graphics_view::GetGV((GtkWidget *) data);
	gnome_qm1_docv * docv = dynamic_cast<gnome_qm1_docv *>(gv->docv);
	if (docv)
	{
		fGL tmp1;
		cp_param cpp; cpp.np = docv->model_prefs->Value("QM1Graphics/PlaneResolution", 30);
		cpp.docv = docv; cpp.ref = docv->current_eng;
		
	if (!docv->current_eng) { docv->err->ErrorMessage("Calculate energy first!!!"); return; }
	
		cout << "give dimension of the plane [nm] (0.5 might be ok) ??? "; cin >> tmp1;
		
		cpp.dim = tmp1; cpp.transparent = true;
		cpp.vf = (ValueFunction *) qm1_eng::getOrbital; cpp.cf = (ColorFunction *) GetRBRange1;
		cpp.value = 0.05; cpp.alpha = 0.75;
		
		docv->AddObject(new color_plane_object(ol_static(), cpp, "molecular orbital "));
		docv->UpdateAllGraphicsViews();
	}
}

void gnome_qm1_docv::popup_ObjMOVolume(GtkWidget *, gpointer data)
{
	gnome_graphics_view * gv = gnome_graphics_view::GetGV((GtkWidget *) data);
	gnome_qm1_docv * docv = dynamic_cast<gnome_qm1_docv *>(gv->docv);
	if (docv)
	{
		fGL tmp1;
		cp_param cpp; cpp.np = docv->model_prefs->Value("QM1Graphics/SurfaceResolution", 30);
		cpp.docv = docv; cpp.ref = docv->current_eng;
		
	if (!docv->current_eng) { docv->err->ErrorMessage("Calculate energy first!!!"); return; }
	
		cout << "give dimension of the volume [nm] (1.0 might be ok) ??? "; cin >> tmp1;
		
		cpp.dim = tmp1; cpp.transparent = true;
		cpp.vf = (ValueFunction *) qm1_eng::getOrbital; cpp.cf = (ColorFunction *) GetRBRange2;
		cpp.value = 0.05; cpp.alpha = 0.25;
		
		docv->AddObject(new volume_rendering_object(ol_static(), cpp, 20, tmp1 / 2.0, (* gv->cam), "MO "));
		docv->UpdateAllGraphicsViews();
	}
}

void gnome_qm1_docv::popup_ObjMOSurface(GtkWidget *, gpointer data)
{
	gnome_graphics_view * gv = gnome_graphics_view::GetGV((GtkWidget *) data);
	gnome_qm1_docv * docv = dynamic_cast<gnome_qm1_docv *>(gv->docv);
	if (docv)
	{
		fGL tmp1; fGL tmp2; char input;
		
		i32s size = docv->model_prefs->Value("QM1Graphics/SurfaceResolution", 50);
		i32s sz[3] = { size, size, size };
		fGL dm[3] = { 0.55, 0.50, 0.45 };
		
		cs_param csp2a; cs_param csp2b;
		csp2a.np = sz; csp2a.dim = dm; csp2a.ostr = & cout;
		csp2a.docv = docv; csp2a.ref = docv->current_eng; csp2a.next = & csp2b;
		csp2b.np = sz; csp2b.dim = dm; csp2b.ostr = & cout;
		csp2b.docv = docv; csp2b.ref = docv->current_eng; csp2b.next = NULL;
		
	if (!docv->current_eng) { docv->err->ErrorMessage("Calculate energy first!!!"); return; }
	
		tmp1 = 0.05;
		cout << "give dimension of the surface [nm] (1.0 might be ok) ??? ";
		cin >> tmp2; dm[0] = dm[1] = dm[2] = tmp2;
		
		cout << "choose the type of surface : solid or wireframe ? (s/w) ";
		cin >> input; csp2a.wireframe = csp2b.wireframe = (input == 'w' || input == 'W');
		
		csp2a.transparent = !true;
		csp2a.vf1 = (ValueFunction *) qm1_eng::getOrbital; csp2a.vf2 = (ValueFunction *) GetUnity;
		csp2a.cvalue = 1.0; csp2a.alpha = 0.50; csp2a.toler = 1.0e-6 * tmp1; csp2a.maxc = 250;
			csp2a.cf = (ColorFunction *) GetRedColor; csp2a.svalue = +tmp1;
			
		csp2b.transparent = !true;
		csp2b.vf1 = (ValueFunction *) qm1_eng::getOrbital; csp2b.vf2 = (ValueFunction *) GetUnity;
		csp2b.cvalue = 1.0; csp2b.alpha = 0.50; csp2b.toler = 1.0e-6 * tmp1; csp2b.maxc = 250;
			csp2b.cf = (ColorFunction *) GetBlueColor; csp2b.svalue = -tmp1;
			
		docv->AddObject(new color_surface_object(ol_static(), csp2a, "MO "));
		docv->UpdateAllGraphicsViews();
	}
}

void gnome_qm1_docv::popup_ObjMODPlane(GtkWidget *, gpointer data)
{
	gnome_graphics_view * gv = gnome_graphics_view::GetGV((GtkWidget *) data);
	gnome_qm1_docv * docv = dynamic_cast<gnome_qm1_docv *>(gv->docv);
	if (docv)
	{
		fGL tmp1;
		cp_param cpp; cpp.np = docv->model_prefs->Value("QM1Graphics/PlaneResolution", 30); 
		cpp.docv = docv; cpp.ref = docv->current_eng;
		
	if (!docv->current_eng) { docv->err->ErrorMessage("Calculate energy first!!!"); return; }
	
		cout << "give dimension of the plane [nm] (0.5 might be ok) ??? "; cin >> tmp1;
		
		cpp.dim = tmp1; cpp.transparent = true;
		cpp.vf = (ValueFunction *) qm1_eng::getOrbDens; cpp.cf = (ColorFunction *) GetGreenColor;
		cpp.value = 0.0125; cpp.alpha = 0.75;
		
		docv->AddObject(new color_plane_object(ol_static(), cpp, "MO-density "));
		docv->UpdateAllGraphicsViews();
	}
}

void gnome_qm1_docv::popup_ObjMODVolume(GtkWidget *, gpointer data)
{
	gnome_graphics_view * gv = gnome_graphics_view::GetGV((GtkWidget *) data);
	gnome_qm1_docv * docv = dynamic_cast<gnome_qm1_docv *>(gv->docv);
	if (docv)
	{
		fGL tmp1;
		cp_param cpp; cpp.np = docv->model_prefs->Value("QM1Graphics/SurfaceResolution", 30);
		cpp.docv = docv; cpp.ref = docv->current_eng;
		
	if (!docv->current_eng) { docv->err->ErrorMessage("Calculate energy first!!!"); return; }
	
		cout << "give dimension of the volume [nm] (1.0 might be ok) ??? "; cin >> tmp1;
		
		cpp.dim = tmp1; cpp.transparent = true;
		cpp.vf = (ValueFunction *) qm1_eng::getOrbDens; cpp.cf = (ColorFunction *) GetRBRange2;
		cpp.value = 0.0125; cpp.alpha = 0.25;
		
		docv->AddObject(new volume_rendering_object(ol_static(), cpp, 20, tmp1 / 2.0, (* gv->cam), "MO "));
		docv->UpdateAllGraphicsViews();
	}
}

void gnome_qm1_docv::popup_ObjMODSurface(GtkWidget *, gpointer data)
{
	gnome_graphics_view * gv = gnome_graphics_view::GetGV((GtkWidget *) data);
	gnome_qm1_docv * docv = dynamic_cast<gnome_qm1_docv *>(gv->docv);
	if (docv)
	{
		fGL tmp1; fGL tmp2; char input;
		
		i32s sz[3] = { 25, 25, 25 };
		fGL dm[3] = { 0.55, 0.50, 0.45 };
		
		cs_param csp1;
		csp1.np = sz; csp1.dim = dm; csp1.ostr = & cout;
		csp1.docv = docv; csp1.ref = docv->current_eng; csp1.next = NULL;
		
	if (!docv->current_eng) { docv->err->ErrorMessage("Calculate energy first!!!"); return; }
	
		tmp1 = 0.0125;
		cout << "give dimension of the surface [nm] (1.0 might be ok) ??? ";
		cin >> tmp2; dm[0] = dm[1] = dm[2] = tmp2;
		
		cout << "choose the type of surface : solid or wireframe ? (s/w) ";
		cin >> input; csp1.wireframe = (input == 'w' || input == 'W');
		
		csp1.transparent = true; csp1.cf = (ColorFunction *) GetGreenColor;
		csp1.vf1 = (ValueFunction *) qm1_eng::getOrbDens; csp1.vf2 = (ValueFunction *) GetUnity;
		csp1.svalue = tmp1; csp1.cvalue = 1.0; csp1.alpha = 0.50; csp1.toler = 1.0e-6 * tmp1; csp1.maxc = 250;
		
		docv->AddObject(new color_surface_object(ol_static(), csp1, "MO-density "));
		docv->UpdateAllGraphicsViews();
	}
}

void gnome_qm1_docv::popup_CompSetup(GtkWidget *, gpointer data)
{
	gnome_graphics_view * gv = gnome_graphics_view::GetGV((GtkWidget *) data);
	gnome_qm1_docv * docv = dynamic_cast<gnome_qm1_docv *>(gv->docv);
	glade_modal_dialog_owner = docv;	// requires modal dialogs!!!
	
	GtkWidget * dialog = create_e1_dialog_qm1_setup();
	gtk_widget_show(dialog);
}

void gnome_qm1_docv::popup_CompEnergy(GtkWidget *, gpointer data)
{
	gnome_graphics_view * gv = gnome_graphics_view::GetGV((GtkWidget *) data);
	gnome_qm1_docv * docv = dynamic_cast<gnome_qm1_docv *>(gv->docv);
	if (docv) docv->DoEnergy();
}

void gnome_qm1_docv::popup_CompGeomOpt(GtkWidget *, gpointer data)
{
	gnome_graphics_view * gv = gnome_graphics_view::GetGV((GtkWidget *) data);
	gnome_qm1_docv * docv = dynamic_cast<gnome_qm1_docv *>(gv->docv);
	if (docv)
	{
		qm1_geomopt_param param;
		param.nsteps = 500;
		
		docv->DoGeomOpt(param);
	}
}

void gnome_qm1_docv::popup_SetOrbital(GtkWidget *, gpointer data)
{
	gnome_graphics_view * gv = gnome_graphics_view::GetGV((GtkWidget *) data);
	gnome_qm1_docv * docv = dynamic_cast<gnome_qm1_docv *>(gv->docv);
	if (docv)
	{
		cout << "current orbital is now " << docv->current_orbital << endl;
		cout << "enter new value (BE CAREFUL, THERE'S NO BOUNDS CHECKING YET!!!) : ";
		
		cin >> docv->current_orbital;
		
		cout << "current orbital now set to " << docv->current_orbital << endl;
	}
}

// temporary, for QM->MM conversion, will move into all_atoms_interface???
// temporary, for QM->MM conversion, will move into all_atoms_interface???
// temporary, for QM->MM conversion, will move into all_atoms_interface???

void gnome_qm1_docv::popup_ConvertMM(GtkWidget *, gpointer data)
{
	gnome_graphics_view * gv = gnome_graphics_view::GetGV((GtkWidget *) data);
	gnome_qm1_docv * docv = dynamic_cast<gnome_qm1_docv *>(gv->docv);
	if (docv)
	{
		const char message[] = "Should I close this old project?";
		bool close_old = docv->err->Question(message);
		
		gnome_mm1_docv * mm_docv;
		mm_docv = new gnome_mm1_docv(& cout, * gnome_class_factory::GetInstance());
	// keep the same project name only if old was closed??? might be confusing otherwise???
	if (close_old) mm_docv->SetProjectFileName(docv->GetProjectFileName(false));
		mm_docv->InitGnomeMDIChild();
		
		// start conversion qm1gp -> mm1gp.
		// start conversion qm1gp -> mm1gp.
		// start conversion qm1gp -> mm1gp.
		
		vector<qm1_atom *> qmtab;	// store the pointers here...
		vector<mm1_atom *> mmtab;	// ...to replicate the bonds!
		
		iter_qm1al it1 = docv->atom_list.begin();
		while (it1 != docv->atom_list.end())
		{
			element tmp1 = (* it1).el;
			fGL * tmp2 = (* it1).crd_vector[0].data;
			
			mm1_atom newatom(tmp1, tmp2, 1);
			mm_docv->AddAtom(newatom);
			
			qmtab.push_back(& (* it1));
			mmtab.push_back(& mm_docv->atom_list.back());
			
			it1++;
		}
		
		iter_qm1bl it2 = docv->bond_list.begin();
		while (it2 != docv->bond_list.end())
		{
			i32u index1 = 0; while (index1 < qmtab.size()) if ((* it2).atmr[0] == qmtab[index1]) break; else index1++;
			if (index1 == qmtab.size()) { cout << "FATAL ERROR : could not find atom #1." << endl; exit(EXIT_FAILURE); }
			
			i32u index2 = 0; while (index2 < qmtab.size()) if ((* it2).atmr[1] == qmtab[index2]) break; else index2++;
			if (index2 == qmtab.size()) { cout << "FATAL ERROR : could not find atom #2." << endl; exit(EXIT_FAILURE); }
			
			bondtype tmp1 = (* it2).bt;
			
			mm1_bond newbond(mmtab[index1], mmtab[index2], tmp1);
			mm_docv->AddBond(newbond);
			
			it2++;
		}
		
		// conversion is now ready.
		
		if (close_old) gnome_mdi_remove_child(gnome_mdi_app::mdi, GNOME_MDI_CHILD(gv->docv->child), TRUE);
	}
}

/*##############################################*/
/*##############################################*/

void gnome_qm1_docv::GeomOptGetParam(qm1_geomopt_param & param)
{
	cout << "how many cg-steps (" << param.nsteps << " might be Ok, -1 = cancel) ??? ";
	cin >> param.nsteps;
	
	param.confirm = !(param.nsteps < 0);
}

/*################################################################################################*/

// eof
