// T3QM1DOCV.H : a graphical user interface for qm1-models.

// Copyright (C) 2000 Tommi Hassinen.

// This program is free software; you can redistribute it and/or modify it
// under the terms of the license (GNU GPL) which comes with this package.

/*################################################################################################*/

#include "config.h"	// this is target-dependent...

#ifndef T3QM1DOCV_H
#define T3QM1DOCV_H

class gnome_qm1_docv;

/*################################################################################################*/

#include "t3docv.h"
#include "qm1docv.h"
#include "t3dialog.h"

#include <gnome.h>

/*################################################################################################*/

#define QM1_FILTER	"*.qm1gp"

/*################################################################################################*/

// save
// import
// export ???

class qm1_file_open_dialog : public file_dialog
{
	private:
	
	static const char title[];
	static gnome_qm1_docv * docv;
	
	public:
	
	qm1_file_open_dialog(gnome_qm1_docv *);
	~qm1_file_open_dialog(void);
	
	bool OkEvent(const char *);	// virtual
	void CancelEvent(void);		// virtual
};

class qm1_importmm1_dialog : public file_dialog
{
	private:
	
	static const char title[];
	static gnome_qm1_docv * docv;
	
	public:
	
	qm1_importmm1_dialog(gnome_qm1_docv *);
	~qm1_importmm1_dialog(void);
	
	bool OkEvent(const char *);	// virtual
	void CancelEvent(void);		// virtual
};

/*################################################################################################*/

/// Combines the "##GNOME" and "##qm1" aspects of "##docview", and contains many callback handlers...

class gnome_qm1_docv : public gnome_docv, public qm1_docv
{
	protected:
	
	static GnomeUIInfo fileimport_submenu[];	// file
	static GnomeUIInfo file_submenu[];
	
	static GnomeUIInfo select_submenu[];
	
	static GnomeUIInfo settings_submenu[];
	
	static GnomeUIInfo viewscreate_submenu[];	// render/views
	static GnomeUIInfo views_submenu[];		// render
	static GnomeUIInfo lights_submenu[];		// render
	static GnomeUIInfo rendermode_submenu[];	// render
	static GnomeUIInfo projection_submenu[];	// render
	static GnomeUIInfo render_submenu[];
	
	static GnomeUIInfo objects_submenu[];
	
	static GnomeUIInfo compute_submenu[];
	
	static GnomeUIInfo popupmenu_info[];
	
	friend class gnome_ogl_view;
	
	public:
	
	gnome_qm1_docv(ostream *, gnome_class_factory &);
	~gnome_qm1_docv(void);
	
	// the qm1-dependent popup-menu callbacks are here...
	// the qm1-dependent popup-menu callbacks are here...
	// the qm1-dependent popup-menu callbacks are here...
	
	static void popup_FileOpen(GtkWidget *, gpointer);
	static void popup_FileImport(GtkWidget *, gpointer);
	static void popup_FileSaveAs(GtkWidget *, gpointer);

	static void popup_ViewsNewEnLevDiag(GtkWidget *, gpointer);
	
	static void popup_RModeWireFrame(GtkWidget *, gpointer);
	static void popup_RModeBallAndStick(GtkWidget *, gpointer);
	static void popup_RModeNothing(GtkWidget *, gpointer);
	
	static void popup_ObjEPlane(GtkWidget *, gpointer);
	static void popup_ObjESurface(GtkWidget *, gpointer);
	static void popup_ObjVDWSurface(GtkWidget *, gpointer);
	static void popup_ObjEDPlane(GtkWidget *, gpointer);
	static void popup_ObjEDSurface(GtkWidget *, gpointer);
	static void popup_ObjMOPlane(GtkWidget *, gpointer);
	static void popup_ObjMOVolume(GtkWidget *, gpointer);
	static void popup_ObjMOSurface(GtkWidget *, gpointer);
	static void popup_ObjMODPlane(GtkWidget *, gpointer);
	static void popup_ObjMODVolume(GtkWidget *, gpointer);
	static void popup_ObjMODSurface(GtkWidget *, gpointer);
	
	static void popup_CompSetup(GtkWidget *, gpointer);
	static void popup_CompEnergy(GtkWidget *, gpointer);
	static void popup_CompGeomOpt(GtkWidget *, gpointer);
	
	static void popup_SetOrbital(GtkWidget *, gpointer);
	
	static void popup_ConvertMM(GtkWidget *, gpointer);
	
	public:
	
	void GeomOptGetParam(qm1_geomopt_param &);	// virtual
};

/*################################################################################################*/

#endif	// T3QM1DOCV_H

// eof
