// T3VIEWS.CPP

// Copyright (C) 1999 Tommi Hassinen, Ville Heikkil, Mike Cruz.

// This program is free software; you can redistribute it and/or modify it
// under the terms of the license (GNU GPL) which comes with this package.

/*################################################################################################*/

#include "t3views.h"

#include "t3main.h"
#include "t3docv.h"

#include "t3qm1docv.h"	// temporary !?!?!?!?
#include "t3mm1docv.h"	// temporary !?!?!?!?

#include "t3errutil.h"
#include "t3prefs.h"

#include <gnome.h>

#include <strstream>
#include <algorithm>
using namespace std;

/*################################################################################################*/

gnome_view::gnome_view(gnome_docv * p1) : view()
{
	docv = p1;
	label_widget = gtk_label_new("this_view_has_no_title");
}

gnome_view::~gnome_view(void)
{
}

docview * gnome_view::GetDV(void)
{
	return docv;
}

void gnome_view::SetTitle(const char * p1)
{
	gtk_label_set_text(GTK_LABEL(label_widget), p1);
}

/*################################################################################################*/

vector<gnome_ogl_view *> gnome_ogl_view::ogl_vector;

gnome_ogl_view::gnome_ogl_view(gnome_docv * p1) : gnome_view(p1), ogl_view()
{
	ogl_vector.push_back(this);
	
	int attrlst[] =
	{
		GDK_GL_RGBA,
		GDK_GL_RED_SIZE, 1,
		GDK_GL_GREEN_SIZE, 1,
		GDK_GL_BLUE_SIZE, 1,
		GDK_GL_DEPTH_SIZE, 1,
		GDK_GL_DOUBLEBUFFER,
		GDK_GL_NONE
	};
	
	view_widget = gtk_gl_area_new(attrlst);
//	gtk_widget_set_usize(GTK_WIDGET(view_widget), 100, 100);
	gtk_widget_set_usize(GTK_WIDGET(view_widget), 400, 400);	// how to set DEFAULT sizes !?!?!?
	
	int events = GDK_EXPOSURE_MASK;
	events |= GDK_BUTTON_PRESS_MASK | GDK_BUTTON_RELEASE_MASK;
	events |= GDK_POINTER_MOTION_MASK | GDK_POINTER_MOTION_HINT_MASK;
	
	gtk_widget_set_events(GTK_WIDGET(view_widget), events);

	gtk_signal_connect(GTK_OBJECT(view_widget),
		"realize", GTK_SIGNAL_FUNC(RealizeHandler), NULL);
	
	gtk_signal_connect(GTK_OBJECT(view_widget),
		"expose_event", GTK_SIGNAL_FUNC(ExposeHandler), NULL);
	
	gtk_signal_connect(GTK_OBJECT(view_widget),
		"motion_notify_event", GTK_SIGNAL_FUNC(MotionNotifyHandler), NULL);
	
	gtk_signal_connect(GTK_OBJECT(view_widget),
		"button_press_event", GTK_SIGNAL_FUNC(ButtonHandler), NULL);
	
	gtk_signal_connect(GTK_OBJECT(view_widget),
		"button_release_event", GTK_SIGNAL_FUNC(ButtonHandler), NULL);
		
	gtk_signal_connect(GTK_OBJECT(view_widget),
		"configure_event", GTK_SIGNAL_FUNC(ConfigureHandler), NULL);
		
	gtk_widget_show(GTK_WIDGET(view_widget));
}

gnome_ogl_view::~gnome_ogl_view(void)
{
	vector<gnome_ogl_view *>::iterator it1;
	it1 = find(ogl_vector.begin(), ogl_vector.end(), this);
	
	if (it1 != ogl_vector.end())
	{
		ogl_vector.erase(it1);
	}
	else
	{
		cout << "WARNING : unknown view_widget at ~gnome_ogl_view()!!!" << endl;
	}
}

void gnome_ogl_view::Update(bool directly)
{
	if (directly) ExposeEvent();
	else ExposeEvent();
	
	// here we update always directly. should emit an update request for indirect rendering!?!?!?
	// here we update always directly. should emit an update request for indirect rendering!?!?!?
	// here we update always directly. should emit an update request for indirect rendering!?!?!?
}

void gnome_ogl_view::SetCurrent(void)
{
	bool failed = !gtk_gl_area_make_current(GTK_GL_AREA(view_widget));
	if (failed) cout << "SetCurrent(): can't make_current!!!" << endl;
}

gnome_ogl_view * gnome_ogl_view::GetWindow(GtkWidget * widget)
{
	vector<gnome_ogl_view *>::iterator it1 = ogl_vector.begin();
	while (it1 != ogl_vector.end())
	{
		vector<gnome_ogl_view *>::iterator it2 = it1++;
		if ((* it2)->view_widget == widget) return (* it2);
	}
	
	// return NULL if the search failed...
	// return NULL if the search failed...
	// return NULL if the search failed...
	
	return NULL;
}

void gnome_ogl_view::RealizeHandler(GtkWidget * widget, gpointer)
{
	gnome_ogl_view * window = GetWindow(widget);
	if (!window) cout << "Unknown ID in RealizeHandler !!!" << endl;
	else window->InitGL();
}

gint gnome_ogl_view::ExposeHandler(GtkWidget * widget, GdkEventExpose *)
{
	gnome_ogl_view * window = GetWindow(widget);
	if (!window) cout << "Unknown ID in ExposeHandler !!!" << endl;
	else window->ExposeEvent();
	
	return FALSE;
}

gint gnome_ogl_view::ButtonHandler(GtkWidget * widget, GdkEventButton * eb)
{
	gnome_ogl_view * window = GetWindow(widget);
	if (!window) cout << "Unknown ID in ButtonHandler !!!" << endl;
	else
	{
		mouse_tool::button tmpb; i32s tmps1;
		switch (eb->button)
		{
			case 1:
			tmpb = mouse_tool::Left;
			tmps1 = GDK_BUTTON1_MASK;
			break;
			
			case 3:
			tmpb = mouse_tool::Right;
			tmps1 = GDK_BUTTON3_MASK;
			break;
			
			default:
			tmpb = mouse_tool::Middle;
			tmps1 = GDK_BUTTON2_MASK;
		}
		
		mouse_tool::state tmps2 = (eb->state & tmps1) ? mouse_tool::Up : mouse_tool::Down;
		
		if (tmps2 == mouse_tool::Down)
		{
			if (button == mouse_tool::None)
			{
				if (tmpb == mouse_tool::Right)
				{
					// the popup menu is created here. pointer to the glarea widget
					// is given as "user_data", and it is also passed to the popup
					// hander callback function (instead of the original value).
					
					// 2001-08-22 quick fix : check that we open the popup for
					// a graphics view only (not for energy level diagrams).
					
					graphics_view * gv = dynamic_cast<graphics_view *>(window);
					if (gv == NULL) return TRUE;	// was not a graphics_view!!!
					
					gnome_popup_menu_do_popup(GetWindow(widget)->docv->popupmenu,
						NULL, NULL, NULL, window->view_widget);
						
					return TRUE;
				}
				
				button = tmpb;
				
				shift_down = (eb->state & GDK_SHIFT_MASK) ? true : false;
				ctrl_down = (eb->state & GDK_CONTROL_MASK) ? true : false;
				
				state = mouse_tool::Down;
				
				current_tool->ButtonEvent((ogl_view *) window, (i32s) eb->x, (i32s) eb->y);
			}
		}
		else
		{
			if (button == mouse_tool::Left && tmpb != mouse_tool::Left) return TRUE;
			if (button == mouse_tool::Middle && tmpb != mouse_tool::Middle) return TRUE;
			if (button == mouse_tool::Right && tmpb != mouse_tool::Right) return TRUE;
			
			state = mouse_tool::Up;
			
			current_tool->ButtonEvent((ogl_view *) window, (i32s) eb->x, (i32s) eb->y);
			
			button = mouse_tool::None;
		}
	}
	
	return TRUE;
}

gint gnome_ogl_view::ConfigureHandler(GtkWidget * widget, GdkEventConfigure *)
{
	gnome_ogl_view * window = GetWindow(widget);
	if (!window) cout << "Unknown ID in ConfigureHandler !!!" << endl;
	else
	{
		window->SetCurrent();
		window->SetSize(widget->allocation.width, widget->allocation.height);
	}
	
	return TRUE;
}

gint gnome_ogl_view::MotionNotifyHandler(GtkWidget * widget, GdkEventMotion * event)
{
	int x; int y; GdkModifierType state;
	if (event->is_hint) gdk_window_get_pointer(event->window, & x, & y, & state);
	else { x = (int) event->x; y = (int) event->y; state = (GdkModifierType) event->state; }
	
	if (button != mouse_tool::None)
	{
		gnome_ogl_view * window = GetWindow(widget);
		if (!window) cout << "Unknown ID in MotionNotifyHandler !!!" << endl;
		else current_tool->MotionEvent((ogl_view *) window, x, y);
	}
	
	return TRUE;
}

/*################################################################################################*/

gnome_graphics_view::gnome_graphics_view(gnome_docv * p1, camera * p2) :
	gnome_ogl_view(p1), graphics_view(p2), ogl_view()
{
}

gnome_graphics_view::~gnome_graphics_view(void)
{
}

/*##############################################*/
/*##############################################*/

// the model-independent popup-menu callbacks are here...
// the model-independent popup-menu callbacks are here...
// the model-independent popup-menu callbacks are here...

void gnome_graphics_view::popup_FileClose(GtkWidget *, gpointer data)
{
	gnome_graphics_view * gv = GetGV((GtkWidget *) data);
	
	// apparently, it is not necessary to call gnome_mdi_remove_view() for the view here...
	// apparently, it is not necessary to call gnome_mdi_remove_view() for the view here...
	// apparently, it is not necessary to call gnome_mdi_remove_view() for the view here...
	
	gnome_mdi_remove_child(gnome_mdi_app::mdi, GNOME_MDI_CHILD(gv->docv->child), FALSE);
}

void gnome_graphics_view::popup_SelectAll(GtkWidget *, gpointer data)
{
	GetGV((GtkWidget *) data)->docv->SelectAll();
}

void gnome_graphics_view::popup_InvertSelection(GtkWidget *, gpointer data)
{
	GetGV((GtkWidget *) data)->docv->InvertSelection();
}

void gnome_graphics_view::popup_ProjOrthographic(GtkWidget *, gpointer data)
{
	gnome_graphics_view * gv = GetGV((GtkWidget *) data);
	gv->cam->ortho = true; gv->cam->stereo_mode = false; gv->cam->stereo_relaxed = false; 
	gv->docv->UpdateGraphicsViews(gv->cam);
}

void gnome_graphics_view::popup_ProjPerspective(GtkWidget *, gpointer data)
{
	gnome_graphics_view * gv = GetGV((GtkWidget *) data);
	gv->cam->ortho = false; gv->cam->stereo_mode = false; gv->cam->stereo_relaxed = false; 
	gv->docv->UpdateGraphicsViews(gv->cam);
}

void gnome_graphics_view::popup_ProjRedGreen(GtkWidget *, gpointer data)
{
	gnome_graphics_view * gv = GetGV((GtkWidget *) data);
	gv->cam->ortho = false; gv->cam->stereo_mode = true; gv->cam->stereo_relaxed = false; 
	gv->docv->UpdateGraphicsViews(gv->cam);
}

void gnome_graphics_view::popup_ProjRelaxedEye(GtkWidget *, gpointer data)
{
	gnome_graphics_view * gv = GetGV((GtkWidget *) data);
	gv->cam->ortho = false; gv->cam->stereo_mode = true; gv->cam->stereo_relaxed = true;
	
	GtkWidget *sliderwindow = NULL;
	GtkWidget *box, *button, *label1, *label2, *hscale1, *hscale2;
	GtkObject *adj1, *adj2;
	if (!sliderwindow)
	{
		sliderwindow = gtk_window_new (GTK_WINDOW_TOPLEVEL);
		gtk_window_set_title (GTK_WINDOW (sliderwindow), "Adjust the Separation");
  
		gtk_signal_connect (GTK_OBJECT (sliderwindow), "destroy",
			GTK_SIGNAL_FUNC(gtk_widget_destroyed), &sliderwindow);
    
		gtk_container_set_border_width (GTK_CONTAINER (sliderwindow), 10);
		
                box = gtk_hbox_new (FALSE, 10);
                gtk_container_set_border_width (GTK_CONTAINER (box), 10);
                gtk_container_add (GTK_CONTAINER (sliderwindow), box);
                gtk_widget_show (box);
		
		label1 = gtk_label_new ("Separation Distance:");
                gtk_box_pack_start (GTK_BOX (box), label1, FALSE, FALSE, 0);
                gtk_widget_show (label1);
   
                adj1 = gtk_adjustment_new (gv->cam->slider, -5.0, 5.0, 0.005, 0.0, 0.0);
                           
                hscale1 = gtk_hscale_new (GTK_ADJUSTMENT (adj1));                     
		scale_set_default_values (GTK_SCALE(hscale1));
                gtk_box_pack_start (GTK_BOX (box), hscale1, TRUE, TRUE, 0);
                gtk_widget_show (hscale1);

		label2 = gtk_label_new ("Second Molecule Angle:");
                gtk_box_pack_start (GTK_BOX (box), label2, FALSE, FALSE, 0);
                gtk_widget_show (label2);
   
                adj2 = gtk_adjustment_new (gv->cam->rang, -5.0, 5.0, 0.005, 0.0, 0.0);
                           
                hscale2 = gtk_hscale_new (GTK_ADJUSTMENT (adj2));                             
		scale_set_default_values (GTK_SCALE(hscale2));
                gtk_box_pack_start (GTK_BOX (box), hscale2, TRUE, TRUE, 0);
                gtk_widget_show (hscale2);
	}
	if (!GTK_WIDGET_VISIBLE (sliderwindow)) gtk_widget_show_all (sliderwindow);
	else gtk_widget_destroy (sliderwindow);
	
	gtk_signal_connect (GTK_OBJECT (adj1), "value_changed",
	                    GTK_SIGNAL_FUNC (callback_slider), data);

	gtk_signal_connect (GTK_OBJECT (adj2), "value_changed",
	                    GTK_SIGNAL_FUNC (callback_rang), data);
}

void gnome_graphics_view::callback_slider(GtkAdjustment * adj, gpointer data)
{
	gnome_graphics_view * gv = GetGV((GtkWidget *) data);
	gv->cam->slider = adj->value;
	gv->docv->UpdateGraphicsViews(gv->cam);
}

void gnome_graphics_view::callback_rang(GtkAdjustment * adj, gpointer data)
{
	gnome_graphics_view * gv = GetGV((GtkWidget *) data);
	gv->cam->rang = adj->value;
	gv->docv->UpdateGraphicsViews(gv->cam);
}

void gnome_graphics_view::scale_set_default_values(GtkScale *scale)
{
	gtk_range_set_update_policy (GTK_RANGE (scale), GTK_UPDATE_CONTINUOUS);
	gtk_scale_set_digits (scale, 3);
	gtk_scale_set_value_pos (scale, GTK_POS_RIGHT);
	gtk_scale_set_draw_value (scale, TRUE);
}

void gnome_graphics_view::popup_RenderQuickUpdate(GtkWidget *, gpointer data)
{
	gnome_graphics_view * gv = GetGV((GtkWidget *) data);
	gv->quick_update = !gv->quick_update;
}

void gnome_graphics_view::popup_ViewsNewCam(GtkWidget *, gpointer data)
{
	gnome_graphics_view * gv = GetGV((GtkWidget *) data);
	gv->docv->AddGraphicsView();
}

void gnome_graphics_view::popup_ViewsNewView(GtkWidget *, gpointer data)
{
	gnome_graphics_view * gv = GetGV((GtkWidget *) data);
	gv->docv->AddGraphicsView(gv->cam);
}

void gnome_graphics_view::popup_ViewsDeleteView(GtkWidget *, gpointer data)
{
	gnome_graphics_view * gv = GetGV((GtkWidget *) data);
	
	// before removing the view, we have to remove it from the GtkNotebook.
	// however, not all calls to RemoveGraphicsView() are successful; here we will not
	// force the removal, so if the view to be removed is the last graphics view for
	// the project, RemoveGraphicsView() will just pop up an error message and skip
	// the removal. so, we use IsThisLastGraphicsView() to detect this case...
	
	if (!gv->docv->IsThisLastGraphicsView(gv))
	{
		gint page = gtk_notebook_page_num(GTK_NOTEBOOK(gv->docv->notebook), gv->view_widget);
		gtk_notebook_remove_page(GTK_NOTEBOOK(gv->docv->notebook), page);
	}
	
// perhaps a more elegant way would be to change "add/remove view"-funtions of docview into virtual functions,
// and then override the default behaviour at, say, here in gnome classes (where we would do add/remove operations
// for out GtkNotebook). HOWEVER, it seems to have some side-effects; just lost 4h trying to figure it out...  :(

	gv->docv->RemoveGraphicsView(gv);
}

void gnome_graphics_view::popup_LightsNewLight(GtkWidget *, gpointer data)
{
	gnome_graphics_view * gv = GetGV((GtkWidget *) data);
	
	char input; light * new_light;
	
	cout << "add light:" << endl;
	cout << "directional- or spotlight ? (d/s) "; cin >> input;
	
	if (input == 'd') new_light = new directional_light(ol_static());
	else if (input == 's')
	{
		new_light = new spot_light(ol_static());
		
		const fGL trans[3] = { 0.0, 0.0, -1.0 };
		new_light->TranslateObject((const fGL *) trans, gv->cam->GetLocData());
	}
	else return;
	
	cout << "global or local light ? (g/l) "; cin >> input;
	
	if (input == 'g') gv->docv->AddGlobalLight(new_light);
	else if (input == 'l') gv->docv->AddLocalLight(new_light, gv->cam);
	else delete new_light;
	
	if (input == 'g' || graphics_view::draw_info) gv->docv->UpdateAllGraphicsViews();
	else if (input == 'l') gv->docv->UpdateGraphicsViews(gv->cam);
}

void gnome_graphics_view::popup_LightsSwitchLoc(GtkWidget *, gpointer data)
{
	gnome_graphics_view * gv = GetGV((GtkWidget *) data);
	gv->docv->DoSwitchLocalLights(gv->cam, false);
}

void gnome_graphics_view::popup_LightsSwitchGlob(GtkWidget *, gpointer data)
{
	gnome_graphics_view * gv = GetGV((GtkWidget *) data);
	gv->docv->DoSwitchLocalLights(gv->cam, false);
}

void gnome_graphics_view::popup_ObjectsDeleteCurrent(GtkWidget *, gpointer data)
{
	gnome_graphics_view * gv = GetGV((GtkWidget *) data);
	gv->docv->DoDeleteCurrentObject();
}

/*##############################################*/
/*##############################################*/

gnome_graphics_view * gnome_graphics_view::GetGV(GtkWidget * widget)
{
	gnome_ogl_view * window = gnome_ogl_view::GetWindow(widget);
	if (!window) cout << "Unknown ID in gnome_graphics_view::GetGV() !!!" << endl;
	
	gnome_graphics_view * gv = dynamic_cast<gnome_graphics_view *>(window);
	if (gv != NULL) return gv;
	else
	{
		cout << "bad cast in gnome_graphics_view::GetGV() !!!!!" << endl;
		return NULL;
	}
}

void gnome_graphics_view::ExposeEvent(void)
{
	SetCurrent(); Render(); glFlush();
//	gtk_gl_area_swap_buffers(GTK_GL_AREA(view_widget));		// newer way???
	gtk_gl_area_swapbuffers(GTK_GL_AREA(view_widget));		// older way???
}

/*################################################################################################*/

gnome_enlevdiag_view::gnome_enlevdiag_view(qm1_mdl * p1) :
	gnome_ogl_view(dynamic_cast<gnome_docv *>(p1)), enlevdiag_view(p1), ogl_view()
{
	gtk_label_set_text(GTK_LABEL(label_widget), "energy-level diagram view");
}

gnome_enlevdiag_view::~gnome_enlevdiag_view(void)
{
}

void gnome_enlevdiag_view::ExposeEvent(void)
{
	SetCurrent(); Render(); glFlush();
//	gtk_gl_area_swap_buffers(GTK_GL_AREA(view_widget));		// newer way???
	gtk_gl_area_swapbuffers(GTK_GL_AREA(view_widget));		// older way???
}

/*################################################################################################*/

vector<gnome_treelist_view *> gnome_treelist_view::tl_vector;

gnome_treelist_view::gnome_treelist_view(gnome_docv * p1) : gnome_view(p1), treelist_view()
{
	tl_vector.push_back(this);
	gtk_label_set_text(GTK_LABEL(label_widget), "project view");
	
	view_widget = GTK_WIDGET(gtk_hpaned_new());
	
	gtk_widget_set_usize(GTK_WIDGET(view_widget), 400, 400);	// how to set DEFAULT sizes !?!?!?
	
	tree = GTK_WIDGET(gtk_tree_new());
	gtk_widget_set_usize(GTK_WIDGET(tree), 100, 100);
	
	// initialize...
	// initialize...
	// initialize...
	
	// is there a bug in gtk_tree?!?!??!?!
	// it seems to lose those expand-buttons when we drag/drop a view in MDI "notebook" mode...
	
	// when we remove the last item from a subtree, it seems that the subtree is automatically deleted.
	// so, we have to create a new subtree always when we add the first item.
	
	item_lights = gtk_tree_item_new_with_label("Lights");
	gtk_widget_show(item_lights); gtk_tree_append(GTK_TREE(tree), item_lights);
	
	for (i32u n1 = 0;n1 < docv->light_vector.size();n1++)
	{
		LightAdded(docv->light_vector[n1]);
	}
	
	item_objects = gtk_tree_item_new_with_label("Objects");
	gtk_widget_show(item_objects); gtk_tree_append(GTK_TREE(tree), item_objects);
	
	for (i32u n1 = 0;n1 < docv->object_vector.size();n1++)
	{
		ObjectAdded(docv->object_vector[n1]);
	}
	
	// ready...
	// ready...
	// ready...
	
	gtk_widget_show(tree);
	
	list = gtk_label_new("");
	gtk_widget_set_usize(GTK_WIDGET(list), 100, 100);
	gtk_widget_show(list);
	
	gtk_paned_add1(GTK_PANED(view_widget), GTK_WIDGET(tree));
	gtk_paned_add2(GTK_PANED(view_widget), GTK_WIDGET(list));
	
	gtk_widget_show(GTK_WIDGET(view_widget));
}

gnome_treelist_view::~gnome_treelist_view(void)
{
	vector<gnome_treelist_view *>::iterator it1;
	it1 = find(tl_vector.begin(), tl_vector.end(), this);
	
	if (it1 != tl_vector.end())
	{
		tl_vector.erase(it1);
	}
	else
	{
		cout << "WARNING : unknown view_widget at ~gnome_treelist_view()!!!" << endl;
	}
}

void gnome_treelist_view::Update(bool directly)
{
	cout << "gnome_treelist_view::Update() called with param " << directly << endl;
// how to handle update requests!??!?!
// how to handle update requests!??!?!
// how to handle update requests!??!?!
}

void gnome_treelist_view::LightAdded(light * p1)
{
	gnome_tlv_light_record nrec; nrec.ref = p1;
	
	char buffer[256];
	ostrstream str(buffer, sizeof(buffer));
	str << p1->GetObjectName() << " ";
	
	// here we have to search for the camera number, which is a bit inconvenient...
	// "index" also for objects (like atoms, etc...) ?!?!? how to keep track of it???
	
	if (!p1->owner) str << "[global]" << ends;
	else
	{
		i32u index = 0;
		while (index < docv->camera_vector.size())
		{
			if (docv->camera_vector[index] != p1->owner) index++;
			else break;
		}
		
		str << "[cam " << (index + 1) << "]" << ends;
	}
	
	nrec.item = gtk_tree_item_new_with_label(buffer);
	gtk_widget_show(nrec.item);
	
	if (light_vector.empty())	// create a new subtree, if needed...
	{
		subt_lights = GTK_WIDGET(gtk_tree_new());
		gtk_tree_item_set_subtree(GTK_TREE_ITEM(item_lights), subt_lights);
		gtk_signal_connect(GTK_OBJECT(subt_lights), "select_child", GTK_SIGNAL_FUNC(SelectChildHandler), tree);
	}
	
	gtk_tree_append(GTK_TREE(subt_lights), nrec.item);
	light_vector.push_back(nrec);
}

void gnome_treelist_view::LightRemoved(light * p1)
{
	i32u index = 0;
	while (index < light_vector.size())
	{
		if (light_vector[index].ref != p1) index++;
		else
		{
			gtk_tree_remove_item(GTK_TREE(subt_lights), light_vector[index].item);
			light_vector.erase(light_vector.begin() + index);
			return;
		}
	}
	
	cout << "tried to remove an unknown light!!!" << endl;
}

void gnome_treelist_view::ObjectAdded(smart_object * p1)
{
	gnome_tlv_object_record nrec; nrec.ref = p1;
	
	nrec.item = gtk_tree_item_new_with_label(p1->GetObjectName());
	gtk_widget_show(nrec.item);
	
	if (object_vector.empty())	// create a new subtree, if needed...
	{
		subt_objects = GTK_WIDGET(gtk_tree_new());
		gtk_tree_item_set_subtree(GTK_TREE_ITEM(item_objects), subt_objects);
		gtk_signal_connect(GTK_OBJECT(subt_objects), "select_child", GTK_SIGNAL_FUNC(SelectChildHandler), tree);
	}
	
	gtk_tree_append(GTK_TREE(subt_objects), nrec.item);
	object_vector.push_back(nrec);
}

void gnome_treelist_view::ObjectRemoved(smart_object * p1)
{
	i32u index = 0;
	while (index < object_vector.size())
	{
		if (object_vector[index].ref != p1) index++;
		else
		{
			gtk_tree_remove_item(GTK_TREE(subt_objects), object_vector[index].item);
			object_vector.erase(object_vector.begin() + index);
			return;
		}
	}
	
	cout << "tried to remove an unknown object!!!" << endl;
}

void gnome_treelist_view::SelectChildHandler(GtkTree * subt, GtkWidget * item, gpointer data)
{
	i32u index = 0;
	while (index < tl_vector.size())
	{
		if (tl_vector[index]->tree != data) index++;
		else return tl_vector[index]->SelectChildEvent(subt, item);
	}
	
	cout << "unknown root found at gnome_treelist_view::SelectChildHandler()!" << endl;
}

void gnome_treelist_view::SelectChildEvent(GtkTree * subt, GtkWidget * item)
{
	if (subt == GTK_TREE(subt_lights))
	{
		i32u index = 0;
		while (index < light_vector.size())
		{
			if (light_vector[index].item != item) index++;
			else
			{
				cout << "treelist: selected light ";
				cout << light_vector[index].ref->GetObjectName() << endl;
				
				docv->SelectLight(light_vector[index].ref);
				return;
			}
		}
	}
	
	if (subt == GTK_TREE(subt_objects))
	{
		i32u index = 0;
		while (index < object_vector.size())
		{
			if (object_vector[index].item != item) index++;
			else
			{
				cout << "treelist: selected object ";
				cout << object_vector[index].ref->GetObjectName() << endl;
				
				docv->SelectObject(object_vector[index].ref);
				return;
			}
		}
	}
}

/*################################################################################################*/

gnome_class_factory * gnome_class_factory::instance = NULL;
singleton_cleaner<gnome_class_factory> gnome_class_factory_cleaner(gnome_class_factory::GetInstance());

gnome_class_factory::gnome_class_factory(void) : graphics_class_factory()
{
}

gnome_class_factory::~gnome_class_factory(void)
{
}

gnome_class_factory * gnome_class_factory::GetInstance(void)
{
	if (instance != NULL) return instance;
	else return (instance = new gnome_class_factory());
}

err_util * gnome_class_factory::ProduceErrUtil(void)
{
	return new gnome_err_util();
}

prefs * gnome_class_factory::ProducePrefs(void)
{
        return new gnome_prefs();
}

graphics_view * gnome_class_factory::ProduceGraphicsView(docview * docv1, camera * cam)
{
	gnome_docv * docv2 = dynamic_cast<gnome_docv *>(docv1);
	
	gnome_graphics_view * gv = new gnome_graphics_view(docv2, cam);
	gtk_notebook_append_page(GTK_NOTEBOOK(docv2->notebook), gv->view_widget, gv->label_widget);
	gtk_notebook_set_page(GTK_NOTEBOOK(docv2->notebook), -1);	// activate the last page.
	
	return gv;
}

enlevdiag_view * gnome_class_factory::ProduceEnLevDiagView(qm1_mdl * mdl)
{
	gnome_docv * docv = dynamic_cast<gnome_docv *>(mdl);
	
	gnome_enlevdiag_view * eldv = new gnome_enlevdiag_view(mdl);
	gtk_notebook_append_page(GTK_NOTEBOOK(docv->notebook), eldv->view_widget, eldv->label_widget);
	gtk_notebook_set_page(GTK_NOTEBOOK(docv->notebook), -1);	// activate the last page.
	
	return eldv;
}

treelist_view * gnome_class_factory::ProduceTreeListView(docview * docv1)
{
	gnome_docv * docv2 = dynamic_cast<gnome_docv *>(docv1);
	
	gnome_treelist_view * tlv = new gnome_treelist_view(docv2);
	gtk_notebook_append_page(GTK_NOTEBOOK(docv2->notebook), tlv->view_widget, tlv->label_widget);
	
	return tlv;
}

/*################################################################################################*/

// eof
