// T3VIEWS.H : a view window class for GTK+/GNOME.

// Copyright (C) 1999 Tommi Hassinen, Ville Heikkil, Mike Cruz.

// This program is free software; you can redistribute it and/or modify it
// under the terms of the license (GNU GPL) which comes with this package.

/*################################################################################################*/

#include "config.h"	// this is for TARGET3...

#ifndef T3VIEWS_H
#define T3VIEWS_H

class gnome_ogl_view;
class gnome_graphics_view;

class gnome_treelist_view;

class gnome_class_factory;

/*################################################################################################*/

#include <gtk/gtk.h>
#include <gtkgl/gtkglarea.h>
#include <gnome.h>

#include "views.h"
#include "t3docv.h"

#include <vector>
using namespace std;

/*################################################################################################*/

/// GNOME-dependent part of "##view" class.

class gnome_view : virtual public view
{
	protected:
	
	gnome_docv * docv;
	
	GtkWidget * view_widget;
	GtkWidget * label_widget;
	
	friend class gnome_graphics_view;
	
	public:
	
	gnome_view(gnome_docv *);
	virtual ~gnome_view(void);
	
	docview * GetDV(void);		// virtual
	void SetTitle(const char *);	// virtual
};

/*################################################################################################*/

/// A GNOME-version of "##ogl_view".

class gnome_ogl_view : public gnome_view, virtual public ogl_view
{
	private:
	
	static vector<gnome_ogl_view *> ogl_vector;
	
	friend class gnome_graphics_view;
	
	public:
	
	gnome_ogl_view(gnome_docv *);
	virtual ~gnome_ogl_view(void);
	
	void Update(bool);			// virtual
	void SetCurrent(void);			// virtual
	
	private:
	
	virtual void ExposeEvent(void) = 0;
	
	private:
	
	static gnome_ogl_view * GetWindow(GtkWidget *);
	
	static void RealizeHandler(GtkWidget *, gpointer);
	static gint ExposeHandler(GtkWidget *, GdkEventExpose *);
	static gint ButtonHandler(GtkWidget *, GdkEventButton *);
	static gint MotionNotifyHandler(GtkWidget *, GdkEventMotion *);
	static gint ConfigureHandler(GtkWidget *, GdkEventConfigure *);
};

/*################################################################################################*/

/// A GNOME-version of "##graphics_view".

class gnome_graphics_view : public gnome_ogl_view, public graphics_view
{
	private:
	
	gnome_graphics_view(gnome_docv *, camera *);
	
	friend class gnome_class_factory;
	
	friend class gnome_qm1_docv;
	friend class gnome_mm1_docv;
	friend class gnome_mm2_docv;
	
	public:
	
	~gnome_graphics_view(void);
	
	// the model-independent popup-menu callbacks are here...
	// the model-independent popup-menu callbacks are here...
	// the model-independent popup-menu callbacks are here...
	
	static void popup_FileClose(GtkWidget *, gpointer);
	
	static void popup_SelectAll(GtkWidget *, gpointer);
	static void popup_InvertSelection(GtkWidget *, gpointer);

	static void popup_ProjOrthographic(GtkWidget *, gpointer);
	static void popup_ProjPerspective(GtkWidget *, gpointer);
	static void popup_ProjRedGreen(GtkWidget *, gpointer);
	static void popup_ProjRelaxedEye(GtkWidget *, gpointer);	
	static void callback_slider(GtkAdjustment *, gpointer);		// stereo adjustment box...
	static void callback_rang(GtkAdjustment *, gpointer);		// stereo adjustment box...
	static void scale_set_default_values(GtkScale *);		// stereo adjustment box...
	
	static void popup_RenderQuickUpdate(GtkWidget *, gpointer);

	static void popup_ViewsNewCam(GtkWidget *, gpointer);
	static void popup_ViewsNewView(GtkWidget *, gpointer);
	static void popup_ViewsDeleteView(GtkWidget *, gpointer);
	
	static void popup_LightsNewLight(GtkWidget *, gpointer);
	static void popup_LightsSwitchLoc(GtkWidget *, gpointer);
	static void popup_LightsSwitchGlob(GtkWidget *, gpointer);

	static void popup_ObjectsDeleteCurrent(GtkWidget *, gpointer);
	
	private:
	
	static gnome_graphics_view * GetGV(GtkWidget *);
	
	void ExposeEvent(void);		// virtual
};

/*################################################################################################*/

class gnome_enlevdiag_view : public gnome_ogl_view, public enlevdiag_view
{
	private:
	
	gnome_enlevdiag_view(qm1_mdl *);
	
	friend class gnome_class_factory;
	
//	friend class gnome_qm1_docv;
//	friend class gnome_mm1_docv;
//	friend class gnome_mm2_docv;
	
	public:
	
	~gnome_enlevdiag_view(void);
	
	private:
	
//	static gnome_graphics_view * GetGV(GtkWidget *);
	
	void ExposeEvent(void);		// virtual
};

/*################################################################################################*/

// these records will always share at least the item.
// a "record" base class?!?!?!? how much would it help???

struct gnome_tlv_light_record
{
	GtkWidget * item;
	light * ref;
};

struct gnome_tlv_object_record
{
	GtkWidget * item;
	smart_object * ref;
};

/**	A GNOME treelist view implementation. Under construction, 
	but still offers a way to select some objects which can't be selected otherwise.
	
	The rumors seem to indicate that tree and/or list widgets are still evolving rapidly in GTK. 
	The tree widget used here is an older one, so this implementation is likely to change...
	
	Also this tree/list system is quite complicated, and needs some more careful desing...
*/

class gnome_treelist_view : public gnome_view, public treelist_view
{
	protected:

	static vector<gnome_treelist_view *> tl_vector;
	
	vector<gnome_tlv_light_record> light_vector;
	vector<gnome_tlv_object_record> object_vector;
	
	GtkWidget * item_lights;
	GtkWidget * subt_lights;
	GtkWidget * item_objects;
	GtkWidget * subt_objects;
	GtkWidget * tree;
	
	GtkWidget * list;
	
	private:
	
	gnome_treelist_view(gnome_docv *);
	
	friend class gnome_class_factory;
		
	public:
	
	~gnome_treelist_view(void);
	
	void Update(bool);			// virtual
	
	void LightAdded(light *);	// virtual
	void LightRemoved(light *);	// virtual
	
	void ObjectAdded(smart_object *);	// virtual
	void ObjectRemoved(smart_object *);	// virtual
	
	static void SelectChildHandler(GtkTree *, GtkWidget *, gpointer);
	void SelectChildEvent(GtkTree *, GtkWidget *);
};

/*################################################################################################*/

/// This class has a private constructor, so you can't use this in the usual way; use the GetInstance() instead.

class gnome_class_factory : public graphics_class_factory
{
	private:
	
	static gnome_class_factory * instance;
	gnome_class_factory(void);
	
	public:
	
	~gnome_class_factory(void);
	static gnome_class_factory * GetInstance(void);
	
	err_util * ProduceErrUtil(void);	// virtual
	prefs * ProducePrefs(void);		// virtual
	
	graphics_view * ProduceGraphicsView(docview *, camera *);	// virtual
	enlevdiag_view * ProduceEnLevDiagView(qm1_mdl *);		// virtual
	treelist_view * ProduceTreeListView(docview *);			// virtual
};

/*################################################################################################*/

#endif  // T3VIEWS_H

// eof
