// Copyright 1993, U.C.S.F. Computer Graphics Laboratory
// $Id: clex.cc,v 1.3 1994/09/07 18:14:13 gregc Exp $

#include "clex.h"
#include <ctype.h>
char const	*const Clex::tokenNames[] = {
			"start of input",
			"end of input",
			"any token expected",
			"class keyword",
			"template keyword",
			"genclass keyword",
			"add_element keyword",
			"del_element keyword",
			"abstract keyword",
			"map keyword",
			"vector keyword",
			"slow_length keyword",
			"eq keyword",
			"le keyword",
			"cmp keyword",
			"hash keyword",
			"itertype keyword",
			"iterdef keyword",
			"string",
			"identifier",
			"{",
			"}",
		};

Clex::Clex(const char *fname): line_num(1), t(SOI), errFunc(0)
{
	if (fname == NULL) {
		f = stdin;
		filename = "stdin";
	} else if ((f = fopen(fname, "r")) == NULL) {
		fprintf(stderr, "unable to open %s for reading\n", fname);
		filename = "error";
		t = EOI;
	} else
		filename = fname;
}

int
Clex::nextToken(Token tok)
{
	int	c;

	if (f == NULL)
		return 0;

	for (;;) {
		for (c = getc(f); c != EOF && isspace(c); c = getc(f))
			if (c == '\n')
				line_num += 1;
		/* look for comment */
		if (c != '/')
			break;
		c = getc(f);
		if (c != '/') {
			(void) ungetc(c, f);
			c = '/';
			break;
		}
		/* skip rest of line */
		for (c = getc(f); c != EOF && c != '\n'; c = getc(f))
			continue;
		if (c == EOF)
			break;
		line_num += 1;
	}

	switch (c) {
	case EOF: t = EOI; goto finish_up;
	case '{': t = LEFT_CURLY; goto finish_up;
	case '}': t = RIGHT_CURLY; goto finish_up;
	case '"':
		string = "";
		for (c = getc(f); c != EOF && c != '"'; c = getc(f)) {
			if (c == '\n')
				line_num += 1;
			string += c;
		}
		t = STRING;
		goto finish_up;
	}
	if (!isalpha(c)) {
		fprintf(stderr, "illegal character '\\%03o' on line %d of %s,"
			" skipping rest of input\n", c & 0xff, line_num,
			filename.chars());
		t = EOI; return 0;
	}

	string = c;
	for (c = getc(f); isalnum(c) || c == '_'; c = getc(f))
		string += c;
	(void) ungetc(c, f);

	if (tok == IDENT)
		t = tok;
	else if (string == "class")
		t = CLASS;
	else if (string == "template")
		t = TEMPLATE;
	else if (string == "genclass")
		t = GENCLASS;
	else if (string == "add_element")
		t = ADD_ELEMENT;
	else if (string == "del_element")
		t = DEL_ELEMENT;
	else if (string == "abstract")
		t = ABSTRACT;
	else if (string == "map")
		t = MAP;
	else if (string == "vector")
		t = VECTOR;
	else if (string == "slow_length")
		t = SLOW_LENGTH;
	else if (string == "eq")
		t = EQ;
	else if (string == "le")
		t = LE;
	else if (string == "cmp")
		t = CMP;
	else if (string == "hash")
		t = HASH;
	else if (string == "itertype")
		t = ITERTYPE;
	else if (string == "iterdef")
		t = ITERDEF;
	else
		t = IDENT;
finish_up:
	if (tok == ANY || tok == t)
		return 1;
	if (errorFunction())
		errorFunction()(this);
	return 0;
}
