// Copyright 1993, U.C.S.F. Computer Graphics Laboratory
// $Id: clex.h,v 1.3 1994/09/07 18:14:13 gregc Exp $

#ifndef Clex_h
#define Clex_h

#include <stdio.h>
#include <String.h>

class Clex {
public:
	enum Token {
		SOI, EOI, ANY,
		CLASS, TEMPLATE, GENCLASS, ADD_ELEMENT, DEL_ELEMENT,
		ABSTRACT, MAP, VECTOR, SLOW_LENGTH, EQ, LE, CMP, HASH,
		ITERTYPE, ITERDEF,
		STRING, IDENT, LEFT_CURLY, RIGHT_CURLY
	};
private:
	FILE	*f;
	String	filename;
	int	line_num;
	String	string;
	Token	t;
	void	(*errFunc)(Clex *);
public:
	static char const	*const tokenNames[];
			Clex(const char *fname);
			~Clex() { if (f != NULL) fclose(f); }
	int		nextToken(Token tok = ANY);
	Token		token() { return t; }
	const String	&value() { return string; }
	const String	&fileName() { return filename; }
	int		lineNum() { return line_num; }
	void		errorFunction(void (*ef)(Clex *)) { errFunc = ef; }
	void		(*errorFunction())(Clex *) { return errFunc; }
};
#endif
