#include "daylight.h"

inline void
AtomIndex::init(dt_Handle h, AtomStream a = NORMAL)
{
	switch (a) {
	case NORMAL:
		sh = dt_stream(h, TYP_ATOM);
		break;
	case ORIGINAL:
		// modify-off
		sh = dt_origsmi_stream(h);
		break;
	case UNIQUE:
		// modify-off
		sh = dt_cansmi_stream(h, 0);
		break;
	case ABSOLUTE:
		// modify-off
		sh = dt_cansmi_stream(h, 1);
		break;
	}
	ah = NULL_OB;
}

void
AtomIndex::AtomIndex(Molecule *m, AtomStream a = NORMAL)
{
	if (a != NORMAL)
		m->modify(0);
	init(m->mh, a);
}

void
AtomIndex::AtomIndex(Bond *b)
{
	init(b->bh, NORMAL);
}

inline void
BondIndex::init(dt_Handle h)
{
	sh = dt_stream(h, TYP_BOND);
	bh = NULL_OB;
}

void
BondIndex::BondIndex(Molecule *m)
{
	init(m->mh);
}

void
BondIndex::BondIndex(Atom *a)
{
	init(a->ah);
}

void
Atom::setCharge(int charge) {
	mol->modify(1);
	dt_setcharge(ah, charge);
}

void
Atom::setWeight(int weight) {
	mol->modify(1);
	dt_setweight(ah, weight);
}
