#ifndef daylight_h
#define daylight_h

#include "Molecule.h"

class AtomIndex {
public:
	enum { NORMAL, ORIGNAL, UNIQUE, ABSOLUTE } AtomStream;
private:
	dt_Handle	sh, ah;
	void	init(dt_Handle h, AtomStream a = NORMAL);
public:
	AtomIndex(Molecule *m, AtomStream a = NORMAL);
	AtomIndex(MolBond *b);
	~AtomIndex() {
			(void) dt_dealloc(ah);
			(void) dt_dealloc(sh);
		}
	int	next() {
			ah = dt_next(sh);
			return !dt_atend(sh);
		}
	Atom	*atom() {
			if (ah == NULL_OB)
				return 0;
			return (Atom *) dt_adjunct(ah);
		}
};

class BondIndex {
private:
	dt_Handle	sh, bh;
	void	init(dt_Handle h);
public:
	BondIndex(Molecule *m);
	BondIndex(Atom *a);
	~BondIndex() {
			(void) dt_dealloc(bh);
			(void) dt_dealloc(sh);
		}
	int	next() {
			bh = dt_next(sh);
			return !dt_atend(sh);
		}
	Bond	*bond() {
			if (bh == NULL_OB)
				return 0;
			return (Bond *) dt_adjunct(bh);
		}
};
#endif
