// Copyright 1993, U.C.S.F. Computer Graphics Laboratory
// $Id: default_use.cc,v 1.8 94/03/04 16:19:36 gregc Exp $

#include "mcd.h"

ContainerInfo	use[MAX_MOLCLASS + 1][MAX_MOLCLASS + 1];

void
default_use()
{
	// default instance names
	for (int for_class = 0; for_class <= MAX_MOLCLASS; for_class += 1)
		for (int in_class = 0; in_class <= MAX_MOLCLASS; in_class += 1)
			use[for_class][in_class].instance
				= String("all") + molClassNames[for_class]
									+ 's';

	// specific defaults for "Bond" class
	use[Atom][Bond].name = "_array2";
	use[Atom][Bond].instance = "atoms_";

	// specific defaults for "Atom" class
	use[Bond][Atom].name = "MPlex";
	use[Bond][Atom].instance = "bonds";
	use[Coord][Atom].name = "reference";
	use[CoordSet][Atom].name = "reference";
	use[Residue][Atom].name = "reference";
	use[Residue][Atom].instance = "res";
	use[Molecule][Atom].name = "reference";
	use[Molecule][Atom].instance = "mol";

	// specific defaults for "Residue" class
	use[Atom][Residue].name = "MPlex";
	use[Atom][Residue].instance = "atoms";
	use[Molecule][Residue].name = "reference";
	use[Molecule][Residue].instance = "mol";

	// specific defaults for "CoordSet" class
	use[Coord][CoordSet].name = "MPlex";
	use[Coord][CoordSet].instance = "coords";
	use[Molecule][CoordSet].name = "reference";
	use[Molecule][CoordSet].instance = "mol";

	// specific defaults for "Molecule" class
	use[Atom][Molecule].name = "MPlex";
	use[Atom][Molecule].instance = "allAtoms";
	use[Bond][Molecule].name = "MPlex";
	use[Bond][Molecule].instance = "allBonds";
	use[Residue][Molecule].name = "SplaySet";
	use[Residue][Molecule].instance = "allResidues";
	use[CoordSet][Molecule].name = "AVLMap";
	use[CoordSet][Molecule].instance = "allCoordSets";
	use[CoordSet][Molecule].keyMember = "csid";
	use[CoordSet][Molecule].keyType = "MolCoordSetId";
}
